/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.bytearray;

import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import java.util.Arrays;
import java.util.Random;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"count", "startPosition", "modificationFilter", "postModification"})
public class ByteArrayDeleteModification
extends VariableModification<byte[]> {
    private static final int MAX_MODIFIER_LENGTH = 32;
    private int count;
    private int startPosition;

    public ByteArrayDeleteModification() {
    }

    public ByteArrayDeleteModification(int startPosition, int count) {
        this.startPosition = startPosition;
        this.count = count;
    }

    @Override
    protected byte[] modifyImplementationHook(byte[] input) {
        int start;
        if (input == null) {
            input = new byte[]{};
        }
        if ((start = this.startPosition) < 0 && (start += input.length) < 0) {
            LOGGER.debug("Trying to delete from too negative Startposition. start = " + (start - input.length));
            return input;
        }
        int endPosition = start + this.count;
        if (endPosition > input.length) {
            LOGGER.debug(String.format("Bytes %d..%d cannot be deleted from {%s} of length %d", start, endPosition, ArrayConverter.bytesToHexString(input), input.length));
            return input;
        }
        if (this.count <= 0) {
            LOGGER.debug("You must delete at least one byte. count = " + this.count);
            return input;
        }
        byte[] ret1 = Arrays.copyOf(input, start);
        byte[] ret2 = null;
        if (endPosition < input.length) {
            ret2 = Arrays.copyOfRange(input, endPosition, input.length);
        }
        return ArrayConverter.concatenate(ret1, ret2);
    }

    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int startPosition) {
        this.startPosition = startPosition;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    @Override
    public VariableModification<byte[]> getModifiedCopy() {
        Random r = new Random();
        int modifier = r.nextInt(32);
        if (r.nextBoolean()) {
            modifier *= -1;
        }
        if (r.nextBoolean()) {
            if ((modifier = this.startPosition + modifier) <= 0) {
                modifier = 0;
            }
            return new ByteArrayDeleteModification(modifier, this.count);
        }
        modifier = this.startPosition + this.count;
        if (modifier <= 0) {
            modifier = 1;
        }
        return new ByteArrayDeleteModification(this.startPosition, modifier);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.count;
        hash = 89 * hash + this.startPosition;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteArrayDeleteModification other = (ByteArrayDeleteModification)obj;
        if (this.count != other.count) {
            return false;
        }
        return this.startPosition == other.startPosition;
    }

    public String toString() {
        return "ByteArrayDeleteModification{count=" + this.count + ", startPosition=" + this.startPosition + '}';
    }
}

