/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.overseer;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.cloud.DistribStateManager;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.cloud.overseer.CollectionMutator;
import org.apache.solr.cloud.overseer.ZkStateWriter;
import org.apache.solr.cloud.overseer.ZkWriteCommand;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.ImplicitDocRouter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterStateMutator {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final SolrCloudManager dataProvider;
    protected final DistribStateManager stateManager;

    public ClusterStateMutator(SolrCloudManager dataProvider) {
        this.dataProvider = dataProvider;
        this.stateManager = dataProvider.getDistribStateManager();
    }

    public ZkWriteCommand createCollection(ClusterState clusterState, ZkNodeProps message) {
        LinkedHashMap<String, Slice> slices;
        String cName = message.getStr("name");
        log.debug("building a new cName: {}", (Object)cName);
        if (clusterState.hasCollection(cName)) {
            log.warn("Collection {} already exists. exit", (Object)cName);
            return ZkStateWriter.NO_OP;
        }
        Map routerSpec = DocRouter.getRouterSpec((ZkNodeProps)message);
        String routerName = routerSpec.get("name") == null ? "compositeId" : (String)routerSpec.get("name");
        DocRouter router = DocRouter.getDocRouter((String)routerName);
        Object messageShardsObj = message.get("shards");
        if (messageShardsObj instanceof Map) {
            slices = Slice.loadAllFromMap((String)cName, (Map)((Map)messageShardsObj));
        } else {
            ArrayList<String> shardNames = new ArrayList<String>();
            if (router instanceof ImplicitDocRouter) {
                ClusterStateMutator.getShardNames(shardNames, message.getStr("shards", "compositeId"));
            } else {
                int numShards = message.getInt("numShards", Integer.valueOf(-1));
                if (numShards < 1) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "numShards is a required parameter for 'compositeId' router");
                }
                ClusterStateMutator.getShardNames(numShards, shardNames);
            }
            List ranges = router.partitionRange(shardNames.size(), router.fullRange());
            slices = new LinkedHashMap<String, Slice>();
            for (int i = 0; i < shardNames.size(); ++i) {
                String sliceName = (String)shardNames.get(i);
                LinkedHashMap<String, Object> sliceProps = new LinkedHashMap<String, Object>(1);
                sliceProps.put("range", ranges == null ? null : (Object)ranges.get(i));
                slices.put(sliceName, new Slice(sliceName, null, sliceProps, cName));
            }
        }
        HashMap<String, Object> collectionProps = new HashMap<String, Object>();
        for (Map.Entry<String, Object> e : OverseerCollectionMessageHandler.COLLECTION_PROPS_AND_DEFAULTS.entrySet()) {
            Object val = message.get(e.getKey());
            if (val == null) {
                val = OverseerCollectionMessageHandler.COLLECTION_PROPS_AND_DEFAULTS.get(e.getKey());
            }
            if (val == null) continue;
            collectionProps.put(e.getKey(), val);
        }
        collectionProps.put("router", routerSpec);
        if (message.getStr("fromApi") == null) {
            collectionProps.put("autoCreated", "true");
        }
        String znode = message.getInt("stateFormat", Integer.valueOf(1)) == 1 ? null : ZkStateReader.getCollectionPath((String)cName);
        DocCollection newCollection = new DocCollection(cName, slices, collectionProps, router, -1, znode);
        return new ZkWriteCommand(cName, newCollection);
    }

    public ZkWriteCommand deleteCollection(ClusterState clusterState, ZkNodeProps message) {
        String collection = message.getStr("name");
        if (!CollectionMutator.checkKeyExistence(message, "name")) {
            return ZkStateWriter.NO_OP;
        }
        DocCollection coll = clusterState.getCollectionOrNull(collection);
        if (coll == null) {
            return ZkStateWriter.NO_OP;
        }
        return new ZkWriteCommand(coll.getName(), null);
    }

    public static ClusterState newState(ClusterState state, String name, DocCollection collection) {
        ClusterState newClusterState = null;
        newClusterState = collection == null ? state.copyWith(name, null) : state.copyWith(name, collection);
        return newClusterState;
    }

    public static void getShardNames(Integer numShards, List<String> shardNames) {
        if (numShards == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "numShards is a required param");
        }
        for (int i = 0; i < numShards; ++i) {
            String sliceName = "shard" + (i + 1);
            shardNames.add(sliceName);
        }
    }

    public static void getShardNames(List<String> shardNames, String shards) {
        if (shards == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "shards is a required param");
        }
        for (String s : shards.split(",")) {
            if (s == null || s.trim().isEmpty()) continue;
            shardNames.add(s.trim());
        }
        if (shardNames.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "shards is a required param");
        }
    }

    public static String getAssignedId(DocCollection collection, String nodeName) {
        Collection slices;
        Collection collection2 = slices = collection != null ? collection.getSlices() : null;
        if (slices != null) {
            for (Slice slice : slices) {
                if (slice.getReplicasMap().get(nodeName) == null) continue;
                return slice.getName();
            }
        }
        return null;
    }

    public static String getAssignedCoreNodeName(DocCollection collection, String forNodeName, String forCoreName) {
        Collection slices;
        Collection collection2 = slices = collection != null ? collection.getSlices() : null;
        if (slices != null) {
            for (Slice slice : slices) {
                for (Replica replica : slice.getReplicas()) {
                    String nodeName = replica.getStr("node_name");
                    String core = replica.getStr("core");
                    if (!nodeName.equals(forNodeName) || !core.equals(forCoreName)) continue;
                    return replica.getName();
                }
            }
        }
        return null;
    }

    public ZkWriteCommand migrateStateFormat(ClusterState clusterState, ZkNodeProps message) {
        String collection = message.getStr("collection");
        if (!CollectionMutator.checkKeyExistence(message, "collection")) {
            return ZkStateWriter.NO_OP;
        }
        DocCollection coll = clusterState.getCollectionOrNull(collection);
        if (coll == null || coll.getStateFormat() == 2) {
            return ZkStateWriter.NO_OP;
        }
        return new ZkWriteCommand(coll.getName(), new DocCollection(coll.getName(), coll.getSlicesMap(), coll.getProperties(), coll.getRouter(), 0, ZkStateReader.getCollectionPath((String)collection)));
    }
}

