/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.graphic.configuration;

import com.projectlibre1.graphic.configuration.shape.Colors;
import com.projectlibre1.graphic.configuration.shape.PredefinedPaint;
import com.projectlibre1.graphic.configuration.shape.PredefinedShape;
import com.projectlibre1.graphic.configuration.shape.PredefinedStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class TexturedShape {
    PredefinedShape shape = null;
    Color color = null;
    Paint paint = null;
    Stroke stroke = null;
    String paintName = null;
    String colorName = null;
    String strokeName = null;
    String shapeName = null;
    double shapeScaleX = 1.0;
    double shapeScaleY = 1.0;

    void build() {
        this.shape = PredefinedShape.find(this.shapeName);
        this.color = Colors.findColor(this.colorName);
        this.stroke = PredefinedStroke.find(this.strokeName);
        this.paint = new PredefinedPaint(PredefinedPaint.find(this.paintName), this.color, Colors.findColor("WHITE"));
    }

    public void setShapeName(String string) {
        this.shapeName = string;
    }

    public void setColorName(String string) {
        this.colorName = string;
    }

    public void setStrokeName(String string) {
        this.strokeName = string;
    }

    public void setPaintName(String string) {
        this.paintName = string;
    }

    public Color getColor() {
        return this.color;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public PredefinedShape getShape() {
        return this.shape;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public void setShape(PredefinedShape predefinedShape) {
        this.shape = predefinedShape;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public Shape draw(Graphics2D graphics2D, double d, double d2, double d3, double d4, boolean bl) {
        return this.draw(graphics2D, d, d2, d3, d4, null, bl);
    }

    public double getShapeScaleX() {
        return this.shapeScaleX;
    }

    public void setShapeScaleX(double d) {
        this.shapeScaleX = d;
    }

    public double getShapeScaleY() {
        return this.shapeScaleY;
    }

    public void setShapeScaleY(double d) {
        this.shapeScaleY = d;
    }

    public Shape draw(Graphics2D graphics2D, double d, double d2, AffineTransform affineTransform, boolean bl) {
        return this.draw(graphics2D, this.shapeScaleX, this.shapeScaleY, d, d2, affineTransform, bl);
    }

    public GeneralPath toGeneralPath(double d, double d2, double d3, double d4, AffineTransform affineTransform) {
        GeneralPath generalPath = this.getShape().toGeneralPath(d - 1.0, d2, d3, d4);
        if (affineTransform != null) {
            generalPath.transform(affineTransform);
        }
        return generalPath;
    }

    public Shape draw(Graphics2D graphics2D, double d, double d2, double d3, double d4, AffineTransform affineTransform, boolean bl) {
        GeneralPath generalPath = this.toGeneralPath(d, d2, d3, d4, affineTransform);
        this.paintShape(graphics2D, generalPath, bl);
        return generalPath;
    }

    public void paintShape(Graphics2D graphics2D, Shape shape, boolean bl) {
        Stroke stroke = null;
        Paint paint = null;
        Color color = null;
        Paint paint2 = this.getPaint();
        Stroke stroke2 = this.getStroke();
        if (paint2 == null) {
            color = graphics2D.getColor();
            graphics2D.setColor(this.getColor());
            if (stroke2 != PredefinedStroke.SOLID) {
                stroke = graphics2D.getStroke();
                graphics2D.setStroke(stroke2);
            }
            graphics2D.draw(shape);
        } else {
            paint = graphics2D.getPaint();
            this.applyPaint(graphics2D, bl);
            graphics2D.fill(shape);
            if (stroke2 != PredefinedStroke.SOLID) {
                color = graphics2D.getColor();
                graphics2D.setColor(this.getColor());
                stroke = graphics2D.getStroke();
                graphics2D.setStroke(stroke2);
                graphics2D.draw(shape);
            }
        }
        if (color != null) {
            graphics2D.setColor(color);
        }
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
        if (stroke != null) {
            graphics2D.setStroke(stroke);
        }
    }

    protected void applyPaint(Graphics2D graphics2D, boolean bl) {
        if (bl) {
            graphics2D.setPaint(this.paint);
        } else if (this.paint instanceof PredefinedPaint) {
            PredefinedPaint predefinedPaint = (PredefinedPaint)this.paint;
            predefinedPaint.applyPaint(graphics2D, bl);
        } else {
            graphics2D.setColor(this.getColor());
        }
    }
}

