/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

public final class JSAttributes {
    public static final String VALUE = "value";
    public static final String GET = "get";
    public static final String SET = "set";
    public static final String WRITABLE = "writable";
    public static final String ENUMERABLE = "enumerable";
    public static final String CONFIGURABLE = "configurable";
    public static final int NOT_ENUMERABLE = 1;
    public static final int NOT_CONFIGURABLE = 2;
    public static final int NOT_WRITABLE = 4;
    public static final int ATTRIBUTES_MASK = 7;
    private static final int NOT_CONFIGURABLE_ENUMERABLE_WRITABLE = 2;
    private static final int NOT_CONFIGURABLE_ENUMERABLE_NOT_WRITABLE = 6;
    private static final int NOT_CONFIGURABLE_NOT_ENUMERABLE_WRITABLE = 3;
    private static final int NOT_CONFIGURABLE_NOT_ENUMERABLE_NOT_WRITABLE = 7;
    private static final int CONFIGURABLE_NOT_ENUMERABLE_WRITABLE = 1;
    private static final int CONFIGURABLE_NOT_ENUMERABLE_NOT_WRITABLE = 5;
    private static final int CONFIGURABLE_ENUMERABLE_NOT_WRITABLE = 4;
    private static final int CONFIGURABLE_ENUMERABLE_WRITABLE = 0;

    private JSAttributes() {
    }

    public static int getDefault() {
        return JSAttributes.configurableEnumerableWritable();
    }

    public static int getDefaultNotEnumerable() {
        return JSAttributes.configurableNotEnumerableWritable();
    }

    public static int configurableEnumerableWritable() {
        return 0;
    }

    public static int configurableNotEnumerableWritable() {
        return 1;
    }

    public static int configurableEnumerableNotWritable() {
        return 4;
    }

    public static int configurableNotEnumerableNotWritable() {
        return 5;
    }

    public static int notConfigurableNotEnumerableNotWritable() {
        return 7;
    }

    public static int notConfigurableNotEnumerableWritable() {
        return 3;
    }

    public static int notConfigurableEnumerableWritable() {
        return 2;
    }

    public static int notConfigurableEnumerableNotWritable() {
        return 6;
    }

    public static int getAccessorDefault() {
        return JSAttributes.configurableEnumerableWritable();
    }

    public static int notConfigurableNotEnumerable() {
        return JSAttributes.notConfigurableNotEnumerableWritable();
    }

    public static int configurableNotEnumerable() {
        return JSAttributes.configurableNotEnumerableWritable();
    }

    public static int fromConfigurableEnumerableWritable(boolean configurable, boolean enumerable, boolean writable) {
        return (!configurable ? 2 : 0) | (!enumerable ? 1 : 0) | (!writable ? 4 : 0);
    }

    public static int fromConfigurableEnumerable(boolean configurable, boolean enumerable) {
        return (!configurable ? 2 : 0) | (!enumerable ? 1 : 0);
    }

    public static boolean isConfigurable(int flags) {
        return (flags & 2) == 0;
    }

    public static boolean isEnumerable(int flags) {
        return (flags & 1) == 0;
    }

    public static boolean isWritable(int flags) {
        return (flags & 4) == 0;
    }
}

