/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.BigInt;

@GeneratedBy(value=ImportValueNode.class)
public final class ImportValueNodeGen
extends ImportValueNode
implements Introspection.Provider {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private int state_;

    private ImportValueNodeGen() {
    }

    @Override
    public Object executeWithTarget(Object arg0Value) {
        int state = this.state_;
        if ((state & 1) != 0 && arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            return ImportValueNode.fromInt(arg0Value_);
        }
        if ((state & 2) != 0 && JSTypesGen.isImplicitString((state & 0x3C000) >>> 14, arg0Value)) {
            String arg0Value_ = JSTypesGen.asImplicitString((state & 0x3C000) >>> 14, arg0Value);
            return ImportValueNode.fromString(arg0Value_);
        }
        if ((state & 4) != 0 && arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            return ImportValueNode.fromBoolean(arg0Value_);
        }
        if ((state & 8) != 0 && arg0Value instanceof BigInt) {
            BigInt arg0Value_ = (BigInt)arg0Value;
            return ImportValueNode.fromBigInt(arg0Value_);
        }
        if ((state & 0x30) != 0 && arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            if ((state & 0x10) != 0 && JSGuards.isLongRepresentableAsInt32(arg0Value_)) {
                return ImportValueNode.fromLongToInt(arg0Value_);
            }
            if ((state & 0x20) != 0 && !JSGuards.isLongRepresentableAsInt32(arg0Value_)) {
                return ImportValueNode.fromLong(arg0Value_);
            }
        }
        if ((state & 0x40) != 0 && JSTypesGen.isImplicitDouble((state & 0x3C0000) >>> 18, arg0Value)) {
            double arg0Value_ = JSTypesGen.asImplicitDouble((state & 0x3C0000) >>> 18, arg0Value);
            return ImportValueNode.fromDouble(arg0Value_);
        }
        if ((state & 0x80) != 0 && arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            return ImportValueNode.fromNumber(arg0Value_);
        }
        if ((state & 0x100) != 0 && arg0Value instanceof Short) {
            short arg0Value_ = (Short)arg0Value;
            return ImportValueNode.fromNumber(arg0Value_);
        }
        if ((state & 0x200) != 0 && arg0Value instanceof Float) {
            float arg0Value_ = ((Float)arg0Value).floatValue();
            return ImportValueNode.fromNumber(arg0Value_);
        }
        if ((state & 0x400) != 0 && arg0Value instanceof Character) {
            char arg0Value_ = ((Character)arg0Value).charValue();
            return ImportValueNode.fromChar(arg0Value_);
        }
        if ((state & 0x800) != 0 && JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject arg0Value_ = (DynamicObject)arg0Value;
            return ImportValueNode.fromDynamicObject(arg0Value_);
        }
        if ((state & 0x1000) != 0 && arg0Value instanceof TruffleObject) {
            TruffleObject arg0Value_ = (TruffleObject)arg0Value;
            return ImportValueNode.fromTruffleObject(arg0Value_);
        }
        if ((state & 0x2000) != 0 && ImportValueNodeGen.fallbackGuard_(state, arg0Value)) {
            return ImportValueNode.fallbackCase(arg0Value);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private Object executeAndSpecialize(Object arg0Value) {
        int n;
        int state = this.state_;
        if (arg0Value instanceof Integer) {
            int n2 = (Integer)arg0Value;
            this.state_ = state |= 1;
            return ImportValueNode.fromInt(n2);
        }
        int n3 = JSTypesGen.specializeImplicitString(arg0Value);
        if (n3 != 0) {
            String arg0Value_3 = JSTypesGen.asImplicitString(n3, arg0Value);
            state |= n3 << 14;
            this.state_ = state |= 2;
            return ImportValueNode.fromString(arg0Value_3);
        }
        if (arg0Value instanceof Boolean) {
            boolean bl = (Boolean)arg0Value;
            this.state_ = state |= 4;
            return ImportValueNode.fromBoolean(bl);
        }
        if (arg0Value instanceof BigInt) {
            BigInt bigInt = (BigInt)arg0Value;
            this.state_ = state |= 8;
            return ImportValueNode.fromBigInt(bigInt);
        }
        if (arg0Value instanceof Long) {
            long l = (Long)arg0Value;
            if (JSGuards.isLongRepresentableAsInt32(l)) {
                this.state_ = state |= 0x10;
                return ImportValueNode.fromLongToInt(l);
            }
            if (!JSGuards.isLongRepresentableAsInt32(l)) {
                this.state_ = state |= 0x20;
                return ImportValueNode.fromLong(l);
            }
        }
        if ((n = JSTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
            double arg0Value_7 = JSTypesGen.asImplicitDouble(n, arg0Value);
            state |= n << 18;
            this.state_ = state |= 0x40;
            return ImportValueNode.fromDouble(arg0Value_7);
        }
        if (arg0Value instanceof Byte) {
            byte by = (Byte)arg0Value;
            this.state_ = state |= 0x80;
            return ImportValueNode.fromNumber(by);
        }
        if (arg0Value instanceof Short) {
            short s = (Short)arg0Value;
            this.state_ = state |= 0x100;
            return ImportValueNode.fromNumber(s);
        }
        if (arg0Value instanceof Float) {
            float f = ((Float)arg0Value).floatValue();
            this.state_ = state |= 0x200;
            return ImportValueNode.fromNumber(f);
        }
        if (arg0Value instanceof Character) {
            char c = ((Character)arg0Value).charValue();
            this.state_ = state |= 0x400;
            return ImportValueNode.fromChar(c);
        }
        if (JSTypes.isDynamicObject(arg0Value)) {
            DynamicObject dynamicObject = (DynamicObject)arg0Value;
            this.state_ = state |= 0x800;
            return ImportValueNode.fromDynamicObject(dynamicObject);
        }
        if (arg0Value instanceof TruffleObject) {
            TruffleObject truffleObject = (TruffleObject)arg0Value;
            this.state_ = state |= 0x1000;
            return ImportValueNode.fromTruffleObject(truffleObject);
        }
        this.state_ = state |= 0x2000;
        return ImportValueNode.fallbackCase(arg0Value);
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x3FFF) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x3FFF & (state & 0x3FFF) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[15];
        data[0] = 0;
        int state = this.state_;
        Object[] s = new Object[3];
        s[0] = "fromInt";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "fromString";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "fromBoolean";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "fromBigInt";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "fromLongToInt";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "fromLong";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "fromDouble";
        s[1] = (state & 0x40) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "fromNumber";
        s[1] = (state & 0x80) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[8] = s;
        s = new Object[3];
        s[0] = "fromNumber";
        s[1] = (state & 0x100) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[9] = s;
        s = new Object[3];
        s[0] = "fromNumber";
        s[1] = (state & 0x200) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[10] = s;
        s = new Object[3];
        s[0] = "fromChar";
        s[1] = (state & 0x400) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[11] = s;
        s = new Object[3];
        s[0] = "fromDynamicObject";
        s[1] = (state & 0x800) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[12] = s;
        s = new Object[3];
        s[0] = "fromTruffleObject";
        s[1] = (state & 0x1000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[13] = s;
        s = new Object[3];
        s[0] = "fallbackCase";
        s[1] = (state & 0x2000) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[14] = s;
        return Introspection.Provider.create((Object[])data);
    }

    private static boolean fallbackGuard_(int state, Object arg0Value) {
        if (JSTypesGen.isImplicitString(arg0Value)) {
            return false;
        }
        if ((state & 4) == 0 && arg0Value instanceof Boolean) {
            return false;
        }
        if (JSTypesGen.isImplicitDouble(arg0Value)) {
            return false;
        }
        if ((state & 0x80) == 0 && arg0Value instanceof Byte) {
            return false;
        }
        if ((state & 0x100) == 0 && arg0Value instanceof Short) {
            return false;
        }
        if ((state & 0x200) == 0 && arg0Value instanceof Float) {
            return false;
        }
        if ((state & 0x400) == 0 && arg0Value instanceof Character) {
            return false;
        }
        return (state & 0x1000) != 0 || !(arg0Value instanceof TruffleObject);
    }

    public static ImportValueNode create() {
        return new ImportValueNodeGen();
    }

    public static ImportValueNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=ImportValueNode.class)
    private static final class Uncached
    extends ImportValueNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object executeWithTarget(Object arg0Value) {
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                return ImportValueNode.fromInt(arg0Value_);
            }
            if (JSTypesGen.isImplicitString(arg0Value)) {
                String arg0Value_ = JSTypesGen.asImplicitString(arg0Value);
                return ImportValueNode.fromString(arg0Value_);
            }
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                return ImportValueNode.fromBoolean(arg0Value_);
            }
            if (arg0Value instanceof BigInt) {
                BigInt arg0Value_ = (BigInt)arg0Value;
                return ImportValueNode.fromBigInt(arg0Value_);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                if (JSGuards.isLongRepresentableAsInt32(arg0Value_)) {
                    return ImportValueNode.fromLongToInt(arg0Value_);
                }
                if (!JSGuards.isLongRepresentableAsInt32(arg0Value_)) {
                    return ImportValueNode.fromLong(arg0Value_);
                }
            }
            if (JSTypesGen.isImplicitDouble(arg0Value)) {
                double arg0Value_ = JSTypesGen.asImplicitDouble(arg0Value);
                return ImportValueNode.fromDouble(arg0Value_);
            }
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (Byte)arg0Value;
                return ImportValueNode.fromNumber(arg0Value_);
            }
            if (arg0Value instanceof Short) {
                short arg0Value_ = (Short)arg0Value;
                return ImportValueNode.fromNumber(arg0Value_);
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = ((Float)arg0Value).floatValue();
                return ImportValueNode.fromNumber(arg0Value_);
            }
            if (arg0Value instanceof Character) {
                char arg0Value_ = ((Character)arg0Value).charValue();
                return ImportValueNode.fromChar(arg0Value_);
            }
            if (JSTypes.isDynamicObject(arg0Value)) {
                DynamicObject arg0Value_ = (DynamicObject)arg0Value;
                return ImportValueNode.fromDynamicObject(arg0Value_);
            }
            if (arg0Value instanceof TruffleObject) {
                TruffleObject arg0Value_ = (TruffleObject)arg0Value;
                return ImportValueNode.fromTruffleObject(arg0Value_);
            }
            return ImportValueNode.fallbackCase(arg0Value);
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }
    }
}

