/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.navigation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.EditorExtender;
import org.netbeans.modules.javascript2.editor.FileUtils;
import org.netbeans.modules.javascript2.editor.Utils;
import org.netbeans.modules.javascript2.editor.navigation.OccurrencesSupport;
import org.netbeans.modules.javascript2.editor.parser.JsParserResult;
import org.netbeans.modules.javascript2.lexer.api.JsDocumentationTokenId;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.javascript2.lexer.api.LexUtilities;
import org.netbeans.modules.javascript2.model.api.Index;
import org.netbeans.modules.javascript2.model.api.IndexedElement;
import org.netbeans.modules.javascript2.model.api.JsElement;
import org.netbeans.modules.javascript2.model.api.JsFunction;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.Model;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.model.api.Occurrence;
import org.netbeans.modules.javascript2.types.api.Type;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class DeclarationFinderImpl
implements DeclarationFinder {
    private final Language<JsTokenId> language;

    public DeclarationFinderImpl(Language<JsTokenId> language) {
        this.language = language;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult info, int caretOffset) {
        FileObject fo;
        JsObject object;
        if (!(info instanceof JsParserResult)) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        JsParserResult jsResult = (JsParserResult)info;
        Snapshot snapshot = jsResult.getSnapshot();
        TokenSequence ts = LexUtilities.getTokenSequence((Snapshot)snapshot, (int)caretOffset, this.language);
        int offset = info.getSnapshot().getEmbeddedOffset(caretOffset);
        ts.move(offset);
        if (ts.moveNext() && ts.token().id() == JsTokenId.STRING) {
            String path = ts.token().text().toString();
            Token token = LexUtilities.findPreviousToken((TokenSequence)ts, Utils.LOOK_FOR_IMPORT_EXPORT_TOKENS);
            if (token.id() == JsTokenId.KEYWORD_IMPORT || token.id() == JsTokenId.KEYWORD_EXPORT) {
                FileObject currentFO = snapshot.getSource().getFileObject();
                FileObject destinationFO = FileUtils.findFileObject(currentFO, path, false);
                if (destinationFO == null) return DeclarationFinder.DeclarationLocation.NONE;
                return new DeclarationFinder.DeclarationLocation(destinationFO, 0);
            }
        }
        Model model = Model.getModel((ParserResult)jsResult, (boolean)false);
        model.resolve();
        OccurrencesSupport os = new OccurrencesSupport(model);
        Occurrence occurrence = os.getOccurrence(offset);
        if (occurrence != null) {
            FileObject fo2;
            Collection assignments;
            object = (JsObject)occurrence.getDeclarations().iterator().next();
            JsObject parent = object.getParent();
            Collection collection = assignments = parent == null ? null : parent.getAssignmentForOffset(offset);
            if (assignments != null && assignments.isEmpty()) {
                assignments = parent.getAssignments();
            }
            Index jsIndex = Index.get((FileObject)snapshot.getSource().getFileObject());
            ArrayList indexResults = new ArrayList();
            if (assignments == null || assignments.isEmpty()) {
                fo2 = object.getFileObject();
                if (object.isDeclared()) {
                    if (fo2 != null) {
                        if (!fo2.equals(snapshot.getSource().getFileObject()) || object.getDeclarationName() == null) return new DeclarationFinder.DeclarationLocation(fo2, this.getDeclarationOffset(object), (ElementHandle)object);
                        int docOffset = LexUtilities.getLexerOffset((ParserResult)jsResult, (int)this.getDeclarationOffset(object));
                        if (docOffset > -1 && ts != null) {
                            int docTsOffset;
                            ts.move(offset);
                            if (ts.moveNext() && ((docTsOffset = LexUtilities.getLexerOffset((ParserResult)jsResult, (int)ts.offset())) > docOffset || docOffset > docTsOffset + ts.token().length())) {
                                return new DeclarationFinder.DeclarationLocation(fo2, docOffset, (ElementHandle)object);
                            }
                        }
                    }
                } else {
                    JsObject property;
                    int partIndex;
                    Collection items = Index.get((FileObject)fo2).findByFqn(object.getFullyQualifiedName(), Index.TERMS_BASIC_INFO);
                    indexResults.addAll(items);
                    DeclarationFinder.DeclarationLocation location = this.processIndexResult(indexResults);
                    if (location != null) {
                        return location;
                    }
                    String fqn = object.getFullyQualifiedName();
                    String[] fqnParts = fqn.split("\\.");
                    for (parent = object; parent != null && !fqnParts[0].equals(parent.getFullyQualifiedName()); parent = parent.getParent()) {
                    }
                    if (parent == null) {
                        return DeclarationFinder.DeclarationLocation.NONE;
                    }
                    for (partIndex = 1; partIndex < fqnParts.length && (property = parent.getProperty(fqnParts[partIndex])) != null && property.isDeclared(); ++partIndex) {
                        parent = property;
                    }
                    String lastDefinedFQN = parent.getFullyQualifiedName();
                    ArrayList<IndexResult> rItems = new ArrayList<IndexResult>();
                    if (partIndex < fqnParts.length) {
                        rItems.addAll(this.findPropertyOfType(jsIndex, lastDefinedFQN.toString(), fqnParts[partIndex]));
                        parent = this.findPropertyOrParameterInModel(parent, fqnParts[partIndex]);
                        for (int i = ++partIndex; !rItems.isEmpty() && i < fqnParts.length; ++i) {
                            Collection assigns;
                            ArrayList<IndexResult> copy = new ArrayList<IndexResult>(rItems);
                            rItems.clear();
                            for (IndexResult indexResult : copy) {
                                rItems.addAll(this.findPropertyOfType(jsIndex, IndexedElement.getFQN((IndexResult)indexResult), fqnParts[i]));
                            }
                            if (rItems.isEmpty() && parent != null && !(assigns = parent.getAssignments()).isEmpty()) {
                                for (Type type : assigns) {
                                    String afqn = ModelUtils.getFQNFromType((Type)type);
                                    rItems.addAll(this.findPropertyOfType(jsIndex, afqn, fqnParts[i]));
                                }
                            }
                            if (parent == null) continue;
                            parent = this.findPropertyOrParameterInModel(parent, fqnParts[i]);
                        }
                    }
                    if ((location = this.processIndexResult(rItems)) != null) {
                        return location;
                    }
                }
            } else {
                fo2 = object.getFileObject();
                if (object.isDeclared() && fo2 != null) {
                    if (!fo2.equals(snapshot.getSource().getFileObject())) return new DeclarationFinder.DeclarationLocation(fo2, this.getDeclarationOffset(object), (ElementHandle)object);
                    int docOffset = LexUtilities.getLexerOffset((ParserResult)jsResult, (int)this.getDeclarationOffset(object));
                    if (docOffset > -1) {
                        return new DeclarationFinder.DeclarationLocation(fo2, docOffset, (ElementHandle)object);
                    }
                }
                if (ts != null) {
                    ts.move(offset);
                    if (ts.moveNext() && ts.token().id() == JsTokenId.IDENTIFIER) {
                        String propertyName = ts.token().text().toString();
                        for (Type type : assignments) {
                            String fqn = ModelUtils.getFQNFromType((Type)type);
                            Collection<? extends IndexResult> items = this.findPropertyOfType(jsIndex, fqn, propertyName);
                            if (items.isEmpty()) {
                                Collection tmpItems = jsIndex.findByFqn(fqn, Index.TERMS_BASIC_INFO);
                                for (IndexResult indexResult : tmpItems) {
                                    Collection tmpAssignments = IndexedElement.getAssignments((IndexResult)indexResult);
                                    for (Type type2 : tmpAssignments) {
                                        items = this.findPropertyOfType(jsIndex, ModelUtils.getFQNFromType((Type)type2), propertyName);
                                        indexResults.addAll(items);
                                    }
                                }
                                continue;
                            }
                            indexResults.addAll(items);
                        }
                        DeclarationFinder.DeclarationLocation location = this.processIndexResult(indexResults);
                        if (location != null) {
                            return location;
                        }
                    }
                }
            }
        }
        object = EditorExtender.getDefault().getDeclarationFinders().iterator();
        while (object.hasNext()) {
            DeclarationFinder finder = (DeclarationFinder)object.next();
            DeclarationFinder.DeclarationLocation loc = finder.findDeclaration(info, caretOffset);
            if (loc == null || loc == DeclarationFinder.DeclarationLocation.NONE) continue;
            return loc;
        }
        if (occurrence == null || (fo = (object = (JsObject)occurrence.getDeclarations().iterator().next()).getFileObject()) == null || object.getName() == null) return DeclarationFinder.DeclarationLocation.NONE;
        Collection items = Index.get((FileObject)fo).query("bn", object.getName(), QuerySupport.Kind.EXACT, Index.TERMS_BASIC_INFO);
        ArrayList<IndexResult> indexResults = new ArrayList<IndexResult>();
        for (IndexResult item : items) {
            IndexedElement element = IndexedElement.create((IndexResult)item);
            if (element.getModifiers().contains(Modifier.PRIVATE) || element.getJSKind() == JsElement.Kind.PARAMETER) continue;
            indexResults.add(item);
        }
        DeclarationFinder.DeclarationLocation location = this.processIndexResult(indexResults);
        if (location == null) return DeclarationFinder.DeclarationLocation.NONE;
        return location;
    }

    private int getDeclarationOffset(JsObject object) {
        return object.getDeclarationName() != null ? object.getDeclarationName().getOffsetRange().getStart() : object.getOffset();
    }

    private JsObject findPropertyOrParameterInModel(JsObject parent, String name) {
        JsObject object = parent.getProperty(name);
        if (object == null && parent instanceof JsFunction) {
            object = ((JsFunction)parent).getParameter(name);
        }
        return object;
    }

    private Collection<? extends IndexResult> findPropertyOfType(Index jsIndex, String fqn, String propertyName) {
        return this.findPropertyOfType(jsIndex, fqn, propertyName, 0);
    }

    private Collection<? extends IndexResult> findPropertyOfType(Index jsIndex, String fqn, String propertyName, int count) {
        ArrayList<? extends IndexResult> items = new ArrayList<IndexResult>();
        if (count > 5) {
            return items;
        }
        items.addAll(jsIndex.findByFqn(fqn + "." + propertyName, Index.TERMS_BASIC_INFO));
        if (items.isEmpty()) {
            items.addAll(jsIndex.findByFqn(fqn + ".prototype." + propertyName, Index.TERMS_BASIC_INFO));
        }
        if (items.isEmpty()) {
            Collection findByFqn = jsIndex.findByFqn(fqn, Index.TERMS_BASIC_INFO);
            for (IndexResult indexResult : findByFqn) {
                Collection assignments = IndexedElement.getAssignments((IndexResult)indexResult);
                for (Type tmpType : assignments) {
                    items.addAll(this.findPropertyOfType(jsIndex, ModelUtils.getFQNFromType((Type)tmpType), propertyName, count++));
                }
            }
        }
        return items;
    }

    private DeclarationFinder.DeclarationLocation processIndexResult(List<IndexResult> indexResults) {
        if (!indexResults.isEmpty()) {
            IndexResult iResult = indexResults.get(0);
            if (iResult.getFile() == null) {
                return null;
            }
            String value = iResult.getValue("offset");
            int offset = Integer.parseInt(value);
            HashSet<String> alreadyThere = new HashSet<String>();
            DeclarationFinder.DeclarationLocation location = new DeclarationFinder.DeclarationLocation(iResult.getFile(), offset, (ElementHandle)IndexedElement.create((IndexResult)iResult));
            alreadyThere.add(iResult.getFile().getPath() + offset);
            if (indexResults.size() > 1) {
                for (int i = 0; i < indexResults.size(); ++i) {
                    iResult = indexResults.get(i);
                    if (iResult == null || iResult.getFile() == null || alreadyThere.contains(iResult.getFile().getPath() + offset)) continue;
                    location.addAlternative((DeclarationFinder.AlternativeLocation)new AlternativeLocationImpl(iResult));
                    alreadyThere.add(iResult.getFile().getPath() + offset);
                }
            }
            return location;
        }
        return null;
    }

    public OffsetRange getReferenceSpan(final Document doc, final int caretOffset) {
        if (doc == null) {
            return OffsetRange.NONE;
        }
        final OffsetRange[] value = new OffsetRange[1];
        doc.render(new Runnable(){

            @Override
            public void run() {
                TokenSequence ts = LexUtilities.getTokenSequence((Document)doc, (int)caretOffset, (Language)DeclarationFinderImpl.this.language);
                if (ts != null) {
                    ts.move(caretOffset);
                    if (ts.moveNext() && ts.token().id() == JsTokenId.IDENTIFIER) {
                        value[0] = new OffsetRange(ts.offset(), ts.offset() + ts.token().length());
                    } else if (ts.token() != null && ts.token().id() == JsTokenId.DOC_COMMENT) {
                        TokenSequence tsDoc = LexerUtils.getTokenSequence((Document)doc, (int)caretOffset, (Language)JsDocumentationTokenId.language(), (boolean)true);
                        if (tsDoc != null && tsDoc.token() != null && tsDoc.token().id() == JsDocumentationTokenId.OTHER && tsDoc.moveNext() && tsDoc.token().id() == JsDocumentationTokenId.BRACKET_RIGHT_CURLY && tsDoc.movePrevious() && tsDoc.movePrevious() && tsDoc.token().id() == JsDocumentationTokenId.BRACKET_LEFT_CURLY) {
                            tsDoc.moveNext();
                            value[0] = new OffsetRange(tsDoc.offset(), tsDoc.offset() + tsDoc.token().length());
                        }
                    } else if (ts.token() != null && ts.token().id() == JsTokenId.STRING) {
                        int start = ts.offset();
                        int end = ts.offset() + ts.token().length();
                        Token token = LexUtilities.findPreviousToken((TokenSequence)ts, Utils.LOOK_FOR_IMPORT_EXPORT_TOKENS);
                        if (token.id() == JsTokenId.KEYWORD_IMPORT || token.id() == JsTokenId.KEYWORD_EXPORT) {
                            value[0] = new OffsetRange(start, end);
                        }
                    }
                }
            }
        });
        if (value[0] != null) {
            return value[0];
        }
        for (DeclarationFinder declarationFinder : EditorExtender.getDefault().getDeclarationFinders()) {
            OffsetRange result = declarationFinder.getReferenceSpan(doc, caretOffset);
            if (result == null || result == OffsetRange.NONE) continue;
            return result;
        }
        return OffsetRange.NONE;
    }

    @SuppressWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"})
    public static class AlternativeLocationImpl
    implements DeclarationFinder.AlternativeLocation {
        private final IndexResult iResult;
        private final int offset;
        private final DeclarationFinder.DeclarationLocation location;
        private final IndexedElement element;

        public AlternativeLocationImpl(IndexResult iResult) {
            this.iResult = iResult;
            String value = iResult.getValue("offset");
            this.offset = Integer.parseInt(value);
            this.location = new DeclarationFinder.DeclarationLocation(iResult.getFile(), this.offset);
            this.element = IndexedElement.create((IndexResult)iResult);
        }

        public ElementHandle getElement() {
            return this.element;
        }

        private String getStringLocation() {
            List asLines;
            int lineNumber = 0;
            int count = 0;
            try {
                asLines = this.element.getFileObject().asLines();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                asLines = null;
            }
            if (asLines != null) {
                for (String line : asLines) {
                    ++lineNumber;
                    if ((count += line.length()) < this.offset) continue;
                    break;
                }
            }
            String result = this.iResult.getRelativePath();
            if (lineNumber > 0) {
                result = result + " : " + lineNumber;
            }
            return result;
        }

        public String getDisplayHtml(HtmlFormatter formatter) {
            formatter.appendText(this.getStringLocation());
            return formatter.getText();
        }

        public DeclarationFinder.DeclarationLocation getLocation() {
            return this.location;
        }

        public int compareTo(DeclarationFinder.AlternativeLocation o) {
            AlternativeLocationImpl ali = (AlternativeLocationImpl)o;
            return this.getStringLocation().compareTo(ali.getStringLocation());
        }
    }
}

