/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.nb.actions;

import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.terminal.api.ui.TerminalContainer;
import org.netbeans.modules.terminal.ioprovider.Terminal;
import org.netbeans.modules.terminal.nb.actions.TerminalAction;
import org.openide.util.Lookup;
import org.openide.windows.IOContainer;

public class SwitchTabAction
extends TerminalAction {
    public SwitchTabAction() {
        this((Terminal)null);
    }

    public SwitchTabAction(Terminal context) {
        super(context);
        KeyStroke[] keyStrokes = new KeyStroke[10];
        for (int i = 0; i < 10; ++i) {
            keyStrokes[i] = KeyStroke.getKeyStroke(48 + i, 8);
        }
        this.putValue("AcceleratorKey", keyStrokes);
        this.putValue("Name", SwitchTabAction.getMessage("CTL_SwitchTab"));
    }

    @Override
    protected void performAction() {
        Container container = SwingUtilities.getAncestorOfClass(TerminalContainer.class, this.getTerminal());
        if (container != null && container instanceof TerminalContainer) {
            TerminalContainer tc = (TerminalContainer)container;
            List<? extends Component> allTabs = tc.getAllTabs();
            try {
                int requested = Integer.parseInt(this.getEvent().getActionCommand());
                int n = requested = requested == 0 ? 9 : requested - 1;
                if (requested >= allTabs.size() || requested < 0) {
                    return;
                }
                if (allTabs.get(requested) instanceof Terminal) {
                    Terminal terminal = (Terminal)allTabs.get(requested);
                    if (tc instanceof IOContainer.Provider) {
                        ((IOContainer.Provider)tc).select((JComponent)terminal);
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new SwitchTabAction((Terminal)actionContext.lookup(Terminal.class));
    }
}

