/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging.launch;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseErrorCode;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.lsp.server.debugging.DebugAdapterContext;
import org.netbeans.modules.java.lsp.server.debugging.NbSourceProvider;
import org.netbeans.modules.java.lsp.server.debugging.launch.NbDebugSession;
import org.netbeans.modules.java.lsp.server.debugging.launch.NbProcessConsole;
import org.netbeans.modules.java.lsp.server.progress.OperationContext;
import org.netbeans.modules.java.lsp.server.progress.ProgressOperationEvent;
import org.netbeans.modules.java.lsp.server.progress.ProgressOperationListener;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Pair;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public abstract class NbLaunchDelegate {
    public abstract void preLaunch(Map<String, Object> var1, DebugAdapterContext var2);

    public abstract void postLaunch(Map<String, Object> var1, DebugAdapterContext var2);

    protected void notifyFinished(DebugAdapterContext ctx, boolean success) {
    }

    public final CompletableFuture<Void> nbLaunch(FileObject toRun, String method, final DebugAdapterContext context, boolean debug, Consumer<NbProcessConsole.ConsoleMessage> consoleMessages) {
        final CompletableFuture<Void> launchFuture = new CompletableFuture<Void>();
        final NbProcessConsole ioContext = new NbProcessConsole(consoleMessages);
        SingleMethod singleMethod = method != null ? new SingleMethod(toRun, method) : null;
        CompletableFuture<Pair<ActionProvider, String>> commandFuture = this.findTargetWithPossibleRebuild(toRun, singleMethod, debug, ioContext);
        ((CompletableFuture)commandFuture.thenAccept(providerAndCommand -> {
            if (debug) {
                DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)new DebuggerManagerAdapter(){

                    public void sessionAdded(Session session) {
                        final JPDADebugger debugger = (JPDADebugger)session.lookupFirst(null, JPDADebugger.class);
                        if (debugger != null) {
                            DebuggerManager.getDebuggerManager().removeDebuggerListener((DebuggerManagerListener)this);
                            Map properties = (Map)session.lookupFirst(null, Map.class);
                            NbSourceProvider sourceProvider = context.getSourceProvider();
                            sourceProvider.setSourcePath(properties != null ? properties.getOrDefault("sourcepath", ClassPath.EMPTY) : ClassPath.EMPTY);
                            debugger.addPropertyChangeListener("state", new PropertyChangeListener(){

                                @Override
                                public void propertyChange(PropertyChangeEvent evt) {
                                    int newState = (Integer)evt.getNewValue();
                                    if (newState == 2) {
                                        debugger.removePropertyChangeListener("state", (PropertyChangeListener)this);
                                        NbDebugSession debugSession = new NbDebugSession(debugger);
                                        context.setDebugSession(debugSession);
                                        launchFuture.complete(null);
                                        context.getConfigurationSemaphore().waitForConfigurationDone();
                                    }
                                }
                            });
                        }
                    }
                });
            } else {
                launchFuture.complete(null);
            }
            ActionProgress progress = new ActionProgress(){

                protected void started() {
                }

                public void finished(boolean success) {
                    ioContext.stop();
                    NbLaunchDelegate.this.notifyFinished(context, success);
                }
            };
            ProxyLookup launchCtx = new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{toRun, ioContext, progress}), Lookup.getDefault()});
            OperationContext ctx = OperationContext.find(Lookup.getDefault());
            ctx.addProgressOperationListener(null, new ProgressOperationListener(){

                @Override
                public void progressHandleCreated(ProgressOperationEvent e) {
                    context.setProcessExecutorHandle(e.getProgressHandle());
                }
            });
            Lookup lookup = singleMethod != null ? Lookups.fixed((Object[])new Object[]{toRun, singleMethod, ioContext, progress}) : Lookups.fixed((Object[])new Object[]{toRun, ioContext, progress});
            Lookups.executeWith((Lookup)launchCtx, () -> ((ActionProvider)providerAndCommand.first()).invokeAction((String)providerAndCommand.second(), lookup));
        })).exceptionally(t -> {
            launchFuture.completeExceptionally((Throwable)t);
            return null;
        });
        return launchFuture;
    }

    private CompletableFuture<Pair<ActionProvider, String>> findTargetWithPossibleRebuild(final FileObject toRun, final SingleMethod singleMethod, final boolean debug, NbProcessConsole ioContext) throws IllegalArgumentException {
        Pair<ActionProvider, String> providerAndCommand = NbLaunchDelegate.findTarget(toRun, singleMethod, debug);
        if (providerAndCommand != null) {
            return CompletableFuture.completedFuture(providerAndCommand);
        }
        final CompletableFuture<Pair<ActionProvider, String>> afterBuild = new CompletableFuture<Pair<ActionProvider, String>>();
        class CheckBuildProgress
        extends ActionProgress {
            boolean running;

            CheckBuildProgress() {
            }

            protected void started() {
                this.running = true;
            }

            public void finished(boolean success) {
                Pair<ActionProvider, String> providerAndCommand;
                if (success && (providerAndCommand = NbLaunchDelegate.findTarget(toRun, singleMethod, debug)) != null) {
                    afterBuild.complete(providerAndCommand);
                    return;
                }
                afterBuild.completeExceptionally((Throwable)new ResponseErrorException(new ResponseError(ResponseErrorCode.MethodNotFound, "Cannot find " + (debug ? "debug" : "run") + " action!", null)));
            }
        }
        CheckBuildProgress progress = new CheckBuildProgress();
        ProxyLookup launchCtx = new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{toRun, ioContext, progress}), Lookup.getDefault()});
        Collection<ActionProvider> providers = NbLaunchDelegate.findActionProviders(toRun);
        for (ActionProvider ap : providers) {
            if (!ap.isActionEnabled("build", (Lookup)launchCtx)) continue;
            Lookups.executeWith((Lookup)launchCtx, () -> NbLaunchDelegate.lambda$findTargetWithPossibleRebuild$3(ap, (Lookup)launchCtx));
            break;
        }
        if (!progress.running) {
            progress.finished(true);
        }
        return afterBuild;
    }

    @CheckForNull
    protected static Pair<ActionProvider, String> findTarget(FileObject toRun, SingleMethod singleMethod, boolean debug) {
        String[] actions;
        FileObject fileRoot;
        ClassPath sourceCP = ClassPath.getClassPath((FileObject)toRun, (String)"classpath/source");
        FileObject fileObject = fileRoot = sourceCP != null ? sourceCP.findOwnerRoot(toRun) : null;
        boolean mainSource = fileRoot != null ? UnitTestForSourceQuery.findUnitTests((FileObject)fileRoot).length > 0 : true;
        ActionProvider provider = null;
        String command = null;
        Collection<ActionProvider> actionProviders = NbLaunchDelegate.findActionProviders(toRun);
        Lookup testLookup = Lookups.singleton((Object)toRun);
        if (mainSource && singleMethod != null) {
            String[] stringArray;
            if (debug) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "debug.single.method";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "run.single.method";
            }
            actions = stringArray;
        } else {
            String[] stringArray;
            if (debug) {
                if (mainSource) {
                    String[] stringArray4 = new String[1];
                    stringArray = stringArray4;
                    stringArray4[0] = "debug.single";
                } else {
                    String[] stringArray5 = new String[2];
                    stringArray5[0] = "debug.test.single";
                    stringArray = stringArray5;
                    stringArray5[1] = "debug.single";
                }
            } else if (mainSource) {
                String[] stringArray6 = new String[1];
                stringArray = stringArray6;
                stringArray6[0] = "run.single";
            } else {
                String[] stringArray7 = new String[2];
                stringArray7[0] = "test.single";
                stringArray = stringArray7;
                stringArray7[1] = "run.single";
            }
            actions = stringArray;
        }
        for (String commandCandidate : actions) {
            provider = NbLaunchDelegate.findActionProvider(commandCandidate, actionProviders, testLookup);
            if (provider == null) continue;
            command = commandCandidate;
            break;
        }
        if (provider == null) {
            command = debug ? (mainSource ? "debug" : "debug") : (mainSource ? "run" : "test");
            provider = NbLaunchDelegate.findActionProvider(command, actionProviders, testLookup);
        }
        if (provider == null) {
            return null;
        }
        return Pair.of(provider, command);
    }

    private static Collection<ActionProvider> findActionProviders(FileObject toRun) {
        ArrayList<ActionProvider> actionProviders = new ArrayList<ActionProvider>();
        Project prj = FileOwnerQuery.getOwner((FileObject)toRun);
        if (prj != null) {
            ActionProvider ap = (ActionProvider)prj.getLookup().lookup(ActionProvider.class);
            actionProviders.add(ap);
        }
        actionProviders.addAll(Lookup.getDefault().lookupAll(ActionProvider.class));
        return actionProviders;
    }

    private static boolean supportsAction(ActionProvider ap, String action) {
        for (String supportedAction : ap.getSupportedActions()) {
            if (!supportedAction.equals(action)) continue;
            return true;
        }
        return false;
    }

    private static ActionProvider findActionProvider(String action, Collection<ActionProvider> actionProviders, Lookup enabledOnLookup) {
        for (ActionProvider ap : actionProviders) {
            if (!NbLaunchDelegate.supportsAction(ap, action) || !ap.isActionEnabled(action, enabledOnLookup)) continue;
            return ap;
        }
        return null;
    }

    private static /* synthetic */ void lambda$findTargetWithPossibleRebuild$3(ActionProvider ap, Lookup launchCtx) {
        ap.invokeAction("build", launchCtx);
    }
}

