/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.debugging;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.lsp4j.debug.launch.DSPLauncher;
import org.eclipse.lsp4j.debug.services.IDebugProtocolClient;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.eclipse.lsp4j.jsonrpc.JsonRpcException;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.MessageIssueException;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.netbeans.modules.java.lsp.server.debugging.DebugAdapterContext;
import org.netbeans.modules.java.lsp.server.debugging.NbProtocolServer;
import org.netbeans.modules.java.lsp.server.progress.OperationContext;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public final class Debugger {
    private Debugger() {
    }

    public static void startDebugger(InputStream in, OutputStream out) {
        DebugAdapterContext context = new DebugAdapterContext();
        NbProtocolServer server = new NbProtocolServer(context);
        Launcher<IDebugProtocolClient> serverLauncher = DSPLauncher.createServerLauncher((IDebugProtocolServer)server, in, out, null, ConsumeWithLookup::new);
        context.setClient((IDebugProtocolClient)serverLauncher.getRemoteProxy());
        Future runningServer = serverLauncher.startListening();
        try {
            runningServer.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static class ConsumeWithLookup
    implements MessageConsumer {
        private final MessageConsumer delegate;
        private OperationContext topContext;

        public ConsumeWithLookup(MessageConsumer delegate) {
            this.delegate = delegate;
        }

        public void consume(Message message) throws MessageIssueException, JsonRpcException {
            OperationContext ctx;
            InstanceContent ic = new InstanceContent();
            ProxyLookup ll = new ProxyLookup(new Lookup[]{new AbstractLookup((AbstractLookup.Content)ic), Lookup.getDefault()});
            if (this.topContext == null) {
                this.topContext = OperationContext.find(null);
            }
            if (this.topContext != null) {
                ctx = this.topContext.operationContext();
                ctx.disableCancels();
                ic.add((Object)ctx);
            } else {
                ctx = null;
            }
            Lookups.executeWith((Lookup)ll, () -> {
                try {
                    this.delegate.consume(message);
                }
                finally {
                    if (ctx != null) {
                        ctx.stop();
                    }
                }
            });
        }
    }
}

