/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.modules.java.lsp.server.Bundle;
import org.openide.util.Exceptions;

final class ConnectionSpec
implements Closeable {
    private final Boolean listen;
    private final int port;
    private final List<Closeable> close = new ArrayList<Closeable>();

    private ConnectionSpec(Boolean listen, int port) {
        this.listen = listen;
        this.port = port;
    }

    public static ConnectionSpec parse(String spec) throws CommandException {
        if (spec == null || spec.isEmpty() || spec.equals("stdio")) {
            return new ConnectionSpec(null, -1);
        }
        String listenPrefix = "listen:";
        if (spec.startsWith("listen:")) {
            int port = ConnectionSpec.parsePort(spec.substring("listen:".length()), spec);
            return new ConnectionSpec(true, port);
        }
        String connectPrefix = "connect:";
        if (spec.startsWith("connect:")) {
            int port = ConnectionSpec.parsePort(spec.substring("connect:".length()), spec);
            return new ConnectionSpec(false, port);
        }
        throw new CommandException(555, Bundle.MSG_ConnectionSpecError(spec));
    }

    private static Integer parsePort(String port, String spec) throws CommandException {
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException ex) {
            throw new CommandException(556, Bundle.MSG_PortParseError(port, spec));
        }
    }

    public void prepare(final String prefix, InputStream in, OutputStream out, final BiConsumer<InputStream, OutputStream> launcher) throws IOException {
        if (this.listen == null) {
            launcher.accept(in, out);
        } else if (this.listen.booleanValue()) {
            final ServerSocket server = new ServerSocket(this.port, 1, Inet4Address.getLoopbackAddress());
            this.close.add(server);
            int localPort = server.getLocalPort();
            Thread listeningThread = new Thread(prefix + " listening at port " + localPort){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                Socket socket = server.accept();
                                ConnectionSpec.this.close.add(socket);
                                ConnectionSpec.this.connectToSocket(socket, prefix, launcher);
                            }
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            continue;
                        }
                        break;
                    }
                }
            };
            listeningThread.start();
            out.write((prefix + " listening at port " + localPort).getBytes());
            out.flush();
        } else {
            Socket socket = new Socket(Inet4Address.getLoopbackAddress(), this.port);
            this.connectToSocket(socket, prefix, launcher);
        }
    }

    private void connectToSocket(final Socket socket, String prefix, final BiConsumer<InputStream, OutputStream> launcher) {
        int connectTo = socket.getPort();
        Thread connectedThread = new Thread(prefix + " connected to " + connectTo){

            @Override
            public void run() {
                try {
                    launcher.accept(socket.getInputStream(), socket.getOutputStream());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        connectedThread.start();
    }

    @Override
    public void close() throws IOException {
        for (Closeable c : this.close) {
            c.close();
        }
    }
}

