/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.RequestImpl;

public class BufferedServletInputStream
extends ServletInputStream {
    private int bytesRead = 0;
    private int limit = -1;
    private RequestImpl reqA;

    public BufferedServletInputStream() {
    }

    public BufferedServletInputStream(Request reqA) {
        this.setRequest(reqA);
    }

    public void setRequest(Request reqA) {
        this.reqA = (RequestImpl)reqA;
    }

    public int doRead() throws IOException {
        return this.reqA.doRead();
    }

    public int doRead(byte[] b, int off, int len) throws IOException {
        return this.reqA.doRead(b, off, len);
    }

    public void setLimit(int limit) {
        this.bytesRead = 0;
        this.limit = limit;
    }

    public int read() throws IOException {
        if (this.limit != -1) {
            if (this.bytesRead < this.limit) {
                ++this.bytesRead;
                return this.doRead();
            }
            return -1;
        }
        return this.doRead();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.limit != -1) {
            int numRead;
            if (this.bytesRead == this.limit) {
                return -1;
            }
            if (this.bytesRead + len > this.limit) {
                len = this.limit - this.bytesRead;
            }
            if ((numRead = this.doRead(b, off, len)) > 0) {
                this.bytesRead += numRead;
            }
            return numRead;
        }
        return this.doRead(b, off, len);
    }
}

