/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser.ir;

import com.oracle.js.parser.ir.BreakableNode;
import com.oracle.js.parser.ir.CatchNode;
import com.oracle.js.parser.ir.Flags;
import com.oracle.js.parser.ir.Label;
import com.oracle.js.parser.ir.LexicalContext;
import com.oracle.js.parser.ir.LexicalContextNode;
import com.oracle.js.parser.ir.Node;
import com.oracle.js.parser.ir.Statement;
import com.oracle.js.parser.ir.Symbol;
import com.oracle.js.parser.ir.Terminal;
import com.oracle.js.parser.ir.visitor.NodeVisitor;
import com.oracle.js.parser.ir.visitor.TranslatorNodeVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Block
extends Node
implements BreakableNode,
Terminal,
Flags<Block> {
    protected final List<Statement> statements;
    protected final Map<String, Symbol> symbols;
    private int blockScopedOrRedeclaredSymbols;
    private int declaredNames;
    private final Label entryLabel;
    private final Label breakLabel;
    protected final int flags;
    public static final int NEEDS_SCOPE = 1;
    public static final int IS_TERMINAL = 4;
    public static final int IS_GLOBAL_SCOPE = 8;
    public static final int IS_SYNTHETIC = 16;
    public static final int IS_BODY = 32;
    public static final int IS_PARAMETER_BLOCK = 64;
    public static final int IS_SWITCH_BLOCK = 128;

    public Block(long l, int n, int n2, Statement ... statementArray) {
        super(l, n);
        assert (this.start <= n);
        this.statements = Arrays.asList(statementArray);
        this.symbols = new LinkedHashMap<String, Symbol>();
        this.entryLabel = new Label("block_entry");
        this.breakLabel = new Label("block_break");
        int n3 = statementArray.length;
        int n4 = n3 > 0 && statementArray[n3 - 1].hasTerminalFlags() ? 4 : 0;
        this.flags = n4 | n2;
    }

    public Block(long l, int n, List<Statement> list) {
        this(l, n, 16, list);
    }

    public Block(long l, int n, int n2, List<Statement> list) {
        this(l, n, n2, list.toArray(new Statement[list.size()]));
    }

    private Block(Block block, int n, List<Statement> list, int n2, Map<String, Symbol> map) {
        super(block, n);
        this.statements = list;
        this.flags = n2;
        this.symbols = new LinkedHashMap<String, Symbol>(map);
        this.entryLabel = new Label(block.entryLabel);
        this.breakLabel = new Label(block.breakLabel);
        this.declaredNames = block.declaredNames;
        this.blockScopedOrRedeclaredSymbols = block.blockScopedOrRedeclaredSymbols;
    }

    public boolean isGlobalScope() {
        return this.getFlag(8);
    }

    @Override
    public Node accept(LexicalContext lexicalContext, NodeVisitor<? extends LexicalContext> nodeVisitor) {
        if (nodeVisitor.enterBlock(this)) {
            return nodeVisitor.leaveBlock(this.setStatements(lexicalContext, Node.accept(nodeVisitor, this.statements)));
        }
        return this;
    }

    @Override
    public <R> R accept(LexicalContext lexicalContext, TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return translatorNodeVisitor.enterBlock(this);
    }

    public List<Symbol> getSymbols() {
        return Collections.unmodifiableList(new ArrayList<Symbol>(this.symbols.values()));
    }

    public Symbol getExistingSymbol(String string) {
        return this.symbols.get(string);
    }

    public boolean isCatchBlock() {
        return this.statements.size() == 1 && this.statements.get(0) instanceof CatchNode;
    }

    @Override
    public void toString(StringBuilder stringBuilder, boolean bl) {
        for (Node node : this.statements) {
            node.toString(stringBuilder, bl);
            stringBuilder.append(';');
        }
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public boolean isTerminal() {
        return this.getFlag(4);
    }

    public Label getEntryLabel() {
        return this.entryLabel;
    }

    @Override
    public Label getBreakLabel() {
        return this.breakLabel;
    }

    public List<Statement> getStatements() {
        return Collections.unmodifiableList(this.statements);
    }

    public int getStatementCount() {
        return this.statements.size();
    }

    public int getFirstStatementLineNumber() {
        if (this.statements == null || this.statements.isEmpty()) {
            return -1;
        }
        return this.statements.get(0).getLineNumber();
    }

    public Statement getFirstStatement() {
        return this.statements.isEmpty() ? null : this.statements.get(0);
    }

    public Statement getLastStatement() {
        return this.statements.isEmpty() ? null : this.statements.get(this.statements.size() - 1);
    }

    public Block setStatements(LexicalContext lexicalContext, List<Statement> list) {
        if (this.statements == list) {
            return this;
        }
        int n = 0;
        if (!list.isEmpty()) {
            n = list.get(list.size() - 1).getFinish();
        }
        return Node.replaceInLexicalContext(lexicalContext, this, new Block(this, Math.max(this.finish, n), list, this.flags, this.symbols));
    }

    public void putSymbol(LexicalContext lexicalContext, Symbol symbol) {
        this.symbols.put(symbol.getName(), symbol);
        if (symbol.isBlockScoped() || symbol.isVarRedeclaredHere()) {
            ++this.blockScopedOrRedeclaredSymbols;
        }
        if (symbol.isBlockScoped() || symbol.isVarDeclaredHere()) {
            ++this.declaredNames;
        }
    }

    public boolean needsScope() {
        return (this.flags & 1) == 1;
    }

    public boolean isSynthetic() {
        return (this.flags & 0x10) == 16;
    }

    @Override
    public Block setFlags(LexicalContext lexicalContext, int n) {
        if (this.flags == n) {
            return this;
        }
        return Node.replaceInLexicalContext(lexicalContext, this, new Block(this, this.finish, this.statements, n, this.symbols));
    }

    @Override
    public Block setFlag(LexicalContext lexicalContext, int n) {
        return this.setFlags(lexicalContext, this.flags | n);
    }

    @Override
    public boolean getFlag(int n) {
        return (this.flags & n) == n;
    }

    @Override
    public boolean isBreakableWithoutLabel() {
        return false;
    }

    @Override
    public List<Label> getLabels() {
        return Collections.unmodifiableList(Arrays.asList(this.entryLabel, this.breakLabel));
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> nodeVisitor) {
        return LexicalContextNode.Acceptor.accept((LexicalContextNode)this, nodeVisitor);
    }

    @Override
    public <R> R accept(TranslatorNodeVisitor<? extends LexicalContext, R> translatorNodeVisitor) {
        return LexicalContextNode.Acceptor.accept((LexicalContextNode)this, translatorNodeVisitor);
    }

    public Map<String, Symbol> getSymbolMap() {
        return this.symbols;
    }

    public boolean hasBlockScopedOrRedeclaredSymbols() {
        return this.blockScopedOrRedeclaredSymbols != 0;
    }

    public boolean hasDeclarations() {
        return this.declaredNames != 0;
    }

    public boolean isFunctionBody() {
        return this.getFlag(32);
    }

    public boolean isParameterBlock() {
        return this.getFlag(64);
    }

    public boolean isSwitchBlock() {
        return this.getFlag(128);
    }
}

