/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.keyinfo;

import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.crypto.SSEData;
import com.sun.xml.ws.security.opt.impl.keyinfo.TokenBuilder;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages;
import java.security.cert.CertificateEncodingException;
import java.util.logging.Level;

public class X509TokenBuilder
extends TokenBuilder {
    AuthenticationTokenPolicy.X509CertificateBinding binding = null;

    public X509TokenBuilder(JAXBFilterProcessingContext context, AuthenticationTokenPolicy.X509CertificateBinding binding) {
        super(context);
        this.binding = binding;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public BuilderResult process() throws XWSSecurityException {
        x509id = this.binding.getUUID();
        if (x509id == null || x509id.equals("")) {
            x509id = this.context.generateID();
        }
        SecurityUtil.checkIncludeTokenPolicyOpt(this.context, this.binding, x509id);
        referenceType = this.binding.getReferenceType();
        if (X509TokenBuilder.logger.isLoggable(Level.FINEST)) {
            X509TokenBuilder.logger.log(Level.FINEST, LogStringsMessages.WSS_1851_REFERENCETYPE_X_509_TOKEN(referenceType));
        }
        result = new BuilderResult();
        if (referenceType.equals("Direct")) {
            bst = this.createBinarySecurityToken(this.binding, this.binding.getX509Certificate());
            if (bst == null) {
                X509TokenBuilder.logger.log(Level.SEVERE, LogStringsMessages.WSS_1802_WRONG_TOKENINCLUSION_POLICY(), "creating binary security token failed");
                throw new XWSSecurityException(LogStringsMessages.WSS_1802_WRONG_TOKENINCLUSION_POLICY());
            }
            dr = this.buildDirectReference(bst.getId(), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
            this.buildKeyInfo(dr, this.binding.getSTRID());
        } else if (referenceType.equals("Identifier")) {
            bst = this.createBinarySecurityToken(this.binding, this.binding.getX509Certificate());
            this.buildKeyInfoWithKI(this.binding, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier");
            try {
                if (this.binding.getSTRID() == null) ** GOTO lbl64
                bsToken = this.elementFactory.createBinarySecurityToken(null, this.binding.getX509Certificate().getEncoded());
                data = new SSEData(bsToken, false, this.context.getNamespaceContext());
                this.context.getSTRTransformCache().put(this.binding.getSTRID(), data);
            }
            catch (CertificateEncodingException ce) {
                X509TokenBuilder.logger.log(Level.SEVERE, LogStringsMessages.WSS_1814_ERROR_ENCODING_CERTIFICATE(), ce);
                throw new XWSSecurityException(LogStringsMessages.WSS_1814_ERROR_ENCODING_CERTIFICATE(), ce);
            }
        } else if (referenceType.equals("Thumbprint")) {
            bst = this.createBinarySecurityToken(this.binding, this.binding.getX509Certificate());
            ki = this.buildKeyInfoWithKI(this.binding, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1");
            try {
                if (this.binding.getSTRID() == null) ** GOTO lbl64
                bsToken = this.elementFactory.createBinarySecurityToken(null, this.binding.getX509Certificate().getEncoded());
                data = new SSEData(bsToken, false, this.context.getNamespaceContext());
                this.context.getSTRTransformCache().put(this.binding.getSTRID(), data);
            }
            catch (CertificateEncodingException ce) {
                X509TokenBuilder.logger.log(Level.SEVERE, LogStringsMessages.WSS_1814_ERROR_ENCODING_CERTIFICATE(), ce);
                throw new XWSSecurityException(LogStringsMessages.WSS_1814_ERROR_ENCODING_CERTIFICATE(), ce);
            }
        } else if (referenceType.equals("IssuerSerialNumber")) {
            bst = this.createBinarySecurityToken(this.binding, this.binding.getX509Certificate());
            xCert = this.binding.getX509Certificate();
            xis = this.elementFactory.createX509IssuerSerial(xCert.getIssuerDN().getName(), xCert.getSerialNumber());
            x509Data = this.elementFactory.createX509DataWithIssuerSerial(xis);
            this.buildKeyInfo(x509Data, this.binding.getSTRID());
            try {
                if (this.binding.getSTRID() == null) ** GOTO lbl64
                bsToken = this.elementFactory.createBinarySecurityToken(null, this.binding.getX509Certificate().getEncoded());
                data = new SSEData(bsToken, false, this.context.getNamespaceContext());
                this.context.getSTRTransformCache().put(this.binding.getSTRID(), data);
            }
            catch (CertificateEncodingException ce) {
                X509TokenBuilder.logger.log(Level.SEVERE, LogStringsMessages.WSS_1814_ERROR_ENCODING_CERTIFICATE(), ce);
                throw new XWSSecurityException(LogStringsMessages.WSS_1814_ERROR_ENCODING_CERTIFICATE(), ce);
            }
        } else {
            X509TokenBuilder.logger.log(Level.SEVERE, LogStringsMessages.WSS_1803_UNSUPPORTED_REFERENCE_TYPE(referenceType));
            throw new XWSSecurityException(LogStringsMessages.WSS_1803_UNSUPPORTED_REFERENCE_TYPE(referenceType));
        }
lbl64:
        // 7 sources

        result.setKeyInfo(this.keyInfo);
        return result;
    }
}

