/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi.infomodel;

import com.sun.xml.registry.uddi.infomodel.ExternalLinkImpl;
import com.sun.xml.registry.uddi.infomodel.InternationalStringImpl;
import com.sun.xml.registry.uddi.infomodel.RegistryObjectImpl;
import com.sun.xml.registry.uddi.infomodel.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.ExternalLink;
import javax.xml.registry.infomodel.Key;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.PostalAddress;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.TelephoneNumber;
import javax.xml.registry.infomodel.User;

public class OrganizationImpl
extends RegistryObjectImpl
implements Organization,
Serializable {
    private ArrayList services = new ArrayList();
    private ArrayList telephoneNumbers = new ArrayList();
    private ArrayList users = new ArrayList();
    private User primaryContact;

    public OrganizationImpl() {
    }

    public OrganizationImpl(Key key) {
        this();
        this.key = key;
    }

    public OrganizationImpl(String name) throws JAXRException {
        this();
        this.name = new InternationalStringImpl(name);
    }

    public OrganizationImpl(Key key, String description, String name) throws JAXRException {
        this(key);
        this.description = new InternationalStringImpl(description);
        this.name = new InternationalStringImpl(name);
    }

    public User getPrimaryContact() throws JAXRException {
        this.getObject();
        return this.primaryContact;
    }

    public void setPrimaryContact(User primaryContact) throws JAXRException {
        this.primaryContact = primaryContact;
        this.getObject();
        if (!this.users.contains(primaryContact)) {
            this.users.add(primaryContact);
        }
        this.setIsModified(true);
    }

    public void addUser(User user) throws JAXRException {
        if (user != null) {
            this.getObject();
            this.users.add(user);
            this.setIsModified(true);
        }
    }

    public void addUsers(Collection users) throws JAXRException {
        if (users != null) {
            this.getObject();
            this.users.addAll(users);
            this.setIsModified(true);
        }
    }

    public void removeUser(User user) throws JAXRException {
        if (user != null) {
            this.getObject();
            this.users.remove(user);
            this.setIsModified(true);
        }
    }

    public void removeUsers(Collection users) throws JAXRException {
        if (users != null) {
            this.getObject();
            this.users.removeAll(users);
            this.setIsModified(true);
        }
    }

    public Collection getUsers() throws JAXRException {
        if (this.users.size() == 0) {
            this.getObject();
        }
        return (Collection)this.users.clone();
    }

    public Collection getTelephoneNumbers(String phoneType) throws JAXRException {
        if (this.telephoneNumbers.size() == 0) {
            this.getObject();
        }
        if (phoneType == null) {
            return (Collection)this.telephoneNumbers.clone();
        }
        ArrayList<TelephoneNumber> numbers = new ArrayList<TelephoneNumber>();
        for (TelephoneNumber number : this.telephoneNumbers) {
            if (!number.getType().equals(phoneType)) continue;
            numbers.add(number);
        }
        return numbers;
    }

    public void setTelephoneNumbers(Collection phoneNumbers) throws JAXRException {
        this.getObject();
        this.telephoneNumbers.clear();
        if (phoneNumbers != null) {
            this.telephoneNumbers.addAll(phoneNumbers);
        }
        this.setIsModified(true);
    }

    public void addService(Service service) throws JAXRException {
        if (service != null) {
            this.getObject();
            ((ServiceImpl)service).setProvidingOrganization(this);
            this.services.add(service);
            this.setIsModified(true);
        }
    }

    public void addServices(Collection services) throws JAXRException {
        if (services == null) {
            return;
        }
        this.getObject();
        Iterator iter = services.iterator();
        try {
            while (iter.hasNext()) {
                ServiceImpl service = (ServiceImpl)iter.next();
                service.setProvidingOrganization(this);
                this.services.add(service);
            }
        }
        catch (ClassCastException e) {
            throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("OrganizationImpl:Objects_in_collection_must_be_services"), (Throwable)e);
        }
        this.setIsModified(true);
    }

    public void removeService(Service service) throws JAXRException {
        if (service != null) {
            this.getObject();
            this.services.remove(service);
            this.setIsModified(true);
        }
    }

    public void removeServices(Collection services) throws JAXRException {
        if (services != null) {
            this.getObject();
            this.services.removeAll(services);
            this.setIsModified(true);
        }
    }

    public Collection getServices() throws JAXRException {
        this.getObject();
        return (Collection)this.services.clone();
    }

    public void setServices(Collection services) throws JAXRException {
        this.getObject();
        this.services.clear();
        this.addServices(services);
    }

    @Override
    public void addExternalLink(ExternalLink link) throws JAXRException {
        if (link != null) {
            this.getObject();
            ExternalLinkImpl externalLink = (ExternalLinkImpl)link;
            externalLink.addLinkedObject(this);
            this.externalLinks.add(externalLink);
            this.setIsModified(true);
        }
    }

    @Override
    public void addExternalLinks(Collection links) throws JAXRException {
        if (links != null) {
            this.getObject();
            Iterator iter = links.iterator();
            try {
                while (iter.hasNext()) {
                    this.addExternalLink((ExternalLink)iter.next());
                }
            }
            catch (ClassCastException e) {
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("OrganizationImpl:Objects_in_collection_must_be_ExternalLinks"), (Throwable)e);
            }
        }
    }

    @Override
    public void setExternalLinks(Collection links) throws JAXRException {
        this.getObject();
        this.externalLinks.clear();
        this.addExternalLinks(links);
    }

    public PostalAddress getPostalAddress() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public void setPostalAddress(PostalAddress address) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public void addChildOrganization(Organization organization) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public void addChildOrganizations(Collection organization) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public void removeChildOrganization(Organization organization) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public void removeChildOrganizations(Collection organization) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public int getChildOrganizationCount() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public Collection getChildOrganizations() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public Collection getDescendantOrganizations() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public Organization getParentOrganization() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    public Organization getRootOrganization() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }
}

