/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser.plugins.chrome;

import java.io.File;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.netbeans.modules.extbrowser.plugins.ExtensionManager;
import org.netbeans.modules.extbrowser.plugins.chrome.LinkListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class ChromeInfoPanel
extends JPanel {
    private static final long serialVersionUID = 5394629966593049098L;
    private static final Logger LOGGER = Logger.getLogger(ChromeInfoPanel.class.getName());
    private JEditorPane myEditorPane;
    private JScrollPane myScrollPane;

    ChromeInfoPanel(String pluginPath, ExtensionManager.ExtensitionStatus currentStatus) {
        this.initComponents();
        File file = new File(pluginPath);
        String name = file.getName();
        File parent = file.getParentFile();
        StringBuilder text = new StringBuilder("<html>");
        if (currentStatus == ExtensionManager.ExtensitionStatus.NEEDS_UPGRADE) {
            text.append(NbBundle.getMessage(ChromeInfoPanel.class, (String)"TXT_RequestUpgrade"));
            text.append(" ");
        }
        String path = "";
        try {
            path = Utilities.toURI((File)parent).toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.WARNING, null, e);
        }
        text.append(NbBundle.getMessage(ChromeInfoPanel.class, (String)"TXT_PluginIstallationIssue", (Object)path, (Object)name, (Object)Integer.toHexString(UIManager.getDefaults().getColor("nb.errorForeground").getRGB() & 0xFFFFFF)));
        text.append("</html>");
        this.myEditorPane.setText(text.toString());
        this.myEditorPane.setCaretPosition(0);
        this.myEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.myEditorPane.setFont(new JLabel().getFont());
        this.myEditorPane.addHyperlinkListener(new LinkListener());
    }

    private void initComponents() {
        this.myScrollPane = new JScrollPane();
        this.myEditorPane = new JEditorPane();
        this.myEditorPane.setEditable(false);
        this.myEditorPane.setContentType("text/html");
        this.myEditorPane.setText(NbBundle.getMessage(ChromeInfoPanel.class, (String)"TXT_PluginIstallationIssue"));
        this.myScrollPane.setViewportView(this.myEditorPane);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.myScrollPane, -1, 519, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.myScrollPane, -1, 120, Short.MAX_VALUE).addContainerGap()));
    }
}

