/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.vendor;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.ejb.HibernateEntityManager;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.jpa.DefaultJpaDialect;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class HibernateJpaDialect
extends DefaultJpaDialect {
    public Object beginTransaction(EntityManager entityManager, TransactionDefinition definition) throws PersistenceException, SQLException, TransactionException {
        if (definition.getTimeout() != -1) {
            this.getSession(entityManager).getTransaction().setTimeout(definition.getTimeout());
        }
        super.beginTransaction(entityManager, definition);
        return this.prepareTransaction(entityManager, definition.isReadOnly(), definition.getName());
    }

    public Object prepareTransaction(EntityManager entityManager, boolean readOnly, String name) throws PersistenceException {
        Session session = this.getSession(entityManager);
        FlushMode flushMode = session.getFlushMode();
        FlushMode previousFlushMode = null;
        if (readOnly) {
            session.setFlushMode(FlushMode.MANUAL);
            previousFlushMode = flushMode;
        } else if (flushMode.lessThan(FlushMode.COMMIT)) {
            session.setFlushMode(FlushMode.AUTO);
            previousFlushMode = flushMode;
        }
        return new SessionTransactionData(session, previousFlushMode);
    }

    public void cleanupTransaction(Object transactionData) {
        ((SessionTransactionData)transactionData).resetFlushMode();
    }

    public ConnectionHandle getJdbcConnection(EntityManager entityManager, boolean readOnly) throws PersistenceException, SQLException {
        Session session = this.getSession(entityManager);
        return new HibernateConnectionHandle(session);
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof HibernateException) {
            return SessionFactoryUtils.convertHibernateAccessException((HibernateException)ex);
        }
        if (ex instanceof PersistenceException && ex.getCause() instanceof HibernateException) {
            return SessionFactoryUtils.convertHibernateAccessException((HibernateException)ex.getCause());
        }
        return EntityManagerFactoryUtils.convertJpaAccessExceptionIfPossible(ex);
    }

    protected Session getSession(EntityManager em) {
        if (em instanceof HibernateEntityManager) {
            return ((HibernateEntityManager)em).getSession();
        }
        Object delegate = em.getDelegate();
        if (delegate instanceof Session) {
            return (Session)delegate;
        }
        throw new IllegalStateException("Cannot obtain native Hibernate Session from given JPA EntityManager: " + em.getClass());
    }

    private static class HibernateConnectionHandle
    implements ConnectionHandle {
        private final Session session;
        private static final Method sessionConnectionMethod;
        private static volatile Method connectionMethodToUse;

        public HibernateConnectionHandle(Session session) {
            this.session = session;
        }

        public Connection getConnection() {
            try {
                if (connectionMethodToUse == null) {
                    connectionMethodToUse = this.session.getClass().getMethod("connection", new Class[0]);
                }
                return (Connection)ReflectionUtils.invokeMethod((Method)connectionMethodToUse, (Object)this.session);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Cannot find connection() method on Hibernate Session", ex);
            }
        }

        public void releaseConnection(Connection con) {
            if (sessionConnectionMethod != null) {
                JdbcUtils.closeConnection((Connection)con);
            }
        }

        static {
            connectionMethodToUse = sessionConnectionMethod = ClassUtils.getMethodIfAvailable(Session.class, (String)"connection", (Class[])new Class[0]);
        }
    }

    private static class SessionTransactionData {
        private final Session session;
        private final FlushMode previousFlushMode;

        public SessionTransactionData(Session session, FlushMode previousFlushMode) {
            this.session = session;
            this.previousFlushMode = previousFlushMode;
        }

        public void resetFlushMode() {
            if (this.previousFlushMode != null) {
                this.session.setFlushMode(this.previousFlushMode);
            }
        }
    }
}

