/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.api;

import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class ResizeOption {
    private final Type type;
    private final String displayName;
    private final int width;
    private final int height;
    private final boolean showInToolbar;
    private final boolean isDefault;
    public static final ResizeOption SIZE_TO_FIT = new ResizeOption(Type.CUSTOM, NbBundle.getMessage(ResizeOption.class, (String)"Lbl_AUTO"), -1, -1, true, true);

    private ResizeOption(Type type, String displayName, int width, int height, boolean showInToolbar, boolean isDefault) {
        Parameters.notEmpty((CharSequence)"displayName", (CharSequence)displayName);
        Parameters.notNull((CharSequence)"type", (Object)((Object)type));
        this.type = type;
        this.displayName = displayName;
        this.width = width;
        this.height = height;
        this.showInToolbar = showInToolbar;
        this.isDefault = isDefault;
    }

    public static ResizeOption create(Type type, String displayName, int width, int height, boolean showInToolbar, boolean isDefault) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid screen dimensions: " + width + " x " + height);
        }
        return new ResizeOption(type, displayName, width, height, showInToolbar, isDefault);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Type getType() {
        return this.type;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isShowInToolbar() {
        return this.showInToolbar;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String toString() {
        return this.displayName;
    }

    public String getToolTip() {
        if (this.width < 0 || this.height < 0) {
            return this.displayName;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.width);
        sb.append(" x ");
        sb.append(this.height);
        sb.append(" (");
        sb.append(this.displayName);
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResizeOption other = (ResizeOption)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        if (this.height != other.height) {
            return false;
        }
        if (this.showInToolbar != other.showInToolbar) {
            return false;
        }
        return this.isDefault == other.isDefault;
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 11 * hash + (this.displayName != null ? this.displayName.hashCode() : 0);
        hash = 11 * hash + this.width;
        hash = 11 * hash + this.height;
        hash = 11 * hash + (this.showInToolbar ? 1 : 0);
        hash = 11 * hash + (this.isDefault ? 1 : 0);
        return hash;
    }

    public static enum Type {
        DESKTOP,
        TABLET_PORTRAIT,
        TABLET_LANDSCAPE,
        SMARTPHONE_PORTRAIT,
        SMARTPHONE_LANDSCAPE,
        WIDESCREEN,
        NETBOOK,
        CUSTOM;

    }
}

