/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.ui.options;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

@SuppressWarnings(value={"SE_BAD_FIELD_STORE"})
public class CodeCompletionPanel
extends JPanel {
    private static final long serialVersionUID = -3783460333563884705L;
    private final Preferences preferences;
    private final ItemListener defaultCheckBoxListener = new DefaultCheckBoxListener();
    private final Map<String, Object> id2Saved = new HashMap<String, Object>();
    private JCheckBox autoCompletionSmartDelimitersCheckBox;
    private JCheckBox autoCompletionSmartQuotesCheckBox;
    private JLabel autoCompletionSmartQuotesDelimitersLabel;

    public CodeCompletionPanel(Preferences preferences) {
        assert (preferences != null);
        this.preferences = preferences;
        this.initComponents();
        this.initAutoCompletion();
    }

    public static PreferencesCustomizer.Factory getCustomizerFactory() {
        return pref -> new CodeCompletionPreferencesCustomizer(pref);
    }

    private void initAutoCompletion() {
        boolean codeCompletionSmartQuotes = this.preferences.getBoolean("twigAutoCompletionSmartQuotes", true);
        boolean codeCompletionSmartDelimiters = this.preferences.getBoolean("twigAutoCompletionSmartDelimiters", true);
        this.autoCompletionSmartQuotesCheckBox.setSelected(codeCompletionSmartQuotes);
        this.autoCompletionSmartQuotesCheckBox.addItemListener(this.defaultCheckBoxListener);
        this.autoCompletionSmartDelimitersCheckBox.setSelected(codeCompletionSmartDelimiters);
        this.autoCompletionSmartDelimitersCheckBox.addItemListener(this.defaultCheckBoxListener);
        this.id2Saved.put("twigAutoCompletionSmartQuotes", this.autoCompletionSmartQuotesCheckBox.isSelected());
        this.id2Saved.put("twigAutoCompletionSmartDelimiters", this.autoCompletionSmartDelimitersCheckBox.isSelected());
    }

    void validateData() {
        this.preferences.putBoolean("twigAutoCompletionSmartQuotes", this.autoCompletionSmartQuotesCheckBox.isSelected());
        this.preferences.putBoolean("twigAutoCompletionSmartDelimiters", this.autoCompletionSmartDelimitersCheckBox.isSelected());
    }

    private void initComponents() {
        this.autoCompletionSmartQuotesDelimitersLabel = new JLabel();
        this.autoCompletionSmartDelimitersCheckBox = new JCheckBox();
        this.autoCompletionSmartQuotesCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.autoCompletionSmartQuotesDelimitersLabel, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionSmartQuotesDelimitersLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoCompletionSmartDelimitersCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionSmartDelimitersCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.autoCompletionSmartQuotesCheckBox, (String)NbBundle.getMessage(CodeCompletionPanel.class, (String)"CodeCompletionPanel.autoCompletionSmartQuotesCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoCompletionSmartQuotesDelimitersLabel).addComponent(this.autoCompletionSmartDelimitersCheckBox).addComponent(this.autoCompletionSmartQuotesCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.autoCompletionSmartQuotesDelimitersLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoCompletionSmartQuotesCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoCompletionSmartDelimitersCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    String getSavedValue(String key) {
        return this.id2Saved.get(key).toString();
    }

    public static final class CustomCustomizerImpl
    extends PreferencesCustomizer.CustomCustomizer {
        public String getSavedValue(PreferencesCustomizer customCustomizer, String key) {
            if (customCustomizer instanceof CodeCompletionPreferencesCustomizer) {
                return ((CodeCompletionPanel)customCustomizer.getComponent()).getSavedValue(key);
            }
            return null;
        }
    }

    static final class CodeCompletionPreferencesCustomizer
    implements PreferencesCustomizer {
        private final Preferences preferences;
        private CodeCompletionPanel component;

        private CodeCompletionPreferencesCustomizer(Preferences preferences) {
            this.preferences = preferences;
        }

        public String getId() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getDisplayName() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("org.netbeans.modules.php.twig.editor.ui.options.CodeCompletionPanel");
        }

        public JComponent getComponent() {
            if (this.component == null) {
                this.component = new CodeCompletionPanel(this.preferences);
            }
            return this.component;
        }
    }

    private final class DefaultCheckBoxListener
    implements ItemListener {
        private DefaultCheckBoxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            CodeCompletionPanel.this.validateData();
        }
    }
}

