/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.v8debug.V8Arguments;
import org.netbeans.lib.v8debug.V8Breakpoint;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.lib.v8debug.commands.ChangeBreakpoint;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.breakpoints.BreakpointsHandler;
import org.netbeans.modules.javascript2.debug.breakpoints.JSBreakpointStatus;
import org.netbeans.modules.javascript2.debug.breakpoints.JSLineBreakpoint;
import org.netbeans.modules.web.common.sourcemap.SourceMapsTranslator;
import org.openide.util.WeakListeners;

public final class SubmittedBreakpoint {
    private static final Logger LOG = Logger.getLogger(SubmittedBreakpoint.class.getName());
    private final JSLineBreakpoint breakpoint;
    private final long id;
    private final SourceMapsTranslator.Location bpLoc;
    private final V8Debugger dbg;
    private final PropertyChangeListener bpChangeListener;
    private final PropertyChangeListener addedChangeListener;

    SubmittedBreakpoint(JSLineBreakpoint breakpoint, long id, SourceMapsTranslator.Location bpLoc, V8Breakpoint.ActualLocation[] actualLocations, V8Debugger dbg) {
        this.breakpoint = breakpoint;
        this.id = id;
        this.bpLoc = bpLoc;
        this.dbg = dbg;
        LOG.log(Level.FINE, "SubmittedBreakpoint({0}, {1})", new Object[]{breakpoint, id});
        this.adjustLocation(actualLocations);
        LOG.log(Level.FINE, "  adjusted BP => {0}", breakpoint);
        this.bpChangeListener = new BPChangeListener();
        this.addedChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this.bpChangeListener, (Object)breakpoint);
        breakpoint.addPropertyChangeListener(this.addedChangeListener);
        JSBreakpointStatus.setValid((JSLineBreakpoint)breakpoint, null);
    }

    public JSLineBreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    public long getId() {
        return this.id;
    }

    private void adjustLocation(V8Breakpoint.ActualLocation[] actualLocations) {
        if (actualLocations != null && actualLocations.length > 0) {
            long line = actualLocations[0].getLine();
            long column = actualLocations[0].getColumn();
            this.updatePosition(line, column);
        }
    }

    void updatePosition(long line, long column) {
        SourceMapsTranslator smt = this.dbg.getScriptsHandler().getSourceMapsTranslator();
        if (smt != null && this.bpLoc != null) {
            SourceMapsTranslator.Location newLoc;
            SourceMapsTranslator.Location l;
            if (line == 0L) {
                column -= (long)this.dbg.getScriptsHandler().getScriptFirstLineColumnShift(this.bpLoc.getFile());
            }
            if ((l = smt.getSourceLocation(newLoc = new SourceMapsTranslator.Location(this.bpLoc.getFile(), (int)line, (int)column))) != newLoc) {
                line = l.getLine();
            }
        }
        this.breakpoint.setLine((int)line + 1);
    }

    void notifyDestroyed() {
        this.breakpoint.removePropertyChangeListener(this.addedChangeListener);
        JSBreakpointStatus.resetValidity((JSLineBreakpoint)this.breakpoint);
    }

    private final class BPChangeListener
    implements PropertyChangeListener {
        private BPChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            switch (evt.getPropertyName()) {
                case "enabled": 
                case "condition": {
                    ChangeBreakpoint.Arguments cbargs = BreakpointsHandler.createChangeRequestArguments(SubmittedBreakpoint.this);
                    SubmittedBreakpoint.this.dbg.sendCommandRequest(V8Command.Changebreakpoint, (V8Arguments)cbargs);
                }
            }
        }
    }
}

