/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette.tester.ui.options;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.nette.tester.ui.options.Bundle;
import org.netbeans.modules.php.nette.tester.util.TesterUtils;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class TesterOptionsPanel
extends JPanel {
    private static final long serialVersionUID = -4168765465465778L;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JComboBox<String> binaryExecutableComboBox;
    private JLabel binaryExecutableLabel;
    private JButton browseTesterButton;
    private JLabel errorLabel;
    private JLabel installLabel;
    private JLabel learnMoreLabel;
    private JLabel minVersionLabel;
    private JLabel noteLabel;
    private JButton phpIniBrowseButton;
    private JLabel phpIniLabel;
    private JTextField phpIniTextField;
    private JButton searchTesterButton;
    private JLabel testerPathHintLabel;
    private JLabel testerPathLabel;
    private JTextField testerPathTextField;

    public TesterOptionsPanel() {
        this.initComponents();
        this.init();
    }

    private void init() {
        for (String binaryExecutable : TesterUtils.BINARY_EXECUTABLES) {
            this.binaryExecutableComboBox.addItem(binaryExecutable);
        }
        this.errorLabel.setText(" ");
        this.testerPathHintLabel.setText(Bundle.TesterOptionsPanel_tester_hint("tester"));
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        DefaultActionListener defaultActionListener = new DefaultActionListener();
        this.testerPathTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.phpIniTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.binaryExecutableComboBox.addActionListener(defaultActionListener);
    }

    public String getTesterPath() {
        return this.testerPathTextField.getText();
    }

    public void setTesterPath(String path) {
        this.testerPathTextField.setText(path);
    }

    public String getPhpIniPath() {
        return this.phpIniTextField.getText();
    }

    public void setPhpIniPath(String path) {
        this.phpIniTextField.setText(path);
    }

    @CheckForNull
    public String getBinaryExecutable() {
        return (String)this.binaryExecutableComboBox.getSelectedItem();
    }

    public void setBinaryExecutable(String binaryExecutable) {
        this.binaryExecutableComboBox.setSelectedItem(binaryExecutable);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    private void initComponents() {
        this.testerPathLabel = new JLabel();
        this.testerPathTextField = new JTextField();
        this.browseTesterButton = new JButton();
        this.searchTesterButton = new JButton();
        this.testerPathHintLabel = new JLabel();
        this.phpIniLabel = new JLabel();
        this.phpIniTextField = new JTextField();
        this.phpIniBrowseButton = new JButton();
        this.binaryExecutableLabel = new JLabel();
        this.binaryExecutableComboBox = new JComboBox();
        this.noteLabel = new JLabel();
        this.minVersionLabel = new JLabel();
        this.installLabel = new JLabel();
        this.learnMoreLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.testerPathLabel.setLabelFor(this.testerPathTextField);
        Mnemonics.setLocalizedText((JLabel)this.testerPathLabel, (String)NbBundle.getMessage(TesterOptionsPanel.class, (String)"TesterOptionsPanel.testerPathLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseTesterButton, (String)NbBundle.getMessage(TesterOptionsPanel.class, (String)"TesterOptionsPanel.browseTesterButton.text"));
        this.browseTesterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TesterOptionsPanel.this.browseTesterButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.searchTesterButton, (String)NbBundle.getMessage(TesterOptionsPanel.class, (String)"TesterOptionsPanel.searchTesterButton.text"));
        this.searchTesterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TesterOptionsPanel.this.searchTesterButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.testerPathHintLabel, (String)"HINT");
        this.phpIniLabel.setLabelFor(this.phpIniTextField);
        Mnemonics.setLocalizedText((JLabel)this.phpIniLabel, (String)NbBundle.getMessage(TesterOptionsPanel.class, (String)"TesterOptionsPanel.phpIniLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.phpIniBrowseButton, (String)NbBundle.getMessage(TesterOptionsPanel.class, (String)"TesterOptionsPanel.phpIniBrowseButton.text"));
        this.phpIniBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TesterOptionsPanel.this.phpIniBrowseButtonActionPerformed(evt);
            }
        });
        this.binaryExecutableLabel.setLabelFor(this.binaryExecutableComboBox);
        Mnemonics.setLocalizedText((JLabel)this.binaryExecutableLabel, (String)NbBundle.getMessage(TesterOptionsPanel.class, (String)"TesterOptionsPanel.binaryExecutableLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.noteLabel, (String)NbBundle.getMessage(TesterOptionsPanel.class, (String)"TesterOptionsPanel.noteLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.minVersionLabel, (String)NbBundle.getMessage(TesterOptionsPanel.class, (String)"TesterOptionsPanel.minVersionLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.installLabel, (String)NbBundle.getMessage(TesterOptionsPanel.class, (String)"TesterOptionsPanel.installLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.learnMoreLabel, (String)NbBundle.getMessage(TesterOptionsPanel.class, (String)"TesterOptionsPanel.learnMoreLabel.text"));
        this.learnMoreLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                TesterOptionsPanel.this.learnMoreLabelMouseEntered(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                TesterOptionsPanel.this.learnMoreLabelMousePressed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.testerPathLabel).addComponent(this.phpIniLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.testerPathTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseTesterButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchTesterButton)).addGroup(layout.createSequentialGroup().addComponent(this.testerPathHintLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.phpIniTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.phpIniBrowseButton)))).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.minVersionLabel).addComponent(this.installLabel).addComponent(this.learnMoreLabel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.binaryExecutableLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.binaryExecutableComboBox, -2, -1, -2)).addComponent(this.noteLabel, -2, -1, -2).addComponent(this.errorLabel)).addGap(0, 0, Short.MAX_VALUE)));
        layout.linkSize(0, this.browseTesterButton, this.phpIniBrowseButton, this.searchTesterButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchTesterButton).addComponent(this.browseTesterButton).addComponent(this.testerPathTextField, -2, -1, -2).addComponent(this.testerPathLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testerPathHintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.phpIniLabel).addComponent(this.phpIniTextField, -2, -1, -2).addComponent(this.phpIniBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.binaryExecutableLabel).addComponent(this.binaryExecutableComboBox, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.noteLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.minVersionLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.installLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.learnMoreLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel)));
    }

    private void browseTesterButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(TesterOptionsPanel.class).setFilesOnly(true).setTitle(Bundle.TesterOptionsPanel_tester_browse_title()).showOpenDialog();
        if (file != null) {
            this.testerPathTextField.setText(file.getAbsolutePath());
        }
    }

    private void searchTesterButtonActionPerformed(ActionEvent evt) {
        String tester = UiUtils.SearchWindow.search((UiUtils.SearchWindow.SearchWindowSupport)new UiUtils.SearchWindow.SearchWindowSupport(){

            public List<String> detect() {
                return FileUtils.findFileOnUsersPath((String)"tester");
            }

            public String getWindowTitle() {
                return Bundle.TesterOptionsPanel_tester_search_title();
            }

            public String getListTitle() {
                return Bundle.TesterOptionsPanel_tester_search_files();
            }

            public String getPleaseWaitPart() {
                return Bundle.TesterOptionsPanel_tester_search_pleaseWaitPart();
            }

            public String getNoItemsFound() {
                return Bundle.TesterOptionsPanel_tester_search_notFound();
            }
        });
        if (tester != null) {
            this.testerPathTextField.setText(tester);
        }
    }

    private void learnMoreLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void learnMoreLabelMousePressed(MouseEvent evt) {
        try {
            URL url = new URL("https://github.com/nette/tester");
            HtmlBrowser.URLDisplayer.getDefault().showURL(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void phpIniBrowseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(TesterOptionsPanel.class).setTitle(Bundle.TesterOptionsPanel_php_ini_browse_title()).setApproveText(Bundle.TesterOptionsPanel_php_ini_browse_ok()).showOpenDialog();
        if (file != null) {
            this.phpIniTextField.setText(file.getAbsolutePath());
        }
    }

    private final class DefaultActionListener
    implements ActionListener {
        private DefaultActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TesterOptionsPanel.this.fireChange();
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            TesterOptionsPanel.this.fireChange();
        }
    }
}

