/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localtasks.task;

import java.awt.Container;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.spi.IssueController;
import org.netbeans.modules.localtasks.task.LocalTask;
import org.netbeans.modules.localtasks.task.TaskPanel;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.windows.TopComponent;

final class TaskController
implements IssueController {
    private final LocalTask task;
    private final TaskPanel panel;
    private boolean opened;

    public TaskController(LocalTask task) {
        this.task = task;
        this.panel = new TaskPanel(task);
    }

    public JComponent getComponent() {
        return this.panel;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.localtasks.editor.TaskPanel");
    }

    public void opened() {
        if (!this.opened) {
            this.opened = true;
            this.panel.opened();
            this.task.opened();
        }
    }

    public void closed() {
        if (this.opened) {
            this.task.closed();
            this.panel.closed();
            this.opened = false;
        }
    }

    void refreshViewData() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                TaskController.this.panel.refreshViewData();
            }
        });
    }

    void modelStateChanged(boolean dirty) {
        this.panel.modelStateChanged(dirty);
    }

    void attachmentDeleted() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                TaskController.this.panel.attachmentDeleted();
            }
        });
    }

    public boolean saveChanges() {
        return this.panel.saveChanges();
    }

    public boolean discardUnsavedChanges() {
        return this.panel.discardUnsavedChanges();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.task.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.task.removePropertyChangeListener(l);
    }

    public boolean isChanged() {
        return this.task.hasUnsavedChanges() || this.task.hasUnsavedAttachments();
    }

    void taskDeleted() {
        Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                Container tc = SwingUtilities.getAncestorOfClass(TopComponent.class, TaskController.this.panel);
                if (tc instanceof TopComponent) {
                    ((TopComponent)tc).close();
                }
                return null;
            }
        });
    }
}

