/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.notifications.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.notifications.filter.NotificationFilter;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class FilterRepository {
    private static FilterRepository theInstance;
    private final LinkedList<NotificationFilter> filters = new LinkedList();
    private int active = -1;

    FilterRepository() {
    }

    public static FilterRepository getInstance() {
        if (null == theInstance) {
            theInstance = new FilterRepository();
        }
        return theInstance;
    }

    public void assign(FilterRepository fr) {
        if (fr != this) {
            this.filters.clear();
            Iterator it = fr.filters.iterator();
            while (it.hasNext()) {
                this.filters.add((NotificationFilter)((NotificationFilter)it.next()).clone());
            }
            this.active = fr.active;
        }
    }

    public Object clone() {
        FilterRepository ret = new FilterRepository();
        ret.assign(this);
        return ret;
    }

    public List<NotificationFilter> getAllFilters() {
        return new ArrayList<NotificationFilter>(this.filters);
    }

    void add(NotificationFilter f) {
        this.filters.add(f);
    }

    void remove(NotificationFilter f) {
        if (f == this.getActive()) {
            this.setActive(null);
        }
        this.filters.remove(f);
    }

    Iterator<NotificationFilter> iterator() {
        return this.filters.iterator();
    }

    int size() {
        return this.filters.size();
    }

    NotificationFilter getFilterByName(String name) {
        for (NotificationFilter f : this.filters) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public NotificationFilter getActive() {
        return this.active == -1 || this.filters.isEmpty() ? NotificationFilter.EMPTY : this.filters.get(this.active);
    }

    public void setActive(NotificationFilter newactive) {
        if (newactive == null || newactive.equals(NotificationFilter.EMPTY)) {
            this.active = -1;
        } else {
            int i = this.filters.indexOf(newactive);
            if (i != -1) {
                this.active = i;
            }
        }
    }

    public void load() throws IOException {
        this.filters.clear();
        this.active = -1;
        Preferences prefs = NbPreferences.forModule(FilterRepository.class);
        prefs = prefs.node("Filters");
        this.active = prefs.getInt("active", -1);
        int count = prefs.getInt("count", 0);
        for (int i = 0; i < count; ++i) {
            NotificationFilter filter = new NotificationFilter();
            try {
                filter.load(prefs, "Filter_" + i);
            }
            catch (BackingStoreException bsE) {
                throw new IOException("Cannot load filter repository", bsE);
            }
            this.filters.add(filter);
        }
    }

    public void save() throws IOException {
        try {
            Preferences prefs = NbPreferences.forModule(FilterRepository.class);
            prefs = prefs.node("Filters");
            prefs.clear();
            prefs.putBoolean("firstTimeStart", false);
            prefs.putBoolean("firstTimeStartWithIssue", false);
            prefs.putInt("count", this.filters.size());
            prefs.putInt("active", this.active);
            for (int i = 0; i < this.filters.size(); ++i) {
                NotificationFilter filter = this.filters.get(i);
                filter.save(prefs, "Filter_" + i);
            }
        }
        catch (BackingStoreException bsE) {
            throw new IOException("Cannot save filter repository", bsE);
        }
    }

    NotificationFilter createNewFilter() {
        return new NotificationFilter(NbBundle.getMessage(FilterRepository.class, (String)"LBL_NewFilter"));
    }

    void clear() {
        this.filters.clear();
        this.setActive(null);
    }

    List<NotificationFilter> getFilters() {
        return new ArrayList<NotificationFilter>(this.filters);
    }
}

