/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.bugs.NPECheck;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jdk.Bundle;
import org.netbeans.modules.java.hints.suggestions.ExpectedTypeResolver;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;

public class UnnecessaryBoxing {
    private static final boolean DEFAULT_PREFER_CAST_TO_BOXING = false;
    static final String PREFER_CAST_TO_BOXING = "boxing.prefer.cast";

    public static ErrorDescription run(HintContext ctx) {
        String text;
        TreePath expr;
        CompilationInfo ci = ctx.getInfo();
        TreePath p = ctx.getPath();
        TreePath vp = (TreePath)ctx.getVariables().get("$v");
        TypeMirror exprType = ci.getTrees().getTypeMirror(vp);
        if (exprType == null || !exprType.getKind().isPrimitive()) {
            return null;
        }
        Tree prev = ctx.getPath().getLeaf();
        for (expr = ctx.getPath().getParentPath(); expr != null && expr.getLeaf().getKind() == Tree.Kind.PARENTHESIZED; expr = expr.getParentPath()) {
            prev = expr.getLeaf();
        }
        if (expr == null) {
            return null;
        }
        boolean ok = true;
        Tree.Kind k = expr.getLeaf().getKind();
        if (k == Tree.Kind.METHOD_INVOCATION) {
            ok = UnnecessaryBoxing.checkMethodInvocation(ctx, expr, vp);
        } else if (k == Tree.Kind.NEW_CLASS) {
            ok = UnnecessaryBoxing.checkMethodInvocation(ctx, expr, vp);
        } else {
            if (k == Tree.Kind.INSTANCE_OF) {
                return null;
            }
            if (k == Tree.Kind.CONDITIONAL_EXPRESSION) {
                ok = UnnecessaryBoxing.checkConditional(ci, expr, prev);
            } else {
                if (k == Tree.Kind.MEMBER_SELECT) {
                    return null;
                }
                if (BinaryTree.class.isAssignableFrom(k.asInterface())) {
                    ok = UnnecessaryBoxing.checkBinaryOp(ci, expr, prev);
                } else if (AssignmentTree.class.isAssignableFrom(k.asInterface())) {
                    AssignmentTree as = (AssignmentTree)expr.getLeaf();
                    TypeMirror m = ci.getTrees().getTypeMirror(new TreePath(expr, as.getVariable()));
                    boolean bl = ok = m != null && ci.getTypes().isAssignable(exprType, m);
                }
            }
        }
        if (!ok) {
            return null;
        }
        TypeMirror boxedType = ci.getTrees().getTypeMirror(ctx.getPath());
        if (boxedType == null || boxedType.getKind() != TypeKind.DECLARED) {
            return null;
        }
        String tname = ci.getTypeUtilities().getTypeName(boxedType, new TypeUtilities.TypeNameOptions[0]).toString();
        TypeMirror valType = ci.getTrees().getTypeMirror(vp);
        TypeMirror unboxedResult = Utilities.unboxIfNecessary(ci, boxedType);
        if (unboxedResult == null) {
            return null;
        }
        TypeKind rk = unboxedResult.getKind();
        if (ci.getTypes().isSameType(valType, unboxedResult)) {
            rk = null;
        }
        if (rk != null) {
            boolean preferCast = ctx.getPreferences().getBoolean(PREFER_CAST_TO_BOXING, false);
            if (!preferCast) {
                return null;
            }
            text = Bundle.FIX_ChangeBoxingToTypecast(ci.getTypeUtilities().getTypeName(valType, new TypeUtilities.TypeNameOptions[0]));
        } else {
            text = p.getLeaf().getKind() == Tree.Kind.NEW_CLASS ? Bundle.FIX_UnnecessaryBoxing1(tname) : Bundle.FIX_UnnecessaryBoxing2(tname);
        }
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)ctx.getPath(), (String)Bundle.TEXT_UnnecessaryBoxing(tname), (Fix[])new Fix[]{new RemoveBoxingFix(TreePathHandle.create((TreePath)vp, (CompilationInfo)ci), text, TreePathHandle.create((TreePath)ctx.getPath(), (CompilationInfo)ci), rk).toEditorFix()});
    }

    private static boolean checkBinaryOp(CompilationInfo ci, TreePath expr, Tree prev) {
        Element el;
        BinaryTree bt = (BinaryTree)expr.getLeaf();
        ExpressionTree other = prev == bt.getLeftOperand() ? bt.getRightOperand() : bt.getLeftOperand();
        Boolean b = UnnecessaryBoxing.checkTwoArguments(ci, expr, other, prev);
        if (Boolean.TRUE == b) {
            return true;
        }
        if (b == null) {
            return false;
        }
        TypeMirror tm = ci.getTrees().getTypeMirror(new TreePath(expr, other));
        if (tm != null && tm.getKind() == TypeKind.DECLARED && (el = ((DeclaredType)tm).asElement()) != null && el.getKind() == ElementKind.CLASS) {
            return ((TypeElement)el).getQualifiedName().contentEquals("java.lang.String");
        }
        return false;
    }

    private static Boolean checkTwoArguments(CompilationInfo ci, TreePath expr, Tree other, Tree prev) {
        if (other == null || prev == null) {
            return null;
        }
        TreePath otherPath = new TreePath(expr, other);
        TreePath prevPath = new TreePath(expr, prev);
        TypeMirror pt = Utilities.unboxIfNecessary(ci, ci.getTrees().getTypeMirror(prevPath));
        TypeMirror ot = Utilities.unboxIfNecessary(ci, ci.getTrees().getTypeMirror(otherPath));
        if (!Utilities.isValidType(pt) || !Utilities.isValidType(ot)) {
            return null;
        }
        ExpectedTypeResolver res = new ExpectedTypeResolver(expr, prevPath, ci);
        List<? extends TypeMirror> types = res.scan(expr, null);
        if (types == null) {
            return null;
        }
        for (TypeMirror typeMirror : types) {
            if (!ci.getTypes().isAssignable(pt, typeMirror)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkConditional(CompilationInfo ci, TreePath expr, Tree prev) {
        ConditionalExpressionTree ct = (ConditionalExpressionTree)expr.getLeaf();
        if (ct.getCondition() == prev) {
            return true;
        }
        TreePath prevPath = new TreePath(expr, prev);
        TypeMirror boxedPrev = ci.getTrees().getTypeMirror(prevPath);
        TypeMirror pt = Utilities.unboxIfNecessary(ci, boxedPrev);
        if (!Utilities.isValidType(pt)) {
            return false;
        }
        ExpectedTypeResolver res = new ExpectedTypeResolver(expr, prevPath, ci);
        List<? extends TypeMirror> types = res.scan(expr, null);
        if (types == null) {
            return false;
        }
        for (TypeMirror typeMirror : types) {
            if (!typeMirror.getKind().isPrimitive() && !Utilities.isPrimitiveWrapperType(typeMirror)) {
                return false;
            }
            TypeMirror typeMirror2 = Utilities.unboxIfNecessary(ci, typeMirror);
            if (!ci.getTypes().isAssignable(pt, typeMirror2)) continue;
            TreePath other = new TreePath(expr, prev == ct.getTrueExpression() ? ct.getFalseExpression() : ct.getTrueExpression());
            TypeMirror m2 = ci.getTrees().getTypeMirror(other);
            if (!Utilities.isValidType(m2)) continue;
            if (NPECheck.isSafeToDereference(ci, other)) {
                return true;
            }
            if (Utilities.isPrimitiveWrapperType(m2) && !ci.getTypes().isSameType(boxedPrev, m2)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkMethodInvocation(HintContext ctx, TreePath invPath, TreePath valPath) {
        TypeMirror m;
        List<? extends ExpressionTree> arguments;
        Trees trees = ctx.getInfo().getTrees();
        Tree invLeaf = invPath.getLeaf();
        switch (invLeaf.getKind()) {
            case METHOD_INVOCATION: {
                MethodInvocationTree mit = (MethodInvocationTree)invLeaf;
                arguments = mit.getArguments();
                m = trees.getTypeMirror(new TreePath(invPath, mit.getMethodSelect()));
                break;
            }
            case NEW_CLASS: {
                NewClassTree nct = (NewClassTree)invLeaf;
                arguments = nct.getArguments();
                Element e = trees.getElement(invPath);
                TypeMirror cl = trees.getTypeMirror(invPath);
                if (!Utilities.isValidType(cl) || cl.getKind().isPrimitive()) {
                    return false;
                }
                m = ctx.getInfo().getTypes().asMemberOf((DeclaredType)cl, e);
                break;
            }
            default: {
                return false;
            }
        }
        if (!Utilities.isValidType(m) || m.getKind() != TypeKind.EXECUTABLE) {
            return false;
        }
        ExecutableType execType = (ExecutableType)m;
        int idx = arguments.indexOf(ctx.getPath().getLeaf());
        if (idx < 0 || idx >= execType.getParameterTypes().size()) {
            return false;
        }
        TypeMirror paramType = execType.getParameterTypes().get(idx);
        TypeMirror curType = trees.getTypeMirror(ctx.getPath());
        TypeMirror valType = trees.getTypeMirror(valPath);
        if (!paramType.getKind().isPrimitive() && valType.getKind().isPrimitive()) {
            valType = ctx.getInfo().getTypes().boxedClass((PrimitiveType)valType).asType();
            if (!ctx.getInfo().getTypes().isSameType(curType, valType)) {
                return false;
            }
        }
        return Utilities.checkAlternativeInvocation(ctx.getInfo(), invPath, ctx.getPath(), valPath, null);
    }

    private static boolean checkCommonInvocation(HintContext ctx, TreePath invPath, Tree sel, TreePath valPath) {
        Element origEl;
        TreePath newInvPath;
        Tree t;
        TreePath stPath;
        CompilationInfo ci = ctx.getInfo();
        CharSequence source = ci.getSnapshot().getText();
        Element e = ci.getTrees().getElement(invPath);
        if (!(e instanceof ExecutableElement)) {
            return false;
        }
        SourcePositions sp = ci.getTrees().getSourcePositions();
        int invOffset = (int)sp.getEndPosition(ci.getCompilationUnit(), sel) - 1;
        int origExpStart = (int)sp.getStartPosition(ci.getCompilationUnit(), ctx.getPath().getLeaf());
        int origExpEnd = (int)sp.getEndPosition(ci.getCompilationUnit(), ctx.getPath().getLeaf());
        TreePath exp = invPath;
        boolean statement = false;
        do {
            boolean breakPrev = false;
            TreePath previousPath = exp;
            Tree previous = exp.getLeaf();
            Tree t2 = (exp = exp.getParentPath()).getLeaf();
            Class<? extends Tree> c = t2.getKind().asInterface();
            if (c == CompoundAssignmentTree.class || c == AssignmentTree.class) break;
            switch (t2.getKind()) {
                case CONDITIONAL_EXPRESSION: {
                    ConditionalExpressionTree ctree = (ConditionalExpressionTree)t2;
                    if (ctree.getCondition() != previous) break;
                    breakPrev = true;
                    break;
                }
                case DO_WHILE_LOOP: {
                    DoWhileLoopTree dlp = (DoWhileLoopTree)t2;
                    if (dlp.getCondition() != previous) break;
                    breakPrev = true;
                    break;
                }
                case FOR_LOOP: {
                    ForLoopTree flp = (ForLoopTree)t2;
                    if (previous != flp.getCondition()) break;
                    breakPrev = true;
                    break;
                }
                case ENHANCED_FOR_LOOP: {
                    EnhancedForLoopTree eflp = (EnhancedForLoopTree)t2;
                    if (previous != eflp.getExpression()) break;
                    breakPrev = true;
                    break;
                }
                case SWITCH: {
                    StatementTree st = (SwitchTree)t2;
                    if (previous != st.getExpression()) break;
                    breakPrev = true;
                    break;
                }
                case SYNCHRONIZED: {
                    StatementTree st = (SynchronizedTree)t2;
                    if (previous != st.getExpression()) break;
                    breakPrev = true;
                    break;
                }
                case WHILE_LOOP: {
                    WhileLoopTree wlt = (WhileLoopTree)t2;
                    if (previous != wlt.getCondition()) break;
                    breakPrev = true;
                    break;
                }
                case IF: {
                    IfTree it = (IfTree)t2;
                    if (previous != it.getCondition()) break;
                    breakPrev = true;
                    break;
                }
            }
            if (breakPrev) {
                exp = previousPath;
                break;
            }
            if (!StatementTree.class.isAssignableFrom(c)) continue;
            statement = true;
            break;
        } while (exp.getParentPath() != null);
        if (!statement) {
            for (stPath = exp; stPath != null && !(stPath.getLeaf() instanceof StatementTree); stPath = stPath.getParentPath()) {
            }
        }
        if (stPath == null) {
            return false;
        }
        int baseIndex = (int)sp.getStartPosition(ci.getCompilationUnit(), exp.getLeaf());
        StringBuilder sb = new StringBuilder();
        sb.append(source.subSequence(baseIndex, origExpStart));
        sb.append("(").append(source.subSequence((int)sp.getStartPosition(ci.getCompilationUnit(), valPath.getLeaf()), (int)sp.getEndPosition(ci.getCompilationUnit(), valPath.getLeaf()))).append(")");
        sb.append(source.subSequence(origExpEnd, (int)sp.getEndPosition(ci.getCompilationUnit(), exp.getLeaf())));
        SourcePositions[] nsp = new SourcePositions[1];
        if (statement) {
            sb.append(";");
            t = ci.getTreeUtilities().parseStatement(sb.toString(), nsp);
        } else {
            t = ci.getTreeUtilities().parseExpression(sb.toString(), nsp);
        }
        Scope s = ci.getTreeUtilities().scopeFor((int)sp.getStartPosition(ci.getCompilationUnit(), exp.getLeaf()) - 1);
        ci.getTreeUtilities().attributeTree(t, s);
        TreePath newPath = new TreePath(exp.getParentPath(), t);
        for (newInvPath = ci.getTreeUtilities().pathFor(newPath, invOffset - baseIndex + 1, nsp[0]); newInvPath != null && newInvPath.getLeaf().getKind() != Tree.Kind.METHOD_INVOCATION; newInvPath = newInvPath.getParentPath()) {
        }
        if (newInvPath == null) {
            return false;
        }
        Element me = ci.getTrees().getElement(newInvPath);
        return me == (origEl = ci.getTrees().getElement(invPath));
    }

    private static class RemoveBoxingFix
    extends JavaFix {
        final TreePathHandle valHandle;
        final String msg;
        final TypeKind primitiveKind;

        public RemoveBoxingFix(TreePathHandle valHandle, String msg, TreePathHandle handle, TypeKind primitiveKind) {
            super(handle);
            this.valHandle = valHandle;
            this.msg = msg;
            this.primitiveKind = primitiveKind;
        }

        protected String getText() {
            return this.msg;
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath val = this.valHandle.resolve((CompilationInfo)wc);
            if (this.primitiveKind == null || !this.primitiveKind.isPrimitive()) {
                wc.rewrite(ctx.getPath().getLeaf(), val.getLeaf());
            } else {
                TreeMaker mk = wc.getTreeMaker();
                wc.rewrite(ctx.getPath().getLeaf(), (Tree)mk.TypeCast(mk.Type((TypeMirror)wc.getTypes().getPrimitiveType(this.primitiveKind)), (ExpressionTree)val.getLeaf()));
            }
        }
    }
}

