/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.sites;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.web.clientproject.api.sites.SiteHelper;
import org.netbeans.modules.web.clientproject.sites.Bundle;
import org.netbeans.modules.web.clientproject.spi.SiteTemplateImplementation;
import org.openide.filesystems.FileObject;

public abstract class OnlineSites
implements SiteTemplateImplementation {
    private static final Logger LOGGER = Logger.getLogger(OnlineSites.class.getName());
    private final String name;
    private final String url;
    private final File libFile;
    private final String description;
    private final String id;

    protected OnlineSites(String id, String name, String description, String url, File libFile) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.url = url;
        this.libFile = libFile;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isPrepared() {
        return this.libFile.isFile();
    }

    public void prepare() throws IOException {
        assert (!EventQueue.isDispatchThread());
        assert (!this.isPrepared());
        SiteHelper.download((String)this.url, (File)this.libFile, null);
    }

    public void configure(SiteTemplateImplementation.ProjectProperties projectProperties) {
    }

    public final void apply(FileObject projectDir, SiteTemplateImplementation.ProjectProperties projectProperties, ProgressHandle handle) throws IOException {
        assert (!EventQueue.isDispatchThread());
        if (!this.isPrepared()) {
            LOGGER.info("Template not correctly prepared, nothing to be applied");
            return;
        }
        SiteHelper.unzipProjectTemplate((FileObject)this.getTargetDir(projectDir, projectProperties), (File)this.libFile, (ProgressHandle)handle, (String[])new String[0]);
    }

    public void cleanup() {
        if (this.libFile.isFile() && !this.libFile.delete()) {
            this.libFile.deleteOnExit();
        }
    }

    protected FileObject getTargetDir(FileObject projectDir, SiteTemplateImplementation.ProjectProperties projectProperties) {
        String siteRootFolder = projectProperties.getSiteRootFolder();
        assert (siteRootFolder != null);
        return projectDir.getFileObject(siteRootFolder);
    }

    public static class SiteMobileBoilerplate
    extends OnlineSites {
        public SiteMobileBoilerplate() {
            super("INIT.BOILER.MOBILE", Bundle.SiteMobileBoilerplate_name(), Bundle.SiteMobileBoilerplate_description(), "https://github.com/h5bp/mobile-boilerplate/zipball/v4.1.2", new File(SiteHelper.getJsLibsDirectory(), "mobile-boilerplate-412.zip"));
        }
    }

    public static class SiteTwitterBootstrap
    extends OnlineSites {
        public SiteTwitterBootstrap() {
            super("TWITTER", Bundle.SiteTwitterBootstrap_name(), Bundle.SiteTwitterBootstrap_description(), "https://github.com/twbs/bootstrap/releases/download/v3.3.6/bootstrap-3.3.6-dist.zip", new File(SiteHelper.getJsLibsDirectory(), "twitter-bootstrap-336.zip"));
        }
    }

    public static class SiteHtml5Boilerplate
    extends OnlineSites {
        public SiteHtml5Boilerplate() {
            super("INIT.BOILER", Bundle.SiteHtml5Boilerplate_name(), Bundle.SiteHtml5Boilerplate_description(), "https://github.com/h5bp/html5-boilerplate/releases/download/5.3.0/html5-boilerplate_v5.3.0.zip", new File(SiteHelper.getJsLibsDirectory(), "html5-boilerplate-530.zip"));
        }
    }

    public static class ResponsiveSiteInitializr
    extends OnlineSites {
        public ResponsiveSiteInitializr() {
            super("INIT.RESP", Bundle.ResponsiveSiteInitializr_name(), Bundle.SiteInitializr_description(), "http://www.initializr.com/builder?izr-responsive&jquerymin&h5bp-iecond&h5bp-chromeframe&h5bp-analytics&h5bp-favicon&h5bp-appletouchicons&modernizrrespond&h5bp-css&h5bp-csshelpers&h5bp-mediaqueryprint&izr-emptyscript", new File(SiteHelper.getJsLibsDirectory(), "initializr-responsive-latest.zip"));
        }
    }

    public static class ClassicSiteInitializr
    extends OnlineSites {
        public ClassicSiteInitializr() {
            super("INIT.CLASSIC", Bundle.ClassicSiteInitializr_name(), Bundle.SiteInitializr_description(), "http://www.initializr.com/builder?h5bp-content&modernizr&jquerymin&h5bp-chromeframe&h5bp-analytics&h5bp-htaccess&h5bp-favicon&h5bp-appletouchicons&h5bp-scripts&h5bp-robots&h5bp-humans&h5bp-404&h5bp-adobecrossdomain&h5bp-css&h5bp-csshelpers&h5bp-mediaqueryprint&h5bp-mediaqueries&simplehtmltag", new File(SiteHelper.getJsLibsDirectory(), "initializr-classic-latest.zip"));
        }
    }

    public static class BootstrapSiteInitializr
    extends OnlineSites {
        public BootstrapSiteInitializr() {
            super("BOOTSTRAP", Bundle.BootstrapSiteInitializr_name(), Bundle.SiteInitializr_description(), "http://www.initializr.com/builder?boot-hero&jquerymin&h5bp-iecond&h5bp-chromeframe&h5bp-analytics&h5bp-favicon&h5bp-appletouchicons&modernizrrespond&izr-emptyscript&boot-css&boot-scripts", new File(SiteHelper.getJsLibsDirectory(), "initializr-bootstrap-latest.zip"));
        }
    }

    public static class SiteAngularJsSeed
    extends OnlineSites {
        private static final String SITE_ROOT_FOLDER = "app";
        private static final String TEST_FOLDER = "test";
        private static final String TEST_SELENIUM_FOLDER = "e2e-tests";
        private static final String JS_TESTING_PROVIDER = "Karma";
        private static final String SELENIUM_TESTING_PROVIDER = "Protractor";

        public SiteAngularJsSeed() {
            super("ANGULAR", Bundle.SiteAngularJsSeed_name(), Bundle.SiteAngularJsSeed_description(), "https://github.com/angular/angular-seed/archive/master.zip", new File(SiteHelper.getJsLibsDirectory(), "angularjs-seed.zip"));
        }

        @Override
        public void configure(SiteTemplateImplementation.ProjectProperties projectProperties) {
            projectProperties.setSiteRootFolder(SITE_ROOT_FOLDER).setTestFolder(TEST_FOLDER).setTestSeleniumFolder(TEST_SELENIUM_FOLDER).setJsTestingProvider(JS_TESTING_PROVIDER).setSeleniumTestingProvider(SELENIUM_TESTING_PROVIDER);
        }

        @Override
        protected FileObject getTargetDir(FileObject projectDir, SiteTemplateImplementation.ProjectProperties projectProperties) {
            return projectDir;
        }
    }
}

