/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.codegen;

import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.maven.codegen.Bundle;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Profile;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class NewProfilePanel
extends JPanel {
    private POMModel model;
    private NotificationLineSupport nls;
    private JCheckBox cbActFile;
    private JCheckBox cbActOS;
    private JCheckBox cbActProperty;
    private JCheckBox cbDependencies;
    private JCheckBox cbPlugins;
    private JLabel lblId;
    private JTextField txtId;

    public NewProfilePanel(POMModel model) {
        this.initComponents();
        this.model = model;
        boolean pomPackaging = "pom".equals(model.getProject().getPackaging());
        if (!pomPackaging) {
            Mnemonics.setLocalizedText((AbstractButton)this.cbPlugins, (String)Bundle.NewProfilePanel_cbPlugins_text2());
            Mnemonics.setLocalizedText((AbstractButton)this.cbDependencies, (String)Bundle.NewProfilePanel_cbDependencies_text2());
        }
        this.txtId.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewProfilePanel.this.checkId();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewProfilePanel.this.checkId();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NewProfilePanel.this.checkId();
            }
        });
    }

    public void attachDialogDisplayer(DialogDescriptor dd) {
        this.nls = dd.getNotificationLineSupport();
        if (this.nls == null) {
            this.nls = dd.createNotificationLineSupport();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        assert (this.nls != null) : " The notificationLineSupport was not attached to the panel.";
    }

    private void checkId() {
        String id = this.txtId.getText().trim();
        Profile existing = this.model.getProject().findProfileById(id);
        if (existing != null) {
            this.nls.setErrorMessage(NbBundle.getMessage(NewProfilePanel.class, (String)"ERR_SameProfileId"));
        } else {
            this.nls.clearMessages();
        }
    }

    private void initComponents() {
        this.lblId = new JLabel();
        this.txtId = new JTextField();
        this.cbActProperty = new JCheckBox();
        this.cbActOS = new JCheckBox();
        this.cbActFile = new JCheckBox();
        this.cbPlugins = new JCheckBox();
        this.cbDependencies = new JCheckBox();
        this.lblId.setLabelFor(this.txtId);
        Mnemonics.setLocalizedText((JLabel)this.lblId, (String)NbBundle.getMessage(NewProfilePanel.class, (String)"NewProfilePanel.lblId.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbActProperty, (String)NbBundle.getMessage(NewProfilePanel.class, (String)"NewProfilePanel.cbActProperty.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbActOS, (String)NbBundle.getMessage(NewProfilePanel.class, (String)"NewProfilePanel.cbActOS.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbActFile, (String)NbBundle.getMessage(NewProfilePanel.class, (String)"NewProfilePanel.cbActFile.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbPlugins, (String)NbBundle.getMessage(NewProfilePanel.class, (String)"NewProfilePanel.cbPlugins.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbDependencies, (String)NbBundle.getMessage(NewProfilePanel.class, (String)"NewProfilePanel.cbDependencies.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbDependencies).addComponent(this.cbPlugins).addComponent(this.cbActFile).addComponent(this.cbActOS).addComponent(this.cbActProperty).addGroup(layout.createSequentialGroup().addComponent(this.lblId).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtId, -1, 234, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblId).addComponent(this.txtId, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.cbActProperty).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbActOS).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbActFile).addGap(18, 18, 18).addComponent(this.cbPlugins).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbDependencies).addContainerGap(64, Short.MAX_VALUE)));
    }

    String getProfileId() {
        return this.txtId.getText();
    }

    boolean isActivation() {
        return this.isActiovationByFile() || this.isActiovationByOS() || this.isActiovationByProperty();
    }

    boolean isActiovationByProperty() {
        return this.cbActProperty.isSelected();
    }

    boolean isActiovationByOS() {
        return this.cbActOS.isSelected();
    }

    boolean isActiovationByFile() {
        return this.cbActFile.isSelected();
    }

    boolean generateDependencies() {
        return this.cbDependencies.isSelected();
    }

    boolean generatePlugins() {
        return this.cbPlugins.isSelected();
    }
}

