/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb.MdbLocationPanelVisual;
import org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb.MessageDestinationUiSupport;
import org.netbeans.modules.j2ee.ejbcore.naming.EJBNameOptions;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class MdbLocationPanel
implements WizardDescriptor.FinishablePanel {
    private MdbLocationPanelVisual locationPanel;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final WizardDescriptor wizardDescriptor;
    private final EJBNameOptions ejbNames;

    public MdbLocationPanel(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
        this.ejbNames = new EJBNameOptions();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public boolean isValid() {
        Project project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        String j2eeVersion = j2eeModuleProvider.getJ2eeModule().getModuleVersion();
        if (!("3.2".equals(j2eeVersion) || "3.1".equals(j2eeVersion) || "3.0".equals(j2eeVersion) || "2.1".equals(j2eeVersion))) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(MdbLocationPanel.class, (String)"MSG_WrongJ2EESpecVersion"));
            return false;
        }
        FileObject targetFolder = (FileObject)this.wizardDescriptor.getProperty("MultiTargetChooserPanel.TARGET_FOLDER");
        if (targetFolder != null) {
            String targetName = (String)this.wizardDescriptor.getProperty("MultiTargetChooserPanel.TARGET_NAME");
            String name = this.ejbNames.getMessageDrivenEjbClassPrefix() + targetName + this.ejbNames.getMessageDrivenEjbClassSuffix();
            if (targetFolder.getFileObject(name + ".java") != null) {
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(MdbLocationPanel.class, (String)"ERR_FileAlreadyExists", (Object)(name + ".java")));
                return false;
            }
        }
        this.getComponent();
        if (this.locationPanel.getDestination() == null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(MdbLocationPanel.class, (String)"ERR_NoDestinationSelected"));
            return false;
        }
        if (!this.locationPanel.isServerConfigured()) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(MdbLocationPanel.class, (String)"ERR_MissingServer"));
        }
        return true;
    }

    public void readSettings(Object settings) {
    }

    public void storeSettings(Object settings) {
        WizardDescriptor descriptor = (WizardDescriptor)settings;
        this.locationPanel.store(descriptor);
    }

    public boolean isFinishPanel() {
        return this.isValid();
    }

    protected final void fireChangeEvent() {
        this.changeSupport.fireChange();
    }

    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.j2ee.ejbcore.ejb.wizard.mdb.MessageEJBWizardPanel");
    }

    public Component getComponent() {
        if (this.locationPanel == null) {
            final Project project = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
            final J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            MessageDestinationUiSupport.DestinationsHolder holder = MessageDestinationUiSupport.getDestinations(project, j2eeModuleProvider);
            this.locationPanel = MdbLocationPanelVisual.newInstance(project, j2eeModuleProvider, holder.getModuleDestinations(), holder.getServerDestinations());
            this.locationPanel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getPropertyName().equals(MdbLocationPanelVisual.SCANNED)) {
                        MessageDestinationUiSupport.DestinationsHolder destinations = MessageDestinationUiSupport.getDestinations(project, j2eeModuleProvider);
                        MdbLocationPanel.this.locationPanel.refreshDestinations(destinations.getModuleDestinations(), destinations.getServerDestinations());
                    }
                    MdbLocationPanel.this.fireChangeEvent();
                }
            });
        }
        return this.locationPanel;
    }

    public MessageDestination getDestination() {
        return this.locationPanel.getDestination();
    }

    protected static ClasspathInfo getClassPathInfo(Project project) {
        return ClasspathInfo.create((ClassPath)MdbLocationPanel.getClassPath(project, "classpath/boot"), (ClassPath)MdbLocationPanel.getClassPath(project, "classpath/compile"), (ClassPath)MdbLocationPanel.getClassPath(project, "classpath/source"));
    }

    private static ClassPath getClassPath(Project project, String type) {
        ClassPathProvider provider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        if (provider == null) {
            return null;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        ClassPath[] paths = new ClassPath[sourceGroups.length];
        int i = 0;
        for (SourceGroup sourceGroup : sourceGroups) {
            FileObject rootFolder = sourceGroup.getRootFolder();
            paths[i] = provider.findClassPath(rootFolder, type);
            ++i;
        }
        return ClassPathSupport.createProxyClassPath((ClassPath[])paths);
    }
}

