/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsf.testrunner.api.NamedObject;
import org.netbeans.modules.gsf.testrunner.api.SizeRestrictedPanel;
import org.netbeans.modules.java.testrunner.CommonSettings;
import org.netbeans.modules.java.testrunner.GuiUtils;
import org.netbeans.modules.junit.api.JUnitUtils;
import org.netbeans.modules.junit.ui.wizards.JavaChildren;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeOperation;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;

public final class SimpleTestStepLocation
implements WizardDescriptor.Panel<WizardDescriptor> {
    private final String testClassNameSuffix = NbBundle.getMessage(CommonSettings.class, (String)"PROP_test_classname_suffix");
    private Component visualComp = this.createVisualComp();
    private List<ChangeListener> changeListeners;
    private JTextField tfClassToTest;
    private JButton btnBrowse;
    private JTextField tfTestClass;
    private JTextField tfProjectName;
    private JComboBox cboxLocation;
    private JTextField tfCreatedFile;
    private JCheckBox chkPublic;
    private JCheckBox chkProtected;
    private JCheckBox chkPackagePrivate;
    private JCheckBox chkSetUp;
    private JCheckBox chkTearDown;
    private JCheckBox chkBeforeClass;
    private JCheckBox chkAfterClass;
    private JCheckBox chkMethodBodies;
    private JCheckBox chkJavadoc;
    private JCheckBox chkHints;
    private String errMsg;
    private String msgClassNameInvalid;
    private String msgClassToTestDoesNotExist;
    private Project project;
    private WizardDescriptor wizard;
    private boolean multipleSourceRoots;
    private boolean interactionRestrictionsEnabled = false;
    private boolean interactionRestrictionsActive = false;
    private boolean interactionRestrictionsSuspended = false;
    private boolean mouseClicksBlocked = false;
    private HierarchyListener displayabilityListener;
    private JRootPane rootPane;
    private JButton defaultButton;
    private String rootPaneDefaultActionKey;
    private Action rootPaneDefaultAction;
    private MouseInputListener glassPaneListener;
    private Component[] mouseBlocked;
    private JComponent[] mnemonicBlocked;
    private ActionMappingInfo[] actionMappingInfo;
    private Component focusGainAllowedFor;
    private SourceGroup[] testableSourceGroups;
    private FileObject[] testableSourceGroupsRoots;
    private SourceGroup[] allTestSourceGroups;
    private Map<SourceGroup, Object[]> sourcesToTestsMap;
    private int sourceGroupParentIndex = -1;
    private FileObject srcFile;
    private SourceGroup srcGroup = null;
    private String testsRootDirName = "";
    private String srcRelFileNameSys = "";
    private String testRelFileName = "";
    private FileObject testRootFolder;
    private int classNameLength = 0;
    private boolean srcGroupNameDisplayed = false;
    private boolean programmaticChange = false;
    private boolean navigationFilterEnabled = false;
    private ClsNameNavigationFilter clsNameNavigationFilter;
    private ClsNameDocumentFilter clsNameDocumentFilter;
    private boolean ignoreCboxItemChanges = false;
    private boolean ignoreClsNameChanges = false;
    private boolean isValid = false;
    private boolean classNameValid = false;
    private boolean classExists = false;

    private Component createVisualComp() {
        JLabel lblClassToTest = new JLabel();
        JLabel lblCreatedTestClass = new JLabel();
        JLabel lblProject = new JLabel();
        JLabel lblLocation = new JLabel();
        JLabel lblFile = new JLabel();
        this.tfClassToTest = new JTextField(25);
        this.btnBrowse = new JButton();
        this.tfTestClass = new JTextField();
        this.tfProjectName = new JTextField();
        this.cboxLocation = new JComboBox();
        this.tfCreatedFile = new JTextField();
        ResourceBundle bundle = NbBundle.getBundle(SimpleTestStepLocation.class);
        Mnemonics.setLocalizedText((JLabel)lblClassToTest, (String)bundle.getString("LBL_ClassToTest"));
        Mnemonics.setLocalizedText((JLabel)lblCreatedTestClass, (String)bundle.getString("LBL_TestClass"));
        Mnemonics.setLocalizedText((JLabel)lblProject, (String)bundle.getString("LBL_Project"));
        Mnemonics.setLocalizedText((JLabel)lblLocation, (String)bundle.getString("LBL_Location"));
        Mnemonics.setLocalizedText((JLabel)lblFile, (String)bundle.getString("LBL_CreatedFile"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnBrowse, (String)bundle.getString("LBL_Browse"));
        lblClassToTest.setLabelFor(this.tfClassToTest);
        lblCreatedTestClass.setLabelFor(this.tfTestClass);
        lblProject.setLabelFor(this.tfProjectName);
        lblFile.setLabelFor(this.tfCreatedFile);
        lblLocation.setLabelFor(this.cboxLocation);
        this.tfTestClass.setEditable(false);
        this.tfProjectName.setEditable(false);
        this.tfCreatedFile.setEditable(false);
        this.tfTestClass.setFocusable(false);
        this.tfProjectName.setFocusable(false);
        this.tfCreatedFile.setFocusable(false);
        this.cboxLocation.setEditable(false);
        JCheckBox[] chkBoxes = GuiUtils.createCheckBoxes((String[])new String[]{"Public", "Protected", "Package"});
        JComponent accessLevels = GuiUtils.createChkBoxGroup((String)NbBundle.getMessage(GuiUtils.class, (String)"CommonTestsCfgOfCreate.groupAccessLevels"), (JCheckBox[])chkBoxes);
        this.chkPublic = chkBoxes[0];
        this.chkProtected = chkBoxes[1];
        this.chkPackagePrivate = chkBoxes[2];
        chkBoxes = GuiUtils.createCheckBoxes((String[])new String[]{"SetUp", "TearDown", "BeforeClass", "AfterClass", "Content"});
        JComponent optCode = GuiUtils.createChkBoxGroup((String)NbBundle.getMessage(GuiUtils.class, (String)"CommonTestsCfgOfCreate.groupOptCode"), (JCheckBox[])chkBoxes);
        this.chkSetUp = chkBoxes[0];
        this.chkTearDown = chkBoxes[1];
        this.chkBeforeClass = chkBoxes[2];
        this.chkAfterClass = chkBoxes[3];
        this.chkMethodBodies = chkBoxes[4];
        chkBoxes = GuiUtils.createCheckBoxes((String[])new String[]{"JavaDoc", "Comments"});
        JComponent optComments = GuiUtils.createChkBoxGroup((String)NbBundle.getMessage(GuiUtils.class, (String)"CommonTestsCfgOfCreate.groupOptComments"), (JCheckBox[])chkBoxes);
        this.chkJavadoc = chkBoxes[0];
        this.chkHints = chkBoxes[1];
        SizeRestrictedPanel targetPanel = new SizeRestrictedPanel((LayoutManager)new GridBagLayout(), false, true);
        GridBagConstraints gbcLeft = new GridBagConstraints();
        gbcLeft.anchor = 17;
        gbcLeft.gridwidth = 1;
        gbcLeft.insets = new Insets(0, 0, 6, 12);
        gbcLeft.fill = 0;
        gbcLeft.weightx = 0.0;
        GridBagConstraints gbcRight = new GridBagConstraints();
        gbcRight.anchor = 17;
        gbcRight.gridwidth = 0;
        gbcRight.insets = new Insets(0, 0, 6, 0);
        gbcRight.fill = 1;
        gbcRight.weightx = 1.0;
        gbcRight.gridwidth = 1;
        GridBagConstraints gbcBrowse = new GridBagConstraints();
        gbcBrowse.insets = new Insets(0, 11, 6, 0);
        gbcBrowse.gridwidth = 0;
        targetPanel.add((Component)lblClassToTest, gbcLeft);
        targetPanel.add((Component)this.tfClassToTest, gbcRight);
        targetPanel.add((Component)this.btnBrowse, gbcBrowse);
        gbcRight.insets.bottom = 24;
        gbcLeft.insets.bottom = 24;
        targetPanel.add((Component)lblCreatedTestClass, gbcLeft);
        targetPanel.add((Component)this.tfTestClass, gbcRight);
        targetPanel.add((Component)new JPanel(), gbcBrowse);
        gbcRight.gridwidth = 0;
        gbcRight.insets.bottom = 6;
        gbcLeft.insets.bottom = 6;
        targetPanel.add((Component)lblProject, gbcLeft);
        targetPanel.add((Component)this.tfProjectName, gbcRight);
        gbcRight.insets.bottom = 12;
        gbcLeft.insets.bottom = 12;
        targetPanel.add((Component)lblLocation, gbcLeft);
        targetPanel.add((Component)this.cboxLocation, gbcRight);
        gbcRight.insets.bottom = 0;
        gbcLeft.insets.bottom = 0;
        targetPanel.add((Component)lblFile, gbcLeft);
        targetPanel.add((Component)this.tfCreatedFile, gbcRight);
        SizeRestrictedPanel optionsBox = new SizeRestrictedPanel(false, true);
        optionsBox.setLayout(new BoxLayout((Container)optionsBox, 0));
        optionsBox.add(accessLevels);
        optionsBox.add(Box.createHorizontalStrut(18));
        optionsBox.add(optCode);
        optionsBox.add(Box.createHorizontalStrut(18));
        optionsBox.add(optComments);
        accessLevels.setAlignmentY(0.0f);
        optCode.setAlignmentY(0.0f);
        optComments.setAlignmentY(0.0f);
        Box result = Box.createVerticalBox();
        result.add((Component)targetPanel);
        result.add(Box.createVerticalStrut(12));
        SizeRestrictedPanel separatorPanel = new SizeRestrictedPanel((LayoutManager)new GridLayout(), false, true);
        separatorPanel.add(new JSeparator());
        result.add((Component)separatorPanel);
        result.add(Box.createVerticalStrut(12));
        result.add((Component)optionsBox);
        targetPanel.setAlignmentX(0.0f);
        optionsBox.setAlignmentX(0.0f);
        optCode.setAlignmentX(0.0f);
        optComments.setAlignmentX(0.0f);
        result.setName(bundle.getString("LBL_panel_ChooseClass"));
        this.addAccessibilityDescriptions(result);
        this.setUpInteraction();
        return result;
    }

    private void addAccessibilityDescriptions(Component wizPanel) {
        ResourceBundle bundle = NbBundle.getBundle(SimpleTestStepLocation.class);
        this.tfClassToTest.setToolTipText(bundle.getString("SimpleTest.classToTest.toolTip"));
        this.tfClassToTest.getAccessibleContext().setAccessibleName(bundle.getString("SimpleTest.classToTest.AN"));
        this.tfClassToTest.getAccessibleContext().setAccessibleDescription(bundle.getString("SimpleTest.classToTest.AD"));
        this.btnBrowse.setToolTipText(bundle.getString("SimpleTest.btnBrowse.toolTip"));
        this.btnBrowse.getAccessibleContext().setAccessibleName(bundle.getString("SimpleTest.btnBrowse.AN"));
        this.btnBrowse.getAccessibleContext().setAccessibleDescription(bundle.getString("SimpleTest.btnBrowse.AD"));
        this.cboxLocation.setToolTipText(bundle.getString("SimpleTest.location.toolTip"));
        this.cboxLocation.getAccessibleContext().setAccessibleName(bundle.getString("SimpleTest.location.AN"));
        this.cboxLocation.getAccessibleContext().setAccessibleDescription(bundle.getString("SimpleTest.location.AD"));
        wizPanel.getAccessibleContext().setAccessibleDescription(bundle.getString("SimpleTest.AD"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateLocationComboBox() {
        Object[] srcRootsToOffer = this.allTestSourceGroups.length == 1 || this.srcGroup == null ? this.allTestSourceGroups : this.sourcesToTestsMap.get(this.srcGroup);
        Object previousSelectedItem = this.cboxLocation.getSelectedItem();
        this.ignoreCboxItemChanges = true;
        try {
            NamedObject[] items = SimpleTestStepLocation.createNamedItems(srcRootsToOffer);
            this.cboxLocation.setModel(new DefaultComboBoxModel<NamedObject>(items));
            if (previousSelectedItem != null) {
                this.cboxLocation.setSelectedItem(previousSelectedItem);
            }
        }
        finally {
            this.ignoreCboxItemChanges = false;
        }
        Object newSelectedItem = this.cboxLocation.getSelectedItem();
        return !newSelectedItem.equals(previousSelectedItem);
    }

    private static NamedObject[] createNamedItems(Object[] srcRoots) {
        NamedObject[] items = new NamedObject[srcRoots.length];
        for (int i = 0; i < srcRoots.length; ++i) {
            String name = srcRoots[i] instanceof SourceGroup ? ((SourceGroup)srcRoots[i]).getDisplayName() : (srcRoots[i] instanceof FileObject ? FileUtil.getFileDisplayName((FileObject)((FileObject)srcRoots[i])) : srcRoots[i].toString());
            items[i] = new NamedObject(srcRoots[i], name);
        }
        return items;
    }

    private void setUpInteraction() {
        class UIListener
        implements ActionListener,
        DocumentListener,
        FocusListener,
        ItemListener {
            UIListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleTestStepLocation.this.chooseClass();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SimpleTestStepLocation.this.classNameChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SimpleTestStepLocation.this.classNameChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SimpleTestStepLocation.this.classNameChanged();
            }

            @Override
            public void focusGained(FocusEvent e) {
                Object source = e.getSource();
                if (source == SimpleTestStepLocation.this.tfClassToTest) {
                    // empty if block
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                Object source = e.getSource();
                if (source == SimpleTestStepLocation.this.tfClassToTest) {
                    if (!e.isTemporary()) {
                        SimpleTestStepLocation.this.tfClassToTestFocusLost(e);
                    }
                } else if (source == SimpleTestStepLocation.this.btnBrowse && !e.isTemporary()) {
                    SimpleTestStepLocation.this.btnBrowseFocusLost(e);
                }
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getSource() == SimpleTestStepLocation.this.cboxLocation) {
                    if (!SimpleTestStepLocation.this.ignoreCboxItemChanges) {
                        SimpleTestStepLocation.this.locationChanged();
                    }
                } else assert (false);
            }
        }
        UIListener listener = new UIListener();
        this.btnBrowse.addActionListener(listener);
        this.tfClassToTest.addFocusListener(listener);
        this.btnBrowse.addFocusListener(listener);
        this.cboxLocation.addItemListener(listener);
        this.tfClassToTest.getDocument().addDocumentListener(listener);
    }

    private void tfClassToTestFocusLost(FocusEvent e) {
        Component allowFocusGain = this.focusGainAllowedFor;
        this.focusGainAllowedFor = null;
        if (this.multipleSourceRoots && this.interactionRestrictionsActive && !this.interactionRestrictionsSuspended) {
            Component opposite = e.getOppositeComponent();
            if (allowFocusGain != null && opposite == allowFocusGain) {
                return;
            }
            if (opposite == this.btnBrowse) {
                return;
            }
            if (opposite instanceof JLabel && ((JLabel)opposite).getLabelFor() == this.tfClassToTest) {
                return;
            }
            if (!this.maybeDisplaySourceGroupChooser()) {
                this.tfClassToTest.requestFocus();
            }
        }
    }

    private void btnBrowseFocusLost(FocusEvent e) {
        Component allowFocusGain = this.focusGainAllowedFor;
        this.focusGainAllowedFor = null;
        if (this.multipleSourceRoots && this.interactionRestrictionsActive && !this.interactionRestrictionsSuspended) {
            Component opposite = e.getOppositeComponent();
            if (allowFocusGain != null && opposite == allowFocusGain) {
                return;
            }
            if (opposite == this.tfClassToTest) {
                return;
            }
            if (opposite instanceof JLabel && ((JLabel)opposite).getLabelFor() == this.tfClassToTest) {
                return;
            }
            if (!this.maybeDisplaySourceGroupChooser()) {
                this.btnBrowse.requestFocus();
            }
        }
    }

    private boolean maybeDisplaySourceGroupChooser() {
        assert (this.multipleSourceRoots);
        if (this.classExists && this.srcGroup == null) {
            SourceGroup[] candidates = this.findParentGroupCandidates();
            assert (candidates.length != 0);
            if (candidates.length == 1) {
                this.setSelectedSrcGroup(candidates[0]);
                return true;
            }
            SourceGroup chosenSrcGroup = this.chooseSrcGroup(candidates);
            if (chosenSrcGroup != null) {
                this.setSelectedSrcGroup(chosenSrcGroup);
                return true;
            }
            return false;
        }
        return true;
    }

    private SourceGroup chooseSrcGroup(SourceGroup[] candidates) {
        assert (candidates != null && candidates.length != 0);
        String[] rootNames = new String[candidates.length];
        for (int i = 0; i < rootNames.length; ++i) {
            rootNames[i] = candidates[i].getDisplayName();
        }
        final JButton btn = new JButton(NbBundle.getMessage(this.getClass(), (String)"LBL_SelectBtn"));
        final JList<String> list = new JList<String>(rootNames);
        list.setSelectionMode(0);
        list.setSelectedIndex(0);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                btn.setEnabled(!list.isSelectionEmpty());
            }
        });
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.add(list, "Center");
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(12, 12, 0, 12), BorderFactory.createBevelBorder(1)));
        String dialogTitle = NbBundle.getMessage(this.getClass(), (String)"LBL_SourceRootChooserTitle");
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, dialogTitle, true, new Object[]{btn, NotifyDescriptor.CANCEL_OPTION}, (Object)btn, 0, (HelpCtx)null, (ActionListener)null);
        Object selected = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        return selected == btn ? candidates[list.getSelectedIndex()] : (SourceGroup)null;
    }

    private void setSelectedSrcGroup(SourceGroup srcGroup) {
        this.setSelectedSrcGroup(srcGroup, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSelectedSrcGroup(SourceGroup srcGroup, boolean updateDisp) {
        boolean locationChanged;
        assert (this.multipleSourceRoots && (srcGroup == null || this.classNameValid && this.classExists));
        if (!SimpleTestStepLocation.checkObjChanged(this.srcGroup, srcGroup)) {
            return;
        }
        this.srcGroup = srcGroup;
        if (updateDisp) {
            try {
                this.programmaticChange = true;
                String className = this.tfClassToTest.getText().substring(0, this.classNameLength);
                String srcGroupDisplay = SimpleTestStepLocation.getSrcGrpDisp(srcGroup);
                this.ignoreClsNameChanges = true;
                this.tfClassToTest.setText(className + srcGroupDisplay);
                this.ignoreClsNameChanges = false;
                this.classNameLength = className.length();
                this.classNameChanged();
                this.srcGroupNameDisplayed = true;
                this.setNavigationFilterEnabled(true);
            }
            finally {
                this.ignoreClsNameChanges = false;
                this.programmaticChange = false;
            }
        }
        this.updateInteractionRestrictionsState();
        if (this.allTestSourceGroups.length > 1 && (locationChanged = this.updateLocationComboBox())) {
            this.updateTargetFolderData();
        }
        this.updateCreatedFileName();
        FileObject fileObject = this.srcFile = srcGroup != null ? srcGroup.getRootFolder().getFileObject(this.srcRelFileNameSys) : null;
        assert (srcGroup == null || this.srcFile != null);
    }

    private static String getSrcGrpDisp(SourceGroup srcGroup) {
        if (srcGroup == null) {
            return "";
        }
        String srcGroupName = srcGroup.getDisplayName();
        return new StringBuffer(srcGroupName.length() + 3).append(' ').append('(').append(srcGroupName).append(')').toString();
    }

    private void setNavigationFilterEnabled(boolean enabled) {
        if (enabled == this.navigationFilterEnabled) {
            if (enabled) {
                this.clsNameNavigationFilter.ensureCursorInRange();
            }
            return;
        }
        if (enabled) {
            if (this.clsNameNavigationFilter == null) {
                this.clsNameNavigationFilter = new ClsNameNavigationFilter();
            }
            this.tfClassToTest.setNavigationFilter(this.clsNameNavigationFilter);
            this.clsNameNavigationFilter.ensureCursorInRange();
        } else {
            this.tfClassToTest.setNavigationFilter(null);
        }
        this.navigationFilterEnabled = enabled;
    }

    private void updateInteractionRestrictionsState() {
        this.setInteractionRestrictionsSuspended(!this.classNameValid || !this.classExists || this.srcGroup != null);
    }

    private void updateTargetFolderData() {
        Object item = this.cboxLocation.getSelectedItem();
        if (item != null) {
            SourceGroup targetSourceGroup = (SourceGroup)((NamedObject)item).object;
            this.testRootFolder = targetSourceGroup.getRootFolder();
            this.testsRootDirName = FileUtil.getFileDisplayName((FileObject)this.testRootFolder);
        } else {
            this.testRootFolder = null;
            this.testsRootDirName = "";
        }
    }

    private void locationChanged() {
        this.updateTargetFolderData();
        this.updateCreatedFileName();
    }

    private void classNameChanged() {
        String testClassName;
        String className;
        if (this.ignoreClsNameChanges) {
            return;
        }
        if (!this.programmaticChange) {
            className = this.tfClassToTest.getText().trim();
            this.classNameLength = className.length();
        } else {
            className = this.tfClassToTest.getText().substring(0, this.classNameLength);
        }
        if (className.length() != 0) {
            this.srcRelFileNameSys = className.replace('.', '/') + ".java";
            testClassName = className + this.testClassNameSuffix;
            this.testRelFileName = testClassName.replace('.', File.separatorChar) + ".java";
        } else {
            this.srcRelFileNameSys = "";
            testClassName = "";
            this.testRelFileName = "";
        }
        this.tfTestClass.setText(testClassName);
        if (!this.programmaticChange) {
            this.updateCreatedFileName();
            if (this.checkClassNameValidity()) {
                this.checkSelectedClassExists();
            }
            this.setErrorMsg(this.errMsg);
            this.setValidity();
            if (this.multipleSourceRoots) {
                this.setSelectedSrcGroup(null, false);
            }
        }
        if (this.multipleSourceRoots) {
            this.updateInteractionRestrictionsState();
        }
    }

    private SourceGroup[] findParentGroupCandidates() {
        SourceGroup[] sourceGroupArray;
        assert (this.sourceGroupParentIndex >= 0);
        ArrayList<SourceGroup> cands = null;
        int count = this.testableSourceGroups.length;
        for (int i = this.sourceGroupParentIndex + 1; i < count; ++i) {
            FileObject groupRoot = this.testableSourceGroupsRoots[i];
            FileObject srcFile = groupRoot.getFileObject(this.srcRelFileNameSys);
            if (srcFile == null || !this.testableSourceGroups[i].contains(srcFile)) continue;
            if (cands == null) {
                cands = new ArrayList<SourceGroup>(this.testableSourceGroups.length - i + 1);
                cands.add(this.testableSourceGroups[this.sourceGroupParentIndex]);
            }
            cands.add(this.testableSourceGroups[i]);
        }
        if (cands == null) {
            SourceGroup[] sourceGroupArray2 = new SourceGroup[1];
            sourceGroupArray = sourceGroupArray2;
            sourceGroupArray2[0] = this.testableSourceGroups[this.sourceGroupParentIndex];
        } else {
            sourceGroupArray = cands.toArray(new SourceGroup[cands.size()]);
        }
        return sourceGroupArray;
    }

    private void updateCreatedFileName() {
        this.tfCreatedFile.setText(this.testsRootDirName + File.separatorChar + this.testRelFileName);
    }

    private boolean checkClassNameValidity() {
        String className = this.tfClassToTest.getText().trim();
        if (this.srcGroupNameDisplayed) {
            className = className.substring(0, this.classNameLength);
        }
        if (className.length() == 0) {
            this.errMsg = null;
            this.classNameValid = false;
        } else if (JUnitUtils.isValidClassName((String)className)) {
            this.errMsg = null;
            this.classNameValid = true;
        } else {
            if (this.msgClassNameInvalid == null) {
                this.msgClassNameInvalid = NbBundle.getMessage(GuiUtils.class, (String)"MSG_InvalidClassName");
            }
            this.errMsg = this.msgClassNameInvalid;
            this.classNameValid = false;
        }
        return this.classNameValid;
    }

    private boolean checkSelectedClassExists() {
        this.sourceGroupParentIndex = -1;
        int count = this.testableSourceGroups.length;
        for (int i = 0; i < count; ++i) {
            FileObject groupRoot = this.testableSourceGroupsRoots[i];
            FileObject srcFile = groupRoot.getFileObject(this.srcRelFileNameSys);
            if (srcFile == null || !this.testableSourceGroups[i].contains(srcFile)) continue;
            this.srcFile = srcFile;
            this.sourceGroupParentIndex = i;
            break;
        }
        boolean bl = this.classExists = this.sourceGroupParentIndex != -1;
        if (this.classExists) {
            this.errMsg = null;
        } else {
            if (this.msgClassToTestDoesNotExist == null) {
                this.msgClassToTestDoesNotExist = NbBundle.getMessage(SimpleTestStepLocation.class, (String)"MSG_ClassToTestDoesNotExist");
            }
            this.errMsg = this.msgClassToTestDoesNotExist;
        }
        return this.classExists;
    }

    private void setValidity() {
        boolean wasValid = this.isValid;
        boolean bl = this.isValid = this.classNameValid && this.classExists;
        if (this.isValid != wasValid) {
            this.fireChange();
            this.updateInteractionRestrictionsState();
            if (this.isValid && this.interactionRestrictionsEnabled && !this.interactionRestrictionsActive) {
                this.tryActivateInteractionRestrictions();
            }
        }
    }

    private void setErrorMsg(String message) {
        if (this.wizard != null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void chooseClass() {
        try {
            boolean locationChanged;
            SourceGroup selectedSourceGroup;
            FilterNode rootNode;
            Node[] sourceGroupNodes = new Node[this.testableSourceGroups.length];
            for (int i = 0; i < sourceGroupNodes.length; ++i) {
                Node srcGroupNode = PackageView.createPackageView((SourceGroup)this.testableSourceGroups[i]);
                sourceGroupNodes[i] = new FilterNode(srcGroupNode, (Children)new JavaChildren(srcGroupNode));
            }
            if (sourceGroupNodes.length == 1) {
                rootNode = new FilterNode(sourceGroupNodes[0], (Children)new JavaChildren(sourceGroupNodes[0]));
            } else {
                Children.Array children = new Children.Array();
                children.add(sourceGroupNodes);
                AbstractNode node = new AbstractNode((Children)children);
                node.setName("Project Source Roots");
                node.setDisplayName(NbBundle.getMessage(this.getClass(), (String)"LBL_Sources"));
                rootNode = node;
            }
            NodeAcceptor acceptor = new NodeAcceptor(){

                public boolean acceptNodes(Node[] nodes) {
                    Node.Cookie cookie;
                    return nodes.length == 1 && (cookie = nodes[0].getCookie(DataObject.class)) != null && !((DataObject)cookie).getPrimaryFile().isFolder();
                }
            };
            Node selectedNode = NodeOperation.getDefault().select(NbBundle.getMessage(SimpleTestStepLocation.class, (String)"LBL_WinTitle_SelectClass"), NbBundle.getMessage(SimpleTestStepLocation.class, (String)"LBL_SelectClassToTest"), (Node)rootNode, acceptor)[0];
            if (sourceGroupNodes.length == 1) {
                selectedSourceGroup = this.testableSourceGroups[0];
            } else {
                Node parent;
                Node previous = null;
                Node current = selectedNode.getParentNode();
                while ((parent = current.getParentNode()) != null) {
                    previous = current;
                    current = parent;
                }
                selectedSourceGroup = null;
                Node selectedSrcGroupNode = previous;
                for (int i = 0; i < sourceGroupNodes.length; ++i) {
                    if (sourceGroupNodes[i] != selectedSrcGroupNode) continue;
                    selectedSourceGroup = this.testableSourceGroups[i];
                    this.sourceGroupParentIndex = i;
                    break;
                }
                assert (selectedSourceGroup != null);
                assert (this.sourceGroupParentIndex >= 0);
            }
            this.srcGroup = selectedSourceGroup;
            FileObject selectedFileObj = ((DataObject)selectedNode.getCookie(DataObject.class)).getPrimaryFile();
            try {
                this.programmaticChange = true;
                String className = SimpleTestStepLocation.getClassName(selectedFileObj);
                this.classNameLength = className.length();
                if (!this.multipleSourceRoots) {
                    this.ignoreClsNameChanges = true;
                    this.tfClassToTest.setText(className);
                    this.ignoreClsNameChanges = false;
                    this.classNameChanged();
                } else {
                    String srcGroupDisplay = SimpleTestStepLocation.getSrcGrpDisp(selectedSourceGroup);
                    this.ignoreClsNameChanges = true;
                    this.tfClassToTest.setText(className + srcGroupDisplay);
                    this.ignoreClsNameChanges = false;
                    this.classNameLength = className.length();
                    this.classNameChanged();
                    this.srcGroupNameDisplayed = true;
                    this.setNavigationFilterEnabled(true);
                }
            }
            finally {
                this.ignoreClsNameChanges = false;
                this.programmaticChange = false;
            }
            this.classNameValid = true;
            this.classExists = true;
            this.setErrorMsg(null);
            this.setValidity();
            this.updateInteractionRestrictionsState();
            if (this.multipleSourceRoots && this.allTestSourceGroups.length > 1 && (locationChanged = this.updateLocationComboBox())) {
                this.updateTargetFolderData();
            }
            this.updateCreatedFileName();
            this.srcFile = selectedFileObj;
        }
        catch (UserCancelException userCancelException) {
            // empty catch block
        }
    }

    private static String getClassName(FileObject fileObj) {
        return ClassPath.getClassPath((FileObject)fileObj, (String)"classpath/source").getResourceName(fileObj, '.', false);
    }

    public Component getComponent() {
        return this.visualComp;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("org.netbeans.modules.junit.wizards.SimpleTest");
    }

    public void readSettings(WizardDescriptor settings) {
        this.wizard = settings;
        this.chkPublic.setSelected(Boolean.TRUE.equals(this.wizard.getProperty("Public")));
        this.chkProtected.setSelected(Boolean.TRUE.equals(this.wizard.getProperty("Protected")));
        this.chkPackagePrivate.setSelected(Boolean.TRUE.equals(this.wizard.getProperty("Package")));
        this.chkSetUp.setSelected(Boolean.TRUE.equals(this.wizard.getProperty("SetUp")));
        this.chkTearDown.setSelected(Boolean.TRUE.equals(this.wizard.getProperty("TearDown")));
        this.chkBeforeClass.setSelected(Boolean.TRUE.equals(settings.getProperty("BeforeClass")));
        this.chkAfterClass.setSelected(Boolean.TRUE.equals(settings.getProperty("AfterClass")));
        this.chkMethodBodies.setSelected(Boolean.TRUE.equals(this.wizard.getProperty("Content")));
        this.chkJavadoc.setSelected(Boolean.TRUE.equals(this.wizard.getProperty("JavaDoc")));
        this.chkHints.setSelected(Boolean.TRUE.equals(this.wizard.getProperty("Comments")));
    }

    public void storeSettings(WizardDescriptor settings) {
        this.wizard = settings;
        this.wizard.putProperty("classToTest", (Object)this.srcFile);
        this.wizard.putProperty("testRootFolder", (Object)this.testRootFolder);
        this.wizard.putProperty("Public", (Object)this.chkPublic.isSelected());
        this.wizard.putProperty("Protected", (Object)this.chkProtected.isSelected());
        this.wizard.putProperty("Package", (Object)this.chkPackagePrivate.isSelected());
        this.wizard.putProperty("SetUp", (Object)this.chkSetUp.isSelected());
        this.wizard.putProperty("TearDown", (Object)this.chkTearDown.isSelected());
        settings.putProperty("BeforeClass", (Object)this.chkBeforeClass.isSelected());
        settings.putProperty("AfterClass", (Object)this.chkAfterClass.isSelected());
        this.wizard.putProperty("Content", (Object)this.chkMethodBodies.isSelected());
        this.wizard.putProperty("JavaDoc", (Object)this.chkJavadoc.isSelected());
        this.wizard.putProperty("Comments", (Object)this.chkHints.isSelected());
    }

    public void addChangeListener(ChangeListener l) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>(4);
        }
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.changeListeners != null && this.changeListeners.remove(l) && this.changeListeners.isEmpty()) {
            this.changeListeners = null;
        }
    }

    private void fireChange() {
        if (this.changeListeners != null) {
            ChangeEvent e = new ChangeEvent(this);
            for (ChangeListener l : this.changeListeners) {
                l.stateChanged(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUp(JUnitUtils utils) {
        Project project = utils.getProject();
        if (project == this.project) {
            return;
        }
        this.project = project;
        this.sourcesToTestsMap = utils.getSourcesToTestsMap(true);
        int sourceGroupsCnt = this.sourcesToTestsMap.size();
        Set<Map.Entry<SourceGroup, Object[]>> mapEntries = this.sourcesToTestsMap.entrySet();
        ArrayList<SourceGroup> testGroups = new ArrayList<SourceGroup>(sourceGroupsCnt + 4);
        this.testableSourceGroups = new SourceGroup[sourceGroupsCnt];
        this.testableSourceGroupsRoots = new FileObject[sourceGroupsCnt];
        this.multipleSourceRoots = sourceGroupsCnt > 1;
        Iterator<Map.Entry<SourceGroup, Object[]>> iterator = mapEntries.iterator();
        for (int i = 0; i < sourceGroupsCnt; ++i) {
            SourceGroup srcGroup;
            Map.Entry<SourceGroup, Object[]> entry = iterator.next();
            this.testableSourceGroups[i] = srcGroup = entry.getKey();
            this.testableSourceGroupsRoots[i] = srcGroup.getRootFolder();
            Object[] testGroupsSubset = entry.getValue();
            for (int j = 0; j < testGroupsSubset.length; ++j) {
                SourceGroup testGroup = (SourceGroup)testGroupsSubset[j];
                if (testGroups.contains(testGroup)) continue;
                testGroups.add(testGroup);
            }
        }
        this.allTestSourceGroups = testGroups.toArray(new SourceGroup[testGroups.size()]);
        this.tfProjectName.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
        try {
            this.programmaticChange = true;
            this.ignoreClsNameChanges = true;
            this.tfClassToTest.setText("");
            this.ignoreClsNameChanges = false;
            this.classNameLength = 0;
            this.classNameChanged();
            this.srcGroupNameDisplayed = false;
            this.setNavigationFilterEnabled(false);
        }
        finally {
            this.ignoreClsNameChanges = false;
            this.programmaticChange = false;
        }
        if (this.checkClassNameValidity()) {
            this.checkSelectedClassExists();
        } else {
            this.classExists = false;
        }
        this.setErrorMsg(this.errMsg);
        this.setValidity();
        this.updateLocationComboBox();
        this.updateTargetFolderData();
        this.updateCreatedFileName();
        this.srcFile = null;
        if (!this.multipleSourceRoots) {
            this.setInteractionRestrictionsEnabled(false);
        } else {
            AbstractDocument doc = (AbstractDocument)this.tfClassToTest.getDocument();
            if (this.clsNameDocumentFilter == null) {
                this.clsNameDocumentFilter = new ClsNameDocumentFilter();
            }
            if (doc.getDocumentFilter() != this.clsNameDocumentFilter) {
                doc.setDocumentFilter(this.clsNameDocumentFilter);
            }
            this.setInteractionRestrictionsEnabled(true);
        }
    }

    void selectLocation(FileObject locationFO) {
        Object[] srcRootsToOffer = this.allTestSourceGroups.length == 1 || this.srcGroup == null ? this.allTestSourceGroups : this.sourcesToTestsMap.get(this.srcGroup);
        NamedObject namedObject = new NamedObject((Object)srcRootsToOffer[0], "");
        for (int i = 0; i < srcRootsToOffer.length; ++i) {
            SourceGroup srcRootToOffer = srcRootsToOffer[i];
            if (!srcRootToOffer.getRootFolder().equals(locationFO)) continue;
            namedObject = new NamedObject((Object)srcRootsToOffer[i], srcRootToOffer.getDisplayName());
            break;
        }
        this.cboxLocation.setSelectedItem(namedObject);
        this.updateTargetFolderData();
        this.updateCreatedFileName();
    }

    void cleanUp() {
        this.setInteractionRestrictionsEnabled(false);
    }

    private void setInteractionRestrictionsEnabled(boolean enabled) {
        if (enabled == this.interactionRestrictionsEnabled) {
            return;
        }
        if (enabled) {
            this.interactionRestrictionsEnabled = true;
            assert (this.displayabilityListener == null);
            class DisplayabilityListener
            implements HierarchyListener {
                DisplayabilityListener() {
                }

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    long flags = e.getChangeFlags();
                    if ((flags & 2L) != 0L) {
                        if (SimpleTestStepLocation.this.visualComp.isDisplayable()) {
                            if (SimpleTestStepLocation.this.interactionRestrictionsEnabled) {
                                SimpleTestStepLocation.this.setInteractionRestrictionsActive(true);
                            }
                        } else {
                            SimpleTestStepLocation.this.setInteractionRestrictionsActive(false);
                        }
                    }
                }
            }
            this.displayabilityListener = new DisplayabilityListener();
            this.visualComp.addHierarchyListener(this.displayabilityListener);
            if (this.visualComp.isDisplayable()) {
                this.setInteractionRestrictionsActive(true);
            }
        } else {
            this.interactionRestrictionsEnabled = false;
            this.setInteractionRestrictionsActive(false);
            this.visualComp.removeHierarchyListener(this.displayabilityListener);
            this.displayabilityListener = null;
        }
    }

    private void setInteractionRestrictionsActive(boolean active) {
        if (active == this.interactionRestrictionsActive) {
            return;
        }
        if (active) {
            this.tryActivateInteractionRestrictions();
        } else {
            this.deactivateInteractionRestrictions();
        }
    }

    private void tryActivateInteractionRestrictions() {
        assert (!this.interactionRestrictionsActive);
        assert (this.interactionRestrictionsEnabled);
        if (this.rootPane == null) {
            this.rootPane = SwingUtilities.getRootPane(this.visualComp);
        }
        if (this.rootPane != null) {
            this.defaultButton = this.rootPane.getDefaultButton();
            if (this.defaultButton != null) {
                this.activateInteractionRestrictions();
            }
        }
    }

    private void activateInteractionRestrictions() {
        assert (!this.interactionRestrictionsActive);
        assert (this.rootPane != null && this.defaultButton != null);
        if (this.mouseBlocked == null || this.mnemonicBlocked == null) {
            this.findComponentsToBlock();
            assert (this.mouseBlocked != null && this.mnemonicBlocked != null);
        }
        this.blockDefaultRootPaneAction();
        this.blockMnemonics();
        this.setMouseClicksBlockingActive(!this.interactionRestrictionsSuspended);
        this.interactionRestrictionsActive = true;
    }

    private void deactivateInteractionRestrictions() {
        assert (this.interactionRestrictionsActive);
        assert (this.defaultButton != null && this.rootPane != null);
        this.setMouseClicksBlockingActive(false);
        this.unblockMnemonics();
        this.unblockDefaultRootPaneAction();
        this.defaultButton = null;
        this.rootPane = null;
        this.interactionRestrictionsActive = false;
        this.interactionRestrictionsSuspended = false;
    }

    private void setInteractionRestrictionsSuspended(boolean suspended) {
        if (suspended != this.interactionRestrictionsSuspended) {
            this.setMouseClicksBlockingActive(this.interactionRestrictionsActive && !suspended);
            this.interactionRestrictionsSuspended = suspended;
        }
    }

    private void setMouseClicksBlockingActive(boolean blockingActive) {
        if (blockingActive != this.mouseClicksBlocked) {
            if (blockingActive) {
                this.blockMouseClicks();
            } else {
                this.unblockMouseClicks();
            }
            this.mouseClicksBlocked = blockingActive;
        }
    }

    private void findComponentsToBlock() {
        assert (this.rootPane != null);
        ArrayList<Component> mouseBlocked = new ArrayList<Component>(20);
        ArrayList<JComponent> mnemBlocked = new ArrayList<JComponent>(20);
        ArrayList<Component> stack = new ArrayList<Component>(16);
        stack.add(this.rootPane.getContentPane());
        int lastIndex = 0;
        block4: while (lastIndex != -1) {
            Component c;
            if (!(c = (Component)stack.remove(lastIndex--)).isVisible()) continue;
            if (c instanceof JLabel) {
                JLabel lbl = (JLabel)c;
                Component labelFor = lbl.getLabelFor();
                if (labelFor == null || labelFor == this.tfClassToTest || lbl.getDisplayedMnemonic() == 0) continue;
                mnemBlocked.add(lbl);
                continue;
            }
            if (c instanceof AbstractButton) {
                if (c == this.btnBrowse) continue;
                AbstractButton btn = (AbstractButton)c;
                mouseBlocked.add(btn);
                if (btn.getMnemonic() == 0) continue;
                mnemBlocked.add(btn);
                continue;
            }
            if (!(c instanceof Container)) {
                if (!c.isFocusable() || c == this.tfClassToTest) continue;
                mouseBlocked.add(c);
                continue;
            }
            Component[] content = ((Container)c).getComponents();
            switch (content.length) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    stack.add(content[0]);
                    ++lastIndex;
                    continue block4;
                }
            }
            stack.addAll(Arrays.asList(content));
            lastIndex += content.length;
        }
        this.mouseBlocked = new Component[mouseBlocked.size()];
        if (mouseBlocked.size() != 0) {
            mouseBlocked.toArray(this.mouseBlocked);
        }
        this.mnemonicBlocked = new JComponent[mnemBlocked.size()];
        if (mnemBlocked.size() != 0) {
            mnemBlocked.toArray(this.mnemonicBlocked);
        }
    }

    private void blockDefaultRootPaneAction() {
        assert (this.rootPane != null && this.defaultButton != null && this.rootPane.getDefaultButton() == this.defaultButton);
        String actionKey1 = "press";
        String actionKey2 = "pressed";
        ActionMap actionMap = this.rootPane.getActionMap();
        String actionKey = "press";
        Action originalAction = actionMap.get("press");
        if (originalAction == null) {
            actionKey = "pressed";
            originalAction = actionMap.get("pressed");
        }
        assert (originalAction != null);
        if (originalAction == null) {
            return;
        }
        actionMap.put(actionKey, new SelectSrcGrpAction(this.rootPane, originalAction));
        this.rootPaneDefaultActionKey = actionKey;
        this.rootPaneDefaultAction = originalAction;
    }

    private void unblockDefaultRootPaneAction() {
        assert (this.rootPane != null);
        if (this.rootPaneDefaultAction == null) {
            return;
        }
        this.rootPane.getActionMap().put(this.rootPaneDefaultActionKey, this.rootPaneDefaultAction);
        this.rootPaneDefaultActionKey = null;
        this.rootPaneDefaultAction = null;
    }

    private void blockMnemonics() {
        assert (this.rootPane != null);
        if (this.actionMappingInfo == null) {
            this.findActionMappings();
        }
        assert (this.actionMappingInfo != null);
        assert (this.actionMappingInfo.length == this.mnemonicBlocked.length);
        JComponent[] comps = this.mnemonicBlocked;
        for (int i = 0; i < comps.length; ++i) {
            ActionMappingInfo mappingInfo = this.actionMappingInfo[i];
            if (mappingInfo != null) {
                comps[i].getActionMap().put(mappingInfo.actionKey, new SelectSrcGrpAction(comps[i], mappingInfo.originalAction));
                continue;
            }
            if (!(comps[i] instanceof JLabel)) continue;
            JLabelActionMap map = new JLabelActionMap(comps[i]);
            map.setParent(comps[i].getActionMap());
            comps[i].setActionMap(map);
        }
    }

    private void unblockMnemonics() {
        assert (this.rootPane != null);
        if (this.actionMappingInfo == null) {
            return;
        }
        assert (this.actionMappingInfo.length == this.mnemonicBlocked.length);
        JComponent[] comps = this.mnemonicBlocked;
        for (int i = 0; i < comps.length; ++i) {
            ActionMappingInfo mappingInfo = this.actionMappingInfo[i];
            if (mappingInfo != null) {
                comps[i].getActionMap().put(mappingInfo.actionKey, mappingInfo.inProximateActionMap ? mappingInfo.originalAction : (Action)null);
                continue;
            }
            if (!(comps[i] instanceof JLabel)) continue;
            comps[i].setActionMap(comps[i].getActionMap().getParent());
        }
    }

    private void findActionMappings() {
        assert (this.mnemonicBlocked != null);
        String actionKey1 = "pressed";
        String actionKey2 = "press";
        this.actionMappingInfo = new ActionMappingInfo[this.mnemonicBlocked.length];
        JComponent[] comps = this.mnemonicBlocked;
        for (int i = 0; i < comps.length; ++i) {
            JComponent c = comps[i];
            ActionMap actionMap = comps[i].getActionMap();
            String primaryKey = "pressed";
            String secondaryKey = "press";
            if (c instanceof JLabel) {
                this.actionMappingInfo[i] = null;
                continue;
            }
            String actionKey = primaryKey;
            Action originalAction = actionMap.get(actionKey);
            if (originalAction == null) {
                actionKey = secondaryKey;
                originalAction = actionMap.get(actionKey);
            }
            if (originalAction == null) {
                ErrorManager.getDefault().log(4096, "JUnitWizard - Test for Existing Class: press action not found for a " + c.getClass().getName() + " component");
                this.actionMappingInfo[i] = null;
                continue;
            }
            ActionMappingInfo mappingInfo = new ActionMappingInfo();
            mappingInfo.actionKey = actionKey;
            mappingInfo.originalAction = originalAction;
            String keyToFind = actionKey;
            Object[] keys = actionMap.keys();
            if (keys != null) {
                for (int j = 0; j < keys.length; ++j) {
                    if (!keyToFind.equals(keys[j])) continue;
                    mappingInfo.inProximateActionMap = true;
                    break;
                }
            }
            this.actionMappingInfo[i] = mappingInfo;
        }
    }

    private void blockMouseClicks() {
        assert (this.rootPane != null);
        Component glassPane = this.rootPane.getGlassPane();
        if (this.glassPaneListener == null) {
            this.glassPaneListener = new GlassPaneListener();
        }
        glassPane.addMouseListener(this.glassPaneListener);
        glassPane.addMouseMotionListener(this.glassPaneListener);
        glassPane.setVisible(true);
    }

    private void unblockMouseClicks() {
        assert (this.rootPane != null);
        if (this.glassPaneListener == null) {
            return;
        }
        Component glassPane = this.rootPane.getGlassPane();
        glassPane.setVisible(false);
        glassPane.removeMouseMotionListener(this.glassPaneListener);
        glassPane.removeMouseListener(this.glassPaneListener);
    }

    private void clearFocusGainAllowedVar() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SimpleTestStepLocation.this.focusGainAllowedFor = null;
            }
        });
    }

    private static boolean checkObjChanged(Object oldObj, Object newObj) {
        return !(oldObj == null && newObj == null || oldObj != null && oldObj.equals(newObj));
    }

    private class ClsNameNavigationFilter
    extends NavigationFilter {
        @Override
        public void setDot(NavigationFilter.FilterBypass bypass, int dot, Position.Bias bias) {
            if (dot > SimpleTestStepLocation.this.classNameLength) {
                bypass.setDot(SimpleTestStepLocation.this.classNameLength, bias);
            } else {
                super.setDot(bypass, dot, bias);
            }
        }

        @Override
        public void moveDot(NavigationFilter.FilterBypass bypass, int dot, Position.Bias bias) {
            if (dot > SimpleTestStepLocation.this.classNameLength) {
                bypass.moveDot(SimpleTestStepLocation.this.classNameLength, bias);
            } else {
                super.moveDot(bypass, dot, bias);
            }
        }

        public void ensureCursorInRange() {
            if (SimpleTestStepLocation.this.srcGroupNameDisplayed && SimpleTestStepLocation.this.tfClassToTest.getCaretPosition() > SimpleTestStepLocation.this.classNameLength) {
                SimpleTestStepLocation.this.tfClassToTest.setCaretPosition(SimpleTestStepLocation.this.classNameLength);
            }
        }
    }

    private class ClsNameDocumentFilter
    extends DocumentFilter {
        @Override
        public void replace(DocumentFilter.FilterBypass bypass, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (!SimpleTestStepLocation.this.programmaticChange && SimpleTestStepLocation.this.srcGroupNameDisplayed) {
                this.removeSrcGroupName(bypass);
            }
            super.replace(bypass, offset, length, text, attrs);
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass bypass, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (!SimpleTestStepLocation.this.programmaticChange && SimpleTestStepLocation.this.srcGroupNameDisplayed) {
                this.removeSrcGroupName(bypass);
            }
            super.insertString(bypass, offset, string, attr);
        }

        @Override
        public void remove(DocumentFilter.FilterBypass bypass, int offset, int length) throws BadLocationException {
            if (!SimpleTestStepLocation.this.programmaticChange && SimpleTestStepLocation.this.srcGroupNameDisplayed) {
                this.removeSrcGroupName(bypass);
            }
            super.remove(bypass, offset, length);
        }

        private void removeSrcGroupName(DocumentFilter.FilterBypass bypass) throws BadLocationException {
            bypass.remove(SimpleTestStepLocation.this.classNameLength, SimpleTestStepLocation.this.tfClassToTest.getText().length() - SimpleTestStepLocation.this.classNameLength);
            SimpleTestStepLocation.this.srcGroupNameDisplayed = false;
            SimpleTestStepLocation.this.setNavigationFilterEnabled(false);
        }
    }

    private class SelectSrcGrpAction
    extends AbstractAction {
        private final Component component;
        private final Action delegate;

        public SelectSrcGrpAction(Component comp, Action delegate) {
            this.component = comp;
            this.delegate = delegate;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean askUserToChoose;
            assert (SimpleTestStepLocation.this.multipleSourceRoots);
            SourceGroup[] candidates = null;
            if (SimpleTestStepLocation.this.interactionRestrictionsSuspended) {
                askUserToChoose = false;
            } else if (this.component == SimpleTestStepLocation.this.defaultButton || this.component == SimpleTestStepLocation.this.rootPane) {
                candidates = SimpleTestStepLocation.this.findParentGroupCandidates();
                askUserToChoose = candidates.length > 1;
            } else if (!SwingUtilities.isDescendingFrom(this.component, SimpleTestStepLocation.this.visualComp)) {
                askUserToChoose = false;
            } else {
                candidates = SimpleTestStepLocation.this.findParentGroupCandidates();
                boolean bl = askUserToChoose = candidates.length > 1;
            }
            assert (!askUserToChoose || candidates.length > 1);
            if (askUserToChoose) {
                SourceGroup srcGroup = SimpleTestStepLocation.this.chooseSrcGroup(candidates);
                if (srcGroup != null) {
                    SimpleTestStepLocation.this.setSelectedSrcGroup(srcGroup);
                    if (this.component == SimpleTestStepLocation.this.rootPane) {
                        SimpleTestStepLocation.this.defaultButton.requestFocus();
                    } else {
                        this.component.requestFocus();
                    }
                }
            } else {
                if (candidates != null) {
                    assert (candidates.length == 1);
                    SimpleTestStepLocation.this.setSelectedSrcGroup(candidates[0]);
                }
                this.redispatchEvent(e);
            }
        }

        private void redispatchEvent(ActionEvent e) {
            SimpleTestStepLocation.this.focusGainAllowedFor = this.component;
            try {
                this.delegate.actionPerformed(e);
            }
            finally {
                SimpleTestStepLocation.this.clearFocusGainAllowedVar();
            }
        }

        @Override
        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }
    }

    final class GlassPaneListener
    implements MouseInputListener {
        final Component glassPane;
        final Component layeredPane;
        final Container contentPane;

        GlassPaneListener() {
            this.glassPane = SimpleTestStepLocation.this.rootPane.getGlassPane();
            this.layeredPane = SimpleTestStepLocation.this.rootPane.getLayeredPane();
            this.contentPane = SimpleTestStepLocation.this.rootPane.getContentPane();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.redispatchEvent(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.redispatchEvent(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.redispatchEvent(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.redispatchEvent(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.redispatchEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.evaluateEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.redispatchEvent(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void evaluateEvent(MouseEvent e) {
            boolean askUserToChoose;
            assert (SimpleTestStepLocation.this.multipleSourceRoots);
            Component component = this.getDeepestComponent(e);
            if (component == null) {
                return;
            }
            boolean isBlocked = false;
            if (SwingUtilities.isLeftMouseButton(e)) {
                Component[] blocked = SimpleTestStepLocation.this.mouseBlocked;
                for (int i = 0; i < blocked.length; ++i) {
                    if (component != blocked[i]) continue;
                    isBlocked = true;
                    break;
                }
            }
            SourceGroup[] candidates = null;
            if (!isBlocked || SimpleTestStepLocation.this.interactionRestrictionsSuspended) {
                askUserToChoose = false;
            } else if (component == SimpleTestStepLocation.this.defaultButton) {
                candidates = SimpleTestStepLocation.this.findParentGroupCandidates();
                askUserToChoose = candidates.length > 1;
            } else if (!SwingUtilities.isDescendingFrom(component, SimpleTestStepLocation.this.visualComp)) {
                askUserToChoose = false;
            } else {
                candidates = SimpleTestStepLocation.this.findParentGroupCandidates();
                boolean bl = askUserToChoose = candidates.length > 1;
            }
            assert (!askUserToChoose || candidates.length > 1);
            if (askUserToChoose) {
                SourceGroup srcGroup = SimpleTestStepLocation.this.chooseSrcGroup(candidates);
                if (srcGroup != null) {
                    SimpleTestStepLocation.this.setSelectedSrcGroup(srcGroup);
                    SimpleTestStepLocation.this.focusGainAllowedFor = component;
                    component.requestFocus();
                }
            } else {
                if (candidates != null) {
                    assert (candidates.length == 1);
                    SimpleTestStepLocation.this.setSelectedSrcGroup(candidates[0]);
                }
                SimpleTestStepLocation.this.focusGainAllowedFor = component;
                try {
                    this.redispatchEvent(e, component);
                }
                finally {
                    SimpleTestStepLocation.this.clearFocusGainAllowedVar();
                }
            }
        }

        private void redispatchEvent(MouseEvent e) {
            Component deepestComp = this.getDeepestComponent(e);
            if (deepestComp != null) {
                this.redispatchEvent(e, deepestComp);
            }
        }

        private void redispatchEvent(MouseEvent e, Component component) {
            Point componentPoint = SwingUtilities.convertPoint(this.glassPane, e.getPoint(), component);
            component.dispatchEvent(new MouseEvent(component, e.getID(), e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger()));
        }

        private Component getDeepestComponent(MouseEvent e) {
            Point contentPanePoint = SwingUtilities.convertPoint(this.glassPane, e.getPoint(), this.contentPane);
            return SwingUtilities.getDeepestComponentAt(this.contentPane, contentPanePoint.x, contentPanePoint.y);
        }
    }

    final class JLabelActionMap
    extends ActionMap {
        private final Component component;

        JLabelActionMap(Component comp) {
            this.component = comp;
        }

        @Override
        public Action get(Object key) {
            if (key.equals("press")) {
                Action defaultAction = super.get(key);
                return defaultAction != null ? new SelectSrcGrpAction(this.component, defaultAction) : null;
            }
            return super.get(key);
        }
    }

    private static class ActionMappingInfo {
        String actionKey;
        Action originalAction;
        boolean inProximateActionMap;

        private ActionMappingInfo() {
        }
    }
}

