/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.spi.java.platform.JavaPlatformFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class DebianJavaPlatformDetector
implements Runnable {
    static final File DEBIAN_JAVA_DIR = new File("/usr/lib/jvm");
    static final String JAVA_DIR_MATCHER = "java-(\\d+)-openjdk-(amd64|arm64|i386)";

    @Override
    public void run() {
        if (DEBIAN_JAVA_DIR.isDirectory()) {
            File[] platformDirs = DEBIAN_JAVA_DIR.listFiles(f -> f.isDirectory() && f.getName().matches(JAVA_DIR_MATCHER));
            Collection providers = Lookup.getDefault().lookupAll(JavaPlatformFactory.Provider.class);
            for (JavaPlatformFactory.Provider provider : providers) {
                JavaPlatformFactory platformFactory = provider.forType("j2se");
                if (platformFactory == null) continue;
                for (File platformDir : platformDirs) {
                    try {
                        FileObject installFolder = FileUtil.toFileObject((File)platformDir);
                        platformFactory.create(installFolder, DebianJavaPlatformDetector.getDisplayName(installFolder), true);
                    }
                    catch (IOException iOException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static String getDisplayName(FileObject installFolder) {
        Matcher m = Pattern.compile(JAVA_DIR_MATCHER).matcher(installFolder.getNameExt());
        return m.find() ? "JDK " + m.group(1) : installFolder.getNameExt();
    }
}

