/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.common.utils;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.payara.common.PayaraInstance;
import org.netbeans.modules.payara.common.PayaraLogger;
import org.netbeans.modules.payara.tooling.data.PayaraVersion;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class ServerUtils {
    private static final Logger LOGGER = PayaraLogger.get(ServerUtils.class);
    private static final String DOMAINS_FOLDER_PREFIX = "GF_";

    public static String getStringAttribute(FileObject fo, String attrName) {
        return ServerUtils.getStringAttribute(fo, attrName, null);
    }

    public static String getStringAttribute(FileObject fo, String attrName, String defValue) {
        String result = defValue;
        Object attr = fo.getAttribute(attrName);
        if (attr instanceof String) {
            result = (String)attr;
        }
        return result;
    }

    public static void setStringAttribute(FileObject fo, String key, String value) {
        try {
            fo.setAttribute(key, (Object)value);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, "Cannot update file object value: {0} -> {1} in {2}", new Object[]{key, value, fo.getPath()});
        }
    }

    public static FileObject getRepositoryDir(String path, boolean create) {
        FileObject dir = FileUtil.getConfigFile((String)path);
        if (dir == null && create) {
            try {
                dir = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)path);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        return dir;
    }

    public static boolean isValidFolder(String folderName) {
        if (folderName == null) {
            return false;
        }
        File f = new File(folderName);
        return f.isDirectory() && f.canRead();
    }

    public static String getDomainsFolder(@NonNull PayaraInstance instance) {
        PayaraVersion version = instance.getVersion();
        if (version == null) {
            throw new IllegalStateException(NbBundle.getMessage(PayaraInstance.class, (String)"PayaraInstance.getDomainsFolder.versionIsNull", (Object)instance.getDisplayName()));
        }
        boolean useBuild = version.getBuild() > 0;
        boolean useUpdate = useBuild || version.getUpdate() > 0;
        StringBuilder sb = new StringBuilder(DOMAINS_FOLDER_PREFIX.length() + 5 + (useUpdate ? (useBuild ? 6 : 3) : 0));
        sb.append(DOMAINS_FOLDER_PREFIX);
        sb.append(Short.toString(version.getMajor()));
        sb.append('.');
        sb.append(Short.toString(version.getMinor()));
        if (useUpdate) {
            sb.append('.');
            sb.append(Short.toString(version.getUpdate()));
            if (useBuild) {
                sb.append('.');
                sb.append(Short.toString(version.getBuild()));
            }
        }
        return sb.toString();
    }

    public static boolean isProcessRunning(Process process) {
        try {
            process.exitValue();
            return false;
        }
        catch (IllegalThreadStateException itse) {
            return true;
        }
    }
}

