/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javawebstart.ui.customizer;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.javawebstart.ui.customizer.JWSCustomizerPanel;
import org.netbeans.modules.javawebstart.ui.customizer.JWSProjectProperties;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class SigningPanel
extends JPanel
implements ActionListener,
DocumentListener {
    private final JWSProjectProperties props;
    private DialogDescriptor desc;
    ButtonGroup bg;
    JButton browse;
    JLabel jLabel1;
    JLabel jLabel2;
    JLabel jLabel3;
    JLabel jLabel4;
    JLabel jLabel5;
    JTextField key;
    JPasswordField keyPass;
    JRadioButton keySign;
    JLabel labelWarning;
    JComboBox mixedCodeCombo;
    JRadioButton noSign;
    JPasswordField password;
    JTextField path;
    JRadioButton selfSign;

    public SigningPanel(JWSProjectProperties props) {
        this.props = props;
        this.initComponents();
        if ("key".equals(props.signing)) {
            this.keySign.setSelected(true);
        } else if ("generated".equals(props.signing)) {
            this.selfSign.setSelected(true);
        } else {
            this.noSign.setSelected(true);
        }
        this.path.setText(props.signingKeyStore);
        this.key.setText(props.signingKeyAlias);
        if (props.signingKeyStorePassword != null) {
            this.password.setText(new String(props.signingKeyStorePassword));
        }
        if (props.signingKeyPassword != null) {
            this.keyPass.setText(new String(props.signingKeyPassword));
        }
        this.mixedCodeCombo.setModel(props.mixedCodeModel);
        this.refreshComponents();
    }

    void setDialogDescriptor(DialogDescriptor desc) {
        this.desc = desc;
        this.updateDialogButtonsAndMessage();
    }

    void registerListeners() {
        this.path.getDocument().addDocumentListener(this);
        this.password.getDocument().addDocumentListener(this);
        this.key.getDocument().addDocumentListener(this);
    }

    void unregisterListeners() {
        this.path.getDocument().removeDocumentListener(this);
        this.password.getDocument().removeDocumentListener(this);
        this.key.getDocument().removeDocumentListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateDialogButtonsAndMessage();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateDialogButtonsAndMessage();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateDialogButtonsAndMessage();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.keySign.addActionListener(this);
        this.selfSign.addActionListener(this);
        this.noSign.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.refreshComponents();
        this.updateDialogButtonsAndMessage();
    }

    private void refreshComponents() {
        this.path.setEnabled(this.keySign.isSelected());
        this.browse.setEnabled(this.keySign.isSelected());
        this.password.setEnabled(this.keySign.isSelected());
        this.key.setEnabled(this.keySign.isSelected());
        this.keyPass.setEnabled(this.keySign.isSelected());
        this.jLabel1.setEnabled(this.keySign.isSelected());
        this.jLabel2.setEnabled(this.keySign.isSelected());
        this.jLabel3.setEnabled(this.keySign.isSelected());
        this.jLabel4.setEnabled(this.keySign.isSelected());
        this.mixedCodeCombo.setEnabled(!this.noSign.isSelected());
        this.jLabel5.setEnabled(!this.noSign.isSelected());
        if (this.keySign.isSelected()) {
            this.labelWarning.setText(null);
        } else {
            this.labelWarning.setText(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"SigningPanel.WarnDeprecated"));
        }
    }

    void store() {
        if (this.noSign.isSelected()) {
            this.props.signing = "";
        } else if (this.selfSign.isSelected()) {
            this.props.signing = "generated";
        } else {
            this.props.signing = "key";
            this.props.signingKeyStorePassword = this.password.getPassword();
            this.props.signingKeyPassword = this.keyPass.getPassword();
            this.props.signingKeyStore = this.path.getText().trim();
            this.props.signingKeyAlias = this.key.getText().trim();
        }
    }

    private void initComponents() {
        this.bg = new ButtonGroup();
        this.selfSign = new JRadioButton();
        this.keySign = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.path = new JTextField();
        this.browse = new JButton();
        this.jLabel2 = new JLabel();
        this.password = new JPasswordField();
        this.jLabel3 = new JLabel();
        this.key = new JTextField();
        this.jLabel4 = new JLabel();
        this.keyPass = new JPasswordField();
        this.noSign = new JRadioButton();
        this.mixedCodeCombo = new JComboBox();
        this.jLabel5 = new JLabel();
        this.labelWarning = new JLabel();
        this.bg.add(this.selfSign);
        Mnemonics.setLocalizedText((AbstractButton)this.selfSign, (String)NbBundle.getMessage(SigningPanel.class, (String)"SigningPanel.selfSign.text"));
        this.bg.add(this.keySign);
        Mnemonics.setLocalizedText((AbstractButton)this.keySign, (String)NbBundle.getMessage(SigningPanel.class, (String)"SigningPanel.keySign.text"));
        this.jLabel1.setLabelFor(this.path);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SigningPanel.class, (String)"SigningPanel.jLabel1.text"));
        this.path.setText(NbBundle.getMessage(SigningPanel.class, (String)"SigningPanel.path.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browse, (String)NbBundle.getMessage(SigningPanel.class, (String)"SigningPanel.browse.text"));
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SigningPanel.this.browseActionPerformed(evt);
            }
        });
        this.jLabel2.setLabelFor(this.password);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SigningPanel.class, (String)"SigningPanel.jLabel2.text"));
        this.password.setText(NbBundle.getMessage(SigningPanel.class, (String)"SigningPanel.password.text"));
        this.jLabel3.setLabelFor(this.key);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SigningPanel.class, (String)"SigningPanel.jLabel3.text"));
        this.key.setText(NbBundle.getMessage(SigningPanel.class, (String)"SigningPanel.key.text"));
        this.jLabel4.setLabelFor(this.keyPass);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SigningPanel.class, (String)"SigningPanel.jLabel4.text"));
        this.keyPass.setText(NbBundle.getMessage(SigningPanel.class, (String)"SigningPanel.keyPass.text"));
        this.bg.add(this.noSign);
        Mnemonics.setLocalizedText((AbstractButton)this.noSign, (String)NbBundle.getMessage(SigningPanel.class, (String)"SigningPanel.noSign.text"));
        this.jLabel5.setLabelFor(this.mixedCodeCombo);
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(SigningPanel.class, (String)"SigningPanel.jLabel5.text"));
        this.jLabel5.setToolTipText(NbBundle.getMessage(SigningPanel.class, (String)"SigningPanel.jLabel5.toolTipText"));
        Mnemonics.setLocalizedText((JLabel)this.labelWarning, (String)NbBundle.getMessage(SigningPanel.class, (String)"SigningPanel.labelWarning.text"));
        this.labelWarning.setPreferredSize(new Dimension(300, 60));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mixedCodeCombo, 0, 391, Short.MAX_VALUE).addComponent(this.keyPass, -1, 391, Short.MAX_VALUE).addComponent(this.key, -1, 391, Short.MAX_VALUE).addComponent(this.password, -1, 391, Short.MAX_VALUE).addComponent(this.path, -1, 391, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browse)).addComponent(this.labelWarning, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noSign).addComponent(this.selfSign).addComponent(this.keySign)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.noSign).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selfSign).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.keySign).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.path, -2, -1, -2).addComponent(this.browse)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.password, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.key, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.keyPass, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.mixedCodeCombo, -2, -1, -2)).addGap(11, 11, 11).addComponent(this.labelWarning, -2, 33, -2).addGap(3, 3, 3)));
        this.selfSign.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SigningPanel.class, (String)"AD_SigningPanel.selfSign.text"));
        this.keySign.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SigningPanel.class, (String)"AD_SigningPanel.keySign.text"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SigningPanel.class, (String)"AD_SigningPanel.jLabel1.text"));
        this.browse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SigningPanel.class, (String)"AD_SigningPanel.browse.text"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SigningPanel.class, (String)"AD_SigningPanel.jLabel2.text"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SigningPanel.class, (String)"AD_SigningPanel.jLabel3.text"));
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SigningPanel.class, (String)"AD_SigningPanel.jLabel4.text"));
        this.noSign.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SigningPanel.class, (String)"AD_SigningPanel.noSign.text"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SigningPanel.class, (String)"AD_SigningPanel"));
    }

    private void browseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"TITLE_KeystoreBrowser"));
        if (0 == chooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.path.setText(file.getAbsolutePath());
        }
    }

    private void updateDialogButtonsAndMessage() {
        if (!this.keySign.isSelected() || this.password.getDocument().getLength() > 0 && this.key.getDocument().getLength() > 0) {
            this.desc.setValid(true);
            if (this.keySign.isSelected()) {
                if (this.path.getDocument().getLength() > 0) {
                    this.labelWarning.setText(null);
                } else {
                    this.labelWarning.setText(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"SigningPanel.InfoDefaultPath"));
                }
            }
        } else {
            this.desc.setValid(false);
            this.labelWarning.setText(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"SigningPanel.WarnMissingInfo"));
        }
    }
}

