/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.structure.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModel;

public final class DocumentModelUtils {
    public static DocumentElement[] elements(DocumentModel model) {
        return model.elements();
    }

    public static DocumentElement findElement(DocumentModel model, int startOffset, String name, String type) throws BadLocationException {
        List<DocumentElement> els = model.getDocumentElements(startOffset);
        for (DocumentElement de : els) {
            if (!de.getName().equals(name) || !de.getType().equals(type)) continue;
            return de;
        }
        return null;
    }

    public static List<DocumentElement> getDescendants(DocumentElement de) {
        ArrayList<DocumentElement> desc = new ArrayList<DocumentElement>();
        for (DocumentElement child : de.getChildren()) {
            desc.add(child);
            desc.addAll(DocumentModelUtils.getDescendants(child));
        }
        return desc;
    }

    public static void dumpElementStructure(DocumentElement de) {
        System.out.println("-------- ELEMENTS STRUCTURE --------");
        DocumentModelUtils.dumpElementStructure(de, 0);
    }

    private static void dumpElementStructure(DocumentElement de, int level) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            sb.append(' ');
        }
        String text = de.toString();
        sb.append(text);
        System.out.println(sb.toString());
        Iterator<DocumentElement> children = de.getChildren().iterator();
        while (children.hasNext()) {
            DocumentModelUtils.dumpElementStructure(children.next(), level + 4);
        }
    }

    public static void dumpModelElements(DocumentModel model) {
        model.debugElements();
    }
}

