/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.multiview;

import java.awt.EventQueue;
import java.io.Serializable;
import java.util.Collections;
import java.util.logging.Logger;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.websvc.design.javamodel.ProjectService;
import org.netbeans.modules.websvc.design.multiview.ShowComponentCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.DataEditorSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public class MultiViewSupport
implements OpenCookie,
EditCookie {
    static final long serialVersionUID = 1L;
    private DataObject dataObject;
    private ProjectService service;
    public static String SOURCE_UNSAFE_CLOSE = "SOURCE_UNSAFE_CLOSE";
    public static final String DESIGN_VIEW_ID = "webservice-designview";
    public static final String SOURCE_VIEW_ID = "webservice-sourceview";
    static Logger l = Logger.getLogger(MultiViewSupport.class.getName());

    public MultiViewSupport() {
    }

    public MultiViewSupport(ProjectService service, DataObject dataObject) {
        this.dataObject = dataObject;
        this.service = service;
    }

    public void open() {
        this.view(View.DESIGN, new Object[0]);
    }

    public void edit() {
        this.view(View.SOURCE, new Object[0]);
    }

    public void preview() {
        this.view(View.PREVIEW, new Object[0]);
    }

    DataObject getDataObject() {
        return this.dataObject;
    }

    private DataEditorSupport getEditorSupport() {
        return (DataEditorSupport)this.dataObject.getLookup().lookup(DataEditorSupport.class);
    }

    ProjectService getService() {
        return this.service;
    }

    FileObject getImplementationBean() {
        return this.getDataObject().getPrimaryFile();
    }

    public CloneableTopComponent createMultiView() {
        CloneableTopComponent multiview = MultiViews.createCloneableMultiView((String)"text/x-jaxws", (Serializable)this.dataObject);
        String displayName = this.getDataObject().getNodeDelegate().getDisplayName();
        multiview.setDisplayName(displayName);
        multiview.setName(displayName);
        return multiview;
    }

    public void view(final View view, final Object ... param) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MultiViewSupport.this.viewInSwingThread(view, param);
                }
            });
        } else {
            this.viewInSwingThread(view, param);
        }
    }

    private void viewInSwingThread(View view, Object ... parameters) {
        TopComponent activeTC;
        ShowComponentCookie cake;
        this.getEditorSupport().open();
        switch (view) {
            case SOURCE: {
                MultiViewSupport.requestMultiviewActive(SOURCE_VIEW_ID);
                break;
            }
            case DESIGN: {
                MultiViewSupport.requestMultiviewActive(DESIGN_VIEW_ID);
                break;
            }
            case PREVIEW: {
                MultiViewSupport.requestMultiviewActive("webservice-wsdlpreview");
            }
        }
        if (parameters != null && parameters.length > 0 && (cake = (ShowComponentCookie)(activeTC = TopComponent.getRegistry().getActivated()).getLookup().lookup(ShowComponentCookie.class)) != null) {
            cake.show(parameters[0]);
        }
    }

    private static void requestMultiviewActive(String id) {
        TopComponent activeTC = TopComponent.getRegistry().getActivated();
        MultiViewHandler handler = MultiViews.findMultiViewHandler((TopComponent)activeTC);
        if (handler != null) {
            MultiViewPerspective[] perspectives;
            for (MultiViewPerspective perspective : perspectives = handler.getPerspectives()) {
                if (!perspective.preferredID().equals(id)) continue;
                handler.requestActive(perspective);
            }
        }
    }

    public static int getNumberOfClones(TopComponent tc) {
        if (!(tc instanceof CloneableTopComponent)) {
            return -1;
        }
        return Collections.list(((CloneableTopComponent)tc).getReference().getComponents()).size();
    }

    public static enum View {
        SOURCE,
        DESIGN,
        PREVIEW;

    }
}

