/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SaxCompiler
implements ContentHandler {
    private StringBuilder sb = new StringBuilder();
    private Writer w;
    private int start = 0;
    private int state = 0;
    private boolean omitRoot = false;
    private int level = 0;

    public SaxCompiler(Writer w) {
        this.w = w;
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.w.write("/* This code was generated by nu.validator.tools.SaxCompiler. Please regenerate instead of editing. */\n");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            if (!this.omitRoot) {
                this.w.write("} finally {\ncontentHandler.endDocument();\n}\n");
            }
            this.w.write("}\n");
            this.w.write("private static final char[] __chars__ = ");
            this.w.write(SaxCompiler.charArrayLiteral(this.sb));
            this.w.write(";\n}\n");
            this.w.flush();
            this.w.close();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        this.ensureState();
        try {
            this.w.write("contentHandler.startPrefixMapping(");
            this.w.write(SaxCompiler.stringLiteral(arg0));
            this.w.write(", ");
            this.w.write(SaxCompiler.stringLiteral(arg1));
            this.w.write(");\n");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
        try {
            this.w.write("contentHandler.endPrefixMapping(");
            this.w.write(SaxCompiler.stringLiteral(arg0));
            this.w.write(");\n");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String arg0, String arg1, String arg2, Attributes attrs) throws SAXException {
        this.ensureState();
        ++this.level;
        if (this.omitRoot && this.level == 1) {
            return;
        }
        try {
            this.w.write("__attrs__.clear();\n");
            for (int i = 0; i < attrs.getLength(); ++i) {
                this.w.write("__attrs__.addAttribute(");
                this.w.write(SaxCompiler.stringLiteral(attrs.getURI(i)));
                this.w.write(", ");
                this.w.write(SaxCompiler.stringLiteral(attrs.getLocalName(i)));
                this.w.write(", ");
                this.w.write(SaxCompiler.stringLiteral(attrs.getQName(i)));
                this.w.write(", ");
                this.w.write(SaxCompiler.stringLiteral(attrs.getType(i)));
                this.w.write(", ");
                this.w.write(SaxCompiler.stringLiteral(attrs.getValue(i)));
                this.w.write(");\n");
            }
            this.w.write("contentHandler.startElement(");
            this.w.write(SaxCompiler.stringLiteral(arg0));
            this.w.write(", ");
            this.w.write(SaxCompiler.stringLiteral(arg1));
            this.w.write(", ");
            this.w.write(SaxCompiler.stringLiteral(arg2));
            this.w.write(", __attrs__);\n");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        if (this.omitRoot && this.level == 1) {
            return;
        }
        --this.level;
        try {
            this.w.write("contentHandler.endElement(");
            this.w.write(SaxCompiler.stringLiteral(arg0));
            this.w.write(", ");
            this.w.write(SaxCompiler.stringLiteral(arg1));
            this.w.write(", ");
            this.w.write(SaxCompiler.stringLiteral(arg2));
            this.w.write(");\n");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void characters(char[] buf, int offset, int length) throws SAXException {
        this.sb.append(buf, offset, length);
        try {
            this.w.write("contentHandler.characters(__chars__, ");
            this.w.write("" + this.start);
            this.w.write(", ");
            this.w.write("" + length);
            this.w.write(");\n");
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        this.start += length;
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            if ("SaxCompiler-package".equals(target)) {
                this.assertState(0);
                this.w.write("package ");
                this.w.write(data);
                this.w.write(";\n");
                this.state = 1;
            } else if ("SaxCompiler-class".equals(target)) {
                this.assertStateLEQ(1);
                this.w.write("public final class ");
                this.w.write(data);
                this.w.write(" {\n");
                this.w.write("private ");
                this.w.write(data);
                this.w.write("() {}\n");
                this.state = 2;
            } else if ("SaxCompiler-args".equals(target)) {
                this.assertState(2);
                this.w.write("public static void emit(org.xml.sax.ContentHandler contentHandler, ");
                this.w.write(data);
                this.w.write(") throws org.xml.sax.SAXException {\n");
                this.state = 3;
                this.writeStart();
            } else if ("SaxCompiler-omitRoot".equals(target)) {
                this.assertStateLEQ(2);
                this.omitRoot = true;
            } else if ("SaxCompiler-code".equals(target)) {
                this.ensureState();
                this.w.write(data);
                this.w.write("\n");
            } else {
                this.ensureState();
                this.w.write("contentHandler.processingInstruction(");
                this.w.write(SaxCompiler.stringLiteral(target));
                this.w.write(", ");
                this.w.write(SaxCompiler.stringLiteral(data));
                this.w.write(");\n");
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
        throw new SAXException("skippedEntity not supported");
    }

    private void assertState(int s) throws SAXException {
        if (this.state != s) {
            throw new SAXException("Illegal state.");
        }
    }

    private void assertStateLEQ(int s) throws SAXException {
        if (this.state > s) {
            throw new SAXException("Illegal state.");
        }
    }

    private void writeStart() throws SAXException {
        try {
            this.w.write("org.xml.sax.helpers.AttributesImpl __attrs__ = new org.xml.sax.helpers.AttributesImpl();\n");
            if (!this.omitRoot) {
                this.w.write("try {\n");
                this.w.write("contentHandler.startDocument();\n");
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    private void ensureState() throws SAXException {
        if (this.state == 2) {
            try {
                this.w.write("public static void emit(org.xml.sax.ContentHandler contentHandler) throws org.xml.sax.SAXException {\n");
                this.writeStart();
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
            this.state = 3;
        } else if (this.state != 3) {
            throw new SAXException("Illegal state.");
        }
    }

    private static String unquotedCharLiteral(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\"': {
                return "\\\"";
            }
            case '\'': {
                return "\\'";
            }
            case '\\': {
                return "\\\\";
            }
        }
        if (c >= ' ' && c <= '~') {
            return "" + c;
        }
        String hex = Integer.toHexString(c);
        switch (hex.length()) {
            case 1: {
                return "\\u000" + hex;
            }
            case 2: {
                return "\\u00" + hex;
            }
            case 3: {
                return "\\u0" + hex;
            }
        }
        return "\\u" + hex;
    }

    private static String stringLiteral(CharSequence cs) {
        if (cs == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        int len = cs.length();
        for (int i = 0; i < len; ++i) {
            sb.append(SaxCompiler.unquotedCharLiteral(cs.charAt(i)));
        }
        sb.append('\"');
        return sb.toString();
    }

    private static String charArrayLiteral(CharSequence cs) {
        if (cs == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int len = cs.length();
        for (int i = 0; i < len; ++i) {
            sb.append(" '");
            sb.append(SaxCompiler.unquotedCharLiteral(cs.charAt(i)));
            sb.append("',");
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(" }");
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            XMLReader reader = factory.newSAXParser().getXMLReader();
            if (!args[0].contains(":")) {
                args[0] = "file:" + args[0];
            }
            System.err.println(args[0]);
            URL url = new URL(args[0]);
            InputSource in = new InputSource(url.openStream());
            SaxCompiler sc = new SaxCompiler(new OutputStreamWriter((OutputStream)new FileOutputStream(args[1]), "UTF-8"));
            reader.setContentHandler(sc);
            reader.parse(in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

