/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.io;

import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;

public final class Utf8PercentDecodingReader
extends Reader {
    private final Reader delegate;
    private char pending = '\u0000';

    public Utf8PercentDecodingReader(Reader delegate) {
        this.delegate = delegate;
    }

    @Override
    public int read() throws IOException {
        if (this.pending != '\u0000') {
            char rv = this.pending;
            this.pending = '\u0000';
            return rv;
        }
        int byteVal = 0;
        int codePoint = 0;
        int c = this.delegate.read();
        int trailBytes = 0;
        if (c == -1) {
            return -1;
        }
        if (c == 37) {
            byteVal = this.readHexByte();
            if (byteVal < 128) {
                return byteVal;
            }
            if ((0xE0 & byteVal) == 192) {
                trailBytes = 1;
                codePoint = byteVal & 0x1F;
            } else if ((0xF0 & byteVal) == 224) {
                trailBytes = 2;
                codePoint = byteVal & 0xF;
            } else if ((0xF8 & byteVal) == 240) {
                trailBytes = 3;
                codePoint = byteVal & 7;
            } else {
                throw new MalformedURLException("Percent escape decodes to a byte that is not a valid UTF-8 lead byte.");
            }
            for (int i = 0; i < trailBytes; ++i) {
                byteVal = this.readPercentHexByte();
                if ((0xC0 & byteVal) != 128) {
                    throw new MalformedURLException("Percent escape decodes to a byte that is not a valid UTF-8 trail byte.");
                }
                codePoint = codePoint << 6 | byteVal & 0x3F;
            }
            switch (trailBytes) {
                case 3: {
                    if (codePoint <= 65535) {
                        throw new MalformedURLException("Non-shortest form UTF-8 percent escape sequence.");
                    }
                    int rv = 55232 + (codePoint >> 10);
                    this.pending = (char)(56320 + (codePoint & 0x3FF));
                    return rv;
                }
                case 2: {
                    if (codePoint <= 2047) {
                        throw new MalformedURLException("Non-shortest form UTF-8 percent escape sequence.");
                    }
                    return codePoint;
                }
            }
            if (codePoint <= 127) {
                throw new MalformedURLException("Non-shortest form UTF-8 percent escape sequence.");
            }
            return codePoint;
        }
        return c;
    }

    private int readPercentHexByte() throws IOException {
        int c = this.delegate.read();
        if (c != 37) {
            throw new MalformedURLException("Percent-encoded trail byte missing.");
        }
        return this.readHexByte();
    }

    private int readHexByte() throws IOException {
        int c = this.delegate.read();
        if (this.isHexDigit(c)) {
            int hi = Character.getNumericValue(c) << 4;
            c = this.delegate.read();
            if (this.isHexDigit(c)) {
                return hi | Character.getNumericValue(c);
            }
            throw new MalformedURLException("Malformed percent escape.");
        }
        throw new MalformedURLException("Malformed percent escape.");
    }

    private boolean isHexDigit(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    @Override
    public void close() throws IOException {
        this.pending = '\u0000';
        this.delegate.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int i;
        for (i = 0; i < len; ++i) {
            int c = this.read();
            if (c == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            cbuf[off] = (char)c;
            ++off;
        }
        return i;
    }
}

