/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws.nodes;

import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.jaxws.actions.JaxWsCodeGenerator;
import org.netbeans.modules.maven.jaxws.nodes.OperationNode;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.text.ActiveEditorDrop;

public class OperationEditorDrop
implements ActiveEditorDrop {
    OperationNode operationNode;

    public OperationEditorDrop(OperationNode operationNode) {
        this.operationNode = operationNode;
    }

    public boolean handleTransfer(JTextComponent targetComponent) {
        Object mimeType = targetComponent.getDocument().getProperty("mimeType");
        if (mimeType != null && ("text/x-java".equals(mimeType) || "text/x-jsp".equals(mimeType))) {
            try {
                FileObject targetFo = NbEditorUtilities.getFileObject((Document)targetComponent.getDocument());
                Node clientNode = this.operationNode.getParentNode().getParentNode().getParentNode();
                JAXWSLightSupport jaxWsSupport = (JAXWSLightSupport)clientNode.getLookup().lookup(JAXWSLightSupport.class);
                if (jaxWsSupport != null) {
                    JaxWsCodeGenerator.insertMethod(targetComponent.getDocument(), targetComponent.getCaret().getDot(), this.operationNode);
                    Object[] params = new Object[]{"JAX-WS", "DRAG & DROP WS OPERATION"};
                    LogUtils.logWsAction((Object[])params);
                    return true;
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().log(ex.getLocalizedMessage());
            }
        }
        return false;
    }
}

