/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.request;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.Mergeable;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.test.web.servlet.request.ConfigurableSmartRequestBuilder;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.FlashMapManager;
import org.springframework.web.servlet.support.SessionFlashMapManager;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;
import org.springframework.web.util.UrlPathHelper;

public class MockHttpServletRequestBuilder
implements ConfigurableSmartRequestBuilder<MockHttpServletRequestBuilder>,
Mergeable {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private final String method;
    private final URI url;
    private String contextPath = "";
    private String servletPath = "";
    private String pathInfo = "";
    private Boolean secure;
    private Principal principal;
    private MockHttpSession session;
    private String characterEncoding;
    private byte[] content;
    private String contentType;
    private final MultiValueMap<String, Object> headers = new LinkedMultiValueMap();
    private final MultiValueMap<String, String> parameters = new LinkedMultiValueMap();
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final List<Locale> locales = new ArrayList<Locale>();
    private final Map<String, Object> requestAttributes = new LinkedHashMap<String, Object>();
    private final Map<String, Object> sessionAttributes = new LinkedHashMap<String, Object>();
    private final Map<String, Object> flashAttributes = new LinkedHashMap<String, Object>();
    private final List<RequestPostProcessor> postProcessors = new ArrayList<RequestPostProcessor>();

    MockHttpServletRequestBuilder(HttpMethod httpMethod, String url, Object ... vars) {
        this(httpMethod.name(), UriComponentsBuilder.fromUriString((String)url).buildAndExpand(vars).encode().toUri());
    }

    MockHttpServletRequestBuilder(HttpMethod httpMethod, URI url) {
        this(httpMethod.name(), url);
    }

    MockHttpServletRequestBuilder(String httpMethod, URI url) {
        Assert.notNull((Object)httpMethod, (String)"'httpMethod' is required");
        Assert.notNull((Object)url, (String)"'url' is required");
        this.method = httpMethod;
        this.url = url;
    }

    public MockHttpServletRequestBuilder contextPath(String contextPath) {
        if (StringUtils.hasText((String)contextPath)) {
            Assert.isTrue((boolean)contextPath.startsWith("/"), (String)"Context path must start with a '/'");
            Assert.isTrue((!contextPath.endsWith("/") ? 1 : 0) != 0, (String)"Context path must not end with a '/'");
        }
        this.contextPath = contextPath != null ? contextPath : "";
        return this;
    }

    public MockHttpServletRequestBuilder servletPath(String servletPath) {
        if (StringUtils.hasText((String)servletPath)) {
            Assert.isTrue((boolean)servletPath.startsWith("/"), (String)"Servlet path must start with a '/'");
            Assert.isTrue((!servletPath.endsWith("/") ? 1 : 0) != 0, (String)"Servlet path must not end with a '/'");
        }
        this.servletPath = servletPath != null ? servletPath : "";
        return this;
    }

    public MockHttpServletRequestBuilder pathInfo(String pathInfo) {
        if (StringUtils.hasText((String)pathInfo)) {
            Assert.isTrue((boolean)pathInfo.startsWith("/"), (String)"Path info must start with a '/'");
        }
        this.pathInfo = pathInfo;
        return this;
    }

    public MockHttpServletRequestBuilder secure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public MockHttpServletRequestBuilder characterEncoding(String encoding) {
        this.characterEncoding = encoding;
        return this;
    }

    public MockHttpServletRequestBuilder content(byte[] content) {
        this.content = content;
        return this;
    }

    public MockHttpServletRequestBuilder content(String content) {
        this.content = content.getBytes(UTF8_CHARSET);
        return this;
    }

    public MockHttpServletRequestBuilder contentType(MediaType contentType) {
        Assert.notNull((Object)contentType, (String)"'contentType' must not be null");
        this.contentType = contentType.toString();
        return this;
    }

    public MockHttpServletRequestBuilder contentType(String contentType) {
        this.contentType = MediaType.parseMediaType((String)contentType).toString();
        return this;
    }

    public MockHttpServletRequestBuilder accept(MediaType ... mediaTypes) {
        Assert.notEmpty((Object[])mediaTypes, (String)"'mediaTypes' must not be empty");
        this.headers.set((Object)"Accept", (Object)MediaType.toString(Arrays.asList(mediaTypes)));
        return this;
    }

    public MockHttpServletRequestBuilder accept(String ... mediaTypes) {
        Assert.notEmpty((Object[])mediaTypes, (String)"'mediaTypes' must not be empty");
        ArrayList<MediaType> result = new ArrayList<MediaType>(mediaTypes.length);
        for (String mediaType : mediaTypes) {
            result.add(MediaType.parseMediaType((String)mediaType));
        }
        this.headers.set((Object)"Accept", (Object)MediaType.toString(result));
        return this;
    }

    public MockHttpServletRequestBuilder header(String name, Object ... values) {
        MockHttpServletRequestBuilder.addToMultiValueMap(this.headers, name, values);
        return this;
    }

    public MockHttpServletRequestBuilder headers(HttpHeaders httpHeaders) {
        for (String name : httpHeaders.keySet()) {
            Object[] values = ObjectUtils.toObjectArray((Object)httpHeaders.get((Object)name).toArray());
            MockHttpServletRequestBuilder.addToMultiValueMap(this.headers, name, values);
        }
        return this;
    }

    public MockHttpServletRequestBuilder param(String name, String ... values) {
        MockHttpServletRequestBuilder.addToMultiValueMap(this.parameters, name, values);
        return this;
    }

    public MockHttpServletRequestBuilder params(MultiValueMap<String, String> params) {
        for (String name : params.keySet()) {
            for (String value : (List)params.get((Object)name)) {
                this.parameters.add((Object)name, (Object)value);
            }
        }
        return this;
    }

    public MockHttpServletRequestBuilder cookie(Cookie ... cookies) {
        Assert.notEmpty((Object[])cookies, (String)"'cookies' must not be empty");
        this.cookies.addAll(Arrays.asList(cookies));
        return this;
    }

    public MockHttpServletRequestBuilder locale(Locale ... locales) {
        Assert.notEmpty((Object[])locales, (String)"'locales' must not be empty");
        this.locales.addAll(Arrays.asList(locales));
        return this;
    }

    public MockHttpServletRequestBuilder locale(Locale locale) {
        this.locales.clear();
        if (locale != null) {
            this.locales.add(locale);
        }
        return this;
    }

    public MockHttpServletRequestBuilder requestAttr(String name, Object value) {
        MockHttpServletRequestBuilder.addToMap(this.requestAttributes, name, value);
        return this;
    }

    public MockHttpServletRequestBuilder sessionAttr(String name, Object value) {
        MockHttpServletRequestBuilder.addToMap(this.sessionAttributes, name, value);
        return this;
    }

    public MockHttpServletRequestBuilder sessionAttrs(Map<String, Object> sessionAttributes) {
        Assert.notEmpty(sessionAttributes, (String)"'sessionAttributes' must not be empty");
        for (String name : sessionAttributes.keySet()) {
            this.sessionAttr(name, sessionAttributes.get(name));
        }
        return this;
    }

    public MockHttpServletRequestBuilder flashAttr(String name, Object value) {
        MockHttpServletRequestBuilder.addToMap(this.flashAttributes, name, value);
        return this;
    }

    public MockHttpServletRequestBuilder flashAttrs(Map<String, Object> flashAttributes) {
        Assert.notEmpty(flashAttributes, (String)"'flashAttributes' must not be empty");
        for (String name : flashAttributes.keySet()) {
            this.flashAttr(name, flashAttributes.get(name));
        }
        return this;
    }

    public MockHttpServletRequestBuilder session(MockHttpSession session) {
        Assert.notNull((Object)session, (String)"'session' must not be null");
        this.session = session;
        return this;
    }

    public MockHttpServletRequestBuilder principal(Principal principal) {
        Assert.notNull((Object)principal, (String)"'principal' must not be null");
        this.principal = principal;
        return this;
    }

    @Override
    public MockHttpServletRequestBuilder with(RequestPostProcessor postProcessor) {
        Assert.notNull((Object)postProcessor, (String)"postProcessor is required");
        this.postProcessors.add(postProcessor);
        return this;
    }

    public boolean isMergeEnabled() {
        return true;
    }

    public Object merge(Object parent) {
        if (parent == null) {
            return this;
        }
        if (!(parent instanceof MockHttpServletRequestBuilder)) {
            throw new IllegalArgumentException("Cannot merge with [" + parent.getClass().getName() + "]");
        }
        MockHttpServletRequestBuilder parentBuilder = (MockHttpServletRequestBuilder)parent;
        if (!StringUtils.hasText((String)this.contextPath)) {
            this.contextPath = parentBuilder.contextPath;
        }
        if (!StringUtils.hasText((String)this.servletPath)) {
            this.servletPath = parentBuilder.servletPath;
        }
        if ("".equals(this.pathInfo)) {
            this.pathInfo = parentBuilder.pathInfo;
        }
        if (this.secure == null) {
            this.secure = parentBuilder.secure;
        }
        if (this.principal == null) {
            this.principal = parentBuilder.principal;
        }
        if (this.session == null) {
            this.session = parentBuilder.session;
        }
        if (this.characterEncoding == null) {
            this.characterEncoding = parentBuilder.characterEncoding;
        }
        if (this.content == null) {
            this.content = parentBuilder.content;
        }
        if (this.contentType == null) {
            this.contentType = parentBuilder.contentType;
        }
        for (String headerName : parentBuilder.headers.keySet()) {
            if (this.headers.containsKey((Object)headerName)) continue;
            this.headers.put((Object)headerName, parentBuilder.headers.get((Object)headerName));
        }
        for (String paramName : parentBuilder.parameters.keySet()) {
            if (this.parameters.containsKey((Object)paramName)) continue;
            this.parameters.put((Object)paramName, parentBuilder.parameters.get((Object)paramName));
        }
        for (Cookie cookie : parentBuilder.cookies) {
            if (this.containsCookie(cookie)) continue;
            this.cookies.add(cookie);
        }
        for (Locale locale : parentBuilder.locales) {
            if (this.locales.contains(locale)) continue;
            this.locales.add(locale);
        }
        for (String attributeName : parentBuilder.requestAttributes.keySet()) {
            if (this.requestAttributes.containsKey(attributeName)) continue;
            this.requestAttributes.put(attributeName, parentBuilder.requestAttributes.get(attributeName));
        }
        for (String attributeName : parentBuilder.sessionAttributes.keySet()) {
            if (this.sessionAttributes.containsKey(attributeName)) continue;
            this.sessionAttributes.put(attributeName, parentBuilder.sessionAttributes.get(attributeName));
        }
        for (String attributeName : parentBuilder.flashAttributes.keySet()) {
            if (this.flashAttributes.containsKey(attributeName)) continue;
            this.flashAttributes.put(attributeName, parentBuilder.flashAttributes.get(attributeName));
        }
        this.postProcessors.addAll(0, parentBuilder.postProcessors);
        return this;
    }

    private boolean containsCookie(Cookie cookie) {
        for (Cookie cookieToCheck : this.cookies) {
            if (!ObjectUtils.nullSafeEquals((Object)cookieToCheck.getName(), (Object)cookie.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public final MockHttpServletRequest buildRequest(ServletContext servletContext) {
        MediaType mediaType;
        Iterator<String> requestContentType;
        MockHttpServletRequest request = this.createServletRequest(servletContext);
        request.setAsyncSupported(true);
        request.setMethod(this.method);
        String requestUri = this.url.getRawPath();
        request.setRequestURI(requestUri);
        if (this.url.getScheme() != null) {
            request.setScheme(this.url.getScheme());
        }
        if (this.url.getHost() != null) {
            request.setServerName(this.url.getHost());
        }
        if (this.url.getPort() != -1) {
            request.setServerPort(this.url.getPort());
        }
        this.updatePathRequestProperties(request, requestUri);
        if (this.secure != null) {
            request.setSecure(this.secure);
        }
        if (this.principal != null) {
            request.setUserPrincipal(this.principal);
        }
        if (this.session != null) {
            request.setSession(this.session);
        }
        request.setCharacterEncoding(this.characterEncoding);
        request.setContent(this.content);
        request.setContentType(this.contentType);
        for (String name : this.headers.keySet()) {
            for (Object value : (List)this.headers.get((Object)name)) {
                request.addHeader(name, value);
            }
        }
        if (this.url.getRawQuery() != null) {
            request.setQueryString(this.url.getRawQuery());
        }
        this.addRequestParams(request, (MultiValueMap<String, String>)UriComponentsBuilder.fromUri((URI)this.url).build().getQueryParams());
        for (String name : this.parameters.keySet()) {
            for (Object value : (List)this.parameters.get((Object)name)) {
                request.addParameter(name, (String)value);
            }
        }
        if (this.content != null && this.content.length > 0 && (requestContentType = request.getContentType()) != null && MediaType.APPLICATION_FORM_URLENCODED.includes(mediaType = MediaType.parseMediaType((String)((Object)requestContentType)))) {
            this.addRequestParams(request, this.parseFormData(mediaType));
        }
        if (!ObjectUtils.isEmpty(this.cookies)) {
            request.setCookies(this.cookies.toArray(new Cookie[this.cookies.size()]));
        }
        if (!ObjectUtils.isEmpty(this.locales)) {
            request.setPreferredLocales(this.locales);
        }
        for (String name : this.requestAttributes.keySet()) {
            request.setAttribute(name, this.requestAttributes.get(name));
        }
        for (String name : this.sessionAttributes.keySet()) {
            request.getSession().setAttribute(name, this.sessionAttributes.get(name));
        }
        FlashMap flashMap = new FlashMap();
        flashMap.putAll(this.flashAttributes);
        FlashMapManager flashMapManager = this.getFlashMapManager(request);
        flashMapManager.saveOutputFlashMap(flashMap, (HttpServletRequest)request, (HttpServletResponse)new MockHttpServletResponse());
        return request;
    }

    protected MockHttpServletRequest createServletRequest(ServletContext servletContext) {
        return new MockHttpServletRequest(servletContext);
    }

    private void updatePathRequestProperties(MockHttpServletRequest request, String requestUri) {
        if (!requestUri.startsWith(this.contextPath)) {
            throw new IllegalArgumentException("Request URI [" + requestUri + "] does not start with context path [" + this.contextPath + "]");
        }
        request.setContextPath(this.contextPath);
        request.setServletPath(this.servletPath);
        if ("".equals(this.pathInfo)) {
            if (!requestUri.startsWith(this.contextPath + this.servletPath)) {
                throw new IllegalArgumentException("Invalid servlet path [" + this.servletPath + "] for request URI [" + requestUri + "]");
            }
            String extraPath = requestUri.substring(this.contextPath.length() + this.servletPath.length());
            this.pathInfo = StringUtils.hasText((String)extraPath) ? UrlPathHelper.defaultInstance.decodeRequestString((HttpServletRequest)request, extraPath) : null;
        }
        request.setPathInfo(this.pathInfo);
    }

    private void addRequestParams(MockHttpServletRequest request, MultiValueMap<String, String> map) {
        try {
            for (Map.Entry entry : map.entrySet()) {
                for (String value : (List)entry.getValue()) {
                    value = value != null ? UriUtils.decode((String)value, (String)"UTF-8") : null;
                    request.addParameter(UriUtils.decode((String)((String)entry.getKey()), (String)"UTF-8"), value);
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private MultiValueMap<String, String> parseFormData(final MediaType mediaType) {
        HttpInputMessage message = new HttpInputMessage(){

            public InputStream getBody() throws IOException {
                return new ByteArrayInputStream(MockHttpServletRequestBuilder.this.content);
            }

            public HttpHeaders getHeaders() {
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(mediaType);
                return headers;
            }
        };
        try {
            return new FormHttpMessageConverter().read(null, message);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to parse form data in request body", ex);
        }
    }

    private FlashMapManager getFlashMapManager(MockHttpServletRequest request) {
        SessionFlashMapManager flashMapManager = null;
        try {
            ServletContext servletContext = request.getServletContext();
            WebApplicationContext wac = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
            flashMapManager = (FlashMapManager)wac.getBean("flashMapManager", FlashMapManager.class);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        return flashMapManager != null ? flashMapManager : new SessionFlashMapManager();
    }

    @Override
    public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
        for (RequestPostProcessor postProcessor : this.postProcessors) {
            request = postProcessor.postProcessRequest(request);
            if (request != null) continue;
            throw new IllegalStateException("Post-processor [" + postProcessor.getClass().getName() + "] returned null");
        }
        return request;
    }

    private static void addToMap(Map<String, Object> map, String name, Object value) {
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        Assert.notNull((Object)value, (String)"'value' must not be null");
        map.put(name, value);
    }

    private static <T> void addToMultiValueMap(MultiValueMap<String, T> map, String name, T[] values) {
        Assert.hasLength((String)name, (String)"'name' must not be empty");
        Assert.notEmpty((Object[])values, (String)"'values' must not be empty");
        for (T value : values) {
            map.add((Object)name, value);
        }
    }
}

