/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.prefs.Preferences;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.NbGradleProjectImpl;
import org.openide.util.NbPreferences;

public class ProjectTrust {
    private static final String KEY_SALT = "secret";
    private static final String NODE_PROJECT = "projects";
    private static final String NODE_TRUST = "trust";
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static ProjectTrust instance;
    private final Key key;
    final Preferences projectTrust;
    final byte[] salt;
    private static final byte[] HEX_ARRAY;

    ProjectTrust(Preferences prefs) {
        byte[] buf = prefs.getByteArray(KEY_SALT, null);
        if (buf == null) {
            buf = new byte[16];
            new Random().nextBytes(buf);
            prefs.putByteArray(KEY_SALT, buf);
        }
        this.salt = buf;
        this.projectTrust = prefs.node(NODE_PROJECT);
        this.key = new SecretKeySpec(this.salt, HMAC_SHA256);
    }

    public boolean isTrusted(Project project) {
        String pathId = this.getPathId(project);
        String projectId = this.projectTrust.get(pathId, null);
        if (projectId == null) {
            return false;
        }
        boolean ret = false;
        Path trustFile = this.getProjectTrustFile(project);
        try {
            List<String> trust = Files.readAllLines(trustFile);
            String hash = this.hmacSha256(ProjectTrust.fromHex(projectId));
            ret = trust.size() == 1 && trust.iterator().next().equals(hash);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    public void trustProject(Project project) {
        if (!this.isTrusted(project)) {
            String pathId = this.getPathId(project);
            Path trustFile = this.getProjectTrustFile(project);
            byte[] rnd = new byte[16];
            new Random().nextBytes(rnd);
            String projectId = ProjectTrust.toHex(rnd);
            this.projectTrust.put(pathId, projectId);
            try {
                Files.createDirectories(trustFile.getParent(), new FileAttribute[0]);
                Files.write(trustFile, Collections.singletonList(this.hmacSha256(rnd)), new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void distrustProject(Project project) {
        String pathId = this.getPathId(project);
        this.projectTrust.remove(pathId);
        Path trustFile = this.getProjectTrustFile(project);
        if (trustFile != null) {
            try {
                Files.delete(trustFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static ProjectTrust getDefault() {
        if (instance == null) {
            Preferences p = NbPreferences.forModule(ProjectTrust.class).node(NODE_TRUST);
            instance = new ProjectTrust(p);
        }
        return instance;
    }

    protected Path getProjectTrustPath(Project project) {
        if (project instanceof NbGradleProjectImpl) {
            return ((NbGradleProjectImpl)project).getGradleFiles().getRootDir().toPath();
        }
        throw new IllegalArgumentException("Project shall be an NbGradleProjectImpl instance.");
    }

    protected Path getProjectTrustFilePath(Project project) {
        if (project instanceof NbGradleProjectImpl) {
            Path root = this.getProjectTrustPath(project);
            return root == null ? null : root.resolve(".gradle/nb-cache/trust");
        }
        throw new IllegalArgumentException("Project shall be an NbGradleProjectImpl instance.");
    }

    Path getProjectTrustFile(Project project) {
        String pathId = this.getPathId(project);
        Path trustFilePath = this.getProjectTrustFilePath(project);
        return trustFilePath.resolve(pathId);
    }

    String getPathId(Project project) {
        Path path = this.getProjectTrustPath(project);
        path = path.normalize().toAbsolutePath();
        return this.hmacSha256(path.toString().getBytes(StandardCharsets.UTF_8));
    }

    String hmacSha256(byte[] buf) {
        try {
            Mac hmac = Mac.getInstance(HMAC_SHA256);
            hmac.init(this.key);
            byte[] out = hmac.doFinal(buf);
            return ProjectTrust.toHex(out);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException("JDK has issues with HMAC_SHA256: " + ex.getMessage());
        }
    }

    static byte[] fromHex(String hex) {
        int len = hex.length();
        byte[] ret = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            ret[i / 2] = (byte)((Character.digit(hex.charAt(i), 16) << 4) + Character.digit(hex.charAt(i + 1), 16));
        }
        return ret;
    }

    static String toHex(byte[] b) {
        byte[] hexChars = new byte[b.length * 2];
        for (int j = 0; j < b.length; ++j) {
            int v = b[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars, StandardCharsets.UTF_8);
    }

    static {
        HEX_ARRAY = "0123456789ABCDEF".getBytes(StandardCharsets.UTF_8);
    }
}

