/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.testrunner.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsf.testrunner.plugin.CommonSettingsProvider;
import org.netbeans.modules.gsf.testrunner.plugin.GuiUtilsProvider;
import org.netbeans.modules.gsf.testrunner.ui.spi.TestCreatorConfiguration;
import org.netbeans.modules.java.testrunner.GuiUtils;
import org.netbeans.modules.java.testrunner.JavaUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Pair;

public class JavaTestCreatorConfiguration
extends TestCreatorConfiguration {
    private JCheckBox chkAbstractImpl;
    private JCheckBox chkComments;
    private JCheckBox chkContent;
    private JCheckBox chkExceptions;
    private JCheckBox chkGenerateSuites;
    private JCheckBox chkJavaDoc;
    private JCheckBox chkPackage;
    private JCheckBox chkPackagePrivateClasses;
    private JCheckBox chkProtected;
    private JCheckBox chkPublic;
    private JCheckBox chkSetUp;
    private JCheckBox chkTearDown;
    private JCheckBox chkBeforeClass;
    private JCheckBox chkAfterClass;
    private ResourceBundle bundle;
    private final FileObject[] activatedFileObjects;

    JavaTestCreatorConfiguration(FileObject[] activatedFileObjects) {
        assert (activatedFileObjects != null);
        this.activatedFileObjects = activatedFileObjects;
    }

    public boolean canHandleProject(@NonNull String framework) {
        return framework.startsWith("JUnit") || "TestNG".equals(framework);
    }

    public JTextComponent getMessagePanel(TestCreatorConfiguration.Context context) {
        Color color = UIManager.getColor("nb.errorForeground");
        if (color == null) {
            color = new Color(89, 79, 191);
        }
        return GuiUtils.createMultilineLabel((String)"", (Color)color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getConfigurationPanel(TestCreatorConfiguration.Context context) {
        JPanel jpCodeGen;
        this.initBundle();
        try {
            Iterator iterator;
            GuiUtilsProvider provider;
            Iterator iterator2;
            String[] chkBoxIDs = new String[14];
            Collection providers = Lookup.getDefault().lookupAll(GuiUtilsProvider.class);
            if (context.isMultipleClasses()) {
                iterator2 = providers.iterator();
                if (iterator2.hasNext()) {
                    provider = (GuiUtilsProvider)iterator2.next();
                    chkBoxIDs = new String[]{provider.getCheckboxText("CHK_PUBLIC"), provider.getCheckboxText("CHK_PROTECTED"), provider.getCheckboxText("CHK_PACKAGE"), provider.getCheckboxText("CHK_PACKAGE_PRIVATE_CLASSES"), provider.getCheckboxText("CHK_ABSTRACT_CLASSES"), provider.getCheckboxText("CHK_EXCEPTION_CLASSES"), provider.getCheckboxText("CHK_SUITES"), provider.getCheckboxText("CHK_SETUP"), provider.getCheckboxText("CHK_TEARDOWN"), provider.getCheckboxText("CHK_BEFORE_CLASS"), provider.getCheckboxText("CHK_AFTER_CLASS"), provider.getCheckboxText("CHK_METHOD_BODIES"), provider.getCheckboxText("CHK_JAVADOC"), provider.getCheckboxText("CHK_HINTS")};
                }
            } else {
                iterator2 = providers.iterator();
                if (iterator2.hasNext()) {
                    provider = (GuiUtilsProvider)iterator2.next();
                    chkBoxIDs = new String[]{provider.getCheckboxText("CHK_PUBLIC"), provider.getCheckboxText("CHK_PROTECTED"), provider.getCheckboxText("CHK_PACKAGE"), null, null, null, null, provider.getCheckboxText("CHK_SETUP"), provider.getCheckboxText("CHK_TEARDOWN"), provider.getCheckboxText("CHK_BEFORE_CLASS"), provider.getCheckboxText("CHK_AFTER_CLASS"), provider.getCheckboxText("CHK_METHOD_BODIES"), provider.getCheckboxText("CHK_JAVADOC"), provider.getCheckboxText("CHK_HINTS")};
                }
            }
            JCheckBox[] chkBoxes = new JCheckBox[chkBoxIDs.length];
            iterator2 = providers.iterator();
            if (iterator2.hasNext()) {
                provider = (GuiUtilsProvider)iterator2.next();
                chkBoxes = provider.createCheckBoxes(chkBoxIDs);
            }
            int i = 0;
            this.chkPublic = chkBoxes[i++];
            this.chkProtected = chkBoxes[i++];
            this.chkPackage = chkBoxes[i++];
            this.chkPackagePrivateClasses = chkBoxes[i++];
            this.chkAbstractImpl = chkBoxes[i++];
            this.chkExceptions = chkBoxes[i++];
            this.chkGenerateSuites = chkBoxes[i++];
            this.chkSetUp = chkBoxes[i++];
            this.chkTearDown = chkBoxes[i++];
            this.chkBeforeClass = chkBoxes[i++];
            this.chkAfterClass = chkBoxes[i++];
            this.chkContent = chkBoxes[i++];
            this.chkJavaDoc = chkBoxes[i++];
            this.chkComments = chkBoxes[i++];
            JComponent methodAccessLevels = null;
            Iterator iterator3 = providers.iterator();
            if (iterator3.hasNext()) {
                GuiUtilsProvider provider2 = (GuiUtilsProvider)iterator3.next();
                methodAccessLevels = provider2.createChkBoxGroup(this.bundle.getString("CommonTestsCfgOfCreate.groupAccessLevels"), new JCheckBox[]{this.chkPublic, this.chkProtected, this.chkPackage});
            }
            JComponent classTypes = null;
            JComponent optionalClasses = null;
            if (context.isMultipleClasses() && (iterator = providers.iterator()).hasNext()) {
                GuiUtilsProvider provider3 = (GuiUtilsProvider)iterator.next();
                classTypes = provider3.createChkBoxGroup(this.bundle.getString("CommonTestsCfgOfCreate.groupClassTypes"), new JCheckBox[]{this.chkPackagePrivateClasses, this.chkAbstractImpl, this.chkExceptions});
                optionalClasses = provider3.createChkBoxGroup(this.bundle.getString("CommonTestsCfgOfCreate.groupOptClasses"), new JCheckBox[]{this.chkGenerateSuites});
            }
            JComponent optionalCode = null;
            JComponent optionalComments = null;
            Iterator iterator4 = providers.iterator();
            if (iterator4.hasNext()) {
                GuiUtilsProvider provider4 = (GuiUtilsProvider)iterator4.next();
                optionalCode = provider4.createChkBoxGroup(this.bundle.getString("CommonTestsCfgOfCreate.groupOptCode"), new JCheckBox[]{this.chkSetUp, this.chkTearDown, this.chkBeforeClass, this.chkAfterClass, this.chkContent});
                optionalComments = provider4.createChkBoxGroup(this.bundle.getString("CommonTestsCfgOfCreate.groupOptComments"), new JCheckBox[]{this.chkJavaDoc, this.chkComments});
            }
            Box leftColumn = Box.createVerticalBox();
            leftColumn.add(methodAccessLevels);
            if (context.isMultipleClasses()) {
                leftColumn.add(Box.createVerticalStrut(11));
                leftColumn.add(classTypes);
            } else {
                leftColumn.add(Box.createVerticalStrut(0));
            }
            leftColumn.add(Box.createVerticalGlue());
            Box rightColumn = Box.createVerticalBox();
            if (context.isMultipleClasses()) {
                rightColumn.add(optionalClasses);
                rightColumn.add(Box.createVerticalStrut(11));
            }
            rightColumn.add(optionalCode);
            rightColumn.add(Box.createVerticalStrut(11));
            rightColumn.add(optionalComments);
            rightColumn.add(Box.createVerticalGlue());
            jpCodeGen = new JPanel();
            jpCodeGen.setLayout(new BoxLayout(jpCodeGen, 0));
            jpCodeGen.add(leftColumn);
            jpCodeGen.add(Box.createHorizontalStrut(24));
            jpCodeGen.add(rightColumn);
            JavaTestCreatorConfiguration.addTitledBorder(jpCodeGen, new Insets(12, 12, 11, 12), this.bundle.getString("CommonTestsCfgOfCreate.jpCodeGen.title"));
            methodAccessLevels.setAlignmentX(0.0f);
            if (context.isMultipleClasses()) {
                classTypes.setAlignmentX(0.0f);
                optionalClasses.setAlignmentX(0.0f);
            }
            optionalCode.setAlignmentX(0.0f);
            optionalComments.setAlignmentX(0.0f);
            this.initializeCheckBoxStates(context.isMultipleClasses());
            this.setupUserInteraction(context.getCallback());
        }
        finally {
            this.unlinkBundle();
        }
        return jpCodeGen;
    }

    private void setupUserInteraction(TestCreatorConfiguration.Callback callback) {
        CheckBoxListener listener = new CheckBoxListener(callback);
        this.chkPublic.addItemListener(listener);
        this.chkProtected.addItemListener(listener);
        this.chkPackage.addItemListener(listener);
    }

    public void persistConfigurationPanel(TestCreatorConfiguration.Context context) {
        this.rememberCheckBoxStates(context.isMultipleClasses());
    }

    private void initBundle() {
        block0: {
            Collection providers = Lookup.getDefault().lookupAll(GuiUtilsProvider.class);
            Iterator iterator = providers.iterator();
            if (!iterator.hasNext()) break block0;
            GuiUtilsProvider provider = (GuiUtilsProvider)iterator.next();
            this.bundle = provider.getBundle();
        }
    }

    private void unlinkBundle() {
        this.bundle = null;
    }

    private static void addTitledBorder(JComponent component, Insets insets, String title) {
        Border insideBorder = BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
        TitledBorder outsideBorder = new TitledBorder(BorderFactory.createEtchedBorder(), title);
        component.setBorder(new CompoundBorder(outsideBorder, insideBorder));
    }

    private void initializeCheckBoxStates(boolean multipleClasses) {
        boolean chkPublicB = true;
        boolean chkProtectedB = true;
        boolean chkPackageB = true;
        boolean chkCommentsB = true;
        boolean chkContentB = true;
        boolean chkJavaDocB = true;
        boolean chkGenerateSuitesB = true;
        boolean chkPackagePrivateClassesB = true;
        boolean chkAbstractImplB = true;
        boolean chkExceptionsB = true;
        boolean chkSetUpB = true;
        boolean chkTearDownB = true;
        boolean chkBeforeClassB = true;
        boolean chkAfterClassB = true;
        Collection providers = Lookup.getDefault().lookupAll(CommonSettingsProvider.class);
        Iterator iterator = providers.iterator();
        if (iterator.hasNext()) {
            CommonSettingsProvider provider = (CommonSettingsProvider)iterator.next();
            chkPublicB = provider.isMembersPublic();
            chkProtectedB = provider.isMembersProtected();
            chkPackageB = provider.isMembersPackage();
            chkCommentsB = provider.isBodyComments();
            chkContentB = provider.isBodyContent();
            chkJavaDocB = provider.isJavaDoc();
            chkGenerateSuitesB = provider.isGenerateSuiteClasses();
            chkPackagePrivateClassesB = provider.isIncludePackagePrivateClasses();
            chkAbstractImplB = provider.isGenerateAbstractImpl();
            chkExceptionsB = provider.isGenerateExceptionClasses();
            chkSetUpB = provider.isGenerateSetUp();
            chkTearDownB = provider.isGenerateTearDown();
            chkBeforeClassB = provider.isGenerateClassSetUp();
            chkAfterClassB = provider.isGenerateClassTearDown();
        }
        this.chkPublic.setSelected(chkPublicB);
        this.chkProtected.setSelected(chkProtectedB);
        this.chkPackage.setSelected(chkPackageB);
        this.chkComments.setSelected(chkCommentsB);
        this.chkContent.setSelected(chkContentB);
        this.chkJavaDoc.setSelected(chkJavaDocB);
        if (multipleClasses) {
            this.chkGenerateSuites.setSelected(chkGenerateSuitesB);
            this.chkPackagePrivateClasses.setSelected(chkPackagePrivateClassesB);
            this.chkAbstractImpl.setSelected(chkAbstractImplB);
            this.chkExceptions.setSelected(chkExceptionsB);
        }
        this.chkSetUp.setSelected(chkSetUpB);
        this.chkTearDown.setSelected(chkTearDownB);
        this.chkBeforeClass.setSelected(chkBeforeClassB);
        this.chkAfterClass.setSelected(chkAfterClassB);
    }

    private void rememberCheckBoxStates(boolean multipleClasses) {
        block1: {
            Collection providers = Lookup.getDefault().lookupAll(CommonSettingsProvider.class);
            Iterator iterator = providers.iterator();
            if (!iterator.hasNext()) break block1;
            CommonSettingsProvider provider = (CommonSettingsProvider)iterator.next();
            provider.setMembersPublic(this.chkPublic.isSelected());
            provider.setMembersProtected(this.chkProtected.isSelected());
            provider.setMembersPackage(this.chkPackage.isSelected());
            provider.setBodyComments(this.chkComments.isSelected());
            provider.setBodyContent(this.chkContent.isSelected());
            provider.setJavaDoc(this.chkJavaDoc.isSelected());
            if (multipleClasses) {
                provider.setGenerateSuiteClasses(this.chkGenerateSuites.isSelected());
                provider.setIncludePackagePrivateClasses(this.chkPackagePrivateClasses.isSelected());
                provider.setGenerateAbstractImpl(this.chkAbstractImpl.isSelected());
                provider.setGenerateExceptionClasses(this.chkExceptions.isSelected());
            }
            provider.setGenerateSetUp(this.chkSetUp.isSelected());
            provider.setGenerateTearDown(this.chkTearDown.isSelected());
            provider.setGenerateClassSetUp(this.chkBeforeClass.isSelected());
            provider.setGenerateClassTearDown(this.chkAfterClass.isSelected());
        }
    }

    public Pair<String, String> getSourceAndTestClassNames(FileObject fileObj, boolean isTestNG, boolean isSelenium) {
        String[] sourceAndTestClassNames = JavaUtils.getSourceAndTestClassNames((FileObject)fileObj, (boolean)isTestNG, (boolean)isSelenium);
        return Pair.of((Object)sourceAndTestClassNames[0], (Object)sourceAndTestClassNames[1]);
    }

    public Object[] getTestSourceRoots(Collection<SourceGroup> createdSourceRoots, FileObject fo) {
        return JavaUtils.getTestSourceRoots(createdSourceRoots, (FileObject)fo);
    }

    private final class CheckBoxListener
    implements ItemListener {
        private final TestCreatorConfiguration.Callback callback;

        public CheckBoxListener(TestCreatorConfiguration.Callback callback) {
            this.callback = callback;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            assert (source == JavaTestCreatorConfiguration.this.chkPublic || source == JavaTestCreatorConfiguration.this.chkProtected || source == JavaTestCreatorConfiguration.this.chkPackage);
            this.callback.checkAcceptability();
        }
    }
}

