/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.frames.models;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.frames.TruffleStackFrame;
import org.netbeans.modules.debugger.jpda.truffle.frames.models.Bundle;
import org.netbeans.modules.debugger.jpda.truffle.options.TruffleOptions;
import org.netbeans.modules.debugger.jpda.truffle.source.SourcePosition;
import org.netbeans.modules.debugger.jpda.util.WeakCacheMap;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class DebuggingTruffleActionsProvider
implements NodeActionsProviderFilter {
    private final Action MAKE_CURRENT_ACTION;
    private final Action GO_TO_SOURCE_ACTION;
    private final Action POP_TO_HERE_ACTION;
    private final Action SHOW_INTERNAL_ACTION;
    private final Action HIDE_INTERNAL_ACTION;
    private final Action SHOW_HOST_ACTION;
    private final Action HIDE_HOST_ACTION;
    private final JPDADebuggerImpl debugger;
    private final RequestProcessor requestProcessor;
    private static final Map<DebuggingView.DVThread, Boolean> SHOWING_ALL_HOST_FRAMES = Collections.synchronizedMap(new WeakHashMap());
    private static final PropertyChangeSupport SHOWING_ALL_HOST_FRAMES_CHANGE = new PropertyChangeSupport(new Object());

    public DebuggingTruffleActionsProvider(ContextProvider lookupProvider) {
        this.debugger = (JPDADebuggerImpl)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.requestProcessor = (RequestProcessor)lookupProvider.lookupFirst(null, RequestProcessor.class);
        this.MAKE_CURRENT_ACTION = this.createMAKE_CURRENT_ACTION(this.requestProcessor);
        this.GO_TO_SOURCE_ACTION = DebuggingTruffleActionsProvider.createGO_TO_SOURCE_ACTION(this.requestProcessor);
        this.POP_TO_HERE_ACTION = this.createPOP_TO_HERE_ACTION(this.requestProcessor);
        this.SHOW_INTERNAL_ACTION = DebuggingTruffleActionsProvider.createSHOW_INTERNAL_ACTION();
        this.HIDE_INTERNAL_ACTION = DebuggingTruffleActionsProvider.createHIDE_INTERNAL_ACTION();
        this.SHOW_HOST_ACTION = DebuggingTruffleActionsProvider.createSHOW_HOST_ACTION();
        this.HIDE_HOST_ACTION = DebuggingTruffleActionsProvider.createHIDE_HOST_ACTION();
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (node instanceof TruffleStackFrame) {
            this.requestProcessor.post(() -> {
                TruffleStackFrame f = (TruffleStackFrame)node;
                JPDAThread thread = f.getThread();
                this.debugger.setCurrentThread(thread);
                CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentPCInfo(thread);
                if (currentPCInfo != null) {
                    currentPCInfo.setSelectedStackFrame(f);
                    DebuggingTruffleActionsProvider.goToSource(f);
                }
            });
        } else if (node instanceof CallStackFrame) {
            CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentPCInfo(((CallStackFrame)node).getThread());
            if (currentPCInfo != null) {
                currentPCInfo.setSelectedStackFrame(null);
            }
            original.performDefaultAction(node);
        }
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (node instanceof TruffleStackFrame) {
            return new Action[]{this.MAKE_CURRENT_ACTION, this.POP_TO_HERE_ACTION, this.GO_TO_SOURCE_ACTION};
        }
        Action[] actions = original.getActions(node);
        if (node instanceof DebuggingView.DVThread && DebuggingTruffleActionsProvider.hasGuestInfo(node)) {
            Action showAction = !DebuggingTruffleActionsProvider.isShowAllHostFrames((DebuggingView.DVThread)node) ? this.SHOW_HOST_ACTION : this.HIDE_HOST_ACTION;
            int pos = actions.length;
            actions = Arrays.copyOf(actions, pos + 2);
            actions[pos++] = null;
            actions[pos] = showAction;
        }
        return actions;
    }

    private static boolean hasGuestInfo(Object node) {
        JPDAThread thread = (JPDAThread)((WeakCacheMap.KeyedValue)node).getKey();
        return TruffleAccess.getCurrentPCInfo(thread) != null;
    }

    static boolean isShowAllHostFrames(DebuggingView.DVThread thread) {
        Boolean is = SHOWING_ALL_HOST_FRAMES.get(thread);
        return Boolean.TRUE.equals(is);
    }

    static void onShowAllHostFramesChange(PropertyChangeListener listener) {
        SHOWING_ALL_HOST_FRAMES_CHANGE.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)listener, (Object)SHOWING_ALL_HOST_FRAMES_CHANGE));
    }

    private static void goToSource(final TruffleStackFrame f) {
        final SourcePosition sourcePosition = f.getSourcePosition();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (sourcePosition.getSource().getHostMethodName() == null) {
                    EditorContextBridge.getContext().showSource(sourcePosition.getSource().getUrl().toExternalForm(), sourcePosition.getStartLine(), (Object)f.getDebugger());
                } else {
                    String path = sourcePosition.getSource().getPath();
                    if (path != null) {
                        path = path.replace(File.separatorChar, '/');
                        String url = ((JPDADebuggerImpl)f.getDebugger()).getEngineContext().getURL(path, true);
                        EditorContextBridge.getContext().showSource(url, sourcePosition.getStartLine(), (Object)f.getDebugger());
                    }
                }
            }
        });
    }

    private Action createMAKE_CURRENT_ACTION(RequestProcessor requestProcessor) {
        return Models.createAction((String)Bundle.CTL_StackFrameAction_MakeCurrent_Label(), (Models.ActionPerformer)new LazyActionPerformer(requestProcessor){

            @Override
            public boolean isEnabled(Object node) {
                if (node instanceof TruffleStackFrame) {
                    TruffleStackFrame f = (TruffleStackFrame)node;
                    JPDAThread thread = f.getThread();
                    if (thread != DebuggingTruffleActionsProvider.this.debugger.getCurrentThread()) {
                        return true;
                    }
                    CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentPCInfo(f.getThread());
                    if (currentPCInfo != null) {
                        return f != currentPCInfo.getSelectedStackFrame();
                    }
                }
                return false;
            }

            @Override
            public void run(Object[] nodes) {
                if (nodes.length == 0) {
                    return;
                }
                if (nodes[0] instanceof TruffleStackFrame) {
                    TruffleStackFrame f = (TruffleStackFrame)nodes[0];
                    JPDAThread thread = f.getThread();
                    DebuggingTruffleActionsProvider.this.debugger.setCurrentThread(thread);
                    CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentPCInfo(thread);
                    if (currentPCInfo != null) {
                        currentPCInfo.setSelectedStackFrame(f);
                    }
                    DebuggingTruffleActionsProvider.goToSource(f);
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    static final Action createGO_TO_SOURCE_ACTION(final RequestProcessor requestProcessor) {
        return Models.createAction((String)Bundle.CTL_StackFrameAction_GoToSource_Label(), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return node instanceof TruffleStackFrame;
            }

            public void perform(final Object[] nodes) {
                requestProcessor.post(new Runnable(){

                    @Override
                    public void run() {
                        DebuggingTruffleActionsProvider.goToSource((TruffleStackFrame)nodes[0]);
                    }
                });
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    static final Action createSHOW_INTERNAL_ACTION() {
        return Models.createAction((String)Bundle.CTL_StackFrameAction_ShowInternal_Label(), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return node instanceof DebuggingView.DVThread;
            }

            public void perform(Object[] nodes) {
                TruffleOptions.setLanguageDeveloperMode(true);
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    static final Action createHIDE_INTERNAL_ACTION() {
        return Models.createAction((String)Bundle.CTL_StackFrameAction_HideInternal_Label(), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return node instanceof DebuggingView.DVThread;
            }

            public void perform(Object[] nodes) {
                TruffleOptions.setLanguageDeveloperMode(false);
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    static final Action createSHOW_HOST_ACTION() {
        return Models.createAction((String)Bundle.CTL_StackFrameAction_ShowHost_Label(), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                if (!(node instanceof DebuggingView.DVThread)) {
                    return false;
                }
                return !DebuggingTruffleActionsProvider.isShowAllHostFrames((DebuggingView.DVThread)node);
            }

            public void perform(Object[] nodes) {
                for (Object node : nodes) {
                    SHOWING_ALL_HOST_FRAMES.put((DebuggingView.DVThread)node, Boolean.TRUE);
                }
                SHOWING_ALL_HOST_FRAMES_CHANGE.firePropertyChange("allHostFrames", false, true);
            }
        }, (int)Models.MULTISELECTION_TYPE_ALL);
    }

    static final Action createHIDE_HOST_ACTION() {
        return Models.createAction((String)Bundle.CTL_StackFrameAction_HideHost_Label(), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                if (!(node instanceof DebuggingView.DVThread)) {
                    return false;
                }
                return DebuggingTruffleActionsProvider.isShowAllHostFrames((DebuggingView.DVThread)node);
            }

            public void perform(Object[] nodes) {
                for (Object node : nodes) {
                    SHOWING_ALL_HOST_FRAMES.remove((DebuggingView.DVThread)node);
                }
                SHOWING_ALL_HOST_FRAMES_CHANGE.firePropertyChange("allHostFrames", true, false);
            }
        }, (int)Models.MULTISELECTION_TYPE_ALL);
    }

    private Action createPOP_TO_HERE_ACTION(final RequestProcessor requestProcessor) {
        return Models.createAction((String)Bundle.CTL_StackFrameAction_PopToHere_Label(), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return node instanceof TruffleStackFrame;
            }

            public void perform(final Object[] nodes) {
                requestProcessor.post(new Runnable(){

                    @Override
                    public void run() {
                        ((TruffleStackFrame)nodes[0]).popToHere();
                    }
                });
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    static abstract class LazyActionPerformer
    implements Models.ActionPerformer {
        private final RequestProcessor rp;

        public LazyActionPerformer(RequestProcessor rp) {
            this.rp = rp;
        }

        public abstract boolean isEnabled(Object var1);

        public final void perform(final Object[] nodes) {
            this.rp.post(new Runnable(){

                @Override
                public void run() {
                    this.run(nodes);
                }
            });
        }

        public abstract void run(Object[] var1);
    }
}

