/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactContextProducer;
import org.apache.maven.index.Scanner;
import org.apache.maven.index.ScanningRequest;
import org.apache.maven.index.ScanningResult;
import org.apache.maven.index.context.IndexingContext;

public class FastScanner
implements Scanner {
    private final ArtifactContextProducer artifactContextProducer;
    private static final Logger LOG = Logger.getLogger(FastScanner.class.getName());

    @Inject
    public FastScanner(ArtifactContextProducer artifactContextProducer) {
        this.artifactContextProducer = artifactContextProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScanningResult scan(ScanningRequest request) {
        request.getArtifactScanningListener().scanningStarted(request.getIndexingContext());
        ScanningResult result = new ScanningResult(request);
        try {
            this.scanDirectory(request.getStartingDirectory().toPath(), request);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Scanning failed", ex);
        }
        finally {
            request.getArtifactScanningListener().scanningFinished(request.getIndexingContext(), result);
        }
        return result;
    }

    private void scanDirectory(Path dir, final ScanningRequest request) throws IOException {
        if (dir == null) {
            return;
        }
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new FileVisitor<Path>(){
            private final Set<Path> poms = new HashSet<Path>();
            private final Set<Path> artifacts = new HashSet<Path>();

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                this.poms.clear();
                this.artifacts.clear();
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String nm = file.getFileName().toString();
                if (nm.endsWith(".pom")) {
                    this.poms.add(file);
                } else if (nm.endsWith(".jar") || nm.endsWith(".nbm") || nm.endsWith(".txt") || nm.endsWith(".xml")) {
                    this.artifacts.add(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                LOG.log(Level.INFO, "Visit failed: " + file, exc);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                try {
                    if (!this.artifacts.isEmpty()) {
                        for (Path jar : this.artifacts) {
                            FastScanner.this.processFile(jar.toFile(), request);
                        }
                    }
                    if (!this.poms.isEmpty()) {
                        for (Path pom : this.poms) {
                            FastScanner.this.processFile(pom.toFile(), request);
                        }
                    }
                }
                catch (Exception e) {
                    LOG.log(Level.INFO, "Exception indexing " + this.artifacts + ", " + this.poms, e);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void processFile(File file, ScanningRequest request) {
        IndexingContext context = request.getIndexingContext();
        ArtifactContext ac = this.artifactContextProducer.getArtifactContext(context, file);
        if (ac != null) {
            request.getArtifactScanningListener().artifactDiscovered(ac);
        }
    }
}

