/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.awt.Image;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.nodes.RestServiceChildFactory;
import org.netbeans.modules.websvc.rest.nodes.TestRestServicesAction;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class RestServicesNode
extends AbstractNode {
    private static final Image REST_SERVICES_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/rest/nodes/resources/restservices.png", (boolean)true);
    static Icon folderIconCache;
    static Icon openedFolderIconCache;

    public RestServicesNode(Project project, RestSupport restSupport) {
        super(Children.create((ChildFactory)new RestServiceChildFactory(project, restSupport), (boolean)true), RestServicesNode.createLookup(project));
        this.setDisplayName(NbBundle.getBundle(RestServicesNode.class).getString("LBL_RestServices"));
    }

    public Image getIcon(int type) {
        return this.computeIcon(false, type);
    }

    public Image getOpenedIcon(int type) {
        return this.computeIcon(true, type);
    }

    static synchronized Icon getFolderIcon(boolean opened) {
        if (openedFolderIconCache == null) {
            Node n = DataFolder.findFolder((FileObject)FileUtil.getConfigRoot()).getNodeDelegate();
            openedFolderIconCache = new ImageIcon(n.getOpenedIcon(1));
            folderIconCache = new ImageIcon(n.getIcon(1));
        }
        if (opened) {
            return openedFolderIconCache;
        }
        return folderIconCache;
    }

    private Image computeIcon(boolean opened, int type) {
        Icon icon = RestServicesNode.getFolderIcon(opened);
        Image image = ((ImageIcon)icon).getImage();
        image = ImageUtilities.mergeImages((Image)image, (Image)REST_SERVICES_BADGE, (int)7, (int)7);
        return image;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{CommonProjectActions.newFileAction(), SystemAction.get(TestRestServicesAction.class), null, SystemAction.get(FindAction.class), null, SystemAction.get(PasteAction.class), null, SystemAction.get(PropertiesAction.class)};
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private static Lookup createLookup(Project project) {
        return Lookups.fixed((Object[])new Object[]{project, new PrivilegedTemplates(){

            public String[] getPrivilegedTemplates() {
                return new String[]{"Templates/WebServices/RestServicesFromEntities", "Templates/WebServices/RestServicesFromPatterns", "Templates/WebServices/RestServicesFromDatabase"};
            }
        }});
    }
}

