/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.hints.pom.MoveToDependencyManagementPanel;
import org.netbeans.modules.maven.hints.pom.OverrideDependencyManagementError;
import org.netbeans.modules.maven.hints.pom.PomModelUtils;
import org.netbeans.modules.maven.hints.pom.spi.Configuration;
import org.netbeans.modules.maven.hints.pom.spi.SelectionPOMFixProvider;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.DependencyManagement;
import org.netbeans.modules.maven.model.pom.ModelList;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MoveToDependencyManagementHint
implements SelectionPOMFixProvider {
    private static final Logger LOG = Logger.getLogger(MoveToDependencyManagementHint.class.getName());
    private final Configuration configuration = new Configuration("MoveToDependencyManagementHint", NbBundle.getMessage(MoveToDependencyManagementHint.class, (String)"TIT_MoveToDependencyManagementHint"), NbBundle.getMessage(MoveToDependencyManagementHint.class, (String)"DESC_MoveToDependencyManagementHint"), true, Configuration.HintSeverity.WARNING);

    @Override
    public List<ErrorDescription> getErrorsForDocument(POMModel model, Project prj, int selectionStart, int selectionEnd, int caretPosition) {
        ArrayList<ErrorDescription> err = new ArrayList<ErrorDescription>();
        if (prj == null) {
            return err;
        }
        DocumentComponent comp1 = model.findComponent(selectionStart);
        DocumentComponent comp2 = model.findComponent(selectionEnd);
        if (comp1 == null || comp2 == null) {
            return err;
        }
        List<Dependency> deps = MoveToDependencyManagementHint.getSelectedDependencies(model, selectionStart, selectionEnd);
        if (deps != null && !deps.isEmpty()) {
            try {
                Line line = NbEditorUtilities.getLine((Document)model.getBaseDocument(), (int)caretPosition, (boolean)false);
                err.add(ErrorDescriptionFactory.createErrorDescription((Severity)Severity.HINT, (String)NbBundle.getMessage(MoveToDependencyManagementHint.class, (String)"TEXT_MoveToDependencyManagementHint"), Collections.singletonList(new MoveFix(selectionStart, selectionEnd, model, prj)), (Document)model.getBaseDocument(), (int)(line.getLineNumber() + 1)));
            }
            catch (IndexOutOfBoundsException ioob) {
                LOG.log(Level.FINE, "document changed", ioob);
            }
        }
        return err;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    private static List<Dependency> getSelectedDependencies(POMModel mdl, int start, int end) {
        DocumentComponent comp1 = mdl.findComponent(start);
        POMComponent pc = MoveToDependencyManagementHint.findEnclosing(comp1);
        List dps = null;
        if (pc instanceof org.netbeans.modules.maven.model.pom.Project) {
            org.netbeans.modules.maven.model.pom.Project modprj = (org.netbeans.modules.maven.model.pom.Project)pc;
            dps = modprj.getDependencies();
        } else if (pc instanceof Profile) {
            Profile prf = (Profile)pc;
            dps = prf.getDependencies();
        }
        if (dps == null) {
            return null;
        }
        return MoveToDependencyManagementHint.extractSelectedDeps(dps, start, end);
    }

    private static void openParent(final int offset, final POMModel model) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Line line = NbEditorUtilities.getLine((Document)model.getBaseDocument(), (int)offset, (boolean)false);
                    line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                }
                catch (IndexOutOfBoundsException e) {
                    LOG.log(Level.FINE, "document changed", e);
                }
            }
        });
    }

    private static List<Dependency> extractSelectedDeps(List<Dependency> dps, int selectionStart, int selectionEnd) {
        ArrayList<Dependency> toRet = new ArrayList<Dependency>();
        for (Dependency d : dps) {
            int pos = d.findPosition();
            int endPos = d.findEndPosition();
            if (pos < selectionStart || endPos > selectionEnd || d.getVersion() == null) continue;
            toRet.add(d);
        }
        return toRet;
    }

    private static POMComponent findEnclosing(DocumentComponent comp1) {
        if (comp1 instanceof ModelList) {
            return (POMComponent)comp1.getParent();
        }
        Component parent = comp1.getParent();
        if (parent == null || !(parent instanceof POMComponent)) {
            return null;
        }
        return MoveToDependencyManagementHint.findEnclosing((DocumentComponent)parent);
    }

    private static class MoveFix
    implements Fix {
        private final POMModel mdl;
        private final int start;
        private final int end;
        private final Project project;

        MoveFix(int selectionStart, int selectionEnd, POMModel model, Project prj) {
            this.mdl = model;
            this.start = selectionStart;
            this.end = selectionEnd;
            this.project = prj;
        }

        public String getText() {
            return NbBundle.getMessage(OverrideDependencyManagementError.class, (String)"TIT_MoveToDependencyManagementHint");
        }

        public ChangeInfo implement() throws Exception {
            ChangeInfo info = new ChangeInfo();
            if (!this.mdl.getState().equals((Object)Model.State.VALID)) {
                return info;
            }
            PomModelUtils.implementInTransaction((Model)this.mdl, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    File fl = (File)MoveFix.this.mdl.getModelSource().getLookup().lookup(File.class);
                    if (fl == null) {
                        FileObject obj = (FileObject)MoveFix.this.mdl.getModelSource().getLookup().lookup(FileObject.class);
                        fl = FileUtil.toFile((FileObject)obj);
                    }
                    assert (fl != null);
                    List deps = MoveToDependencyManagementHint.getSelectedDependencies(MoveFix.this.mdl, MoveFix.this.start, MoveFix.this.end);
                    if (deps == null || deps.isEmpty()) {
                        return;
                    }
                    MoveToDependencyManagementPanel pnl = this.createPanel(fl);
                    DialogDescriptor dd = new DialogDescriptor((Object)pnl, NbBundle.getMessage(MoveToDependencyManagementHint.class, (String)"TIT_MoveDepMan"));
                    Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                    if (ret == DialogDescriptor.OK_OPTION) {
                        POMModel depMdl;
                        FileObject fo = pnl.getSelectedPomFile();
                        if (fo == null) {
                            return;
                        }
                        FileObject current = (FileObject)MoveFix.this.mdl.getModelSource().getLookup().lookup(FileObject.class);
                        if (fo.equals(current)) {
                            depMdl = MoveFix.this.mdl;
                        } else {
                            ModelSource depSource = Utilities.createModelSource((FileObject)fo);
                            depMdl = POMModelFactory.getDefault().getModel(depSource);
                        }
                        int oldpos = -1;
                        try {
                            DependencyManagement dm;
                            if (depMdl != MoveFix.this.mdl) {
                                depMdl.startTransaction();
                            }
                            if ((dm = depMdl.getProject().getDependencyManagement()) == null) {
                                dm = depMdl.getFactory().createDependencyManagement();
                                depMdl.getProject().setDependencyManagement(dm);
                            }
                            for (Dependency d : deps) {
                                Dependency old = dm.findDependencyById(d.getGroupId(), d.getArtifactId(), d.getScope());
                                if (old == null) {
                                    old = depMdl.getFactory().createDependency();
                                    old.setGroupId(d.getGroupId());
                                    old.setArtifactId(d.getArtifactId());
                                    old.setVersion(d.getVersion());
                                    old.setClassifier(d.getClassifier());
                                    old.setType(d.getType());
                                    old.setScope(d.getScope());
                                    dm.addDependency(old);
                                } else {
                                    old.setVersion(d.getVersion());
                                }
                                oldpos = old.findPosition();
                            }
                        }
                        finally {
                            if (depMdl != MoveFix.this.mdl) {
                                try {
                                    depMdl.endTransaction();
                                }
                                catch (IllegalStateException ex) {
                                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(PomModelUtils.class, (String)"ERR_UpdatePomModel", (Object)Exceptions.findLocalizedMessage((Throwable)ex)));
                                }
                            }
                        }
                        for (Dependency d : deps) {
                            d.setVersion(null);
                        }
                        if (oldpos != -1) {
                            MoveToDependencyManagementHint.openParent(oldpos, depMdl);
                        }
                    }
                }

                private MoveToDependencyManagementPanel createPanel(File fl) {
                    final MoveToDependencyManagementPanel[] pnl = new MoveToDependencyManagementPanel[1];
                    final File ffl = fl;
                    try {
                        EventQueue.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                pnl[0] = new MoveToDependencyManagementPanel(ffl, MoveFix.this.project);
                            }
                        });
                    }
                    catch (InterruptedException ex) {
                        LOG.log(Level.WARNING, null, ex);
                    }
                    catch (InvocationTargetException ex) {
                        LOG.log(Level.WARNING, null, ex);
                    }
                    return pnl[0];
                }
            });
            return info;
        }
    }
}

