/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.FunctionElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.ArrayElement;
import org.netbeans.modules.php.editor.parser.astnodes.ArrowFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Assignment;
import org.netbeans.modules.php.editor.parser.astnodes.CatchClause;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.GlobalStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ListVariable;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.Reference;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.netbeans.modules.php.editor.parser.astnodes.Variadic;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.CustomisableRule;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.UninitializedVariableCustomizer;
import org.openide.filesystems.FileObject;

public class UninitializedVariableHint
extends HintRule
implements CustomisableRule {
    private static final String HINT_ID = "Uninitialized.Variable.Hint";
    private static final String CHECK_VARIABLES_INITIALIZED_BY_REFERENCE = "php.verification.check.variables.initialized.by.reference";
    private static final List<String> UNCHECKED_VARIABLES = new ArrayList<String>();
    private static final List<UglyElement> UGLY_ELEMENTS = new ArrayList<UglyElement>();
    private Preferences preferences;

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject == null) {
            return;
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        CheckVisitor checkVisitor = new CheckVisitor(fileObject, phpParseResult.getModel(), context.doc);
        phpParseResult.getProgram().accept(checkVisitor);
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        hints.addAll(checkVisitor.getHints());
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.UninitializedVariableHintDesc();
    }

    public String getDisplayName() {
        return Bundle.UninitializedVariableHintDispName();
    }

    @Override
    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    @Override
    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        UninitializedVariableCustomizer customizer = new UninitializedVariableCustomizer(preferences, this);
        this.setCheckVariablesInitializedByReference(preferences, this.checkVariablesInitializedByReference(preferences));
        return customizer;
    }

    public void setCheckVariablesInitializedByReference(Preferences preferences, boolean isEnabled) {
        preferences.putBoolean(CHECK_VARIABLES_INITIALIZED_BY_REFERENCE, isEnabled);
    }

    public boolean checkVariablesInitializedByReference(Preferences preferences) {
        return preferences.getBoolean(CHECK_VARIABLES_INITIALIZED_BY_REFERENCE, false);
    }

    static {
        UNCHECKED_VARIABLES.add("this");
        UNCHECKED_VARIABLES.add("GLOBALS");
        UNCHECKED_VARIABLES.add("_SERVER");
        UNCHECKED_VARIABLES.add("_GET");
        UNCHECKED_VARIABLES.add("_POST");
        UNCHECKED_VARIABLES.add("_FILES");
        UNCHECKED_VARIABLES.add("_COOKIE");
        UNCHECKED_VARIABLES.add("_SESSION");
        UNCHECKED_VARIABLES.add("_REQUEST");
        UNCHECKED_VARIABLES.add("_ENV");
        UNCHECKED_VARIABLES.add("argc");
        UNCHECKED_VARIABLES.add("argv");
        UNCHECKED_VARIABLES.add("HTTP_RAW_POST_DATA");
        UNCHECKED_VARIABLES.add("php_errormsg");
        UNCHECKED_VARIABLES.add("http_response_header");
        UGLY_ELEMENTS.add(new UglyElementImpl("bind_result", "mysqli_stmt"));
    }

    private static final class UglyElementImpl
    implements UglyElement {
        private final String methodName;
        private final String className;

        public UglyElementImpl(String methodName, String className) {
            assert (methodName != null);
            assert (className != null);
            this.methodName = methodName;
            this.className = className;
        }

        public UglyElementImpl(BaseFunctionElement baseFunctionElement) {
            this(baseFunctionElement.getName(), baseFunctionElement.getIn() == null ? "" : baseFunctionElement.getIn());
        }

        @Override
        public boolean matches(BaseFunctionElement functionElement) {
            return this.methodName.equals(functionElement.getName()) && this.className.equals(functionElement.getIn());
        }

        public int hashCode() {
            int hash = 5;
            hash = 53 * hash + Objects.hashCode(this.methodName);
            hash = 53 * hash + Objects.hashCode(this.className);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            UglyElementImpl other = (UglyElementImpl)obj;
            if (!Objects.equals(this.methodName, other.methodName)) {
                return false;
            }
            return Objects.equals(this.className, other.className);
        }
    }

    private static interface UglyElement {
        public boolean matches(BaseFunctionElement var1);
    }

    private final class CheckVisitor
    extends DefaultVisitor {
        private final FileObject fileObject;
        private final ArrayDeque<ASTNode> parentNodes = new ArrayDeque();
        private final Map<ASTNode, List<Variable>> initializedVariablesAll = new HashMap<ASTNode, List<Variable>>();
        private final Map<ASTNode, List<Variable>> uninitializedVariablesAll = new HashMap<ASTNode, List<Variable>>();
        private final List<Hint> hints = new ArrayList<Hint>();
        private final Model model;
        private final Map<String, Set<BaseFunctionElement>> invocationCache = new HashMap<String, Set<BaseFunctionElement>>();
        private final BaseDocument baseDocument;
        private final Map<ArrowFunctionDeclaration, Set<String>> arrowFunctionParameters = new HashMap<ArrowFunctionDeclaration, Set<String>>();
        private ArrowFunctionDeclaration firstArrowFunction = null;
        private ArrowFunctionDeclaration currentArrowFunction = null;

        private CheckVisitor(FileObject fileObject, Model model, BaseDocument baseDocument) {
            this.fileObject = fileObject;
            this.model = model;
            this.baseDocument = baseDocument;
        }

        private Collection<? extends Hint> getHints() {
            for (ASTNode scopeNode : this.uninitializedVariablesAll.keySet()) {
                this.createHints(this.getUninitializedVariables(scopeNode));
            }
            return Collections.unmodifiableCollection(this.hints);
        }

        private void createHints(List<Variable> uninitializedVariables) {
            for (Variable variable : uninitializedVariables) {
                this.createHint(variable);
            }
        }

        private void createHint(Variable variable) {
            int end;
            int start = variable.getStartOffset() + 1;
            OffsetRange offsetRange = new OffsetRange(start, end = variable.getEndOffset());
            if (UninitializedVariableHint.this.showHint(offsetRange, this.baseDocument)) {
                this.hints.add(new Hint((Rule)UninitializedVariableHint.this, Bundle.UninitializedVariableVariableHintCustom(this.getVariableName(variable)), this.fileObject, offsetRange, null, 500));
            }
        }

        @Override
        public void visit(Program node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(NamespaceDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(FunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.parentNodes.push(node);
            super.visit(node);
            this.parentNodes.pop();
        }

        @Override
        public void visit(LambdaFunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.scan(node.getLexicalVariables());
            this.parentNodes.push(node);
            this.initializeExpressions(node.getLexicalVariables());
            this.scan(node.getFormalParameters());
            this.scan(node.getBody());
            this.parentNodes.pop();
        }

        @Override
        public void visit(ArrowFunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (this.firstArrowFunction == null) {
                this.firstArrowFunction = node;
            }
            if (this.currentArrowFunction == null || this.parentNodes.peek() instanceof LambdaFunctionDeclaration) {
                this.currentArrowFunction = node;
            }
            Set<String> arrowFunctionParams = this.getArrowFunctionParams(this.currentArrowFunction);
            for (FormalParameter parameter : node.getFormalParameters()) {
                arrowFunctionParams.add(CodeUtils.extractFormalParameterName(parameter));
            }
            this.scan(node.getExpression());
            if (this.firstArrowFunction == node) {
                this.firstArrowFunction = null;
                this.currentArrowFunction = null;
                this.arrowFunctionParameters.clear();
            }
        }

        @Override
        public void visit(Assignment node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            VariableBase leftHandSide = node.getLeftHandSide();
            this.initializeVariableBase(leftHandSide);
            this.scan(node.getRightHandSide());
        }

        @Override
        public void visit(CatchClause node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.initializeVariable(node.getVariable());
            this.scan(node.getClassNames());
            this.scan(node.getBody());
        }

        @Override
        public void visit(DoStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.scan(node.getBody());
            this.scan(node.getCondition());
        }

        @Override
        public void visit(ForEachStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.scan(node.getExpression());
            this.initializeExpression(node.getKey());
            this.initializeExpression(node.getValue());
            this.scan(node.getStatement());
        }

        @Override
        public void visit(ForStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.scan(node.getInitializers());
            this.scan(node.getConditions());
            this.scan(node.getBody());
            this.scan(node.getUpdaters());
        }

        @Override
        public void visit(FormalParameter node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            Expression expression = node.getParameterName();
            if (expression instanceof Reference) {
                Reference reference = (Reference)expression;
                expression = reference.getExpression();
            } else if (expression instanceof Variadic) {
                Variadic variadic = (Variadic)expression;
                expression = variadic.getExpression();
            }
            this.initializeExpression(expression);
        }

        @Override
        public void visit(GlobalStatement node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            for (Variable variable : node.getVariables()) {
                this.initializeVariable(variable);
            }
        }

        @Override
        public void visit(Variable node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (this.isProcessableVariable(node) && !this.isArrowFunctionParameter(node)) {
                this.addUninitializedVariable(node);
            }
        }

        @Override
        public void visit(FunctionInvocation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (UninitializedVariableHint.this.checkVariablesInitializedByReference(UninitializedVariableHint.this.preferences)) {
                List<Expression> invocationParametersExp = node.getParameters();
                String functionName = CodeUtils.extractFunctionName(node);
                if (functionName != null) {
                    Set<BaseFunctionElement> allFunctions = this.invocationCache.get(functionName);
                    if (allFunctions == null) {
                        allFunctions = new HashSet<FunctionElement>(this.model.getIndexScope().getIndex().getFunctions(NameKind.create(functionName, QuerySupport.Kind.EXACT)));
                        this.invocationCache.put(functionName, allFunctions);
                    }
                    this.processAllFunctions(allFunctions, invocationParametersExp);
                }
                this.scan(node.getFunctionName());
            } else {
                super.visit(node);
            }
        }

        @Override
        public void visit(MethodInvocation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (UninitializedVariableHint.this.checkVariablesInitializedByReference(UninitializedVariableHint.this.preferences)) {
                String functionName;
                List<Expression> invocationParametersExp = node.getMethod().getParameters();
                if (invocationParametersExp.size() > 0 && (functionName = CodeUtils.extractFunctionName(node.getMethod())) != null) {
                    Collection<? extends TypeScope> resolvedTypes;
                    Set<BaseFunctionElement> allFunctions = this.invocationCache.get(functionName);
                    if (allFunctions == null && (resolvedTypes = ModelUtils.resolveType(this.model, node)).size() > 0) {
                        TypeScope resolvedType = ModelUtils.getFirst(resolvedTypes);
                        ElementQuery.Index index = this.model.getIndexScope().getIndex();
                        allFunctions = new HashSet<MethodElement>(ElementFilter.forName(NameKind.exact(functionName)).filter(index.getAllMethods(resolvedType)));
                        this.invocationCache.put(functionName, allFunctions);
                    }
                    this.processAllFunctions(allFunctions, invocationParametersExp);
                }
            } else {
                super.visit(node);
            }
        }

        @Override
        public void visit(FieldsDeclaration node) {
        }

        @Override
        public void visit(StaticFieldAccess node) {
        }

        private void processAllFunctions(Set<BaseFunctionElement> allFunctions, List<Expression> invocationParametersExp) {
            if (allFunctions != null && !allFunctions.isEmpty()) {
                BaseFunctionElement methodElement = ModelUtils.getFirst(allFunctions);
                if (methodElement != null && !UGLY_ELEMENTS.contains(new UglyElementImpl(methodElement))) {
                    List<ParameterElement> methodParameters = methodElement.getParameters();
                    int invocationParamsSize = invocationParametersExp.size();
                    if (this.matchNumberOfParams(invocationParamsSize, methodParameters)) {
                        for (int i = 0; i < invocationParamsSize; ++i) {
                            Expression invocationParameterExp = invocationParametersExp.get(i);
                            if (methodParameters.get(i).isReference()) {
                                this.initializeExpression(invocationParameterExp);
                                continue;
                            }
                            this.scan(invocationParameterExp);
                        }
                    } else {
                        this.scan(invocationParametersExp);
                    }
                }
            } else {
                this.scan(invocationParametersExp);
            }
        }

        private boolean matchNumberOfParams(int invocationParamsNumber, List<ParameterElement> methodParameters) {
            int mandatoryParams = 0;
            for (ParameterElement parameterElement : methodParameters) {
                if (!parameterElement.isMandatory()) continue;
                ++mandatoryParams;
            }
            return invocationParamsNumber >= mandatoryParams && invocationParamsNumber <= methodParameters.size();
        }

        private boolean isProcessableVariable(Variable node) {
            Identifier identifier = this.getIdentifier(node);
            return !this.isInGlobalContext() && identifier != null && !UNCHECKED_VARIABLES.contains(identifier.getName()) && !this.isInitialized(node) && !this.isUninitialized(node);
        }

        private boolean isInGlobalContext() {
            return this.parentNodes.peek() instanceof Program || this.parentNodes.peek() instanceof NamespaceDeclaration;
        }

        private void initializeVariable(Variable variable) {
            if (!this.isInitialized(variable) && !this.isUninitialized(variable)) {
                this.addInitializedVariable(variable);
            }
        }

        private boolean isInitialized(Variable node) {
            return this.contains(this.getInitializedVariables(this.parentNodes.peek()), node);
        }

        private boolean isUninitialized(Variable node) {
            return this.contains(this.getUninitializedVariables(this.parentNodes.peek()), node);
        }

        private boolean contains(List<Variable> scopeVariables, Variable node) {
            boolean retval = false;
            String currentVariableName = this.getVariableName(node);
            for (Variable variable : scopeVariables) {
                if (!currentVariableName.equals(this.getVariableName(variable))) continue;
                retval = true;
                break;
            }
            return retval;
        }

        private String getVariableName(Variable variable) {
            String retval = "";
            Identifier identifier = this.getIdentifier(variable);
            if (identifier != null) {
                retval = identifier.getName();
            }
            return retval;
        }

        private void initializeExpressions(List<Expression> expressions) {
            for (Expression expression : expressions) {
                this.initializeExpression(expression);
            }
        }

        private void initializeExpression(Expression expression) {
            if (expression instanceof Variable) {
                this.initializeVariable((Variable)expression);
            } else if (expression instanceof Reference) {
                this.initializeReference((Reference)expression);
            } else if (expression instanceof Variadic) {
                this.initializeVariadic((Variadic)expression);
            } else if (expression instanceof ListVariable) {
                this.initializeListVariable((ListVariable)expression);
            }
        }

        private void initializeReference(Reference node) {
            this.initializeExpression(node.getExpression());
        }

        private void initializeVariadic(Variadic node) {
            this.initializeExpression(node.getExpression());
        }

        private void initializeVariableBase(VariableBase variableBase) {
            if (variableBase instanceof ArrayAccess) {
                this.initializeArrayAccessVariable((ArrayAccess)variableBase);
            } else if (variableBase instanceof Variable) {
                this.initializeVariable((Variable)variableBase);
            } else if (variableBase instanceof ListVariable) {
                this.initializeListVariable((ListVariable)variableBase);
            } else {
                super.visit(variableBase);
            }
        }

        private void initializeArrayAccessVariable(ArrayAccess node) {
            VariableBase name = node.getName();
            if (name instanceof Variable) {
                this.initializeVariable((Variable)name);
            }
        }

        private void initializeListVariable(ListVariable node) {
            List<ArrayElement> elements = node.getElements();
            for (ArrayElement element : elements) {
                Expression value = element.getValue();
                if (!(value instanceof VariableBase)) continue;
                this.initializeVariableBase((VariableBase)value);
            }
        }

        private void addInitializedVariable(Variable node) {
            List<Variable> scopeVariables = this.getInitializedVariables(this.parentNodes.peek());
            scopeVariables.add(node);
        }

        private void addUninitializedVariable(Variable node) {
            List<Variable> scopeVariables = this.getUninitializedVariables(this.parentNodes.peek());
            scopeVariables.add(node);
        }

        private List<Variable> getInitializedVariables(ASTNode parent) {
            List<Variable> scopeVariables = this.initializedVariablesAll.get(parent);
            if (scopeVariables == null) {
                scopeVariables = new ArrayList<Variable>();
                this.initializedVariablesAll.put(parent, scopeVariables);
            }
            return scopeVariables;
        }

        private List<Variable> getUninitializedVariables(ASTNode parent) {
            List<Variable> scopeVariables = this.uninitializedVariablesAll.get(parent);
            if (scopeVariables == null) {
                scopeVariables = new ArrayList<Variable>();
                this.uninitializedVariablesAll.put(parent, scopeVariables);
            }
            return scopeVariables;
        }

        @CheckForNull
        private Identifier getIdentifier(Variable variable) {
            Identifier retval = null;
            if (variable != null && variable.isDollared() && variable.getName() instanceof Identifier) {
                retval = (Identifier)variable.getName();
            }
            return retval;
        }

        private boolean isArrowFunctionParameter(Variable node) {
            if (this.currentArrowFunction == null) {
                return false;
            }
            return this.getArrowFunctionParams(this.currentArrowFunction).contains(CodeUtils.extractVariableName(node));
        }

        private Set<String> getArrowFunctionParams(ArrowFunctionDeclaration arrowFunctionDeclaration) {
            Set<String> arrowFunctionParams = this.arrowFunctionParameters.get(arrowFunctionDeclaration);
            if (arrowFunctionParams == null) {
                arrowFunctionParams = new HashSet<String>();
                this.arrowFunctionParameters.put(arrowFunctionDeclaration, arrowFunctionParams);
            }
            return arrowFunctionParams;
        }
    }
}

