/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.web.wizards.FilterMappingData;
import org.netbeans.modules.web.wizards.ServletData;

class AnnotationGenerator {
    private static final String TRUE = "true";
    private static final String CLASS_ANNOTATION = "classAnnotation";
    private static final String INCL_INIT_PARAMS = "includeInitParams";
    private static final String INCL_DISPATCHER = "includeDispatcher";

    private AnnotationGenerator() {
    }

    static String webServlet(ServletData data, Map<String, Object> parameters) {
        String initParams = AnnotationGenerator.generInitParams(data.getInitParams());
        if (initParams != null) {
            parameters.put(INCL_INIT_PARAMS, TRUE);
        }
        String res = "@WebServlet(" + AnnotationGenerator.join(AnnotationGenerator.generServletName(data.getClassName(), data.getName()), AnnotationGenerator.generUrlPatterns(data.getUrlMappings()), initParams) + ")";
        parameters.put(CLASS_ANNOTATION, res);
        return res;
    }

    private static String generServletName(String className, String servletName) {
        if (servletName == null || servletName.length() < 1 || servletName.equals(className)) {
            return null;
        }
        return "name=\"" + servletName + "\"";
    }

    private static String generUrlPatterns(String[] mappings) {
        if (mappings == null || mappings.length <= 0) {
            return null;
        }
        ArrayList<String> patterns = new ArrayList<String>();
        for (String s : mappings) {
            patterns.add(s);
        }
        return AnnotationGenerator.list("urlPatterns", patterns);
    }

    private static String generInitParams(String[][] params) {
        if (params == null || params.length <= 0) {
            return null;
        }
        ArrayList<String> initParams = new ArrayList<String>();
        for (String[] param : params) {
            initParams.add("@WebInitParam(name=\"" + param[0] + "\", value=\"" + param[1] + "\")");
        }
        return AnnotationGenerator.list2("initParams", initParams);
    }

    static String webFilter(ServletData data, Map<String, Object> parameters) {
        String initParams = AnnotationGenerator.generInitParams(data.getInitParams());
        if (initParams != null) {
            parameters.put(INCL_INIT_PARAMS, TRUE);
        }
        String res = "@WebFilter(" + AnnotationGenerator.join(AnnotationGenerator.generFilterName(data.getName()), AnnotationGenerator.generMappings(data.getName(), data.getFilterMappings(), parameters), initParams) + ")";
        parameters.put(CLASS_ANNOTATION, res);
        return res;
    }

    private static String generFilterName(String name) {
        return name == null || name.length() < 1 ? null : "filterName=\"" + name + "\"";
    }

    private static String generMappings(String filterName, List<FilterMappingData> mappings, Map<String, Object> parameters) {
        String resDispatchers;
        HashSet<String> dispatchers = new HashSet<String>();
        ArrayList<String> urlPatterns = new ArrayList<String>();
        ArrayList<String> servletNames = new ArrayList<String>();
        for (FilterMappingData item : mappings) {
            if (!item.getName().equals(filterName)) continue;
            if (item.getType() == FilterMappingData.Type.URL) {
                urlPatterns.add(item.getPattern());
            } else if (item.getType() == FilterMappingData.Type.SERVLET) {
                servletNames.add(item.getPattern());
            }
            for (FilterMappingData.Dispatcher d : item.getDispatcher()) {
                if (d == FilterMappingData.Dispatcher.BLANK) continue;
                dispatchers.add(d.toString());
            }
        }
        String string = resDispatchers = dispatchers.isEmpty() ? null : "dispatcherTypes={" + AnnotationGenerator.join(dispatchers, "DispatcherType.", "") + "}";
        if (resDispatchers != null) {
            parameters.put(INCL_DISPATCHER, TRUE);
        }
        String resUrlPatterns = urlPatterns.isEmpty() ? null : AnnotationGenerator.list("urlPatterns", urlPatterns);
        String resServltets = servletNames.isEmpty() ? null : AnnotationGenerator.list("servletNames", servletNames);
        return AnnotationGenerator.join(resUrlPatterns, resServltets, resDispatchers);
    }

    static String webListener() {
        return "@WebListener()";
    }

    private static String join(String ... params) {
        boolean first = true;
        StringBuilder res = new StringBuilder();
        for (String s : params) {
            if (s == null || s.length() < 1) continue;
            if (!first) {
                res.append(", ");
            }
            res.append(s);
            first = false;
        }
        return res.toString();
    }

    private static String join(Collection<String> params, String left, String right) {
        boolean first = true;
        StringBuilder res = new StringBuilder();
        for (String s : params) {
            if (s == null || s.length() < 1) continue;
            if (!first) {
                res.append(", ");
            }
            res.append(left);
            res.append(s);
            res.append(right);
            first = false;
        }
        return res.toString();
    }

    private static String list(String name, List<String> items) {
        StringBuilder res = new StringBuilder();
        res.append(name);
        res.append("={");
        res.append(AnnotationGenerator.join(items, "\"", "\""));
        res.append("}");
        return res.toString();
    }

    private static String list2(String name, List<String> items) {
        StringBuilder res = new StringBuilder();
        res.append(name);
        res.append("={");
        res.append(AnnotationGenerator.join(items, "", ""));
        res.append("}");
        return res.toString();
    }
}

