/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.lower.PolymorphicSignatureLoweringKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrFunctionImpl;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpressionKt;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallWithIndexedArgumentsBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrMemberAccessExpressionBase;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u000f*\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/PolymorphicSignatureLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "isCast", "", "transform", "castReturnType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "backend.jvm"})
public final class PolymorphicSignatureLowering
extends IrElementTransformerVoid
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        if (this.context.getState().getLanguageVersionSettings().supportsFeature(LanguageFeature.PolymorphicSignature)) {
            this.transformChildrenVoid(irFile);
        }
    }

    private final boolean isCast(@NotNull IrTypeOperatorCall $this$isCast) {
        return $this$isCast.getOperator() != IrTypeOperator.INSTANCEOF && $this$isCast.getOperator() != IrTypeOperator.NOT_INSTANCEOF;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrExpression irExpression;
        IrCall irCall;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrExpression irExpression2 = expression2.getArgument();
        if (!(irExpression2 instanceof IrCall)) {
            irExpression2 = null;
        }
        if ((irCall = (IrCall)irExpression2) != null) {
            IrCall irCall2 = irCall;
            boolean bl = false;
            boolean bl2 = false;
            IrCall it = irCall2;
            boolean bl3 = false;
            irCall = this.isCast(expression2) && IrTypePredicatesKt.isNullableAny(it.getType()) ? irCall2 : null;
            if (irCall != null && (irCall = this.transform(irCall, expression2.getTypeOperand())) != null) {
                irExpression = irCall;
                return irExpression;
            }
        }
        irExpression = super.visitTypeOperator(expression2);
        return irExpression;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrCall irCall = this.transform(expression2, null);
        return irCall != null ? (IrExpression)irCall : super.visitCall(expression2);
    }

    /*
     * WARNING - void declaration
     */
    private final IrCall transform(@NotNull IrCall $this$transform, IrType castReturnType) {
        List list2;
        boolean $i$f$mapTo;
        Iterator iterator2;
        IrFunction irFunction = $this$transform.getSymbol().getOwner();
        if (!(irFunction instanceof IrSimpleFunction)) {
            irFunction = null;
        }
        IrSimpleFunction irSimpleFunction = (IrSimpleFunction)irFunction;
        if (irSimpleFunction == null) {
            return null;
        }
        IrSimpleFunction function2 = irSimpleFunction;
        if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)function2, PolymorphicSignatureLoweringKt.access$getPolymorphicSignatureAnnotation$p())) {
            return null;
        }
        IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.singleOrNull(function2.getValueParameters());
        boolean bl = (irValueParameter != null ? irValueParameter.getVarargElementType() : null) != null;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-PolymorphicSignatureLowering$transform$22 = false;
            String $i$a$-assert-PolymorphicSignatureLowering$transform$22 = "@PolymorphicSignature methods should only have a single vararg argument: " + DumpIrTreeKt.dump$default($this$transform, false, 1, null);
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-PolymorphicSignatureLowering$transform$22));
        }
        Object object = (IrVararg)$this$transform.getValueArgument(0);
        if (object != null && (object = object.getElements()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrExpression irExpression;
                void it;
                IrVarargElement irVarargElement = (IrVarargElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                Iterator iterator3 = it;
                if (iterator3 instanceof IrExpression) {
                    irExpression = (IrExpression)it;
                } else if (iterator3 instanceof IrSpreadElement) {
                    irExpression = ((IrSpreadElement)it).getExpression();
                } else {
                    throw (Throwable)((Object)new AssertionError((Object)("unknown IrVarargElement: " + it)));
                }
                IrExpression irExpression2 = irExpression;
                collection.add(irExpression2);
            }
            list2 = (List)destination$iv$iv;
        } else {
            boolean $this$map$iv = false;
            list2 = CollectionsKt.emptyList();
        }
        List values2 = list2;
        boolean $i$f$buildFun = false;
        iterator2 = new IrFunctionBuilder();
        boolean bl4 = false;
        $i$f$mapTo = false;
        Iterator $this$run$iv = iterator2;
        boolean bl5 = false;
        Iterator $this$buildFun = $this$run$iv;
        boolean bl6 = false;
        ((IrFunctionBuilder)((Object)$this$buildFun)).updateFrom(function2);
        ((IrDeclarationBuilder)((Object)$this$buildFun)).setName(function2.getName());
        ((IrDeclarationBuilder)((Object)$this$buildFun)).setOrigin(JvmLoweredDeclarationOrigin.POLYMORPHIC_SIGNATURE_INSTANTIATION.INSTANCE);
        IrType irType = castReturnType;
        if (irType == null) {
            irType = function2.getReturnType();
        }
        ((IrFunctionBuilder)((Object)$this$buildFun)).setReturnType(irType);
        IrElementBase irElementBase = DeclarationBuildersKt.buildFun$default((IrFunctionBuilder)((Object)$this$run$iv), null, 1, null);
        boolean bl7 = false;
        bl4 = false;
        IrFunctionImpl $this$apply = irElementBase;
        boolean bl8 = false;
        $this$apply.setParent(function2.getParent());
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTypeParametersFrom$default($this$apply, function2, null, 2, null);
        $this$apply.setDispatchReceiverParameter(function2.getDispatchReceiverParameter());
        $this$apply.setExtensionReceiverParameter(function2.getExtensionReceiverParameter());
        bl5 = false;
        for (IrExpression value2 : (Iterable)values2) {
            void i;
            DeclarationBuildersKt.addValueParameter($this$apply, "" + '$' + (int)i, value2.getType(), JvmLoweredDeclarationOrigin.POLYMORPHIC_SIGNATURE_INSTANTIATION.INSTANCE);
            ++i;
        }
        IrFunctionImpl fakeFunction = irElementBase;
        irElementBase = new IrCallImpl($this$transform.getStartOffset(), $this$transform.getEndOffset(), fakeFunction.getReturnType(), fakeFunction.getSymbol(), $this$transform.getOrigin(), $this$transform.getSuperQualifierSymbol());
        bl7 = false;
        bl4 = false;
        $this$apply = irElementBase;
        boolean bl9 = false;
        IrMemberAccessExpressionKt.copyTypeArgumentsFrom((IrMemberAccessExpression)((Object)$this$apply), $this$transform);
        ((IrMemberAccessExpressionBase)((Object)$this$apply)).setDispatchReceiver($this$transform.getDispatchReceiver());
        ((IrMemberAccessExpressionBase)((Object)$this$apply)).setExtensionReceiver($this$transform.getExtensionReceiver());
        Iterable $this$forEachIndexed$iv = values2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void p2;
            int n = index$iv++;
            boolean bl10 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            IrExpression irExpression = (IrExpression)item$iv;
            int p1 = n2;
            boolean bl11 = false;
            ((IrCallWithIndexedArgumentsBase)((Object)$this$apply)).putValueArgument(p1, (IrExpression)p2);
        }
        this.transformChildrenVoid($this$apply);
        return (IrCall)((Object)irElementBase);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public PolymorphicSignatureLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.context = context2;
    }
}

