/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build.event;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.Provider;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.Cast;
import org.gradle.internal.Pair;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.build.event.BuildEventListenerFactory;
import org.gradle.internal.build.event.BuildEventListenerRegistryInternal;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.build.event.types.AbstractTaskResult;
import org.gradle.internal.build.event.types.DefaultTaskFinishedProgressEvent;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.task.TaskOperationDescriptor;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.internal.DefaultTaskFinishEvent;
import org.gradle.tooling.events.task.internal.DefaultTaskOperationDescriptor;
import org.gradle.tooling.internal.consumer.parameters.BuildProgressListenerAdapter;
import org.gradle.tooling.internal.protocol.events.InternalTaskDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalTaskResult;
import org.gradle.util.CollectionUtils;

public class DefaultBuildEventsListenerRegistry
implements BuildEventsListenerRegistry,
BuildEventListenerRegistryInternal {
    private final BuildEventListenerFactory factory;
    private final ListenerManager listenerManager;
    private final BuildOperationListenerManager buildOperationListenerManager;
    private final Map<Provider<?>, AbstractListener<?>> subscriptions = new LinkedHashMap();
    private final List<Object> listeners = new ArrayList<Object>();
    private final ExecutorFactory executorFactory;

    public DefaultBuildEventsListenerRegistry(BuildEventListenerFactory factory, ListenerManager listenerManager, BuildOperationListenerManager buildOperationListenerManager, ExecutorFactory executorFactory) {
        this.factory = factory;
        this.listenerManager = listenerManager;
        this.buildOperationListenerManager = buildOperationListenerManager;
        this.executorFactory = executorFactory;
        listenerManager.addListener((Object)new ListenerCleanup());
    }

    @Override
    public List<Provider<?>> getSubscriptions() {
        return ImmutableList.copyOf(this.subscriptions.keySet());
    }

    @Override
    public void subscribe(Provider<?> provider) {
        ProviderInternal providerInternal = Providers.internal(provider);
        if (OperationCompletionListener.class.isAssignableFrom(providerInternal.getType())) {
            this.onTaskCompletion((Provider<? extends OperationCompletionListener>)((Provider)Cast.uncheckedCast(provider)));
        } else {
            this.onOperationCompletion((Provider<? extends BuildOperationListener>)((Provider)Cast.uncheckedCast(provider)));
        }
    }

    @Override
    public void onOperationCompletion(Provider<? extends BuildOperationListener> listenerProvider) {
        if (this.subscriptions.containsKey(listenerProvider)) {
            return;
        }
        ForwardingBuildOperationListener subscription = new ForwardingBuildOperationListener(listenerProvider, this.executorFactory);
        this.subscriptions.put(listenerProvider, subscription);
        this.buildOperationListenerManager.addListener((BuildOperationListener)subscription);
        this.listeners.add(subscription);
    }

    @Override
    public void onTaskCompletion(Provider<? extends OperationCompletionListener> listenerProvider) {
        if (this.subscriptions.containsKey(listenerProvider)) {
            return;
        }
        ForwardingBuildEventConsumer subscription = new ForwardingBuildEventConsumer(listenerProvider, this.executorFactory);
        this.subscriptions.put(listenerProvider, subscription);
        BuildEventSubscriptions eventSubscriptions = new BuildEventSubscriptions(Collections.singleton(OperationType.TASK));
        Iterable<Object> listeners = this.factory.createListeners(eventSubscriptions, subscription);
        CollectionUtils.addAll(this.listeners, listeners);
        for (Object listener : listeners) {
            this.listenerManager.addListener(listener);
            if (!(listener instanceof BuildOperationListener)) continue;
            this.buildOperationListenerManager.addListener((BuildOperationListener)listener);
        }
    }

    private class ListenerCleanup
    extends BuildAdapter {
        private ListenerCleanup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void buildFinished(BuildResult result) {
            if (result.getGradle().getParent() != null) {
                return;
            }
            try {
                for (Object listener : DefaultBuildEventsListenerRegistry.this.listeners) {
                    DefaultBuildEventsListenerRegistry.this.listenerManager.removeListener(listener);
                    if (!(listener instanceof BuildOperationListener)) continue;
                    DefaultBuildEventsListenerRegistry.this.buildOperationListenerManager.removeListener((BuildOperationListener)listener);
                }
                CompositeStoppable.stoppable(DefaultBuildEventsListenerRegistry.this.subscriptions.values()).stop();
            }
            finally {
                DefaultBuildEventsListenerRegistry.this.listeners.clear();
                DefaultBuildEventsListenerRegistry.this.subscriptions.clear();
            }
        }
    }

    private static class ForwardingBuildEventConsumer
    extends AbstractListener<DefaultTaskFinishedProgressEvent>
    implements BuildEventConsumer {
        private final Provider<? extends OperationCompletionListener> listenerProvider;

        public ForwardingBuildEventConsumer(Provider<? extends OperationCompletionListener> listenerProvider, ExecutorFactory executorFactory) {
            super(executorFactory);
            this.listenerProvider = listenerProvider;
        }

        public void dispatch(Object message) {
            if (message instanceof DefaultTaskFinishedProgressEvent) {
                this.queue((DefaultTaskFinishedProgressEvent)message);
            }
        }

        @Override
        protected void handle(DefaultTaskFinishedProgressEvent providerEvent) {
            InternalTaskDescriptor providerDescriptor = (InternalTaskDescriptor)providerEvent.getDescriptor();
            AbstractTaskResult providerResult = providerEvent.getResult();
            DefaultTaskOperationDescriptor descriptor = new DefaultTaskOperationDescriptor(providerDescriptor, null, providerDescriptor.getTaskPath());
            TaskOperationResult result = BuildProgressListenerAdapter.toTaskResult((InternalTaskResult)providerResult);
            DefaultTaskFinishEvent finishEvent = new DefaultTaskFinishEvent(providerEvent.getEventTime(), providerEvent.getDisplayName(), (TaskOperationDescriptor)descriptor, result);
            ((OperationCompletionListener)this.listenerProvider.get()).onFinish((FinishEvent)finishEvent);
        }
    }

    private static class ForwardingBuildOperationListener
    extends AbstractListener<Pair<BuildOperationDescriptor, OperationFinishEvent>>
    implements BuildOperationListener {
        private final Provider<? extends BuildOperationListener> listenerProvider;

        public ForwardingBuildOperationListener(Provider<? extends BuildOperationListener> listenerProvider, ExecutorFactory executorFactory) {
            super(executorFactory);
            this.listenerProvider = listenerProvider;
        }

        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        }

        public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent progressEvent) {
        }

        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            this.queue(Pair.of((Object)buildOperation, (Object)finishEvent));
        }

        @Override
        protected void handle(Pair<BuildOperationDescriptor, OperationFinishEvent> message) {
            ((BuildOperationListener)this.listenerProvider.get()).finished((BuildOperationDescriptor)message.left, (OperationFinishEvent)message.right);
        }
    }

    private static abstract class AbstractListener<T>
    implements Closeable {
        private static final Object END = new Object();
        private final ManagedExecutor executor;
        private final BlockingQueue<Object> events = new LinkedBlockingQueue<Object>();
        private final AtomicReference<Exception> failure = new AtomicReference();

        public AbstractListener(ExecutorFactory executorFactory) {
            this.executor = executorFactory.create("build event listener");
            this.executor.submit(this::run);
        }

        private void run() {
            while (true) {
                Object next;
                try {
                    next = this.events.take();
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
                if (next == END) {
                    return;
                }
                try {
                    this.handle(Cast.uncheckedNonnullCast((Object)next));
                }
                catch (Exception e) {
                    this.failure.set(e);
                    this.events.clear();
                    return;
                }
            }
        }

        protected abstract void handle(T var1);

        protected void queue(T message) {
            if (this.failure.get() == null) {
                this.events.add(message);
            }
        }

        @Override
        public void close() {
            this.events.add(END);
            this.executor.stop(60, TimeUnit.SECONDS);
            Exception failure = this.failure.get();
            if (failure != null) {
                throw UncheckedException.throwAsUncheckedException((Throwable)failure);
            }
        }
    }
}

