/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;

public final class RevWalkUtils {
    private RevWalkUtils() {
    }

    public static int count(RevWalk walk2, RevCommit start, RevCommit end) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return RevWalkUtils.find(walk2, start, end).size();
    }

    public static List<RevCommit> find(RevWalk walk2, RevCommit start, RevCommit end) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        walk2.reset();
        walk2.markStart(start);
        if (end != null) {
            walk2.markUninteresting(end);
        }
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        for (RevCommit c : walk2) {
            commits.add(c);
        }
        return commits;
    }

    public static List<Ref> findBranchesReachableFrom(RevCommit commit, RevWalk revWalk, Collection<Ref> refs) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        commit = revWalk.parseCommit(commit.getId());
        revWalk.reset();
        ArrayList<Ref> result = new ArrayList<Ref>();
        int SKEW = 86400;
        for (Ref ref2 : refs) {
            RevCommit headCommit;
            RevObject maybehead = revWalk.parseAny(ref2.getObjectId());
            if (!(maybehead instanceof RevCommit) || (headCommit = (RevCommit)maybehead).getCommitTime() + 86400 < commit.getCommitTime() || !revWalk.isMergedInto(commit, headCommit)) continue;
            result.add(ref2);
        }
        return result;
    }
}

