/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.Date;
import java.util.TimeZone;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;

public final class Time {
    public static final Primitive _TIME = new pf__time();
    private static final Primitive GET_INTERNAL_REAL_TIME = new pf_get_internal_real_time();
    private static final Primitive GET_INTERNAL_RUN_TIME = new pf_get_internal_run_time();
    private static final Primitive GET_UNIVERSAL_TIME = new pf_get_universal_time();
    private static final Primitive DEFAULT_TIME_ZONE = new pf_default_time_zone();
    private static final Primitive GET_TIME_ZONE = new pf_get_time_zone();

    private static final LispObject getTimeZone(long unixTimeMillis) {
        TimeZone tz = TimeZone.getDefault();
        int rawOffset = tz.getRawOffset();
        boolean inDaylightTime = tz.inDaylightTime(new Date(unixTimeMillis));
        if (inDaylightTime) {
            rawOffset += tz.getDSTSavings();
        }
        return LispThread.currentThread().setValues(Fixnum.getInstance(-rawOffset).divideBy(Fixnum.getInstance(3600000)), inDaylightTime ? Lisp.T : Lisp.NIL);
    }

    @DocString(name="get-time-zone", args="time-in-millis", returns="hours-west daylight-p", doc="Returns as the first value the timezone difference in hours from the Greenwich meridian for TIME-IN-MILLIS via the Daylight Savings Time assumptions that were in place at the instant's occurance.  Returns as the second value a boolean as to whether daylight savings time was in effect at the occurance.")
    private static final class pf_get_time_zone
    extends Primitive {
        pf_get_time_zone() {
            super("get-time-zone", Lisp.PACKAGE_EXT, true);
        }

        @Override
        public LispObject execute(LispObject arg) {
            return Time.getTimeZone((arg.longValue() - 2208988800L) * 1000L);
        }
    }

    private static final class pf_default_time_zone
    extends Primitive {
        pf_default_time_zone() {
            super("default-time-zone", Lisp.PACKAGE_SYS, false);
        }

        @Override
        public LispObject execute() {
            return Time.getTimeZone(System.currentTimeMillis());
        }
    }

    private static final class pf_get_universal_time
    extends Primitive {
        pf_get_universal_time() {
            super("get-universal-time", "");
        }

        @Override
        public LispObject execute() {
            return Lisp.number(System.currentTimeMillis() / 1000L + 2208988800L);
        }
    }

    private static final class pf_get_internal_run_time
    extends Primitive {
        pf_get_internal_run_time() {
            super("get-internal-run-time", "");
        }

        @Override
        public LispObject execute() {
            return Lisp.number(System.currentTimeMillis());
        }
    }

    private static final class pf_get_internal_real_time
    extends Primitive {
        pf_get_internal_real_time() {
            super("get-internal-real-time", "");
        }

        @Override
        public LispObject execute() {
            return Lisp.number(System.currentTimeMillis());
        }
    }

    private static final class pf__time
    extends Primitive {
        pf__time() {
            super("%time", Lisp.PACKAGE_SYS, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public LispObject execute(LispObject arg) {
            Cons.setCount(0L);
            long realStart = System.currentTimeMillis();
            try {
                LispObject lispObject = arg.execute();
                return lispObject;
            }
            finally {
                long realElapsed = System.currentTimeMillis() - realStart;
                long count = Cons.getCount();
                Stream out = Lisp.checkCharacterOutputStream(Symbol.TRACE_OUTPUT.symbolValue());
                out.freshLine();
                StringBuilder sb = new StringBuilder();
                sb.append(String.valueOf((float)realElapsed / 1000.0f));
                sb.append(" seconds real time");
                sb.append(System.getProperty("line.separator"));
                sb.append(count);
                sb.append(" cons cell");
                if (count != 1L) {
                    sb.append('s');
                }
                sb.append(System.getProperty("line.separator"));
                out._writeString(sb.toString());
                out._finishOutput();
            }
        }
    }
}

