; -*- coding: iso-2022-7bit  -*-
;;; ugb2312.el --- tables between UCS and GB2312-80

;; Keywords: CCL, mule, multilingual, 
;;           character set, coding-system, ISO10646, Unicode, JIS X 0208

;; This file is part of Mule-UCS

;; Mule-UCS is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; Mule-UCS is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; This file is converted from GB2312.TXT of Unicode consortium
;;; by Miyashita Hisashi <himi@bird.scphys.kyoto-u.ac.jp>.

(put 'chinese-gb2312 'unicode-assoc
     'gb2312-80-vs-unicode-assoc)

(defvar
  gb2312-80-vs-unicode-assoc
  `(assoc
    (char-1 . ucs-generic)
    ,(transformate-list-structure
      (identity . c-notated-string-to-number)
      ((?$A!!(B . "0x3000") ;; IDEOGRAPHIC SPACE
       (?$A!"(B . "0x3001") ;; IDEOGRAPHIC COMMA
       (?$A!#(B . "0x3002") ;; IDEOGRAPHIC FULL STOP
       (?$A!$(B . "0x30FB") ;; KATAKANA MIDDLE DOT
       (?$A!%(B . "0x02C9") ;; MODIFIER LETTER MACRON (Mandarin Chinese first tone)
       (?$A!&(B . "0x02C7") ;; CARON (Mandarin Chinese third tone)
       (?$A!'(B . "0x00A8") ;; DIAERESIS
       (?$A!((B . "0x3003") ;; DITTO MARK
       (?$A!)(B . "0x3005") ;; IDEOGRAPHIC ITERATION MARK
       (?$A!*(B . "0x2015") ;; HORIZONTAL BAR
       (?$A!+(B . "0xFF5E") ;; FULLWIDTH TILDE
       (?$A!,(B . "0x2225") ;; PARALLEL TO
       (?$A!-(B . "0x2026") ;; HORIZONTAL ELLIPSIS
       (?$A!.(B . "0x2018") ;; LEFT SINGLE QUOTATION MARK
       (?$A!/(B . "0x2019") ;; RIGHT SINGLE QUOTATION MARK
       (?$A!0(B . "0x201C") ;; LEFT DOUBLE QUOTATION MARK
       (?$A!1(B . "0x201D") ;; RIGHT DOUBLE QUOTATION MARK
       (?$A!2(B . "0x3014") ;; LEFT TORTOISE SHELL BRACKET
       (?$A!3(B . "0x3015") ;; RIGHT TORTOISE SHELL BRACKET
       (?$A!4(B . "0x3008") ;; LEFT ANGLE BRACKET
       (?$A!5(B . "0x3009") ;; RIGHT ANGLE BRACKET
       (?$A!6(B . "0x300A") ;; LEFT DOUBLE ANGLE BRACKET
       (?$A!7(B . "0x300B") ;; RIGHT DOUBLE ANGLE BRACKET
       (?$A!8(B . "0x300C") ;; LEFT CORNER BRACKET
       (?$A!9(B . "0x300D") ;; RIGHT CORNER BRACKET
       (?$A!:(B . "0x300E") ;; LEFT WHITE CORNER BRACKET
       (?$A!;(B . "0x300F") ;; RIGHT WHITE CORNER BRACKET
       (?$A!<(B . "0x3016") ;; LEFT WHITE LENTICULAR BRACKET
       (?$A!=(B . "0x3017") ;; RIGHT WHITE LENTICULAR BRACKET
       (?$A!>(B . "0x3010") ;; LEFT BLACK LENTICULAR BRACKET
       (?$A!?(B . "0x3011") ;; RIGHT BLACK LENTICULAR BRACKET
       (?$A!@(B . "0x00B1") ;; PLUS-MINUS SIGN
       (?$A!A(B . "0x00D7") ;; MULTIPLICATION SIGN
       (?$A!B(B . "0x00F7") ;; DIVISION SIGN
       (?$A!C(B . "0x2236") ;; RATIO
       (?$A!D(B . "0x2227") ;; LOGICAL AND
       (?$A!E(B . "0x2228") ;; LOGICAL OR
       (?$A!F(B . "0x2211") ;; N-ARY SUMMATION
       (?$A!G(B . "0x220F") ;; N-ARY PRODUCT
       (?$A!H(B . "0x222A") ;; UNION
       (?$A!I(B . "0x2229") ;; INTERSECTION
       (?$A!J(B . "0x2208") ;; ELEMENT OF
       (?$A!K(B . "0x2237") ;; PROPORTION
       (?$A!L(B . "0x221A") ;; SQUARE ROOT
       (?$A!M(B . "0x22A5") ;; UP TACK
       (?$A!N(B . "0x2225") ;; PARALLEL TO
       (?$A!O(B . "0x2220") ;; ANGLE
       (?$A!P(B . "0x2312") ;; ARC
       (?$A!Q(B . "0x2299") ;; CIRCLED DOT OPERATOR
       (?$A!R(B . "0x222B") ;; INTEGRAL
       (?$A!S(B . "0x222E") ;; CONTOUR INTEGRAL
       (?$A!T(B . "0x2261") ;; IDENTICAL TO
       (?$A!U(B . "0x224C") ;; ALL EQUAL TO
       (?$A!V(B . "0x2248") ;; ALMOST EQUAL TO
       (?$A!W(B . "0x223D") ;; REVERSED TILDE
       (?$A!X(B . "0x221D") ;; PROPORTIONAL TO
       (?$A!Y(B . "0x2260") ;; NOT EQUAL TO
       (?$A!Z(B . "0x226E") ;; NOT LESS-THAN
       (?$A![(B . "0x226F") ;; NOT GREATER-THAN
       (?$A!\(B . "0x2264") ;; LESS-THAN OR EQUAL TO
       (?$A!](B . "0x2265") ;; GREATER-THAN OR EQUAL TO
       (?$A!^(B . "0x221E") ;; INFINITY
       (?$A!_(B . "0x2235") ;; BECAUSE
       (?$A!`(B . "0x2234") ;; THEREFORE
       (?$A!a(B . "0x2642") ;; MALE SIGN
       (?$A!b(B . "0x2640") ;; FEMALE SIGN
       (?$A!c(B . "0x00B0") ;; DEGREE SIGN
       (?$A!d(B . "0x2032") ;; PRIME
       (?$A!e(B . "0x2033") ;; DOUBLE PRIME
       (?$A!f(B . "0x2103") ;; DEGREE CELSIUS
       (?$A!g(B . "0xFF04") ;; FULLWIDTH DOLLAR SIGN
       (?$A!h(B . "0x00A4") ;; CURRENCY SIGN
       (?$A!i(B . "0xFFE0") ;; FULLWIDTH CENT SIGN
       (?$A!j(B . "0xFFE1") ;; FULLWIDTH POUND SIGN
       (?$A!k(B . "0x2030") ;; PER MILLE SIGN
       (?$A!l(B . "0x00A7") ;; SECTION SIGN
       (?$A!m(B . "0x2116") ;; NUMERO SIGN
       (?$A!n(B . "0x2606") ;; WHITE STAR
       (?$A!o(B . "0x2605") ;; BLACK STAR
       (?$A!p(B . "0x25CB") ;; WHITE CIRCLE
       (?$A!q(B . "0x25CF") ;; BLACK CIRCLE
       (?$A!r(B . "0x25CE") ;; BULLSEYE
       (?$A!s(B . "0x25C7") ;; WHITE DIAMOND
       (?$A!t(B . "0x25C6") ;; BLACK DIAMOND
       (?$A!u(B . "0x25A1") ;; WHITE SQUARE
       (?$A!v(B . "0x25A0") ;; BLACK SQUARE
       (?$A!w(B . "0x25B3") ;; WHITE UP-POINTING TRIANGLE
       (?$A!x(B . "0x25B2") ;; BLACK UP-POINTING TRIANGLE
       (?$A!y(B . "0x203B") ;; REFERENCE MARK
       (?$A!z(B . "0x2192") ;; RIGHTWARDS ARROW
       (?$A!{(B . "0x2190") ;; LEFTWARDS ARROW
       (?$A!|(B . "0x2191") ;; UPWARDS ARROW
       (?$A!}(B . "0x2193") ;; DOWNWARDS ARROW
       (?$A!~(B . "0x3013") ;; GETA MARK
       (?$A"1(B . "0x2488") ;; DIGIT ONE FULL STOP
       (?$A"2(B . "0x2489") ;; DIGIT TWO FULL STOP
       (?$A"3(B . "0x248A") ;; DIGIT THREE FULL STOP
       (?$A"4(B . "0x248B") ;; DIGIT FOUR FULL STOP
       (?$A"5(B . "0x248C") ;; DIGIT FIVE FULL STOP
       (?$A"6(B . "0x248D") ;; DIGIT SIX FULL STOP
       (?$A"7(B . "0x248E") ;; DIGIT SEVEN FULL STOP
       (?$A"8(B . "0x248F") ;; DIGIT EIGHT FULL STOP
       (?$A"9(B . "0x2490") ;; DIGIT NINE FULL STOP
       (?$A":(B . "0x2491") ;; NUMBER TEN FULL STOP
       (?$A";(B . "0x2492") ;; NUMBER ELEVEN FULL STOP
       (?$A"<(B . "0x2493") ;; NUMBER TWELVE FULL STOP
       (?$A"=(B . "0x2494") ;; NUMBER THIRTEEN FULL STOP
       (?$A">(B . "0x2495") ;; NUMBER FOURTEEN FULL STOP
       (?$A"?(B . "0x2496") ;; NUMBER FIFTEEN FULL STOP
       (?$A"@(B . "0x2497") ;; NUMBER SIXTEEN FULL STOP
       (?$A"A(B . "0x2498") ;; NUMBER SEVENTEEN FULL STOP
       (?$A"B(B . "0x2499") ;; NUMBER EIGHTEEN FULL STOP
       (?$A"C(B . "0x249A") ;; NUMBER NINETEEN FULL STOP
       (?$A"D(B . "0x249B") ;; NUMBER TWENTY FULL STOP
       (?$A"E(B . "0x2474") ;; PARENTHESIZED DIGIT ONE
       (?$A"F(B . "0x2475") ;; PARENTHESIZED DIGIT TWO
       (?$A"G(B . "0x2476") ;; PARENTHESIZED DIGIT THREE
       (?$A"H(B . "0x2477") ;; PARENTHESIZED DIGIT FOUR
       (?$A"I(B . "0x2478") ;; PARENTHESIZED DIGIT FIVE
       (?$A"J(B . "0x2479") ;; PARENTHESIZED DIGIT SIX
       (?$A"K(B . "0x247A") ;; PARENTHESIZED DIGIT SEVEN
       (?$A"L(B . "0x247B") ;; PARENTHESIZED DIGIT EIGHT
       (?$A"M(B . "0x247C") ;; PARENTHESIZED DIGIT NINE
       (?$A"N(B . "0x247D") ;; PARENTHESIZED NUMBER TEN
       (?$A"O(B . "0x247E") ;; PARENTHESIZED NUMBER ELEVEN
       (?$A"P(B . "0x247F") ;; PARENTHESIZED NUMBER TWELVE
       (?$A"Q(B . "0x2480") ;; PARENTHESIZED NUMBER THIRTEEN
       (?$A"R(B . "0x2481") ;; PARENTHESIZED NUMBER FOURTEEN
       (?$A"S(B . "0x2482") ;; PARENTHESIZED NUMBER FIFTEEN
       (?$A"T(B . "0x2483") ;; PARENTHESIZED NUMBER SIXTEEN
       (?$A"U(B . "0x2484") ;; PARENTHESIZED NUMBER SEVENTEEN
       (?$A"V(B . "0x2485") ;; PARENTHESIZED NUMBER EIGHTEEN
       (?$A"W(B . "0x2486") ;; PARENTHESIZED NUMBER NINETEEN
       (?$A"X(B . "0x2487") ;; PARENTHESIZED NUMBER TWENTY
       (?$A"Y(B . "0x2460") ;; CIRCLED DIGIT ONE
       (?$A"Z(B . "0x2461") ;; CIRCLED DIGIT TWO
       (?$A"[(B . "0x2462") ;; CIRCLED DIGIT THREE
       (?$A"\(B . "0x2463") ;; CIRCLED DIGIT FOUR
       (?$A"](B . "0x2464") ;; CIRCLED DIGIT FIVE
       (?$A"^(B . "0x2465") ;; CIRCLED DIGIT SIX
       (?$A"_(B . "0x2466") ;; CIRCLED DIGIT SEVEN
       (?$A"`(B . "0x2467") ;; CIRCLED DIGIT EIGHT
       (?$A"a(B . "0x2468") ;; CIRCLED DIGIT NINE
       (?$A"b(B . "0x2469") ;; CIRCLED NUMBER TEN
       (?$A"e(B . "0x3220") ;; PARENTHESIZED IDEOGRAPH ONE
       (?$A"f(B . "0x3221") ;; PARENTHESIZED IDEOGRAPH TWO
       (?$A"g(B . "0x3222") ;; PARENTHESIZED IDEOGRAPH THREE
       (?$A"h(B . "0x3223") ;; PARENTHESIZED IDEOGRAPH FOUR
       (?$A"i(B . "0x3224") ;; PARENTHESIZED IDEOGRAPH FIVE
       (?$A"j(B . "0x3225") ;; PARENTHESIZED IDEOGRAPH SIX
       (?$A"k(B . "0x3226") ;; PARENTHESIZED IDEOGRAPH SEVEN
       (?$A"l(B . "0x3227") ;; PARENTHESIZED IDEOGRAPH EIGHT
       (?$A"m(B . "0x3228") ;; PARENTHESIZED IDEOGRAPH NINE
       (?$A"n(B . "0x3229") ;; PARENTHESIZED IDEOGRAPH TEN
       (?$A"q(B . "0x2160") ;; ROMAN NUMERAL ONE
       (?$A"r(B . "0x2161") ;; ROMAN NUMERAL TWO
       (?$A"s(B . "0x2162") ;; ROMAN NUMERAL THREE
       (?$A"t(B . "0x2163") ;; ROMAN NUMERAL FOUR
       (?$A"u(B . "0x2164") ;; ROMAN NUMERAL FIVE
       (?$A"v(B . "0x2165") ;; ROMAN NUMERAL SIX
       (?$A"w(B . "0x2166") ;; ROMAN NUMERAL SEVEN
       (?$A"x(B . "0x2167") ;; ROMAN NUMERAL EIGHT
       (?$A"y(B . "0x2168") ;; ROMAN NUMERAL NINE
       (?$A"z(B . "0x2169") ;; ROMAN NUMERAL TEN
       (?$A"{(B . "0x216A") ;; ROMAN NUMERAL ELEVEN
       (?$A"|(B . "0x216B") ;; ROMAN NUMERAL TWELVE
       (?$A#!(B . "0xFF01") ;; FULLWIDTH EXCLAMATION MARK
       (?$A#"(B . "0xFF02") ;; FULLWIDTH QUOTATION MARK
       (?$A##(B . "0xFF03") ;; FULLWIDTH NUMBER SIGN
       (?$A#$(B . "0xFFE5") ;; FULLWIDTH YEN SIGN
       (?$A#%(B . "0xFF05") ;; FULLWIDTH PERCENT SIGN
       (?$A#&(B . "0xFF06") ;; FULLWIDTH AMPERSAND
       (?$A#'(B . "0xFF07") ;; FULLWIDTH APOSTROPHE
       (?$A#((B . "0xFF08") ;; FULLWIDTH LEFT PARENTHESIS
       (?$A#)(B . "0xFF09") ;; FULLWIDTH RIGHT PARENTHESIS
       (?$A#*(B . "0xFF0A") ;; FULLWIDTH ASTERISK
       (?$A#+(B . "0xFF0B") ;; FULLWIDTH PLUS SIGN
       (?$A#,(B . "0xFF0C") ;; FULLWIDTH COMMA
       (?$A#-(B . "0xFF0D") ;; FULLWIDTH HYPHEN-MINUS
       (?$A#.(B . "0xFF0E") ;; FULLWIDTH FULL STOP
       (?$A#/(B . "0xFF0F") ;; FULLWIDTH SOLIDUS
       (?$A#0(B . "0xFF10") ;; FULLWIDTH DIGIT ZERO
       (?$A#1(B . "0xFF11") ;; FULLWIDTH DIGIT ONE
       (?$A#2(B . "0xFF12") ;; FULLWIDTH DIGIT TWO
       (?$A#3(B . "0xFF13") ;; FULLWIDTH DIGIT THREE
       (?$A#4(B . "0xFF14") ;; FULLWIDTH DIGIT FOUR
       (?$A#5(B . "0xFF15") ;; FULLWIDTH DIGIT FIVE
       (?$A#6(B . "0xFF16") ;; FULLWIDTH DIGIT SIX
       (?$A#7(B . "0xFF17") ;; FULLWIDTH DIGIT SEVEN
       (?$A#8(B . "0xFF18") ;; FULLWIDTH DIGIT EIGHT
       (?$A#9(B . "0xFF19") ;; FULLWIDTH DIGIT NINE
       (?$A#:(B . "0xFF1A") ;; FULLWIDTH COLON
       (?$A#;(B . "0xFF1B") ;; FULLWIDTH SEMICOLON
       (?$A#<(B . "0xFF1C") ;; FULLWIDTH LESS-THAN SIGN
       (?$A#=(B . "0xFF1D") ;; FULLWIDTH EQUALS SIGN
       (?$A#>(B . "0xFF1E") ;; FULLWIDTH GREATER-THAN SIGN
       (?$A#?(B . "0xFF1F") ;; FULLWIDTH QUESTION MARK
       (?$A#@(B . "0xFF20") ;; FULLWIDTH COMMERCIAL AT
       (?$A#A(B . "0xFF21") ;; FULLWIDTH LATIN CAPITAL LETTER A
       (?$A#B(B . "0xFF22") ;; FULLWIDTH LATIN CAPITAL LETTER B
       (?$A#C(B . "0xFF23") ;; FULLWIDTH LATIN CAPITAL LETTER C
       (?$A#D(B . "0xFF24") ;; FULLWIDTH LATIN CAPITAL LETTER D
       (?$A#E(B . "0xFF25") ;; FULLWIDTH LATIN CAPITAL LETTER E
       (?$A#F(B . "0xFF26") ;; FULLWIDTH LATIN CAPITAL LETTER F
       (?$A#G(B . "0xFF27") ;; FULLWIDTH LATIN CAPITAL LETTER G
       (?$A#H(B . "0xFF28") ;; FULLWIDTH LATIN CAPITAL LETTER H
       (?$A#I(B . "0xFF29") ;; FULLWIDTH LATIN CAPITAL LETTER I
       (?$A#J(B . "0xFF2A") ;; FULLWIDTH LATIN CAPITAL LETTER J
       (?$A#K(B . "0xFF2B") ;; FULLWIDTH LATIN CAPITAL LETTER K
       (?$A#L(B . "0xFF2C") ;; FULLWIDTH LATIN CAPITAL LETTER L
       (?$A#M(B . "0xFF2D") ;; FULLWIDTH LATIN CAPITAL LETTER M
       (?$A#N(B . "0xFF2E") ;; FULLWIDTH LATIN CAPITAL LETTER N
       (?$A#O(B . "0xFF2F") ;; FULLWIDTH LATIN CAPITAL LETTER O
       (?$A#P(B . "0xFF30") ;; FULLWIDTH LATIN CAPITAL LETTER P
       (?$A#Q(B . "0xFF31") ;; FULLWIDTH LATIN CAPITAL LETTER Q
       (?$A#R(B . "0xFF32") ;; FULLWIDTH LATIN CAPITAL LETTER R
       (?$A#S(B . "0xFF33") ;; FULLWIDTH LATIN CAPITAL LETTER S
       (?$A#T(B . "0xFF34") ;; FULLWIDTH LATIN CAPITAL LETTER T
       (?$A#U(B . "0xFF35") ;; FULLWIDTH LATIN CAPITAL LETTER U
       (?$A#V(B . "0xFF36") ;; FULLWIDTH LATIN CAPITAL LETTER V
       (?$A#W(B . "0xFF37") ;; FULLWIDTH LATIN CAPITAL LETTER W
       (?$A#X(B . "0xFF38") ;; FULLWIDTH LATIN CAPITAL LETTER X
       (?$A#Y(B . "0xFF39") ;; FULLWIDTH LATIN CAPITAL LETTER Y
       (?$A#Z(B . "0xFF3A") ;; FULLWIDTH LATIN CAPITAL LETTER Z
       (?$A#[(B . "0xFF3B") ;; FULLWIDTH LEFT SQUARE BRACKET
       (?$A#\(B . "0xFF3C") ;; FULLWIDTH REVERSE SOLIDUS
       (?$A#](B . "0xFF3D") ;; FULLWIDTH RIGHT SQUARE BRACKET
       (?$A#^(B . "0xFF3E") ;; FULLWIDTH CIRCUMFLEX ACCENT
       (?$A#_(B . "0xFF3F") ;; FULLWIDTH LOW LINE
       (?$A#`(B . "0xFF40") ;; FULLWIDTH GRAVE ACCENT
       (?$A#a(B . "0xFF41") ;; FULLWIDTH LATIN SMALL LETTER A
       (?$A#b(B . "0xFF42") ;; FULLWIDTH LATIN SMALL LETTER B
       (?$A#c(B . "0xFF43") ;; FULLWIDTH LATIN SMALL LETTER C
       (?$A#d(B . "0xFF44") ;; FULLWIDTH LATIN SMALL LETTER D
       (?$A#e(B . "0xFF45") ;; FULLWIDTH LATIN SMALL LETTER E
       (?$A#f(B . "0xFF46") ;; FULLWIDTH LATIN SMALL LETTER F
       (?$A#g(B . "0xFF47") ;; FULLWIDTH LATIN SMALL LETTER G
       (?$A#h(B . "0xFF48") ;; FULLWIDTH LATIN SMALL LETTER H
       (?$A#i(B . "0xFF49") ;; FULLWIDTH LATIN SMALL LETTER I
       (?$A#j(B . "0xFF4A") ;; FULLWIDTH LATIN SMALL LETTER J
       (?$A#k(B . "0xFF4B") ;; FULLWIDTH LATIN SMALL LETTER K
       (?$A#l(B . "0xFF4C") ;; FULLWIDTH LATIN SMALL LETTER L
       (?$A#m(B . "0xFF4D") ;; FULLWIDTH LATIN SMALL LETTER M
       (?$A#n(B . "0xFF4E") ;; FULLWIDTH LATIN SMALL LETTER N
       (?$A#o(B . "0xFF4F") ;; FULLWIDTH LATIN SMALL LETTER O
       (?$A#p(B . "0xFF50") ;; FULLWIDTH LATIN SMALL LETTER P
       (?$A#q(B . "0xFF51") ;; FULLWIDTH LATIN SMALL LETTER Q
       (?$A#r(B . "0xFF52") ;; FULLWIDTH LATIN SMALL LETTER R
       (?$A#s(B . "0xFF53") ;; FULLWIDTH LATIN SMALL LETTER S
       (?$A#t(B . "0xFF54") ;; FULLWIDTH LATIN SMALL LETTER T
       (?$A#u(B . "0xFF55") ;; FULLWIDTH LATIN SMALL LETTER U
       (?$A#v(B . "0xFF56") ;; FULLWIDTH LATIN SMALL LETTER V
       (?$A#w(B . "0xFF57") ;; FULLWIDTH LATIN SMALL LETTER W
       (?$A#x(B . "0xFF58") ;; FULLWIDTH LATIN SMALL LETTER X
       (?$A#y(B . "0xFF59") ;; FULLWIDTH LATIN SMALL LETTER Y
       (?$A#z(B . "0xFF5A") ;; FULLWIDTH LATIN SMALL LETTER Z
       (?$A#{(B . "0xFF5B") ;; FULLWIDTH LEFT CURLY BRACKET
       (?$A#|(B . "0xFF5C") ;; FULLWIDTH VERTICAL LINE
       (?$A#}(B . "0xFF5D") ;; FULLWIDTH RIGHT CURLY BRACKET
       (?$A#~(B . "0xFFE3") ;; FULLWIDTH MACRON
       (?$A$!(B . "0x3041") ;; HIRAGANA LETTER SMALL A
       (?$A$"(B . "0x3042") ;; HIRAGANA LETTER A
       (?$A$#(B . "0x3043") ;; HIRAGANA LETTER SMALL I
       (?$A$$(B . "0x3044") ;; HIRAGANA LETTER I
       (?$A$%(B . "0x3045") ;; HIRAGANA LETTER SMALL U
       (?$A$&(B . "0x3046") ;; HIRAGANA LETTER U
       (?$A$'(B . "0x3047") ;; HIRAGANA LETTER SMALL E
       (?$A$((B . "0x3048") ;; HIRAGANA LETTER E
       (?$A$)(B . "0x3049") ;; HIRAGANA LETTER SMALL O
       (?$A$*(B . "0x304A") ;; HIRAGANA LETTER O
       (?$A$+(B . "0x304B") ;; HIRAGANA LETTER KA
       (?$A$,(B . "0x304C") ;; HIRAGANA LETTER GA
       (?$A$-(B . "0x304D") ;; HIRAGANA LETTER KI
       (?$A$.(B . "0x304E") ;; HIRAGANA LETTER GI
       (?$A$/(B . "0x304F") ;; HIRAGANA LETTER KU
       (?$A$0(B . "0x3050") ;; HIRAGANA LETTER GU
       (?$A$1(B . "0x3051") ;; HIRAGANA LETTER KE
       (?$A$2(B . "0x3052") ;; HIRAGANA LETTER GE
       (?$A$3(B . "0x3053") ;; HIRAGANA LETTER KO
       (?$A$4(B . "0x3054") ;; HIRAGANA LETTER GO
       (?$A$5(B . "0x3055") ;; HIRAGANA LETTER SA
       (?$A$6(B . "0x3056") ;; HIRAGANA LETTER ZA
       (?$A$7(B . "0x3057") ;; HIRAGANA LETTER SI
       (?$A$8(B . "0x3058") ;; HIRAGANA LETTER ZI
       (?$A$9(B . "0x3059") ;; HIRAGANA LETTER SU
       (?$A$:(B . "0x305A") ;; HIRAGANA LETTER ZU
       (?$A$;(B . "0x305B") ;; HIRAGANA LETTER SE
       (?$A$<(B . "0x305C") ;; HIRAGANA LETTER ZE
       (?$A$=(B . "0x305D") ;; HIRAGANA LETTER SO
       (?$A$>(B . "0x305E") ;; HIRAGANA LETTER ZO
       (?$A$?(B . "0x305F") ;; HIRAGANA LETTER TA
       (?$A$@(B . "0x3060") ;; HIRAGANA LETTER DA
       (?$A$A(B . "0x3061") ;; HIRAGANA LETTER TI
       (?$A$B(B . "0x3062") ;; HIRAGANA LETTER DI
       (?$A$C(B . "0x3063") ;; HIRAGANA LETTER SMALL TU
       (?$A$D(B . "0x3064") ;; HIRAGANA LETTER TU
       (?$A$E(B . "0x3065") ;; HIRAGANA LETTER DU
       (?$A$F(B . "0x3066") ;; HIRAGANA LETTER TE
       (?$A$G(B . "0x3067") ;; HIRAGANA LETTER DE
       (?$A$H(B . "0x3068") ;; HIRAGANA LETTER TO
       (?$A$I(B . "0x3069") ;; HIRAGANA LETTER DO
       (?$A$J(B . "0x306A") ;; HIRAGANA LETTER NA
       (?$A$K(B . "0x306B") ;; HIRAGANA LETTER NI
       (?$A$L(B . "0x306C") ;; HIRAGANA LETTER NU
       (?$A$M(B . "0x306D") ;; HIRAGANA LETTER NE
       (?$A$N(B . "0x306E") ;; HIRAGANA LETTER NO
       (?$A$O(B . "0x306F") ;; HIRAGANA LETTER HA
       (?$A$P(B . "0x3070") ;; HIRAGANA LETTER BA
       (?$A$Q(B . "0x3071") ;; HIRAGANA LETTER PA
       (?$A$R(B . "0x3072") ;; HIRAGANA LETTER HI
       (?$A$S(B . "0x3073") ;; HIRAGANA LETTER BI
       (?$A$T(B . "0x3074") ;; HIRAGANA LETTER PI
       (?$A$U(B . "0x3075") ;; HIRAGANA LETTER HU
       (?$A$V(B . "0x3076") ;; HIRAGANA LETTER BU
       (?$A$W(B . "0x3077") ;; HIRAGANA LETTER PU
       (?$A$X(B . "0x3078") ;; HIRAGANA LETTER HE
       (?$A$Y(B . "0x3079") ;; HIRAGANA LETTER BE
       (?$A$Z(B . "0x307A") ;; HIRAGANA LETTER PE
       (?$A$[(B . "0x307B") ;; HIRAGANA LETTER HO
       (?$A$\(B . "0x307C") ;; HIRAGANA LETTER BO
       (?$A$](B . "0x307D") ;; HIRAGANA LETTER PO
       (?$A$^(B . "0x307E") ;; HIRAGANA LETTER MA
       (?$A$_(B . "0x307F") ;; HIRAGANA LETTER MI
       (?$A$`(B . "0x3080") ;; HIRAGANA LETTER MU
       (?$A$a(B . "0x3081") ;; HIRAGANA LETTER ME
       (?$A$b(B . "0x3082") ;; HIRAGANA LETTER MO
       (?$A$c(B . "0x3083") ;; HIRAGANA LETTER SMALL YA
       (?$A$d(B . "0x3084") ;; HIRAGANA LETTER YA
       (?$A$e(B . "0x3085") ;; HIRAGANA LETTER SMALL YU
       (?$A$f(B . "0x3086") ;; HIRAGANA LETTER YU
       (?$A$g(B . "0x3087") ;; HIRAGANA LETTER SMALL YO
       (?$A$h(B . "0x3088") ;; HIRAGANA LETTER YO
       (?$A$i(B . "0x3089") ;; HIRAGANA LETTER RA
       (?$A$j(B . "0x308A") ;; HIRAGANA LETTER RI
       (?$A$k(B . "0x308B") ;; HIRAGANA LETTER RU
       (?$A$l(B . "0x308C") ;; HIRAGANA LETTER RE
       (?$A$m(B . "0x308D") ;; HIRAGANA LETTER RO
       (?$A$n(B . "0x308E") ;; HIRAGANA LETTER SMALL WA
       (?$A$o(B . "0x308F") ;; HIRAGANA LETTER WA
       (?$A$p(B . "0x3090") ;; HIRAGANA LETTER WI
       (?$A$q(B . "0x3091") ;; HIRAGANA LETTER WE
       (?$A$r(B . "0x3092") ;; HIRAGANA LETTER WO
       (?$A$s(B . "0x3093") ;; HIRAGANA LETTER N
       (?$A%!(B . "0x30A1") ;; KATAKANA LETTER SMALL A
       (?$A%"(B . "0x30A2") ;; KATAKANA LETTER A
       (?$A%#(B . "0x30A3") ;; KATAKANA LETTER SMALL I
       (?$A%$(B . "0x30A4") ;; KATAKANA LETTER I
       (?$A%%(B . "0x30A5") ;; KATAKANA LETTER SMALL U
       (?$A%&(B . "0x30A6") ;; KATAKANA LETTER U
       (?$A%'(B . "0x30A7") ;; KATAKANA LETTER SMALL E
       (?$A%((B . "0x30A8") ;; KATAKANA LETTER E
       (?$A%)(B . "0x30A9") ;; KATAKANA LETTER SMALL O
       (?$A%*(B . "0x30AA") ;; KATAKANA LETTER O
       (?$A%+(B . "0x30AB") ;; KATAKANA LETTER KA
       (?$A%,(B . "0x30AC") ;; KATAKANA LETTER GA
       (?$A%-(B . "0x30AD") ;; KATAKANA LETTER KI
       (?$A%.(B . "0x30AE") ;; KATAKANA LETTER GI
       (?$A%/(B . "0x30AF") ;; KATAKANA LETTER KU
       (?$A%0(B . "0x30B0") ;; KATAKANA LETTER GU
       (?$A%1(B . "0x30B1") ;; KATAKANA LETTER KE
       (?$A%2(B . "0x30B2") ;; KATAKANA LETTER GE
       (?$A%3(B . "0x30B3") ;; KATAKANA LETTER KO
       (?$A%4(B . "0x30B4") ;; KATAKANA LETTER GO
       (?$A%5(B . "0x30B5") ;; KATAKANA LETTER SA
       (?$A%6(B . "0x30B6") ;; KATAKANA LETTER ZA
       (?$A%7(B . "0x30B7") ;; KATAKANA LETTER SI
       (?$A%8(B . "0x30B8") ;; KATAKANA LETTER ZI
       (?$A%9(B . "0x30B9") ;; KATAKANA LETTER SU
       (?$A%:(B . "0x30BA") ;; KATAKANA LETTER ZU
       (?$A%;(B . "0x30BB") ;; KATAKANA LETTER SE
       (?$A%<(B . "0x30BC") ;; KATAKANA LETTER ZE
       (?$A%=(B . "0x30BD") ;; KATAKANA LETTER SO
       (?$A%>(B . "0x30BE") ;; KATAKANA LETTER ZO
       (?$A%?(B . "0x30BF") ;; KATAKANA LETTER TA
       (?$A%@(B . "0x30C0") ;; KATAKANA LETTER DA
       (?$A%A(B . "0x30C1") ;; KATAKANA LETTER TI
       (?$A%B(B . "0x30C2") ;; KATAKANA LETTER DI
       (?$A%C(B . "0x30C3") ;; KATAKANA LETTER SMALL TU
       (?$A%D(B . "0x30C4") ;; KATAKANA LETTER TU
       (?$A%E(B . "0x30C5") ;; KATAKANA LETTER DU
       (?$A%F(B . "0x30C6") ;; KATAKANA LETTER TE
       (?$A%G(B . "0x30C7") ;; KATAKANA LETTER DE
       (?$A%H(B . "0x30C8") ;; KATAKANA LETTER TO
       (?$A%I(B . "0x30C9") ;; KATAKANA LETTER DO
       (?$A%J(B . "0x30CA") ;; KATAKANA LETTER NA
       (?$A%K(B . "0x30CB") ;; KATAKANA LETTER NI
       (?$A%L(B . "0x30CC") ;; KATAKANA LETTER NU
       (?$A%M(B . "0x30CD") ;; KATAKANA LETTER NE
       (?$A%N(B . "0x30CE") ;; KATAKANA LETTER NO
       (?$A%O(B . "0x30CF") ;; KATAKANA LETTER HA
       (?$A%P(B . "0x30D0") ;; KATAKANA LETTER BA
       (?$A%Q(B . "0x30D1") ;; KATAKANA LETTER PA
       (?$A%R(B . "0x30D2") ;; KATAKANA LETTER HI
       (?$A%S(B . "0x30D3") ;; KATAKANA LETTER BI
       (?$A%T(B . "0x30D4") ;; KATAKANA LETTER PI
       (?$A%U(B . "0x30D5") ;; KATAKANA LETTER HU
       (?$A%V(B . "0x30D6") ;; KATAKANA LETTER BU
       (?$A%W(B . "0x30D7") ;; KATAKANA LETTER PU
       (?$A%X(B . "0x30D8") ;; KATAKANA LETTER HE
       (?$A%Y(B . "0x30D9") ;; KATAKANA LETTER BE
       (?$A%Z(B . "0x30DA") ;; KATAKANA LETTER PE
       (?$A%[(B . "0x30DB") ;; KATAKANA LETTER HO
       (?$A%\(B . "0x30DC") ;; KATAKANA LETTER BO
       (?$A%](B . "0x30DD") ;; KATAKANA LETTER PO
       (?$A%^(B . "0x30DE") ;; KATAKANA LETTER MA
       (?$A%_(B . "0x30DF") ;; KATAKANA LETTER MI
       (?$A%`(B . "0x30E0") ;; KATAKANA LETTER MU
       (?$A%a(B . "0x30E1") ;; KATAKANA LETTER ME
       (?$A%b(B . "0x30E2") ;; KATAKANA LETTER MO
       (?$A%c(B . "0x30E3") ;; KATAKANA LETTER SMALL YA
       (?$A%d(B . "0x30E4") ;; KATAKANA LETTER YA
       (?$A%e(B . "0x30E5") ;; KATAKANA LETTER SMALL YU
       (?$A%f(B . "0x30E6") ;; KATAKANA LETTER YU
       (?$A%g(B . "0x30E7") ;; KATAKANA LETTER SMALL YO
       (?$A%h(B . "0x30E8") ;; KATAKANA LETTER YO
       (?$A%i(B . "0x30E9") ;; KATAKANA LETTER RA
       (?$A%j(B . "0x30EA") ;; KATAKANA LETTER RI
       (?$A%k(B . "0x30EB") ;; KATAKANA LETTER RU
       (?$A%l(B . "0x30EC") ;; KATAKANA LETTER RE
       (?$A%m(B . "0x30ED") ;; KATAKANA LETTER RO
       (?$A%n(B . "0x30EE") ;; KATAKANA LETTER SMALL WA
       (?$A%o(B . "0x30EF") ;; KATAKANA LETTER WA
       (?$A%p(B . "0x30F0") ;; KATAKANA LETTER WI
       (?$A%q(B . "0x30F1") ;; KATAKANA LETTER WE
       (?$A%r(B . "0x30F2") ;; KATAKANA LETTER WO
       (?$A%s(B . "0x30F3") ;; KATAKANA LETTER N
       (?$A%t(B . "0x30F4") ;; KATAKANA LETTER VU
       (?$A%u(B . "0x30F5") ;; KATAKANA LETTER SMALL KA
       (?$A%v(B . "0x30F6") ;; KATAKANA LETTER SMALL KE
       (?$A&!(B . "0x0391") ;; GREEK CAPITAL LETTER ALPHA
       (?$A&"(B . "0x0392") ;; GREEK CAPITAL LETTER BETA
       (?$A&#(B . "0x0393") ;; GREEK CAPITAL LETTER GAMMA
       (?$A&$(B . "0x0394") ;; GREEK CAPITAL LETTER DELTA
       (?$A&%(B . "0x0395") ;; GREEK CAPITAL LETTER EPSILON
       (?$A&&(B . "0x0396") ;; GREEK CAPITAL LETTER ZETA
       (?$A&'(B . "0x0397") ;; GREEK CAPITAL LETTER ETA
       (?$A&((B . "0x0398") ;; GREEK CAPITAL LETTER THETA
       (?$A&)(B . "0x0399") ;; GREEK CAPITAL LETTER IOTA
       (?$A&*(B . "0x039A") ;; GREEK CAPITAL LETTER KAPPA
       (?$A&+(B . "0x039B") ;; GREEK CAPITAL LETTER LAMDA
       (?$A&,(B . "0x039C") ;; GREEK CAPITAL LETTER MU
       (?$A&-(B . "0x039D") ;; GREEK CAPITAL LETTER NU
       (?$A&.(B . "0x039E") ;; GREEK CAPITAL LETTER XI
       (?$A&/(B . "0x039F") ;; GREEK CAPITAL LETTER OMICRON
       (?$A&0(B . "0x03A0") ;; GREEK CAPITAL LETTER PI
       (?$A&1(B . "0x03A1") ;; GREEK CAPITAL LETTER RHO
       (?$A&2(B . "0x03A3") ;; GREEK CAPITAL LETTER SIGMA
       (?$A&3(B . "0x03A4") ;; GREEK CAPITAL LETTER TAU
       (?$A&4(B . "0x03A5") ;; GREEK CAPITAL LETTER UPSILON
       (?$A&5(B . "0x03A6") ;; GREEK CAPITAL LETTER PHI
       (?$A&6(B . "0x03A7") ;; GREEK CAPITAL LETTER CHI
       (?$A&7(B . "0x03A8") ;; GREEK CAPITAL LETTER PSI
       (?$A&8(B . "0x03A9") ;; GREEK CAPITAL LETTER OMEGA
       (?$A&A(B . "0x03B1") ;; GREEK SMALL LETTER ALPHA
       (?$A&B(B . "0x03B2") ;; GREEK SMALL LETTER BETA
       (?$A&C(B . "0x03B3") ;; GREEK SMALL LETTER GAMMA
       (?$A&D(B . "0x03B4") ;; GREEK SMALL LETTER DELTA
       (?$A&E(B . "0x03B5") ;; GREEK SMALL LETTER EPSILON
       (?$A&F(B . "0x03B6") ;; GREEK SMALL LETTER ZETA
       (?$A&G(B . "0x03B7") ;; GREEK SMALL LETTER ETA
       (?$A&H(B . "0x03B8") ;; GREEK SMALL LETTER THETA
       (?$A&I(B . "0x03B9") ;; GREEK SMALL LETTER IOTA
       (?$A&J(B . "0x03BA") ;; GREEK SMALL LETTER KAPPA
       (?$A&K(B . "0x03BB") ;; GREEK SMALL LETTER LAMDA
       (?$A&L(B . "0x03BC") ;; GREEK SMALL LETTER MU
       (?$A&M(B . "0x03BD") ;; GREEK SMALL LETTER NU
       (?$A&N(B . "0x03BE") ;; GREEK SMALL LETTER XI
       (?$A&O(B . "0x03BF") ;; GREEK SMALL LETTER OMICRON
       (?$A&P(B . "0x03C0") ;; GREEK SMALL LETTER PI
       (?$A&Q(B . "0x03C1") ;; GREEK SMALL LETTER RHO
       (?$A&R(B . "0x03C3") ;; GREEK SMALL LETTER SIGMA
       (?$A&S(B . "0x03C4") ;; GREEK SMALL LETTER TAU
       (?$A&T(B . "0x03C5") ;; GREEK SMALL LETTER UPSILON
       (?$A&U(B . "0x03C6") ;; GREEK SMALL LETTER PHI
       (?$A&V(B . "0x03C7") ;; GREEK SMALL LETTER CHI
       (?$A&W(B . "0x03C8") ;; GREEK SMALL LETTER PSI
       (?$A&X(B . "0x03C9") ;; GREEK SMALL LETTER OMEGA
       (?$A'!(B . "0x0410") ;; CYRILLIC CAPITAL LETTER A
       (?$A'"(B . "0x0411") ;; CYRILLIC CAPITAL LETTER BE
       (?$A'#(B . "0x0412") ;; CYRILLIC CAPITAL LETTER VE
       (?$A'$(B . "0x0413") ;; CYRILLIC CAPITAL LETTER GHE
       (?$A'%(B . "0x0414") ;; CYRILLIC CAPITAL LETTER DE
       (?$A'&(B . "0x0415") ;; CYRILLIC CAPITAL LETTER IE
       (?$A''(B . "0x0401") ;; CYRILLIC CAPITAL LETTER IO
       (?$A'((B . "0x0416") ;; CYRILLIC CAPITAL LETTER ZHE
       (?$A')(B . "0x0417") ;; CYRILLIC CAPITAL LETTER ZE
       (?$A'*(B . "0x0418") ;; CYRILLIC CAPITAL LETTER I
       (?$A'+(B . "0x0419") ;; CYRILLIC CAPITAL LETTER SHORT I
       (?$A',(B . "0x041A") ;; CYRILLIC CAPITAL LETTER KA
       (?$A'-(B . "0x041B") ;; CYRILLIC CAPITAL LETTER EL
       (?$A'.(B . "0x041C") ;; CYRILLIC CAPITAL LETTER EM
       (?$A'/(B . "0x041D") ;; CYRILLIC CAPITAL LETTER EN
       (?$A'0(B . "0x041E") ;; CYRILLIC CAPITAL LETTER O
       (?$A'1(B . "0x041F") ;; CYRILLIC CAPITAL LETTER PE
       (?$A'2(B . "0x0420") ;; CYRILLIC CAPITAL LETTER ER
       (?$A'3(B . "0x0421") ;; CYRILLIC CAPITAL LETTER ES
       (?$A'4(B . "0x0422") ;; CYRILLIC CAPITAL LETTER TE
       (?$A'5(B . "0x0423") ;; CYRILLIC CAPITAL LETTER U
       (?$A'6(B . "0x0424") ;; CYRILLIC CAPITAL LETTER EF
       (?$A'7(B . "0x0425") ;; CYRILLIC CAPITAL LETTER HA
       (?$A'8(B . "0x0426") ;; CYRILLIC CAPITAL LETTER TSE
       (?$A'9(B . "0x0427") ;; CYRILLIC CAPITAL LETTER CHE
       (?$A':(B . "0x0428") ;; CYRILLIC CAPITAL LETTER SHA
       (?$A';(B . "0x0429") ;; CYRILLIC CAPITAL LETTER SHCHA
       (?$A'<(B . "0x042A") ;; CYRILLIC CAPITAL LETTER HARD SIGN
       (?$A'=(B . "0x042B") ;; CYRILLIC CAPITAL LETTER YERU
       (?$A'>(B . "0x042C") ;; CYRILLIC CAPITAL LETTER SOFT SIGN
       (?$A'?(B . "0x042D") ;; CYRILLIC CAPITAL LETTER E
       (?$A'@(B . "0x042E") ;; CYRILLIC CAPITAL LETTER YU
       (?$A'A(B . "0x042F") ;; CYRILLIC CAPITAL LETTER YA
       (?$A'Q(B . "0x0430") ;; CYRILLIC SMALL LETTER A
       (?$A'R(B . "0x0431") ;; CYRILLIC SMALL LETTER BE
       (?$A'S(B . "0x0432") ;; CYRILLIC SMALL LETTER VE
       (?$A'T(B . "0x0433") ;; CYRILLIC SMALL LETTER GHE
       (?$A'U(B . "0x0434") ;; CYRILLIC SMALL LETTER DE
       (?$A'V(B . "0x0435") ;; CYRILLIC SMALL LETTER IE
       (?$A'W(B . "0x0451") ;; CYRILLIC SMALL LETTER IO
       (?$A'X(B . "0x0436") ;; CYRILLIC SMALL LETTER ZHE
       (?$A'Y(B . "0x0437") ;; CYRILLIC SMALL LETTER ZE
       (?$A'Z(B . "0x0438") ;; CYRILLIC SMALL LETTER I
       (?$A'[(B . "0x0439") ;; CYRILLIC SMALL LETTER SHORT I
       (?$A'\(B . "0x043A") ;; CYRILLIC SMALL LETTER KA
       (?$A'](B . "0x043B") ;; CYRILLIC SMALL LETTER EL
       (?$A'^(B . "0x043C") ;; CYRILLIC SMALL LETTER EM
       (?$A'_(B . "0x043D") ;; CYRILLIC SMALL LETTER EN
       (?$A'`(B . "0x043E") ;; CYRILLIC SMALL LETTER O
       (?$A'a(B . "0x043F") ;; CYRILLIC SMALL LETTER PE
       (?$A'b(B . "0x0440") ;; CYRILLIC SMALL LETTER ER
       (?$A'c(B . "0x0441") ;; CYRILLIC SMALL LETTER ES
       (?$A'd(B . "0x0442") ;; CYRILLIC SMALL LETTER TE
       (?$A'e(B . "0x0443") ;; CYRILLIC SMALL LETTER U
       (?$A'f(B . "0x0444") ;; CYRILLIC SMALL LETTER EF
       (?$A'g(B . "0x0445") ;; CYRILLIC SMALL LETTER HA
       (?$A'h(B . "0x0446") ;; CYRILLIC SMALL LETTER TSE
       (?$A'i(B . "0x0447") ;; CYRILLIC SMALL LETTER CHE
       (?$A'j(B . "0x0448") ;; CYRILLIC SMALL LETTER SHA
       (?$A'k(B . "0x0449") ;; CYRILLIC SMALL LETTER SHCHA
       (?$A'l(B . "0x044A") ;; CYRILLIC SMALL LETTER HARD SIGN
       (?$A'm(B . "0x044B") ;; CYRILLIC SMALL LETTER YERU
       (?$A'n(B . "0x044C") ;; CYRILLIC SMALL LETTER SOFT SIGN
       (?$A'o(B . "0x044D") ;; CYRILLIC SMALL LETTER E
       (?$A'p(B . "0x044E") ;; CYRILLIC SMALL LETTER YU
       (?$A'q(B . "0x044F") ;; CYRILLIC SMALL LETTER YA
       (?$A(!(B . "0x0101") ;; LATIN SMALL LETTER A WITH MACRON
       (?$A("(B . "0x00E1") ;; LATIN SMALL LETTER A WITH ACUTE
       (?$A(#(B . "0x01CE") ;; LATIN SMALL LETTER A WITH CARON
       (?$A($(B . "0x00E0") ;; LATIN SMALL LETTER A WITH GRAVE
       (?$A(%(B . "0x0113") ;; LATIN SMALL LETTER E WITH MACRON
       (?$A(&(B . "0x00E9") ;; LATIN SMALL LETTER E WITH ACUTE
       (?$A('(B . "0x011B") ;; LATIN SMALL LETTER E WITH CARON
       (?$A(((B . "0x00E8") ;; LATIN SMALL LETTER E WITH GRAVE
       (?$A()(B . "0x012B") ;; LATIN SMALL LETTER I WITH MACRON
       (?$A(*(B . "0x00ED") ;; LATIN SMALL LETTER I WITH ACUTE
       (?$A(+(B . "0x01D0") ;; LATIN SMALL LETTER I WITH CARON
       (?$A(,(B . "0x00EC") ;; LATIN SMALL LETTER I WITH GRAVE
       (?$A(-(B . "0x014D") ;; LATIN SMALL LETTER O WITH MACRON
       (?$A(.(B . "0x00F3") ;; LATIN SMALL LETTER O WITH ACUTE
       (?$A(/(B . "0x01D2") ;; LATIN SMALL LETTER O WITH CARON
       (?$A(0(B . "0x00F2") ;; LATIN SMALL LETTER O WITH GRAVE
       (?$A(1(B . "0x016B") ;; LATIN SMALL LETTER U WITH MACRON
       (?$A(2(B . "0x00FA") ;; LATIN SMALL LETTER U WITH ACUTE
       (?$A(3(B . "0x01D4") ;; LATIN SMALL LETTER U WITH CARON
       (?$A(4(B . "0x00F9") ;; LATIN SMALL LETTER U WITH GRAVE
       (?$A(5(B . "0x01D6") ;; LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
       (?$A(6(B . "0x01D8") ;; LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
       (?$A(7(B . "0x01DA") ;; LATIN SMALL LETTER U WITH DIAERESIS AND CARON
       (?$A(8(B . "0x01DC") ;; LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
       (?$A(9(B . "0x00FC") ;; LATIN SMALL LETTER U WITH DIAERESIS
       (?$A(:(B . "0x00EA") ;; LATIN SMALL LETTER E WITH CIRCUMFLEX
       (?$A(E(B . "0x3105") ;; BOPOMOFO LETTER B
       (?$A(F(B . "0x3106") ;; BOPOMOFO LETTER P
       (?$A(G(B . "0x3107") ;; BOPOMOFO LETTER M
       (?$A(H(B . "0x3108") ;; BOPOMOFO LETTER F
       (?$A(I(B . "0x3109") ;; BOPOMOFO LETTER D
       (?$A(J(B . "0x310A") ;; BOPOMOFO LETTER T
       (?$A(K(B . "0x310B") ;; BOPOMOFO LETTER N
       (?$A(L(B . "0x310C") ;; BOPOMOFO LETTER L
       (?$A(M(B . "0x310D") ;; BOPOMOFO LETTER G
       (?$A(N(B . "0x310E") ;; BOPOMOFO LETTER K
       (?$A(O(B . "0x310F") ;; BOPOMOFO LETTER H
       (?$A(P(B . "0x3110") ;; BOPOMOFO LETTER J
       (?$A(Q(B . "0x3111") ;; BOPOMOFO LETTER Q
       (?$A(R(B . "0x3112") ;; BOPOMOFO LETTER X
       (?$A(S(B . "0x3113") ;; BOPOMOFO LETTER ZH
       (?$A(T(B . "0x3114") ;; BOPOMOFO LETTER CH
       (?$A(U(B . "0x3115") ;; BOPOMOFO LETTER SH
       (?$A(V(B . "0x3116") ;; BOPOMOFO LETTER R
       (?$A(W(B . "0x3117") ;; BOPOMOFO LETTER Z
       (?$A(X(B . "0x3118") ;; BOPOMOFO LETTER C
       (?$A(Y(B . "0x3119") ;; BOPOMOFO LETTER S
       (?$A(Z(B . "0x311A") ;; BOPOMOFO LETTER A
       (?$A([(B . "0x311B") ;; BOPOMOFO LETTER O
       (?$A(\(B . "0x311C") ;; BOPOMOFO LETTER E
       (?$A(](B . "0x311D") ;; BOPOMOFO LETTER EH
       (?$A(^(B . "0x311E") ;; BOPOMOFO LETTER AI
       (?$A(_(B . "0x311F") ;; BOPOMOFO LETTER EI
       (?$A(`(B . "0x3120") ;; BOPOMOFO LETTER AU
       (?$A(a(B . "0x3121") ;; BOPOMOFO LETTER OU
       (?$A(b(B . "0x3122") ;; BOPOMOFO LETTER AN
       (?$A(c(B . "0x3123") ;; BOPOMOFO LETTER EN
       (?$A(d(B . "0x3124") ;; BOPOMOFO LETTER ANG
       (?$A(e(B . "0x3125") ;; BOPOMOFO LETTER ENG
       (?$A(f(B . "0x3126") ;; BOPOMOFO LETTER ER
       (?$A(g(B . "0x3127") ;; BOPOMOFO LETTER I
       (?$A(h(B . "0x3128") ;; BOPOMOFO LETTER U
       (?$A(i(B . "0x3129") ;; BOPOMOFO LETTER IU
       (?$A)$(B . "0x2500") ;; BOX DRAWINGS LIGHT HORIZONTAL
       (?$A)%(B . "0x2501") ;; BOX DRAWINGS HEAVY HORIZONTAL
       (?$A)&(B . "0x2502") ;; BOX DRAWINGS LIGHT VERTICAL
       (?$A)'(B . "0x2503") ;; BOX DRAWINGS HEAVY VERTICAL
       (?$A)((B . "0x2504") ;; BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL
       (?$A))(B . "0x2505") ;; BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL
       (?$A)*(B . "0x2506") ;; BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL
       (?$A)+(B . "0x2507") ;; BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL
       (?$A),(B . "0x2508") ;; BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL
       (?$A)-(B . "0x2509") ;; BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL
       (?$A).(B . "0x250A") ;; BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL
       (?$A)/(B . "0x250B") ;; BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL
       (?$A)0(B . "0x250C") ;; BOX DRAWINGS LIGHT DOWN AND RIGHT
       (?$A)1(B . "0x250D") ;; BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY
       (?$A)2(B . "0x250E") ;; BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT
       (?$A)3(B . "0x250F") ;; BOX DRAWINGS HEAVY DOWN AND RIGHT
       (?$A)4(B . "0x2510") ;; BOX DRAWINGS LIGHT DOWN AND LEFT
       (?$A)5(B . "0x2511") ;; BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY
       (?$A)6(B . "0x2512") ;; BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT
       (?$A)7(B . "0x2513") ;; BOX DRAWINGS HEAVY DOWN AND LEFT
       (?$A)8(B . "0x2514") ;; BOX DRAWINGS LIGHT UP AND RIGHT
       (?$A)9(B . "0x2515") ;; BOX DRAWINGS UP LIGHT AND RIGHT HEAVY
       (?$A):(B . "0x2516") ;; BOX DRAWINGS UP HEAVY AND RIGHT LIGHT
       (?$A);(B . "0x2517") ;; BOX DRAWINGS HEAVY UP AND RIGHT
       (?$A)<(B . "0x2518") ;; BOX DRAWINGS LIGHT UP AND LEFT
       (?$A)=(B . "0x2519") ;; BOX DRAWINGS UP LIGHT AND LEFT HEAVY
       (?$A)>(B . "0x251A") ;; BOX DRAWINGS UP HEAVY AND LEFT LIGHT
       (?$A)?(B . "0x251B") ;; BOX DRAWINGS HEAVY UP AND LEFT
       (?$A)@(B . "0x251C") ;; BOX DRAWINGS LIGHT VERTICAL AND RIGHT
       (?$A)A(B . "0x251D") ;; BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
       (?$A)B(B . "0x251E") ;; BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT
       (?$A)C(B . "0x251F") ;; BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT
       (?$A)D(B . "0x2520") ;; BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
       (?$A)E(B . "0x2521") ;; BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY
       (?$A)F(B . "0x2522") ;; BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY
       (?$A)G(B . "0x2523") ;; BOX DRAWINGS HEAVY VERTICAL AND RIGHT
       (?$A)H(B . "0x2524") ;; BOX DRAWINGS LIGHT VERTICAL AND LEFT
       (?$A)I(B . "0x2525") ;; BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
       (?$A)J(B . "0x2526") ;; BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT
       (?$A)K(B . "0x2527") ;; BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT
       (?$A)L(B . "0x2528") ;; BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
       (?$A)M(B . "0x2529") ;; BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY
       (?$A)N(B . "0x252A") ;; BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY
       (?$A)O(B . "0x252B") ;; BOX DRAWINGS HEAVY VERTICAL AND LEFT
       (?$A)P(B . "0x252C") ;; BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
       (?$A)Q(B . "0x252D") ;; BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT
       (?$A)R(B . "0x252E") ;; BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT
       (?$A)S(B . "0x252F") ;; BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
       (?$A)T(B . "0x2530") ;; BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
       (?$A)U(B . "0x2531") ;; BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY
       (?$A)V(B . "0x2532") ;; BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY
       (?$A)W(B . "0x2533") ;; BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
       (?$A)X(B . "0x2534") ;; BOX DRAWINGS LIGHT UP AND HORIZONTAL
       (?$A)Y(B . "0x2535") ;; BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT
       (?$A)Z(B . "0x2536") ;; BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT
       (?$A)[(B . "0x2537") ;; BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
       (?$A)\(B . "0x2538") ;; BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
       (?$A)](B . "0x2539") ;; BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY
       (?$A)^(B . "0x253A") ;; BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY
       (?$A)_(B . "0x253B") ;; BOX DRAWINGS HEAVY UP AND HORIZONTAL
       (?$A)`(B . "0x253C") ;; BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
       (?$A)a(B . "0x253D") ;; BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT
       (?$A)b(B . "0x253E") ;; BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT
       (?$A)c(B . "0x253F") ;; BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
       (?$A)d(B . "0x2540") ;; BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT
       (?$A)e(B . "0x2541") ;; BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT
       (?$A)f(B . "0x2542") ;; BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
       (?$A)g(B . "0x2543") ;; BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT
       (?$A)h(B . "0x2544") ;; BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT
       (?$A)i(B . "0x2545") ;; BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT
       (?$A)j(B . "0x2546") ;; BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT
       (?$A)k(B . "0x2547") ;; BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY
       (?$A)l(B . "0x2548") ;; BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY
       (?$A)m(B . "0x2549") ;; BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY
       (?$A)n(B . "0x254A") ;; BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY
       (?$A)o(B . "0x254B") ;; BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
       (?$A0!(B . "0x554A") ;; <CJK>
       (?$A0"(B . "0x963F") ;; <CJK>
       (?$A0#(B . "0x57C3") ;; <CJK>
       (?$A0$(B . "0x6328") ;; <CJK>
       (?$A0%(B . "0x54CE") ;; <CJK>
       (?$A0&(B . "0x5509") ;; <CJK>
       (?$A0'(B . "0x54C0") ;; <CJK>
       (?$A0((B . "0x7691") ;; <CJK>
       (?$A0)(B . "0x764C") ;; <CJK>
       (?$A0*(B . "0x853C") ;; <CJK>
       (?$A0+(B . "0x77EE") ;; <CJK>
       (?$A0,(B . "0x827E") ;; <CJK>
       (?$A0-(B . "0x788D") ;; <CJK>
       (?$A0.(B . "0x7231") ;; <CJK>
       (?$A0/(B . "0x9698") ;; <CJK>
       (?$A00(B . "0x978D") ;; <CJK>
       (?$A01(B . "0x6C28") ;; <CJK>
       (?$A02(B . "0x5B89") ;; <CJK>
       (?$A03(B . "0x4FFA") ;; <CJK>
       (?$A04(B . "0x6309") ;; <CJK>
       (?$A05(B . "0x6697") ;; <CJK>
       (?$A06(B . "0x5CB8") ;; <CJK>
       (?$A07(B . "0x80FA") ;; <CJK>
       (?$A08(B . "0x6848") ;; <CJK>
       (?$A09(B . "0x80AE") ;; <CJK>
       (?$A0:(B . "0x6602") ;; <CJK>
       (?$A0;(B . "0x76CE") ;; <CJK>
       (?$A0<(B . "0x51F9") ;; <CJK>
       (?$A0=(B . "0x6556") ;; <CJK>
       (?$A0>(B . "0x71AC") ;; <CJK>
       (?$A0?(B . "0x7FF1") ;; <CJK>
       (?$A0@(B . "0x8884") ;; <CJK>
       (?$A0A(B . "0x50B2") ;; <CJK>
       (?$A0B(B . "0x5965") ;; <CJK>
       (?$A0C(B . "0x61CA") ;; <CJK>
       (?$A0D(B . "0x6FB3") ;; <CJK>
       (?$A0E(B . "0x82AD") ;; <CJK>
       (?$A0F(B . "0x634C") ;; <CJK>
       (?$A0G(B . "0x6252") ;; <CJK>
       (?$A0H(B . "0x53ED") ;; <CJK>
       (?$A0I(B . "0x5427") ;; <CJK>
       (?$A0J(B . "0x7B06") ;; <CJK>
       (?$A0K(B . "0x516B") ;; <CJK>
       (?$A0L(B . "0x75A4") ;; <CJK>
       (?$A0M(B . "0x5DF4") ;; <CJK>
       (?$A0N(B . "0x62D4") ;; <CJK>
       (?$A0O(B . "0x8DCB") ;; <CJK>
       (?$A0P(B . "0x9776") ;; <CJK>
       (?$A0Q(B . "0x628A") ;; <CJK>
       (?$A0R(B . "0x8019") ;; <CJK>
       (?$A0S(B . "0x575D") ;; <CJK>
       (?$A0T(B . "0x9738") ;; <CJK>
       (?$A0U(B . "0x7F62") ;; <CJK>
       (?$A0V(B . "0x7238") ;; <CJK>
       (?$A0W(B . "0x767D") ;; <CJK>
       (?$A0X(B . "0x67CF") ;; <CJK>
       (?$A0Y(B . "0x767E") ;; <CJK>
       (?$A0Z(B . "0x6446") ;; <CJK>
       (?$A0[(B . "0x4F70") ;; <CJK>
       (?$A0\(B . "0x8D25") ;; <CJK>
       (?$A0](B . "0x62DC") ;; <CJK>
       (?$A0^(B . "0x7A17") ;; <CJK>
       (?$A0_(B . "0x6591") ;; <CJK>
       (?$A0`(B . "0x73ED") ;; <CJK>
       (?$A0a(B . "0x642C") ;; <CJK>
       (?$A0b(B . "0x6273") ;; <CJK>
       (?$A0c(B . "0x822C") ;; <CJK>
       (?$A0d(B . "0x9881") ;; <CJK>
       (?$A0e(B . "0x677F") ;; <CJK>
       (?$A0f(B . "0x7248") ;; <CJK>
       (?$A0g(B . "0x626E") ;; <CJK>
       (?$A0h(B . "0x62CC") ;; <CJK>
       (?$A0i(B . "0x4F34") ;; <CJK>
       (?$A0j(B . "0x74E3") ;; <CJK>
       (?$A0k(B . "0x534A") ;; <CJK>
       (?$A0l(B . "0x529E") ;; <CJK>
       (?$A0m(B . "0x7ECA") ;; <CJK>
       (?$A0n(B . "0x90A6") ;; <CJK>
       (?$A0o(B . "0x5E2E") ;; <CJK>
       (?$A0p(B . "0x6886") ;; <CJK>
       (?$A0q(B . "0x699C") ;; <CJK>
       (?$A0r(B . "0x8180") ;; <CJK>
       (?$A0s(B . "0x7ED1") ;; <CJK>
       (?$A0t(B . "0x68D2") ;; <CJK>
       (?$A0u(B . "0x78C5") ;; <CJK>
       (?$A0v(B . "0x868C") ;; <CJK>
       (?$A0w(B . "0x9551") ;; <CJK>
       (?$A0x(B . "0x508D") ;; <CJK>
       (?$A0y(B . "0x8C24") ;; <CJK>
       (?$A0z(B . "0x82DE") ;; <CJK>
       (?$A0{(B . "0x80DE") ;; <CJK>
       (?$A0|(B . "0x5305") ;; <CJK>
       (?$A0}(B . "0x8912") ;; <CJK>
       (?$A0~(B . "0x5265") ;; <CJK>
       (?$A1!(B . "0x8584") ;; <CJK>
       (?$A1"(B . "0x96F9") ;; <CJK>
       (?$A1#(B . "0x4FDD") ;; <CJK>
       (?$A1$(B . "0x5821") ;; <CJK>
       (?$A1%(B . "0x9971") ;; <CJK>
       (?$A1&(B . "0x5B9D") ;; <CJK>
       (?$A1'(B . "0x62B1") ;; <CJK>
       (?$A1((B . "0x62A5") ;; <CJK>
       (?$A1)(B . "0x66B4") ;; <CJK>
       (?$A1*(B . "0x8C79") ;; <CJK>
       (?$A1+(B . "0x9C8D") ;; <CJK>
       (?$A1,(B . "0x7206") ;; <CJK>
       (?$A1-(B . "0x676F") ;; <CJK>
       (?$A1.(B . "0x7891") ;; <CJK>
       (?$A1/(B . "0x60B2") ;; <CJK>
       (?$A10(B . "0x5351") ;; <CJK>
       (?$A11(B . "0x5317") ;; <CJK>
       (?$A12(B . "0x8F88") ;; <CJK>
       (?$A13(B . "0x80CC") ;; <CJK>
       (?$A14(B . "0x8D1D") ;; <CJK>
       (?$A15(B . "0x94A1") ;; <CJK>
       (?$A16(B . "0x500D") ;; <CJK>
       (?$A17(B . "0x72C8") ;; <CJK>
       (?$A18(B . "0x5907") ;; <CJK>
       (?$A19(B . "0x60EB") ;; <CJK>
       (?$A1:(B . "0x7119") ;; <CJK>
       (?$A1;(B . "0x88AB") ;; <CJK>
       (?$A1<(B . "0x5954") ;; <CJK>
       (?$A1=(B . "0x82EF") ;; <CJK>
       (?$A1>(B . "0x672C") ;; <CJK>
       (?$A1?(B . "0x7B28") ;; <CJK>
       (?$A1@(B . "0x5D29") ;; <CJK>
       (?$A1A(B . "0x7EF7") ;; <CJK>
       (?$A1B(B . "0x752D") ;; <CJK>
       (?$A1C(B . "0x6CF5") ;; <CJK>
       (?$A1D(B . "0x8E66") ;; <CJK>
       (?$A1E(B . "0x8FF8") ;; <CJK>
       (?$A1F(B . "0x903C") ;; <CJK>
       (?$A1G(B . "0x9F3B") ;; <CJK>
       (?$A1H(B . "0x6BD4") ;; <CJK>
       (?$A1I(B . "0x9119") ;; <CJK>
       (?$A1J(B . "0x7B14") ;; <CJK>
       (?$A1K(B . "0x5F7C") ;; <CJK>
       (?$A1L(B . "0x78A7") ;; <CJK>
       (?$A1M(B . "0x84D6") ;; <CJK>
       (?$A1N(B . "0x853D") ;; <CJK>
       (?$A1O(B . "0x6BD5") ;; <CJK>
       (?$A1P(B . "0x6BD9") ;; <CJK>
       (?$A1Q(B . "0x6BD6") ;; <CJK>
       (?$A1R(B . "0x5E01") ;; <CJK>
       (?$A1S(B . "0x5E87") ;; <CJK>
       (?$A1T(B . "0x75F9") ;; <CJK>
       (?$A1U(B . "0x95ED") ;; <CJK>
       (?$A1V(B . "0x655D") ;; <CJK>
       (?$A1W(B . "0x5F0A") ;; <CJK>
       (?$A1X(B . "0x5FC5") ;; <CJK>
       (?$A1Y(B . "0x8F9F") ;; <CJK>
       (?$A1Z(B . "0x58C1") ;; <CJK>
       (?$A1[(B . "0x81C2") ;; <CJK>
       (?$A1\(B . "0x907F") ;; <CJK>
       (?$A1](B . "0x965B") ;; <CJK>
       (?$A1^(B . "0x97AD") ;; <CJK>
       (?$A1_(B . "0x8FB9") ;; <CJK>
       (?$A1`(B . "0x7F16") ;; <CJK>
       (?$A1a(B . "0x8D2C") ;; <CJK>
       (?$A1b(B . "0x6241") ;; <CJK>
       (?$A1c(B . "0x4FBF") ;; <CJK>
       (?$A1d(B . "0x53D8") ;; <CJK>
       (?$A1e(B . "0x535E") ;; <CJK>
       (?$A1f(B . "0x8FA8") ;; <CJK>
       (?$A1g(B . "0x8FA9") ;; <CJK>
       (?$A1h(B . "0x8FAB") ;; <CJK>
       (?$A1i(B . "0x904D") ;; <CJK>
       (?$A1j(B . "0x6807") ;; <CJK>
       (?$A1k(B . "0x5F6A") ;; <CJK>
       (?$A1l(B . "0x8198") ;; <CJK>
       (?$A1m(B . "0x8868") ;; <CJK>
       (?$A1n(B . "0x9CD6") ;; <CJK>
       (?$A1o(B . "0x618B") ;; <CJK>
       (?$A1p(B . "0x522B") ;; <CJK>
       (?$A1q(B . "0x762A") ;; <CJK>
       (?$A1r(B . "0x5F6C") ;; <CJK>
       (?$A1s(B . "0x658C") ;; <CJK>
       (?$A1t(B . "0x6FD2") ;; <CJK>
       (?$A1u(B . "0x6EE8") ;; <CJK>
       (?$A1v(B . "0x5BBE") ;; <CJK>
       (?$A1w(B . "0x6448") ;; <CJK>
       (?$A1x(B . "0x5175") ;; <CJK>
       (?$A1y(B . "0x51B0") ;; <CJK>
       (?$A1z(B . "0x67C4") ;; <CJK>
       (?$A1{(B . "0x4E19") ;; <CJK>
       (?$A1|(B . "0x79C9") ;; <CJK>
       (?$A1}(B . "0x997C") ;; <CJK>
       (?$A1~(B . "0x70B3") ;; <CJK>
       (?$A2!(B . "0x75C5") ;; <CJK>
       (?$A2"(B . "0x5E76") ;; <CJK>
       (?$A2#(B . "0x73BB") ;; <CJK>
       (?$A2$(B . "0x83E0") ;; <CJK>
       (?$A2%(B . "0x64AD") ;; <CJK>
       (?$A2&(B . "0x62E8") ;; <CJK>
       (?$A2'(B . "0x94B5") ;; <CJK>
       (?$A2((B . "0x6CE2") ;; <CJK>
       (?$A2)(B . "0x535A") ;; <CJK>
       (?$A2*(B . "0x52C3") ;; <CJK>
       (?$A2+(B . "0x640F") ;; <CJK>
       (?$A2,(B . "0x94C2") ;; <CJK>
       (?$A2-(B . "0x7B94") ;; <CJK>
       (?$A2.(B . "0x4F2F") ;; <CJK>
       (?$A2/(B . "0x5E1B") ;; <CJK>
       (?$A20(B . "0x8236") ;; <CJK>
       (?$A21(B . "0x8116") ;; <CJK>
       (?$A22(B . "0x818A") ;; <CJK>
       (?$A23(B . "0x6E24") ;; <CJK>
       (?$A24(B . "0x6CCA") ;; <CJK>
       (?$A25(B . "0x9A73") ;; <CJK>
       (?$A26(B . "0x6355") ;; <CJK>
       (?$A27(B . "0x535C") ;; <CJK>
       (?$A28(B . "0x54FA") ;; <CJK>
       (?$A29(B . "0x8865") ;; <CJK>
       (?$A2:(B . "0x57E0") ;; <CJK>
       (?$A2;(B . "0x4E0D") ;; <CJK>
       (?$A2<(B . "0x5E03") ;; <CJK>
       (?$A2=(B . "0x6B65") ;; <CJK>
       (?$A2>(B . "0x7C3F") ;; <CJK>
       (?$A2?(B . "0x90E8") ;; <CJK>
       (?$A2@(B . "0x6016") ;; <CJK>
       (?$A2A(B . "0x64E6") ;; <CJK>
       (?$A2B(B . "0x731C") ;; <CJK>
       (?$A2C(B . "0x88C1") ;; <CJK>
       (?$A2D(B . "0x6750") ;; <CJK>
       (?$A2E(B . "0x624D") ;; <CJK>
       (?$A2F(B . "0x8D22") ;; <CJK>
       (?$A2G(B . "0x776C") ;; <CJK>
       (?$A2H(B . "0x8E29") ;; <CJK>
       (?$A2I(B . "0x91C7") ;; <CJK>
       (?$A2J(B . "0x5F69") ;; <CJK>
       (?$A2K(B . "0x83DC") ;; <CJK>
       (?$A2L(B . "0x8521") ;; <CJK>
       (?$A2M(B . "0x9910") ;; <CJK>
       (?$A2N(B . "0x53C2") ;; <CJK>
       (?$A2O(B . "0x8695") ;; <CJK>
       (?$A2P(B . "0x6B8B") ;; <CJK>
       (?$A2Q(B . "0x60ED") ;; <CJK>
       (?$A2R(B . "0x60E8") ;; <CJK>
       (?$A2S(B . "0x707F") ;; <CJK>
       (?$A2T(B . "0x82CD") ;; <CJK>
       (?$A2U(B . "0x8231") ;; <CJK>
       (?$A2V(B . "0x4ED3") ;; <CJK>
       (?$A2W(B . "0x6CA7") ;; <CJK>
       (?$A2X(B . "0x85CF") ;; <CJK>
       (?$A2Y(B . "0x64CD") ;; <CJK>
       (?$A2Z(B . "0x7CD9") ;; <CJK>
       (?$A2[(B . "0x69FD") ;; <CJK>
       (?$A2\(B . "0x66F9") ;; <CJK>
       (?$A2](B . "0x8349") ;; <CJK>
       (?$A2^(B . "0x5395") ;; <CJK>
       (?$A2_(B . "0x7B56") ;; <CJK>
       (?$A2`(B . "0x4FA7") ;; <CJK>
       (?$A2a(B . "0x518C") ;; <CJK>
       (?$A2b(B . "0x6D4B") ;; <CJK>
       (?$A2c(B . "0x5C42") ;; <CJK>
       (?$A2d(B . "0x8E6D") ;; <CJK>
       (?$A2e(B . "0x63D2") ;; <CJK>
       (?$A2f(B . "0x53C9") ;; <CJK>
       (?$A2g(B . "0x832C") ;; <CJK>
       (?$A2h(B . "0x8336") ;; <CJK>
       (?$A2i(B . "0x67E5") ;; <CJK>
       (?$A2j(B . "0x78B4") ;; <CJK>
       (?$A2k(B . "0x643D") ;; <CJK>
       (?$A2l(B . "0x5BDF") ;; <CJK>
       (?$A2m(B . "0x5C94") ;; <CJK>
       (?$A2n(B . "0x5DEE") ;; <CJK>
       (?$A2o(B . "0x8BE7") ;; <CJK>
       (?$A2p(B . "0x62C6") ;; <CJK>
       (?$A2q(B . "0x67F4") ;; <CJK>
       (?$A2r(B . "0x8C7A") ;; <CJK>
       (?$A2s(B . "0x6400") ;; <CJK>
       (?$A2t(B . "0x63BA") ;; <CJK>
       (?$A2u(B . "0x8749") ;; <CJK>
       (?$A2v(B . "0x998B") ;; <CJK>
       (?$A2w(B . "0x8C17") ;; <CJK>
       (?$A2x(B . "0x7F20") ;; <CJK>
       (?$A2y(B . "0x94F2") ;; <CJK>
       (?$A2z(B . "0x4EA7") ;; <CJK>
       (?$A2{(B . "0x9610") ;; <CJK>
       (?$A2|(B . "0x98A4") ;; <CJK>
       (?$A2}(B . "0x660C") ;; <CJK>
       (?$A2~(B . "0x7316") ;; <CJK>
       (?$A3!(B . "0x573A") ;; <CJK>
       (?$A3"(B . "0x5C1D") ;; <CJK>
       (?$A3#(B . "0x5E38") ;; <CJK>
       (?$A3$(B . "0x957F") ;; <CJK>
       (?$A3%(B . "0x507F") ;; <CJK>
       (?$A3&(B . "0x80A0") ;; <CJK>
       (?$A3'(B . "0x5382") ;; <CJK>
       (?$A3((B . "0x655E") ;; <CJK>
       (?$A3)(B . "0x7545") ;; <CJK>
       (?$A3*(B . "0x5531") ;; <CJK>
       (?$A3+(B . "0x5021") ;; <CJK>
       (?$A3,(B . "0x8D85") ;; <CJK>
       (?$A3-(B . "0x6284") ;; <CJK>
       (?$A3.(B . "0x949E") ;; <CJK>
       (?$A3/(B . "0x671D") ;; <CJK>
       (?$A30(B . "0x5632") ;; <CJK>
       (?$A31(B . "0x6F6E") ;; <CJK>
       (?$A32(B . "0x5DE2") ;; <CJK>
       (?$A33(B . "0x5435") ;; <CJK>
       (?$A34(B . "0x7092") ;; <CJK>
       (?$A35(B . "0x8F66") ;; <CJK>
       (?$A36(B . "0x626F") ;; <CJK>
       (?$A37(B . "0x64A4") ;; <CJK>
       (?$A38(B . "0x63A3") ;; <CJK>
       (?$A39(B . "0x5F7B") ;; <CJK>
       (?$A3:(B . "0x6F88") ;; <CJK>
       (?$A3;(B . "0x90F4") ;; <CJK>
       (?$A3<(B . "0x81E3") ;; <CJK>
       (?$A3=(B . "0x8FB0") ;; <CJK>
       (?$A3>(B . "0x5C18") ;; <CJK>
       (?$A3?(B . "0x6668") ;; <CJK>
       (?$A3@(B . "0x5FF1") ;; <CJK>
       (?$A3A(B . "0x6C89") ;; <CJK>
       (?$A3B(B . "0x9648") ;; <CJK>
       (?$A3C(B . "0x8D81") ;; <CJK>
       (?$A3D(B . "0x886C") ;; <CJK>
       (?$A3E(B . "0x6491") ;; <CJK>
       (?$A3F(B . "0x79F0") ;; <CJK>
       (?$A3G(B . "0x57CE") ;; <CJK>
       (?$A3H(B . "0x6A59") ;; <CJK>
       (?$A3I(B . "0x6210") ;; <CJK>
       (?$A3J(B . "0x5448") ;; <CJK>
       (?$A3K(B . "0x4E58") ;; <CJK>
       (?$A3L(B . "0x7A0B") ;; <CJK>
       (?$A3M(B . "0x60E9") ;; <CJK>
       (?$A3N(B . "0x6F84") ;; <CJK>
       (?$A3O(B . "0x8BDA") ;; <CJK>
       (?$A3P(B . "0x627F") ;; <CJK>
       (?$A3Q(B . "0x901E") ;; <CJK>
       (?$A3R(B . "0x9A8B") ;; <CJK>
       (?$A3S(B . "0x79E4") ;; <CJK>
       (?$A3T(B . "0x5403") ;; <CJK>
       (?$A3U(B . "0x75F4") ;; <CJK>
       (?$A3V(B . "0x6301") ;; <CJK>
       (?$A3W(B . "0x5319") ;; <CJK>
       (?$A3X(B . "0x6C60") ;; <CJK>
       (?$A3Y(B . "0x8FDF") ;; <CJK>
       (?$A3Z(B . "0x5F1B") ;; <CJK>
       (?$A3[(B . "0x9A70") ;; <CJK>
       (?$A3\(B . "0x803B") ;; <CJK>
       (?$A3](B . "0x9F7F") ;; <CJK>
       (?$A3^(B . "0x4F88") ;; <CJK>
       (?$A3_(B . "0x5C3A") ;; <CJK>
       (?$A3`(B . "0x8D64") ;; <CJK>
       (?$A3a(B . "0x7FC5") ;; <CJK>
       (?$A3b(B . "0x65A5") ;; <CJK>
       (?$A3c(B . "0x70BD") ;; <CJK>
       (?$A3d(B . "0x5145") ;; <CJK>
       (?$A3e(B . "0x51B2") ;; <CJK>
       (?$A3f(B . "0x866B") ;; <CJK>
       (?$A3g(B . "0x5D07") ;; <CJK>
       (?$A3h(B . "0x5BA0") ;; <CJK>
       (?$A3i(B . "0x62BD") ;; <CJK>
       (?$A3j(B . "0x916C") ;; <CJK>
       (?$A3k(B . "0x7574") ;; <CJK>
       (?$A3l(B . "0x8E0C") ;; <CJK>
       (?$A3m(B . "0x7A20") ;; <CJK>
       (?$A3n(B . "0x6101") ;; <CJK>
       (?$A3o(B . "0x7B79") ;; <CJK>
       (?$A3p(B . "0x4EC7") ;; <CJK>
       (?$A3q(B . "0x7EF8") ;; <CJK>
       (?$A3r(B . "0x7785") ;; <CJK>
       (?$A3s(B . "0x4E11") ;; <CJK>
       (?$A3t(B . "0x81ED") ;; <CJK>
       (?$A3u(B . "0x521D") ;; <CJK>
       (?$A3v(B . "0x51FA") ;; <CJK>
       (?$A3w(B . "0x6A71") ;; <CJK>
       (?$A3x(B . "0x53A8") ;; <CJK>
       (?$A3y(B . "0x8E87") ;; <CJK>
       (?$A3z(B . "0x9504") ;; <CJK>
       (?$A3{(B . "0x96CF") ;; <CJK>
       (?$A3|(B . "0x6EC1") ;; <CJK>
       (?$A3}(B . "0x9664") ;; <CJK>
       (?$A3~(B . "0x695A") ;; <CJK>
       (?$A4!(B . "0x7840") ;; <CJK>
       (?$A4"(B . "0x50A8") ;; <CJK>
       (?$A4#(B . "0x77D7") ;; <CJK>
       (?$A4$(B . "0x6410") ;; <CJK>
       (?$A4%(B . "0x89E6") ;; <CJK>
       (?$A4&(B . "0x5904") ;; <CJK>
       (?$A4'(B . "0x63E3") ;; <CJK>
       (?$A4((B . "0x5DDD") ;; <CJK>
       (?$A4)(B . "0x7A7F") ;; <CJK>
       (?$A4*(B . "0x693D") ;; <CJK>
       (?$A4+(B . "0x4F20") ;; <CJK>
       (?$A4,(B . "0x8239") ;; <CJK>
       (?$A4-(B . "0x5598") ;; <CJK>
       (?$A4.(B . "0x4E32") ;; <CJK>
       (?$A4/(B . "0x75AE") ;; <CJK>
       (?$A40(B . "0x7A97") ;; <CJK>
       (?$A41(B . "0x5E62") ;; <CJK>
       (?$A42(B . "0x5E8A") ;; <CJK>
       (?$A43(B . "0x95EF") ;; <CJK>
       (?$A44(B . "0x521B") ;; <CJK>
       (?$A45(B . "0x5439") ;; <CJK>
       (?$A46(B . "0x708A") ;; <CJK>
       (?$A47(B . "0x6376") ;; <CJK>
       (?$A48(B . "0x9524") ;; <CJK>
       (?$A49(B . "0x5782") ;; <CJK>
       (?$A4:(B . "0x6625") ;; <CJK>
       (?$A4;(B . "0x693F") ;; <CJK>
       (?$A4<(B . "0x9187") ;; <CJK>
       (?$A4=(B . "0x5507") ;; <CJK>
       (?$A4>(B . "0x6DF3") ;; <CJK>
       (?$A4?(B . "0x7EAF") ;; <CJK>
       (?$A4@(B . "0x8822") ;; <CJK>
       (?$A4A(B . "0x6233") ;; <CJK>
       (?$A4B(B . "0x7EF0") ;; <CJK>
       (?$A4C(B . "0x75B5") ;; <CJK>
       (?$A4D(B . "0x8328") ;; <CJK>
       (?$A4E(B . "0x78C1") ;; <CJK>
       (?$A4F(B . "0x96CC") ;; <CJK>
       (?$A4G(B . "0x8F9E") ;; <CJK>
       (?$A4H(B . "0x6148") ;; <CJK>
       (?$A4I(B . "0x74F7") ;; <CJK>
       (?$A4J(B . "0x8BCD") ;; <CJK>
       (?$A4K(B . "0x6B64") ;; <CJK>
       (?$A4L(B . "0x523A") ;; <CJK>
       (?$A4M(B . "0x8D50") ;; <CJK>
       (?$A4N(B . "0x6B21") ;; <CJK>
       (?$A4O(B . "0x806A") ;; <CJK>
       (?$A4P(B . "0x8471") ;; <CJK>
       (?$A4Q(B . "0x56F1") ;; <CJK>
       (?$A4R(B . "0x5306") ;; <CJK>
       (?$A4S(B . "0x4ECE") ;; <CJK>
       (?$A4T(B . "0x4E1B") ;; <CJK>
       (?$A4U(B . "0x51D1") ;; <CJK>
       (?$A4V(B . "0x7C97") ;; <CJK>
       (?$A4W(B . "0x918B") ;; <CJK>
       (?$A4X(B . "0x7C07") ;; <CJK>
       (?$A4Y(B . "0x4FC3") ;; <CJK>
       (?$A4Z(B . "0x8E7F") ;; <CJK>
       (?$A4[(B . "0x7BE1") ;; <CJK>
       (?$A4\(B . "0x7A9C") ;; <CJK>
       (?$A4](B . "0x6467") ;; <CJK>
       (?$A4^(B . "0x5D14") ;; <CJK>
       (?$A4_(B . "0x50AC") ;; <CJK>
       (?$A4`(B . "0x8106") ;; <CJK>
       (?$A4a(B . "0x7601") ;; <CJK>
       (?$A4b(B . "0x7CB9") ;; <CJK>
       (?$A4c(B . "0x6DEC") ;; <CJK>
       (?$A4d(B . "0x7FE0") ;; <CJK>
       (?$A4e(B . "0x6751") ;; <CJK>
       (?$A4f(B . "0x5B58") ;; <CJK>
       (?$A4g(B . "0x5BF8") ;; <CJK>
       (?$A4h(B . "0x78CB") ;; <CJK>
       (?$A4i(B . "0x64AE") ;; <CJK>
       (?$A4j(B . "0x6413") ;; <CJK>
       (?$A4k(B . "0x63AA") ;; <CJK>
       (?$A4l(B . "0x632B") ;; <CJK>
       (?$A4m(B . "0x9519") ;; <CJK>
       (?$A4n(B . "0x642D") ;; <CJK>
       (?$A4o(B . "0x8FBE") ;; <CJK>
       (?$A4p(B . "0x7B54") ;; <CJK>
       (?$A4q(B . "0x7629") ;; <CJK>
       (?$A4r(B . "0x6253") ;; <CJK>
       (?$A4s(B . "0x5927") ;; <CJK>
       (?$A4t(B . "0x5446") ;; <CJK>
       (?$A4u(B . "0x6B79") ;; <CJK>
       (?$A4v(B . "0x50A3") ;; <CJK>
       (?$A4w(B . "0x6234") ;; <CJK>
       (?$A4x(B . "0x5E26") ;; <CJK>
       (?$A4y(B . "0x6B86") ;; <CJK>
       (?$A4z(B . "0x4EE3") ;; <CJK>
       (?$A4{(B . "0x8D37") ;; <CJK>
       (?$A4|(B . "0x888B") ;; <CJK>
       (?$A4}(B . "0x5F85") ;; <CJK>
       (?$A4~(B . "0x902E") ;; <CJK>
       (?$A5!(B . "0x6020") ;; <CJK>
       (?$A5"(B . "0x803D") ;; <CJK>
       (?$A5#(B . "0x62C5") ;; <CJK>
       (?$A5$(B . "0x4E39") ;; <CJK>
       (?$A5%(B . "0x5355") ;; <CJK>
       (?$A5&(B . "0x90F8") ;; <CJK>
       (?$A5'(B . "0x63B8") ;; <CJK>
       (?$A5((B . "0x80C6") ;; <CJK>
       (?$A5)(B . "0x65E6") ;; <CJK>
       (?$A5*(B . "0x6C2E") ;; <CJK>
       (?$A5+(B . "0x4F46") ;; <CJK>
       (?$A5,(B . "0x60EE") ;; <CJK>
       (?$A5-(B . "0x6DE1") ;; <CJK>
       (?$A5.(B . "0x8BDE") ;; <CJK>
       (?$A5/(B . "0x5F39") ;; <CJK>
       (?$A50(B . "0x86CB") ;; <CJK>
       (?$A51(B . "0x5F53") ;; <CJK>
       (?$A52(B . "0x6321") ;; <CJK>
       (?$A53(B . "0x515A") ;; <CJK>
       (?$A54(B . "0x8361") ;; <CJK>
       (?$A55(B . "0x6863") ;; <CJK>
       (?$A56(B . "0x5200") ;; <CJK>
       (?$A57(B . "0x6363") ;; <CJK>
       (?$A58(B . "0x8E48") ;; <CJK>
       (?$A59(B . "0x5012") ;; <CJK>
       (?$A5:(B . "0x5C9B") ;; <CJK>
       (?$A5;(B . "0x7977") ;; <CJK>
       (?$A5<(B . "0x5BFC") ;; <CJK>
       (?$A5=(B . "0x5230") ;; <CJK>
       (?$A5>(B . "0x7A3B") ;; <CJK>
       (?$A5?(B . "0x60BC") ;; <CJK>
       (?$A5@(B . "0x9053") ;; <CJK>
       (?$A5A(B . "0x76D7") ;; <CJK>
       (?$A5B(B . "0x5FB7") ;; <CJK>
       (?$A5C(B . "0x5F97") ;; <CJK>
       (?$A5D(B . "0x7684") ;; <CJK>
       (?$A5E(B . "0x8E6C") ;; <CJK>
       (?$A5F(B . "0x706F") ;; <CJK>
       (?$A5G(B . "0x767B") ;; <CJK>
       (?$A5H(B . "0x7B49") ;; <CJK>
       (?$A5I(B . "0x77AA") ;; <CJK>
       (?$A5J(B . "0x51F3") ;; <CJK>
       (?$A5K(B . "0x9093") ;; <CJK>
       (?$A5L(B . "0x5824") ;; <CJK>
       (?$A5M(B . "0x4F4E") ;; <CJK>
       (?$A5N(B . "0x6EF4") ;; <CJK>
       (?$A5O(B . "0x8FEA") ;; <CJK>
       (?$A5P(B . "0x654C") ;; <CJK>
       (?$A5Q(B . "0x7B1B") ;; <CJK>
       (?$A5R(B . "0x72C4") ;; <CJK>
       (?$A5S(B . "0x6DA4") ;; <CJK>
       (?$A5T(B . "0x7FDF") ;; <CJK>
       (?$A5U(B . "0x5AE1") ;; <CJK>
       (?$A5V(B . "0x62B5") ;; <CJK>
       (?$A5W(B . "0x5E95") ;; <CJK>
       (?$A5X(B . "0x5730") ;; <CJK>
       (?$A5Y(B . "0x8482") ;; <CJK>
       (?$A5Z(B . "0x7B2C") ;; <CJK>
       (?$A5[(B . "0x5E1D") ;; <CJK>
       (?$A5\(B . "0x5F1F") ;; <CJK>
       (?$A5](B . "0x9012") ;; <CJK>
       (?$A5^(B . "0x7F14") ;; <CJK>
       (?$A5_(B . "0x98A0") ;; <CJK>
       (?$A5`(B . "0x6382") ;; <CJK>
       (?$A5a(B . "0x6EC7") ;; <CJK>
       (?$A5b(B . "0x7898") ;; <CJK>
       (?$A5c(B . "0x70B9") ;; <CJK>
       (?$A5d(B . "0x5178") ;; <CJK>
       (?$A5e(B . "0x975B") ;; <CJK>
       (?$A5f(B . "0x57AB") ;; <CJK>
       (?$A5g(B . "0x7535") ;; <CJK>
       (?$A5h(B . "0x4F43") ;; <CJK>
       (?$A5i(B . "0x7538") ;; <CJK>
       (?$A5j(B . "0x5E97") ;; <CJK>
       (?$A5k(B . "0x60E6") ;; <CJK>
       (?$A5l(B . "0x5960") ;; <CJK>
       (?$A5m(B . "0x6DC0") ;; <CJK>
       (?$A5n(B . "0x6BBF") ;; <CJK>
       (?$A5o(B . "0x7889") ;; <CJK>
       (?$A5p(B . "0x53FC") ;; <CJK>
       (?$A5q(B . "0x96D5") ;; <CJK>
       (?$A5r(B . "0x51CB") ;; <CJK>
       (?$A5s(B . "0x5201") ;; <CJK>
       (?$A5t(B . "0x6389") ;; <CJK>
       (?$A5u(B . "0x540A") ;; <CJK>
       (?$A5v(B . "0x9493") ;; <CJK>
       (?$A5w(B . "0x8C03") ;; <CJK>
       (?$A5x(B . "0x8DCC") ;; <CJK>
       (?$A5y(B . "0x7239") ;; <CJK>
       (?$A5z(B . "0x789F") ;; <CJK>
       (?$A5{(B . "0x8776") ;; <CJK>
       (?$A5|(B . "0x8FED") ;; <CJK>
       (?$A5}(B . "0x8C0D") ;; <CJK>
       (?$A5~(B . "0x53E0") ;; <CJK>
       (?$A6!(B . "0x4E01") ;; <CJK>
       (?$A6"(B . "0x76EF") ;; <CJK>
       (?$A6#(B . "0x53EE") ;; <CJK>
       (?$A6$(B . "0x9489") ;; <CJK>
       (?$A6%(B . "0x9876") ;; <CJK>
       (?$A6&(B . "0x9F0E") ;; <CJK>
       (?$A6'(B . "0x952D") ;; <CJK>
       (?$A6((B . "0x5B9A") ;; <CJK>
       (?$A6)(B . "0x8BA2") ;; <CJK>
       (?$A6*(B . "0x4E22") ;; <CJK>
       (?$A6+(B . "0x4E1C") ;; <CJK>
       (?$A6,(B . "0x51AC") ;; <CJK>
       (?$A6-(B . "0x8463") ;; <CJK>
       (?$A6.(B . "0x61C2") ;; <CJK>
       (?$A6/(B . "0x52A8") ;; <CJK>
       (?$A60(B . "0x680B") ;; <CJK>
       (?$A61(B . "0x4F97") ;; <CJK>
       (?$A62(B . "0x606B") ;; <CJK>
       (?$A63(B . "0x51BB") ;; <CJK>
       (?$A64(B . "0x6D1E") ;; <CJK>
       (?$A65(B . "0x515C") ;; <CJK>
       (?$A66(B . "0x6296") ;; <CJK>
       (?$A67(B . "0x6597") ;; <CJK>
       (?$A68(B . "0x9661") ;; <CJK>
       (?$A69(B . "0x8C46") ;; <CJK>
       (?$A6:(B . "0x9017") ;; <CJK>
       (?$A6;(B . "0x75D8") ;; <CJK>
       (?$A6<(B . "0x90FD") ;; <CJK>
       (?$A6=(B . "0x7763") ;; <CJK>
       (?$A6>(B . "0x6BD2") ;; <CJK>
       (?$A6?(B . "0x728A") ;; <CJK>
       (?$A6@(B . "0x72EC") ;; <CJK>
       (?$A6A(B . "0x8BFB") ;; <CJK>
       (?$A6B(B . "0x5835") ;; <CJK>
       (?$A6C(B . "0x7779") ;; <CJK>
       (?$A6D(B . "0x8D4C") ;; <CJK>
       (?$A6E(B . "0x675C") ;; <CJK>
       (?$A6F(B . "0x9540") ;; <CJK>
       (?$A6G(B . "0x809A") ;; <CJK>
       (?$A6H(B . "0x5EA6") ;; <CJK>
       (?$A6I(B . "0x6E21") ;; <CJK>
       (?$A6J(B . "0x5992") ;; <CJK>
       (?$A6K(B . "0x7AEF") ;; <CJK>
       (?$A6L(B . "0x77ED") ;; <CJK>
       (?$A6M(B . "0x953B") ;; <CJK>
       (?$A6N(B . "0x6BB5") ;; <CJK>
       (?$A6O(B . "0x65AD") ;; <CJK>
       (?$A6P(B . "0x7F0E") ;; <CJK>
       (?$A6Q(B . "0x5806") ;; <CJK>
       (?$A6R(B . "0x5151") ;; <CJK>
       (?$A6S(B . "0x961F") ;; <CJK>
       (?$A6T(B . "0x5BF9") ;; <CJK>
       (?$A6U(B . "0x58A9") ;; <CJK>
       (?$A6V(B . "0x5428") ;; <CJK>
       (?$A6W(B . "0x8E72") ;; <CJK>
       (?$A6X(B . "0x6566") ;; <CJK>
       (?$A6Y(B . "0x987F") ;; <CJK>
       (?$A6Z(B . "0x56E4") ;; <CJK>
       (?$A6[(B . "0x949D") ;; <CJK>
       (?$A6\(B . "0x76FE") ;; <CJK>
       (?$A6](B . "0x9041") ;; <CJK>
       (?$A6^(B . "0x6387") ;; <CJK>
       (?$A6_(B . "0x54C6") ;; <CJK>
       (?$A6`(B . "0x591A") ;; <CJK>
       (?$A6a(B . "0x593A") ;; <CJK>
       (?$A6b(B . "0x579B") ;; <CJK>
       (?$A6c(B . "0x8EB2") ;; <CJK>
       (?$A6d(B . "0x6735") ;; <CJK>
       (?$A6e(B . "0x8DFA") ;; <CJK>
       (?$A6f(B . "0x8235") ;; <CJK>
       (?$A6g(B . "0x5241") ;; <CJK>
       (?$A6h(B . "0x60F0") ;; <CJK>
       (?$A6i(B . "0x5815") ;; <CJK>
       (?$A6j(B . "0x86FE") ;; <CJK>
       (?$A6k(B . "0x5CE8") ;; <CJK>
       (?$A6l(B . "0x9E45") ;; <CJK>
       (?$A6m(B . "0x4FC4") ;; <CJK>
       (?$A6n(B . "0x989D") ;; <CJK>
       (?$A6o(B . "0x8BB9") ;; <CJK>
       (?$A6p(B . "0x5A25") ;; <CJK>
       (?$A6q(B . "0x6076") ;; <CJK>
       (?$A6r(B . "0x5384") ;; <CJK>
       (?$A6s(B . "0x627C") ;; <CJK>
       (?$A6t(B . "0x904F") ;; <CJK>
       (?$A6u(B . "0x9102") ;; <CJK>
       (?$A6v(B . "0x997F") ;; <CJK>
       (?$A6w(B . "0x6069") ;; <CJK>
       (?$A6x(B . "0x800C") ;; <CJK>
       (?$A6y(B . "0x513F") ;; <CJK>
       (?$A6z(B . "0x8033") ;; <CJK>
       (?$A6{(B . "0x5C14") ;; <CJK>
       (?$A6|(B . "0x9975") ;; <CJK>
       (?$A6}(B . "0x6D31") ;; <CJK>
       (?$A6~(B . "0x4E8C") ;; <CJK>
       (?$A7!(B . "0x8D30") ;; <CJK>
       (?$A7"(B . "0x53D1") ;; <CJK>
       (?$A7#(B . "0x7F5A") ;; <CJK>
       (?$A7$(B . "0x7B4F") ;; <CJK>
       (?$A7%(B . "0x4F10") ;; <CJK>
       (?$A7&(B . "0x4E4F") ;; <CJK>
       (?$A7'(B . "0x9600") ;; <CJK>
       (?$A7((B . "0x6CD5") ;; <CJK>
       (?$A7)(B . "0x73D0") ;; <CJK>
       (?$A7*(B . "0x85E9") ;; <CJK>
       (?$A7+(B . "0x5E06") ;; <CJK>
       (?$A7,(B . "0x756A") ;; <CJK>
       (?$A7-(B . "0x7FFB") ;; <CJK>
       (?$A7.(B . "0x6A0A") ;; <CJK>
       (?$A7/(B . "0x77FE") ;; <CJK>
       (?$A70(B . "0x9492") ;; <CJK>
       (?$A71(B . "0x7E41") ;; <CJK>
       (?$A72(B . "0x51E1") ;; <CJK>
       (?$A73(B . "0x70E6") ;; <CJK>
       (?$A74(B . "0x53CD") ;; <CJK>
       (?$A75(B . "0x8FD4") ;; <CJK>
       (?$A76(B . "0x8303") ;; <CJK>
       (?$A77(B . "0x8D29") ;; <CJK>
       (?$A78(B . "0x72AF") ;; <CJK>
       (?$A79(B . "0x996D") ;; <CJK>
       (?$A7:(B . "0x6CDB") ;; <CJK>
       (?$A7;(B . "0x574A") ;; <CJK>
       (?$A7<(B . "0x82B3") ;; <CJK>
       (?$A7=(B . "0x65B9") ;; <CJK>
       (?$A7>(B . "0x80AA") ;; <CJK>
       (?$A7?(B . "0x623F") ;; <CJK>
       (?$A7@(B . "0x9632") ;; <CJK>
       (?$A7A(B . "0x59A8") ;; <CJK>
       (?$A7B(B . "0x4EFF") ;; <CJK>
       (?$A7C(B . "0x8BBF") ;; <CJK>
       (?$A7D(B . "0x7EBA") ;; <CJK>
       (?$A7E(B . "0x653E") ;; <CJK>
       (?$A7F(B . "0x83F2") ;; <CJK>
       (?$A7G(B . "0x975E") ;; <CJK>
       (?$A7H(B . "0x5561") ;; <CJK>
       (?$A7I(B . "0x98DE") ;; <CJK>
       (?$A7J(B . "0x80A5") ;; <CJK>
       (?$A7K(B . "0x532A") ;; <CJK>
       (?$A7L(B . "0x8BFD") ;; <CJK>
       (?$A7M(B . "0x5420") ;; <CJK>
       (?$A7N(B . "0x80BA") ;; <CJK>
       (?$A7O(B . "0x5E9F") ;; <CJK>
       (?$A7P(B . "0x6CB8") ;; <CJK>
       (?$A7Q(B . "0x8D39") ;; <CJK>
       (?$A7R(B . "0x82AC") ;; <CJK>
       (?$A7S(B . "0x915A") ;; <CJK>
       (?$A7T(B . "0x5429") ;; <CJK>
       (?$A7U(B . "0x6C1B") ;; <CJK>
       (?$A7V(B . "0x5206") ;; <CJK>
       (?$A7W(B . "0x7EB7") ;; <CJK>
       (?$A7X(B . "0x575F") ;; <CJK>
       (?$A7Y(B . "0x711A") ;; <CJK>
       (?$A7Z(B . "0x6C7E") ;; <CJK>
       (?$A7[(B . "0x7C89") ;; <CJK>
       (?$A7\(B . "0x594B") ;; <CJK>
       (?$A7](B . "0x4EFD") ;; <CJK>
       (?$A7^(B . "0x5FFF") ;; <CJK>
       (?$A7_(B . "0x6124") ;; <CJK>
       (?$A7`(B . "0x7CAA") ;; <CJK>
       (?$A7a(B . "0x4E30") ;; <CJK>
       (?$A7b(B . "0x5C01") ;; <CJK>
       (?$A7c(B . "0x67AB") ;; <CJK>
       (?$A7d(B . "0x8702") ;; <CJK>
       (?$A7e(B . "0x5CF0") ;; <CJK>
       (?$A7f(B . "0x950B") ;; <CJK>
       (?$A7g(B . "0x98CE") ;; <CJK>
       (?$A7h(B . "0x75AF") ;; <CJK>
       (?$A7i(B . "0x70FD") ;; <CJK>
       (?$A7j(B . "0x9022") ;; <CJK>
       (?$A7k(B . "0x51AF") ;; <CJK>
       (?$A7l(B . "0x7F1D") ;; <CJK>
       (?$A7m(B . "0x8BBD") ;; <CJK>
       (?$A7n(B . "0x5949") ;; <CJK>
       (?$A7o(B . "0x51E4") ;; <CJK>
       (?$A7p(B . "0x4F5B") ;; <CJK>
       (?$A7q(B . "0x5426") ;; <CJK>
       (?$A7r(B . "0x592B") ;; <CJK>
       (?$A7s(B . "0x6577") ;; <CJK>
       (?$A7t(B . "0x80A4") ;; <CJK>
       (?$A7u(B . "0x5B75") ;; <CJK>
       (?$A7v(B . "0x6276") ;; <CJK>
       (?$A7w(B . "0x62C2") ;; <CJK>
       (?$A7x(B . "0x8F90") ;; <CJK>
       (?$A7y(B . "0x5E45") ;; <CJK>
       (?$A7z(B . "0x6C1F") ;; <CJK>
       (?$A7{(B . "0x7B26") ;; <CJK>
       (?$A7|(B . "0x4F0F") ;; <CJK>
       (?$A7}(B . "0x4FD8") ;; <CJK>
       (?$A7~(B . "0x670D") ;; <CJK>
       (?$A8!(B . "0x6D6E") ;; <CJK>
       (?$A8"(B . "0x6DAA") ;; <CJK>
       (?$A8#(B . "0x798F") ;; <CJK>
       (?$A8$(B . "0x88B1") ;; <CJK>
       (?$A8%(B . "0x5F17") ;; <CJK>
       (?$A8&(B . "0x752B") ;; <CJK>
       (?$A8'(B . "0x629A") ;; <CJK>
       (?$A8((B . "0x8F85") ;; <CJK>
       (?$A8)(B . "0x4FEF") ;; <CJK>
       (?$A8*(B . "0x91DC") ;; <CJK>
       (?$A8+(B . "0x65A7") ;; <CJK>
       (?$A8,(B . "0x812F") ;; <CJK>
       (?$A8-(B . "0x8151") ;; <CJK>
       (?$A8.(B . "0x5E9C") ;; <CJK>
       (?$A8/(B . "0x8150") ;; <CJK>
       (?$A80(B . "0x8D74") ;; <CJK>
       (?$A81(B . "0x526F") ;; <CJK>
       (?$A82(B . "0x8986") ;; <CJK>
       (?$A83(B . "0x8D4B") ;; <CJK>
       (?$A84(B . "0x590D") ;; <CJK>
       (?$A85(B . "0x5085") ;; <CJK>
       (?$A86(B . "0x4ED8") ;; <CJK>
       (?$A87(B . "0x961C") ;; <CJK>
       (?$A88(B . "0x7236") ;; <CJK>
       (?$A89(B . "0x8179") ;; <CJK>
       (?$A8:(B . "0x8D1F") ;; <CJK>
       (?$A8;(B . "0x5BCC") ;; <CJK>
       (?$A8<(B . "0x8BA3") ;; <CJK>
       (?$A8=(B . "0x9644") ;; <CJK>
       (?$A8>(B . "0x5987") ;; <CJK>
       (?$A8?(B . "0x7F1A") ;; <CJK>
       (?$A8@(B . "0x5490") ;; <CJK>
       (?$A8A(B . "0x5676") ;; <CJK>
       (?$A8B(B . "0x560E") ;; <CJK>
       (?$A8C(B . "0x8BE5") ;; <CJK>
       (?$A8D(B . "0x6539") ;; <CJK>
       (?$A8E(B . "0x6982") ;; <CJK>
       (?$A8F(B . "0x9499") ;; <CJK>
       (?$A8G(B . "0x76D6") ;; <CJK>
       (?$A8H(B . "0x6E89") ;; <CJK>
       (?$A8I(B . "0x5E72") ;; <CJK>
       (?$A8J(B . "0x7518") ;; <CJK>
       (?$A8K(B . "0x6746") ;; <CJK>
       (?$A8L(B . "0x67D1") ;; <CJK>
       (?$A8M(B . "0x7AFF") ;; <CJK>
       (?$A8N(B . "0x809D") ;; <CJK>
       (?$A8O(B . "0x8D76") ;; <CJK>
       (?$A8P(B . "0x611F") ;; <CJK>
       (?$A8Q(B . "0x79C6") ;; <CJK>
       (?$A8R(B . "0x6562") ;; <CJK>
       (?$A8S(B . "0x8D63") ;; <CJK>
       (?$A8T(B . "0x5188") ;; <CJK>
       (?$A8U(B . "0x521A") ;; <CJK>
       (?$A8V(B . "0x94A2") ;; <CJK>
       (?$A8W(B . "0x7F38") ;; <CJK>
       (?$A8X(B . "0x809B") ;; <CJK>
       (?$A8Y(B . "0x7EB2") ;; <CJK>
       (?$A8Z(B . "0x5C97") ;; <CJK>
       (?$A8[(B . "0x6E2F") ;; <CJK>
       (?$A8\(B . "0x6760") ;; <CJK>
       (?$A8](B . "0x7BD9") ;; <CJK>
       (?$A8^(B . "0x768B") ;; <CJK>
       (?$A8_(B . "0x9AD8") ;; <CJK>
       (?$A8`(B . "0x818F") ;; <CJK>
       (?$A8a(B . "0x7F94") ;; <CJK>
       (?$A8b(B . "0x7CD5") ;; <CJK>
       (?$A8c(B . "0x641E") ;; <CJK>
       (?$A8d(B . "0x9550") ;; <CJK>
       (?$A8e(B . "0x7A3F") ;; <CJK>
       (?$A8f(B . "0x544A") ;; <CJK>
       (?$A8g(B . "0x54E5") ;; <CJK>
       (?$A8h(B . "0x6B4C") ;; <CJK>
       (?$A8i(B . "0x6401") ;; <CJK>
       (?$A8j(B . "0x6208") ;; <CJK>
       (?$A8k(B . "0x9E3D") ;; <CJK>
       (?$A8l(B . "0x80F3") ;; <CJK>
       (?$A8m(B . "0x7599") ;; <CJK>
       (?$A8n(B . "0x5272") ;; <CJK>
       (?$A8o(B . "0x9769") ;; <CJK>
       (?$A8p(B . "0x845B") ;; <CJK>
       (?$A8q(B . "0x683C") ;; <CJK>
       (?$A8r(B . "0x86E4") ;; <CJK>
       (?$A8s(B . "0x9601") ;; <CJK>
       (?$A8t(B . "0x9694") ;; <CJK>
       (?$A8u(B . "0x94EC") ;; <CJK>
       (?$A8v(B . "0x4E2A") ;; <CJK>
       (?$A8w(B . "0x5404") ;; <CJK>
       (?$A8x(B . "0x7ED9") ;; <CJK>
       (?$A8y(B . "0x6839") ;; <CJK>
       (?$A8z(B . "0x8DDF") ;; <CJK>
       (?$A8{(B . "0x8015") ;; <CJK>
       (?$A8|(B . "0x66F4") ;; <CJK>
       (?$A8}(B . "0x5E9A") ;; <CJK>
       (?$A8~(B . "0x7FB9") ;; <CJK>
       (?$A9!(B . "0x57C2") ;; <CJK>
       (?$A9"(B . "0x803F") ;; <CJK>
       (?$A9#(B . "0x6897") ;; <CJK>
       (?$A9$(B . "0x5DE5") ;; <CJK>
       (?$A9%(B . "0x653B") ;; <CJK>
       (?$A9&(B . "0x529F") ;; <CJK>
       (?$A9'(B . "0x606D") ;; <CJK>
       (?$A9((B . "0x9F9A") ;; <CJK>
       (?$A9)(B . "0x4F9B") ;; <CJK>
       (?$A9*(B . "0x8EAC") ;; <CJK>
       (?$A9+(B . "0x516C") ;; <CJK>
       (?$A9,(B . "0x5BAB") ;; <CJK>
       (?$A9-(B . "0x5F13") ;; <CJK>
       (?$A9.(B . "0x5DE9") ;; <CJK>
       (?$A9/(B . "0x6C5E") ;; <CJK>
       (?$A90(B . "0x62F1") ;; <CJK>
       (?$A91(B . "0x8D21") ;; <CJK>
       (?$A92(B . "0x5171") ;; <CJK>
       (?$A93(B . "0x94A9") ;; <CJK>
       (?$A94(B . "0x52FE") ;; <CJK>
       (?$A95(B . "0x6C9F") ;; <CJK>
       (?$A96(B . "0x82DF") ;; <CJK>
       (?$A97(B . "0x72D7") ;; <CJK>
       (?$A98(B . "0x57A2") ;; <CJK>
       (?$A99(B . "0x6784") ;; <CJK>
       (?$A9:(B . "0x8D2D") ;; <CJK>
       (?$A9;(B . "0x591F") ;; <CJK>
       (?$A9<(B . "0x8F9C") ;; <CJK>
       (?$A9=(B . "0x83C7") ;; <CJK>
       (?$A9>(B . "0x5495") ;; <CJK>
       (?$A9?(B . "0x7B8D") ;; <CJK>
       (?$A9@(B . "0x4F30") ;; <CJK>
       (?$A9A(B . "0x6CBD") ;; <CJK>
       (?$A9B(B . "0x5B64") ;; <CJK>
       (?$A9C(B . "0x59D1") ;; <CJK>
       (?$A9D(B . "0x9F13") ;; <CJK>
       (?$A9E(B . "0x53E4") ;; <CJK>
       (?$A9F(B . "0x86CA") ;; <CJK>
       (?$A9G(B . "0x9AA8") ;; <CJK>
       (?$A9H(B . "0x8C37") ;; <CJK>
       (?$A9I(B . "0x80A1") ;; <CJK>
       (?$A9J(B . "0x6545") ;; <CJK>
       (?$A9K(B . "0x987E") ;; <CJK>
       (?$A9L(B . "0x56FA") ;; <CJK>
       (?$A9M(B . "0x96C7") ;; <CJK>
       (?$A9N(B . "0x522E") ;; <CJK>
       (?$A9O(B . "0x74DC") ;; <CJK>
       (?$A9P(B . "0x5250") ;; <CJK>
       (?$A9Q(B . "0x5BE1") ;; <CJK>
       (?$A9R(B . "0x6302") ;; <CJK>
       (?$A9S(B . "0x8902") ;; <CJK>
       (?$A9T(B . "0x4E56") ;; <CJK>
       (?$A9U(B . "0x62D0") ;; <CJK>
       (?$A9V(B . "0x602A") ;; <CJK>
       (?$A9W(B . "0x68FA") ;; <CJK>
       (?$A9X(B . "0x5173") ;; <CJK>
       (?$A9Y(B . "0x5B98") ;; <CJK>
       (?$A9Z(B . "0x51A0") ;; <CJK>
       (?$A9[(B . "0x89C2") ;; <CJK>
       (?$A9\(B . "0x7BA1") ;; <CJK>
       (?$A9](B . "0x9986") ;; <CJK>
       (?$A9^(B . "0x7F50") ;; <CJK>
       (?$A9_(B . "0x60EF") ;; <CJK>
       (?$A9`(B . "0x704C") ;; <CJK>
       (?$A9a(B . "0x8D2F") ;; <CJK>
       (?$A9b(B . "0x5149") ;; <CJK>
       (?$A9c(B . "0x5E7F") ;; <CJK>
       (?$A9d(B . "0x901B") ;; <CJK>
       (?$A9e(B . "0x7470") ;; <CJK>
       (?$A9f(B . "0x89C4") ;; <CJK>
       (?$A9g(B . "0x572D") ;; <CJK>
       (?$A9h(B . "0x7845") ;; <CJK>
       (?$A9i(B . "0x5F52") ;; <CJK>
       (?$A9j(B . "0x9F9F") ;; <CJK>
       (?$A9k(B . "0x95FA") ;; <CJK>
       (?$A9l(B . "0x8F68") ;; <CJK>
       (?$A9m(B . "0x9B3C") ;; <CJK>
       (?$A9n(B . "0x8BE1") ;; <CJK>
       (?$A9o(B . "0x7678") ;; <CJK>
       (?$A9p(B . "0x6842") ;; <CJK>
       (?$A9q(B . "0x67DC") ;; <CJK>
       (?$A9r(B . "0x8DEA") ;; <CJK>
       (?$A9s(B . "0x8D35") ;; <CJK>
       (?$A9t(B . "0x523D") ;; <CJK>
       (?$A9u(B . "0x8F8A") ;; <CJK>
       (?$A9v(B . "0x6EDA") ;; <CJK>
       (?$A9w(B . "0x68CD") ;; <CJK>
       (?$A9x(B . "0x9505") ;; <CJK>
       (?$A9y(B . "0x90ED") ;; <CJK>
       (?$A9z(B . "0x56FD") ;; <CJK>
       (?$A9{(B . "0x679C") ;; <CJK>
       (?$A9|(B . "0x88F9") ;; <CJK>
       (?$A9}(B . "0x8FC7") ;; <CJK>
       (?$A9~(B . "0x54C8") ;; <CJK>
       (?$A:!(B . "0x9AB8") ;; <CJK>
       (?$A:"(B . "0x5B69") ;; <CJK>
       (?$A:#(B . "0x6D77") ;; <CJK>
       (?$A:$(B . "0x6C26") ;; <CJK>
       (?$A:%(B . "0x4EA5") ;; <CJK>
       (?$A:&(B . "0x5BB3") ;; <CJK>
       (?$A:'(B . "0x9A87") ;; <CJK>
       (?$A:((B . "0x9163") ;; <CJK>
       (?$A:)(B . "0x61A8") ;; <CJK>
       (?$A:*(B . "0x90AF") ;; <CJK>
       (?$A:+(B . "0x97E9") ;; <CJK>
       (?$A:,(B . "0x542B") ;; <CJK>
       (?$A:-(B . "0x6DB5") ;; <CJK>
       (?$A:.(B . "0x5BD2") ;; <CJK>
       (?$A:/(B . "0x51FD") ;; <CJK>
       (?$A:0(B . "0x558A") ;; <CJK>
       (?$A:1(B . "0x7F55") ;; <CJK>
       (?$A:2(B . "0x7FF0") ;; <CJK>
       (?$A:3(B . "0x64BC") ;; <CJK>
       (?$A:4(B . "0x634D") ;; <CJK>
       (?$A:5(B . "0x65F1") ;; <CJK>
       (?$A:6(B . "0x61BE") ;; <CJK>
       (?$A:7(B . "0x608D") ;; <CJK>
       (?$A:8(B . "0x710A") ;; <CJK>
       (?$A:9(B . "0x6C57") ;; <CJK>
       (?$A::(B . "0x6C49") ;; <CJK>
       (?$A:;(B . "0x592F") ;; <CJK>
       (?$A:<(B . "0x676D") ;; <CJK>
       (?$A:=(B . "0x822A") ;; <CJK>
       (?$A:>(B . "0x58D5") ;; <CJK>
       (?$A:?(B . "0x568E") ;; <CJK>
       (?$A:@(B . "0x8C6A") ;; <CJK>
       (?$A:A(B . "0x6BEB") ;; <CJK>
       (?$A:B(B . "0x90DD") ;; <CJK>
       (?$A:C(B . "0x597D") ;; <CJK>
       (?$A:D(B . "0x8017") ;; <CJK>
       (?$A:E(B . "0x53F7") ;; <CJK>
       (?$A:F(B . "0x6D69") ;; <CJK>
       (?$A:G(B . "0x5475") ;; <CJK>
       (?$A:H(B . "0x559D") ;; <CJK>
       (?$A:I(B . "0x8377") ;; <CJK>
       (?$A:J(B . "0x83CF") ;; <CJK>
       (?$A:K(B . "0x6838") ;; <CJK>
       (?$A:L(B . "0x79BE") ;; <CJK>
       (?$A:M(B . "0x548C") ;; <CJK>
       (?$A:N(B . "0x4F55") ;; <CJK>
       (?$A:O(B . "0x5408") ;; <CJK>
       (?$A:P(B . "0x76D2") ;; <CJK>
       (?$A:Q(B . "0x8C89") ;; <CJK>
       (?$A:R(B . "0x9602") ;; <CJK>
       (?$A:S(B . "0x6CB3") ;; <CJK>
       (?$A:T(B . "0x6DB8") ;; <CJK>
       (?$A:U(B . "0x8D6B") ;; <CJK>
       (?$A:V(B . "0x8910") ;; <CJK>
       (?$A:W(B . "0x9E64") ;; <CJK>
       (?$A:X(B . "0x8D3A") ;; <CJK>
       (?$A:Y(B . "0x563F") ;; <CJK>
       (?$A:Z(B . "0x9ED1") ;; <CJK>
       (?$A:[(B . "0x75D5") ;; <CJK>
       (?$A:\(B . "0x5F88") ;; <CJK>
       (?$A:](B . "0x72E0") ;; <CJK>
       (?$A:^(B . "0x6068") ;; <CJK>
       (?$A:_(B . "0x54FC") ;; <CJK>
       (?$A:`(B . "0x4EA8") ;; <CJK>
       (?$A:a(B . "0x6A2A") ;; <CJK>
       (?$A:b(B . "0x8861") ;; <CJK>
       (?$A:c(B . "0x6052") ;; <CJK>
       (?$A:d(B . "0x8F70") ;; <CJK>
       (?$A:e(B . "0x54C4") ;; <CJK>
       (?$A:f(B . "0x70D8") ;; <CJK>
       (?$A:g(B . "0x8679") ;; <CJK>
       (?$A:h(B . "0x9E3F") ;; <CJK>
       (?$A:i(B . "0x6D2A") ;; <CJK>
       (?$A:j(B . "0x5B8F") ;; <CJK>
       (?$A:k(B . "0x5F18") ;; <CJK>
       (?$A:l(B . "0x7EA2") ;; <CJK>
       (?$A:m(B . "0x5589") ;; <CJK>
       (?$A:n(B . "0x4FAF") ;; <CJK>
       (?$A:o(B . "0x7334") ;; <CJK>
       (?$A:p(B . "0x543C") ;; <CJK>
       (?$A:q(B . "0x539A") ;; <CJK>
       (?$A:r(B . "0x5019") ;; <CJK>
       (?$A:s(B . "0x540E") ;; <CJK>
       (?$A:t(B . "0x547C") ;; <CJK>
       (?$A:u(B . "0x4E4E") ;; <CJK>
       (?$A:v(B . "0x5FFD") ;; <CJK>
       (?$A:w(B . "0x745A") ;; <CJK>
       (?$A:x(B . "0x58F6") ;; <CJK>
       (?$A:y(B . "0x846B") ;; <CJK>
       (?$A:z(B . "0x80E1") ;; <CJK>
       (?$A:{(B . "0x8774") ;; <CJK>
       (?$A:|(B . "0x72D0") ;; <CJK>
       (?$A:}(B . "0x7CCA") ;; <CJK>
       (?$A:~(B . "0x6E56") ;; <CJK>
       (?$A;!(B . "0x5F27") ;; <CJK>
       (?$A;"(B . "0x864E") ;; <CJK>
       (?$A;#(B . "0x552C") ;; <CJK>
       (?$A;$(B . "0x62A4") ;; <CJK>
       (?$A;%(B . "0x4E92") ;; <CJK>
       (?$A;&(B . "0x6CAA") ;; <CJK>
       (?$A;'(B . "0x6237") ;; <CJK>
       (?$A;((B . "0x82B1") ;; <CJK>
       (?$A;)(B . "0x54D7") ;; <CJK>
       (?$A;*(B . "0x534E") ;; <CJK>
       (?$A;+(B . "0x733E") ;; <CJK>
       (?$A;,(B . "0x6ED1") ;; <CJK>
       (?$A;-(B . "0x753B") ;; <CJK>
       (?$A;.(B . "0x5212") ;; <CJK>
       (?$A;/(B . "0x5316") ;; <CJK>
       (?$A;0(B . "0x8BDD") ;; <CJK>
       (?$A;1(B . "0x69D0") ;; <CJK>
       (?$A;2(B . "0x5F8A") ;; <CJK>
       (?$A;3(B . "0x6000") ;; <CJK>
       (?$A;4(B . "0x6DEE") ;; <CJK>
       (?$A;5(B . "0x574F") ;; <CJK>
       (?$A;6(B . "0x6B22") ;; <CJK>
       (?$A;7(B . "0x73AF") ;; <CJK>
       (?$A;8(B . "0x6853") ;; <CJK>
       (?$A;9(B . "0x8FD8") ;; <CJK>
       (?$A;:(B . "0x7F13") ;; <CJK>
       (?$A;;(B . "0x6362") ;; <CJK>
       (?$A;<(B . "0x60A3") ;; <CJK>
       (?$A;=(B . "0x5524") ;; <CJK>
       (?$A;>(B . "0x75EA") ;; <CJK>
       (?$A;?(B . "0x8C62") ;; <CJK>
       (?$A;@(B . "0x7115") ;; <CJK>
       (?$A;A(B . "0x6DA3") ;; <CJK>
       (?$A;B(B . "0x5BA6") ;; <CJK>
       (?$A;C(B . "0x5E7B") ;; <CJK>
       (?$A;D(B . "0x8352") ;; <CJK>
       (?$A;E(B . "0x614C") ;; <CJK>
       (?$A;F(B . "0x9EC4") ;; <CJK>
       (?$A;G(B . "0x78FA") ;; <CJK>
       (?$A;H(B . "0x8757") ;; <CJK>
       (?$A;I(B . "0x7C27") ;; <CJK>
       (?$A;J(B . "0x7687") ;; <CJK>
       (?$A;K(B . "0x51F0") ;; <CJK>
       (?$A;L(B . "0x60F6") ;; <CJK>
       (?$A;M(B . "0x714C") ;; <CJK>
       (?$A;N(B . "0x6643") ;; <CJK>
       (?$A;O(B . "0x5E4C") ;; <CJK>
       (?$A;P(B . "0x604D") ;; <CJK>
       (?$A;Q(B . "0x8C0E") ;; <CJK>
       (?$A;R(B . "0x7070") ;; <CJK>
       (?$A;S(B . "0x6325") ;; <CJK>
       (?$A;T(B . "0x8F89") ;; <CJK>
       (?$A;U(B . "0x5FBD") ;; <CJK>
       (?$A;V(B . "0x6062") ;; <CJK>
       (?$A;W(B . "0x86D4") ;; <CJK>
       (?$A;X(B . "0x56DE") ;; <CJK>
       (?$A;Y(B . "0x6BC1") ;; <CJK>
       (?$A;Z(B . "0x6094") ;; <CJK>
       (?$A;[(B . "0x6167") ;; <CJK>
       (?$A;\(B . "0x5349") ;; <CJK>
       (?$A;](B . "0x60E0") ;; <CJK>
       (?$A;^(B . "0x6666") ;; <CJK>
       (?$A;_(B . "0x8D3F") ;; <CJK>
       (?$A;`(B . "0x79FD") ;; <CJK>
       (?$A;a(B . "0x4F1A") ;; <CJK>
       (?$A;b(B . "0x70E9") ;; <CJK>
       (?$A;c(B . "0x6C47") ;; <CJK>
       (?$A;d(B . "0x8BB3") ;; <CJK>
       (?$A;e(B . "0x8BF2") ;; <CJK>
       (?$A;f(B . "0x7ED8") ;; <CJK>
       (?$A;g(B . "0x8364") ;; <CJK>
       (?$A;h(B . "0x660F") ;; <CJK>
       (?$A;i(B . "0x5A5A") ;; <CJK>
       (?$A;j(B . "0x9B42") ;; <CJK>
       (?$A;k(B . "0x6D51") ;; <CJK>
       (?$A;l(B . "0x6DF7") ;; <CJK>
       (?$A;m(B . "0x8C41") ;; <CJK>
       (?$A;n(B . "0x6D3B") ;; <CJK>
       (?$A;o(B . "0x4F19") ;; <CJK>
       (?$A;p(B . "0x706B") ;; <CJK>
       (?$A;q(B . "0x83B7") ;; <CJK>
       (?$A;r(B . "0x6216") ;; <CJK>
       (?$A;s(B . "0x60D1") ;; <CJK>
       (?$A;t(B . "0x970D") ;; <CJK>
       (?$A;u(B . "0x8D27") ;; <CJK>
       (?$A;v(B . "0x7978") ;; <CJK>
       (?$A;w(B . "0x51FB") ;; <CJK>
       (?$A;x(B . "0x573E") ;; <CJK>
       (?$A;y(B . "0x57FA") ;; <CJK>
       (?$A;z(B . "0x673A") ;; <CJK>
       (?$A;{(B . "0x7578") ;; <CJK>
       (?$A;|(B . "0x7A3D") ;; <CJK>
       (?$A;}(B . "0x79EF") ;; <CJK>
       (?$A;~(B . "0x7B95") ;; <CJK>
       (?$A<!(B . "0x808C") ;; <CJK>
       (?$A<"(B . "0x9965") ;; <CJK>
       (?$A<#(B . "0x8FF9") ;; <CJK>
       (?$A<$(B . "0x6FC0") ;; <CJK>
       (?$A<%(B . "0x8BA5") ;; <CJK>
       (?$A<&(B . "0x9E21") ;; <CJK>
       (?$A<'(B . "0x59EC") ;; <CJK>
       (?$A<((B . "0x7EE9") ;; <CJK>
       (?$A<)(B . "0x7F09") ;; <CJK>
       (?$A<*(B . "0x5409") ;; <CJK>
       (?$A<+(B . "0x6781") ;; <CJK>
       (?$A<,(B . "0x68D8") ;; <CJK>
       (?$A<-(B . "0x8F91") ;; <CJK>
       (?$A<.(B . "0x7C4D") ;; <CJK>
       (?$A</(B . "0x96C6") ;; <CJK>
       (?$A<0(B . "0x53CA") ;; <CJK>
       (?$A<1(B . "0x6025") ;; <CJK>
       (?$A<2(B . "0x75BE") ;; <CJK>
       (?$A<3(B . "0x6C72") ;; <CJK>
       (?$A<4(B . "0x5373") ;; <CJK>
       (?$A<5(B . "0x5AC9") ;; <CJK>
       (?$A<6(B . "0x7EA7") ;; <CJK>
       (?$A<7(B . "0x6324") ;; <CJK>
       (?$A<8(B . "0x51E0") ;; <CJK>
       (?$A<9(B . "0x810A") ;; <CJK>
       (?$A<:(B . "0x5DF1") ;; <CJK>
       (?$A<;(B . "0x84DF") ;; <CJK>
       (?$A<<(B . "0x6280") ;; <CJK>
       (?$A<=(B . "0x5180") ;; <CJK>
       (?$A<>(B . "0x5B63") ;; <CJK>
       (?$A<?(B . "0x4F0E") ;; <CJK>
       (?$A<@(B . "0x796D") ;; <CJK>
       (?$A<A(B . "0x5242") ;; <CJK>
       (?$A<B(B . "0x60B8") ;; <CJK>
       (?$A<C(B . "0x6D4E") ;; <CJK>
       (?$A<D(B . "0x5BC4") ;; <CJK>
       (?$A<E(B . "0x5BC2") ;; <CJK>
       (?$A<F(B . "0x8BA1") ;; <CJK>
       (?$A<G(B . "0x8BB0") ;; <CJK>
       (?$A<H(B . "0x65E2") ;; <CJK>
       (?$A<I(B . "0x5FCC") ;; <CJK>
       (?$A<J(B . "0x9645") ;; <CJK>
       (?$A<K(B . "0x5993") ;; <CJK>
       (?$A<L(B . "0x7EE7") ;; <CJK>
       (?$A<M(B . "0x7EAA") ;; <CJK>
       (?$A<N(B . "0x5609") ;; <CJK>
       (?$A<O(B . "0x67B7") ;; <CJK>
       (?$A<P(B . "0x5939") ;; <CJK>
       (?$A<Q(B . "0x4F73") ;; <CJK>
       (?$A<R(B . "0x5BB6") ;; <CJK>
       (?$A<S(B . "0x52A0") ;; <CJK>
       (?$A<T(B . "0x835A") ;; <CJK>
       (?$A<U(B . "0x988A") ;; <CJK>
       (?$A<V(B . "0x8D3E") ;; <CJK>
       (?$A<W(B . "0x7532") ;; <CJK>
       (?$A<X(B . "0x94BE") ;; <CJK>
       (?$A<Y(B . "0x5047") ;; <CJK>
       (?$A<Z(B . "0x7A3C") ;; <CJK>
       (?$A<[(B . "0x4EF7") ;; <CJK>
       (?$A<\(B . "0x67B6") ;; <CJK>
       (?$A<](B . "0x9A7E") ;; <CJK>
       (?$A<^(B . "0x5AC1") ;; <CJK>
       (?$A<_(B . "0x6B7C") ;; <CJK>
       (?$A<`(B . "0x76D1") ;; <CJK>
       (?$A<a(B . "0x575A") ;; <CJK>
       (?$A<b(B . "0x5C16") ;; <CJK>
       (?$A<c(B . "0x7B3A") ;; <CJK>
       (?$A<d(B . "0x95F4") ;; <CJK>
       (?$A<e(B . "0x714E") ;; <CJK>
       (?$A<f(B . "0x517C") ;; <CJK>
       (?$A<g(B . "0x80A9") ;; <CJK>
       (?$A<h(B . "0x8270") ;; <CJK>
       (?$A<i(B . "0x5978") ;; <CJK>
       (?$A<j(B . "0x7F04") ;; <CJK>
       (?$A<k(B . "0x8327") ;; <CJK>
       (?$A<l(B . "0x68C0") ;; <CJK>
       (?$A<m(B . "0x67EC") ;; <CJK>
       (?$A<n(B . "0x78B1") ;; <CJK>
       (?$A<o(B . "0x7877") ;; <CJK>
       (?$A<p(B . "0x62E3") ;; <CJK>
       (?$A<q(B . "0x6361") ;; <CJK>
       (?$A<r(B . "0x7B80") ;; <CJK>
       (?$A<s(B . "0x4FED") ;; <CJK>
       (?$A<t(B . "0x526A") ;; <CJK>
       (?$A<u(B . "0x51CF") ;; <CJK>
       (?$A<v(B . "0x8350") ;; <CJK>
       (?$A<w(B . "0x69DB") ;; <CJK>
       (?$A<x(B . "0x9274") ;; <CJK>
       (?$A<y(B . "0x8DF5") ;; <CJK>
       (?$A<z(B . "0x8D31") ;; <CJK>
       (?$A<{(B . "0x89C1") ;; <CJK>
       (?$A<|(B . "0x952E") ;; <CJK>
       (?$A<}(B . "0x7BAD") ;; <CJK>
       (?$A<~(B . "0x4EF6") ;; <CJK>
       (?$A=!(B . "0x5065") ;; <CJK>
       (?$A="(B . "0x8230") ;; <CJK>
       (?$A=#(B . "0x5251") ;; <CJK>
       (?$A=$(B . "0x996F") ;; <CJK>
       (?$A=%(B . "0x6E10") ;; <CJK>
       (?$A=&(B . "0x6E85") ;; <CJK>
       (?$A='(B . "0x6DA7") ;; <CJK>
       (?$A=((B . "0x5EFA") ;; <CJK>
       (?$A=)(B . "0x50F5") ;; <CJK>
       (?$A=*(B . "0x59DC") ;; <CJK>
       (?$A=+(B . "0x5C06") ;; <CJK>
       (?$A=,(B . "0x6D46") ;; <CJK>
       (?$A=-(B . "0x6C5F") ;; <CJK>
       (?$A=.(B . "0x7586") ;; <CJK>
       (?$A=/(B . "0x848B") ;; <CJK>
       (?$A=0(B . "0x6868") ;; <CJK>
       (?$A=1(B . "0x5956") ;; <CJK>
       (?$A=2(B . "0x8BB2") ;; <CJK>
       (?$A=3(B . "0x5320") ;; <CJK>
       (?$A=4(B . "0x9171") ;; <CJK>
       (?$A=5(B . "0x964D") ;; <CJK>
       (?$A=6(B . "0x8549") ;; <CJK>
       (?$A=7(B . "0x6912") ;; <CJK>
       (?$A=8(B . "0x7901") ;; <CJK>
       (?$A=9(B . "0x7126") ;; <CJK>
       (?$A=:(B . "0x80F6") ;; <CJK>
       (?$A=;(B . "0x4EA4") ;; <CJK>
       (?$A=<(B . "0x90CA") ;; <CJK>
       (?$A==(B . "0x6D47") ;; <CJK>
       (?$A=>(B . "0x9A84") ;; <CJK>
       (?$A=?(B . "0x5A07") ;; <CJK>
       (?$A=@(B . "0x56BC") ;; <CJK>
       (?$A=A(B . "0x6405") ;; <CJK>
       (?$A=B(B . "0x94F0") ;; <CJK>
       (?$A=C(B . "0x77EB") ;; <CJK>
       (?$A=D(B . "0x4FA5") ;; <CJK>
       (?$A=E(B . "0x811A") ;; <CJK>
       (?$A=F(B . "0x72E1") ;; <CJK>
       (?$A=G(B . "0x89D2") ;; <CJK>
       (?$A=H(B . "0x997A") ;; <CJK>
       (?$A=I(B . "0x7F34") ;; <CJK>
       (?$A=J(B . "0x7EDE") ;; <CJK>
       (?$A=K(B . "0x527F") ;; <CJK>
       (?$A=L(B . "0x6559") ;; <CJK>
       (?$A=M(B . "0x9175") ;; <CJK>
       (?$A=N(B . "0x8F7F") ;; <CJK>
       (?$A=O(B . "0x8F83") ;; <CJK>
       (?$A=P(B . "0x53EB") ;; <CJK>
       (?$A=Q(B . "0x7A96") ;; <CJK>
       (?$A=R(B . "0x63ED") ;; <CJK>
       (?$A=S(B . "0x63A5") ;; <CJK>
       (?$A=T(B . "0x7686") ;; <CJK>
       (?$A=U(B . "0x79F8") ;; <CJK>
       (?$A=V(B . "0x8857") ;; <CJK>
       (?$A=W(B . "0x9636") ;; <CJK>
       (?$A=X(B . "0x622A") ;; <CJK>
       (?$A=Y(B . "0x52AB") ;; <CJK>
       (?$A=Z(B . "0x8282") ;; <CJK>
       (?$A=[(B . "0x6854") ;; <CJK>
       (?$A=\(B . "0x6770") ;; <CJK>
       (?$A=](B . "0x6377") ;; <CJK>
       (?$A=^(B . "0x776B") ;; <CJK>
       (?$A=_(B . "0x7AED") ;; <CJK>
       (?$A=`(B . "0x6D01") ;; <CJK>
       (?$A=a(B . "0x7ED3") ;; <CJK>
       (?$A=b(B . "0x89E3") ;; <CJK>
       (?$A=c(B . "0x59D0") ;; <CJK>
       (?$A=d(B . "0x6212") ;; <CJK>
       (?$A=e(B . "0x85C9") ;; <CJK>
       (?$A=f(B . "0x82A5") ;; <CJK>
       (?$A=g(B . "0x754C") ;; <CJK>
       (?$A=h(B . "0x501F") ;; <CJK>
       (?$A=i(B . "0x4ECB") ;; <CJK>
       (?$A=j(B . "0x75A5") ;; <CJK>
       (?$A=k(B . "0x8BEB") ;; <CJK>
       (?$A=l(B . "0x5C4A") ;; <CJK>
       (?$A=m(B . "0x5DFE") ;; <CJK>
       (?$A=n(B . "0x7B4B") ;; <CJK>
       (?$A=o(B . "0x65A4") ;; <CJK>
       (?$A=p(B . "0x91D1") ;; <CJK>
       (?$A=q(B . "0x4ECA") ;; <CJK>
       (?$A=r(B . "0x6D25") ;; <CJK>
       (?$A=s(B . "0x895F") ;; <CJK>
       (?$A=t(B . "0x7D27") ;; <CJK>
       (?$A=u(B . "0x9526") ;; <CJK>
       (?$A=v(B . "0x4EC5") ;; <CJK>
       (?$A=w(B . "0x8C28") ;; <CJK>
       (?$A=x(B . "0x8FDB") ;; <CJK>
       (?$A=y(B . "0x9773") ;; <CJK>
       (?$A=z(B . "0x664B") ;; <CJK>
       (?$A={(B . "0x7981") ;; <CJK>
       (?$A=|(B . "0x8FD1") ;; <CJK>
       (?$A=}(B . "0x70EC") ;; <CJK>
       (?$A=~(B . "0x6D78") ;; <CJK>
       (?$A>!(B . "0x5C3D") ;; <CJK>
       (?$A>"(B . "0x52B2") ;; <CJK>
       (?$A>#(B . "0x8346") ;; <CJK>
       (?$A>$(B . "0x5162") ;; <CJK>
       (?$A>%(B . "0x830E") ;; <CJK>
       (?$A>&(B . "0x775B") ;; <CJK>
       (?$A>'(B . "0x6676") ;; <CJK>
       (?$A>((B . "0x9CB8") ;; <CJK>
       (?$A>)(B . "0x4EAC") ;; <CJK>
       (?$A>*(B . "0x60CA") ;; <CJK>
       (?$A>+(B . "0x7CBE") ;; <CJK>
       (?$A>,(B . "0x7CB3") ;; <CJK>
       (?$A>-(B . "0x7ECF") ;; <CJK>
       (?$A>.(B . "0x4E95") ;; <CJK>
       (?$A>/(B . "0x8B66") ;; <CJK>
       (?$A>0(B . "0x666F") ;; <CJK>
       (?$A>1(B . "0x9888") ;; <CJK>
       (?$A>2(B . "0x9759") ;; <CJK>
       (?$A>3(B . "0x5883") ;; <CJK>
       (?$A>4(B . "0x656C") ;; <CJK>
       (?$A>5(B . "0x955C") ;; <CJK>
       (?$A>6(B . "0x5F84") ;; <CJK>
       (?$A>7(B . "0x75C9") ;; <CJK>
       (?$A>8(B . "0x9756") ;; <CJK>
       (?$A>9(B . "0x7ADF") ;; <CJK>
       (?$A>:(B . "0x7ADE") ;; <CJK>
       (?$A>;(B . "0x51C0") ;; <CJK>
       (?$A><(B . "0x70AF") ;; <CJK>
       (?$A>=(B . "0x7A98") ;; <CJK>
       (?$A>>(B . "0x63EA") ;; <CJK>
       (?$A>?(B . "0x7A76") ;; <CJK>
       (?$A>@(B . "0x7EA0") ;; <CJK>
       (?$A>A(B . "0x7396") ;; <CJK>
       (?$A>B(B . "0x97ED") ;; <CJK>
       (?$A>C(B . "0x4E45") ;; <CJK>
       (?$A>D(B . "0x7078") ;; <CJK>
       (?$A>E(B . "0x4E5D") ;; <CJK>
       (?$A>F(B . "0x9152") ;; <CJK>
       (?$A>G(B . "0x53A9") ;; <CJK>
       (?$A>H(B . "0x6551") ;; <CJK>
       (?$A>I(B . "0x65E7") ;; <CJK>
       (?$A>J(B . "0x81FC") ;; <CJK>
       (?$A>K(B . "0x8205") ;; <CJK>
       (?$A>L(B . "0x548E") ;; <CJK>
       (?$A>M(B . "0x5C31") ;; <CJK>
       (?$A>N(B . "0x759A") ;; <CJK>
       (?$A>O(B . "0x97A0") ;; <CJK>
       (?$A>P(B . "0x62D8") ;; <CJK>
       (?$A>Q(B . "0x72D9") ;; <CJK>
       (?$A>R(B . "0x75BD") ;; <CJK>
       (?$A>S(B . "0x5C45") ;; <CJK>
       (?$A>T(B . "0x9A79") ;; <CJK>
       (?$A>U(B . "0x83CA") ;; <CJK>
       (?$A>V(B . "0x5C40") ;; <CJK>
       (?$A>W(B . "0x5480") ;; <CJK>
       (?$A>X(B . "0x77E9") ;; <CJK>
       (?$A>Y(B . "0x4E3E") ;; <CJK>
       (?$A>Z(B . "0x6CAE") ;; <CJK>
       (?$A>[(B . "0x805A") ;; <CJK>
       (?$A>\(B . "0x62D2") ;; <CJK>
       (?$A>](B . "0x636E") ;; <CJK>
       (?$A>^(B . "0x5DE8") ;; <CJK>
       (?$A>_(B . "0x5177") ;; <CJK>
       (?$A>`(B . "0x8DDD") ;; <CJK>
       (?$A>a(B . "0x8E1E") ;; <CJK>
       (?$A>b(B . "0x952F") ;; <CJK>
       (?$A>c(B . "0x4FF1") ;; <CJK>
       (?$A>d(B . "0x53E5") ;; <CJK>
       (?$A>e(B . "0x60E7") ;; <CJK>
       (?$A>f(B . "0x70AC") ;; <CJK>
       (?$A>g(B . "0x5267") ;; <CJK>
       (?$A>h(B . "0x6350") ;; <CJK>
       (?$A>i(B . "0x9E43") ;; <CJK>
       (?$A>j(B . "0x5A1F") ;; <CJK>
       (?$A>k(B . "0x5026") ;; <CJK>
       (?$A>l(B . "0x7737") ;; <CJK>
       (?$A>m(B . "0x5377") ;; <CJK>
       (?$A>n(B . "0x7EE2") ;; <CJK>
       (?$A>o(B . "0x6485") ;; <CJK>
       (?$A>p(B . "0x652B") ;; <CJK>
       (?$A>q(B . "0x6289") ;; <CJK>
       (?$A>r(B . "0x6398") ;; <CJK>
       (?$A>s(B . "0x5014") ;; <CJK>
       (?$A>t(B . "0x7235") ;; <CJK>
       (?$A>u(B . "0x89C9") ;; <CJK>
       (?$A>v(B . "0x51B3") ;; <CJK>
       (?$A>w(B . "0x8BC0") ;; <CJK>
       (?$A>x(B . "0x7EDD") ;; <CJK>
       (?$A>y(B . "0x5747") ;; <CJK>
       (?$A>z(B . "0x83CC") ;; <CJK>
       (?$A>{(B . "0x94A7") ;; <CJK>
       (?$A>|(B . "0x519B") ;; <CJK>
       (?$A>}(B . "0x541B") ;; <CJK>
       (?$A>~(B . "0x5CFB") ;; <CJK>
       (?$A?!(B . "0x4FCA") ;; <CJK>
       (?$A?"(B . "0x7AE3") ;; <CJK>
       (?$A?#(B . "0x6D5A") ;; <CJK>
       (?$A?$(B . "0x90E1") ;; <CJK>
       (?$A?%(B . "0x9A8F") ;; <CJK>
       (?$A?&(B . "0x5580") ;; <CJK>
       (?$A?'(B . "0x5496") ;; <CJK>
       (?$A?((B . "0x5361") ;; <CJK>
       (?$A?)(B . "0x54AF") ;; <CJK>
       (?$A?*(B . "0x5F00") ;; <CJK>
       (?$A?+(B . "0x63E9") ;; <CJK>
       (?$A?,(B . "0x6977") ;; <CJK>
       (?$A?-(B . "0x51EF") ;; <CJK>
       (?$A?.(B . "0x6168") ;; <CJK>
       (?$A?/(B . "0x520A") ;; <CJK>
       (?$A?0(B . "0x582A") ;; <CJK>
       (?$A?1(B . "0x52D8") ;; <CJK>
       (?$A?2(B . "0x574E") ;; <CJK>
       (?$A?3(B . "0x780D") ;; <CJK>
       (?$A?4(B . "0x770B") ;; <CJK>
       (?$A?5(B . "0x5EB7") ;; <CJK>
       (?$A?6(B . "0x6177") ;; <CJK>
       (?$A?7(B . "0x7CE0") ;; <CJK>
       (?$A?8(B . "0x625B") ;; <CJK>
       (?$A?9(B . "0x6297") ;; <CJK>
       (?$A?:(B . "0x4EA2") ;; <CJK>
       (?$A?;(B . "0x7095") ;; <CJK>
       (?$A?<(B . "0x8003") ;; <CJK>
       (?$A?=(B . "0x62F7") ;; <CJK>
       (?$A?>(B . "0x70E4") ;; <CJK>
       (?$A??(B . "0x9760") ;; <CJK>
       (?$A?@(B . "0x5777") ;; <CJK>
       (?$A?A(B . "0x82DB") ;; <CJK>
       (?$A?B(B . "0x67EF") ;; <CJK>
       (?$A?C(B . "0x68F5") ;; <CJK>
       (?$A?D(B . "0x78D5") ;; <CJK>
       (?$A?E(B . "0x9897") ;; <CJK>
       (?$A?F(B . "0x79D1") ;; <CJK>
       (?$A?G(B . "0x58F3") ;; <CJK>
       (?$A?H(B . "0x54B3") ;; <CJK>
       (?$A?I(B . "0x53EF") ;; <CJK>
       (?$A?J(B . "0x6E34") ;; <CJK>
       (?$A?K(B . "0x514B") ;; <CJK>
       (?$A?L(B . "0x523B") ;; <CJK>
       (?$A?M(B . "0x5BA2") ;; <CJK>
       (?$A?N(B . "0x8BFE") ;; <CJK>
       (?$A?O(B . "0x80AF") ;; <CJK>
       (?$A?P(B . "0x5543") ;; <CJK>
       (?$A?Q(B . "0x57A6") ;; <CJK>
       (?$A?R(B . "0x6073") ;; <CJK>
       (?$A?S(B . "0x5751") ;; <CJK>
       (?$A?T(B . "0x542D") ;; <CJK>
       (?$A?U(B . "0x7A7A") ;; <CJK>
       (?$A?V(B . "0x6050") ;; <CJK>
       (?$A?W(B . "0x5B54") ;; <CJK>
       (?$A?X(B . "0x63A7") ;; <CJK>
       (?$A?Y(B . "0x62A0") ;; <CJK>
       (?$A?Z(B . "0x53E3") ;; <CJK>
       (?$A?[(B . "0x6263") ;; <CJK>
       (?$A?\(B . "0x5BC7") ;; <CJK>
       (?$A?](B . "0x67AF") ;; <CJK>
       (?$A?^(B . "0x54ED") ;; <CJK>
       (?$A?_(B . "0x7A9F") ;; <CJK>
       (?$A?`(B . "0x82E6") ;; <CJK>
       (?$A?a(B . "0x9177") ;; <CJK>
       (?$A?b(B . "0x5E93") ;; <CJK>
       (?$A?c(B . "0x88E4") ;; <CJK>
       (?$A?d(B . "0x5938") ;; <CJK>
       (?$A?e(B . "0x57AE") ;; <CJK>
       (?$A?f(B . "0x630E") ;; <CJK>
       (?$A?g(B . "0x8DE8") ;; <CJK>
       (?$A?h(B . "0x80EF") ;; <CJK>
       (?$A?i(B . "0x5757") ;; <CJK>
       (?$A?j(B . "0x7B77") ;; <CJK>
       (?$A?k(B . "0x4FA9") ;; <CJK>
       (?$A?l(B . "0x5FEB") ;; <CJK>
       (?$A?m(B . "0x5BBD") ;; <CJK>
       (?$A?n(B . "0x6B3E") ;; <CJK>
       (?$A?o(B . "0x5321") ;; <CJK>
       (?$A?p(B . "0x7B50") ;; <CJK>
       (?$A?q(B . "0x72C2") ;; <CJK>
       (?$A?r(B . "0x6846") ;; <CJK>
       (?$A?s(B . "0x77FF") ;; <CJK>
       (?$A?t(B . "0x7736") ;; <CJK>
       (?$A?u(B . "0x65F7") ;; <CJK>
       (?$A?v(B . "0x51B5") ;; <CJK>
       (?$A?w(B . "0x4E8F") ;; <CJK>
       (?$A?x(B . "0x76D4") ;; <CJK>
       (?$A?y(B . "0x5CBF") ;; <CJK>
       (?$A?z(B . "0x7AA5") ;; <CJK>
       (?$A?{(B . "0x8475") ;; <CJK>
       (?$A?|(B . "0x594E") ;; <CJK>
       (?$A?}(B . "0x9B41") ;; <CJK>
       (?$A?~(B . "0x5080") ;; <CJK>
       (?$A@!(B . "0x9988") ;; <CJK>
       (?$A@"(B . "0x6127") ;; <CJK>
       (?$A@#(B . "0x6E83") ;; <CJK>
       (?$A@$(B . "0x5764") ;; <CJK>
       (?$A@%(B . "0x6606") ;; <CJK>
       (?$A@&(B . "0x6346") ;; <CJK>
       (?$A@'(B . "0x56F0") ;; <CJK>
       (?$A@((B . "0x62EC") ;; <CJK>
       (?$A@)(B . "0x6269") ;; <CJK>
       (?$A@*(B . "0x5ED3") ;; <CJK>
       (?$A@+(B . "0x9614") ;; <CJK>
       (?$A@,(B . "0x5783") ;; <CJK>
       (?$A@-(B . "0x62C9") ;; <CJK>
       (?$A@.(B . "0x5587") ;; <CJK>
       (?$A@/(B . "0x8721") ;; <CJK>
       (?$A@0(B . "0x814A") ;; <CJK>
       (?$A@1(B . "0x8FA3") ;; <CJK>
       (?$A@2(B . "0x5566") ;; <CJK>
       (?$A@3(B . "0x83B1") ;; <CJK>
       (?$A@4(B . "0x6765") ;; <CJK>
       (?$A@5(B . "0x8D56") ;; <CJK>
       (?$A@6(B . "0x84DD") ;; <CJK>
       (?$A@7(B . "0x5A6A") ;; <CJK>
       (?$A@8(B . "0x680F") ;; <CJK>
       (?$A@9(B . "0x62E6") ;; <CJK>
       (?$A@:(B . "0x7BEE") ;; <CJK>
       (?$A@;(B . "0x9611") ;; <CJK>
       (?$A@<(B . "0x5170") ;; <CJK>
       (?$A@=(B . "0x6F9C") ;; <CJK>
       (?$A@>(B . "0x8C30") ;; <CJK>
       (?$A@?(B . "0x63FD") ;; <CJK>
       (?$A@@(B . "0x89C8") ;; <CJK>
       (?$A@A(B . "0x61D2") ;; <CJK>
       (?$A@B(B . "0x7F06") ;; <CJK>
       (?$A@C(B . "0x70C2") ;; <CJK>
       (?$A@D(B . "0x6EE5") ;; <CJK>
       (?$A@E(B . "0x7405") ;; <CJK>
       (?$A@F(B . "0x6994") ;; <CJK>
       (?$A@G(B . "0x72FC") ;; <CJK>
       (?$A@H(B . "0x5ECA") ;; <CJK>
       (?$A@I(B . "0x90CE") ;; <CJK>
       (?$A@J(B . "0x6717") ;; <CJK>
       (?$A@K(B . "0x6D6A") ;; <CJK>
       (?$A@L(B . "0x635E") ;; <CJK>
       (?$A@M(B . "0x52B3") ;; <CJK>
       (?$A@N(B . "0x7262") ;; <CJK>
       (?$A@O(B . "0x8001") ;; <CJK>
       (?$A@P(B . "0x4F6C") ;; <CJK>
       (?$A@Q(B . "0x59E5") ;; <CJK>
       (?$A@R(B . "0x916A") ;; <CJK>
       (?$A@S(B . "0x70D9") ;; <CJK>
       (?$A@T(B . "0x6D9D") ;; <CJK>
       (?$A@U(B . "0x52D2") ;; <CJK>
       (?$A@V(B . "0x4E50") ;; <CJK>
       (?$A@W(B . "0x96F7") ;; <CJK>
       (?$A@X(B . "0x956D") ;; <CJK>
       (?$A@Y(B . "0x857E") ;; <CJK>
       (?$A@Z(B . "0x78CA") ;; <CJK>
       (?$A@[(B . "0x7D2F") ;; <CJK>
       (?$A@\(B . "0x5121") ;; <CJK>
       (?$A@](B . "0x5792") ;; <CJK>
       (?$A@^(B . "0x64C2") ;; <CJK>
       (?$A@_(B . "0x808B") ;; <CJK>
       (?$A@`(B . "0x7C7B") ;; <CJK>
       (?$A@a(B . "0x6CEA") ;; <CJK>
       (?$A@b(B . "0x68F1") ;; <CJK>
       (?$A@c(B . "0x695E") ;; <CJK>
       (?$A@d(B . "0x51B7") ;; <CJK>
       (?$A@e(B . "0x5398") ;; <CJK>
       (?$A@f(B . "0x68A8") ;; <CJK>
       (?$A@g(B . "0x7281") ;; <CJK>
       (?$A@h(B . "0x9ECE") ;; <CJK>
       (?$A@i(B . "0x7BF1") ;; <CJK>
       (?$A@j(B . "0x72F8") ;; <CJK>
       (?$A@k(B . "0x79BB") ;; <CJK>
       (?$A@l(B . "0x6F13") ;; <CJK>
       (?$A@m(B . "0x7406") ;; <CJK>
       (?$A@n(B . "0x674E") ;; <CJK>
       (?$A@o(B . "0x91CC") ;; <CJK>
       (?$A@p(B . "0x9CA4") ;; <CJK>
       (?$A@q(B . "0x793C") ;; <CJK>
       (?$A@r(B . "0x8389") ;; <CJK>
       (?$A@s(B . "0x8354") ;; <CJK>
       (?$A@t(B . "0x540F") ;; <CJK>
       (?$A@u(B . "0x6817") ;; <CJK>
       (?$A@v(B . "0x4E3D") ;; <CJK>
       (?$A@w(B . "0x5389") ;; <CJK>
       (?$A@x(B . "0x52B1") ;; <CJK>
       (?$A@y(B . "0x783E") ;; <CJK>
       (?$A@z(B . "0x5386") ;; <CJK>
       (?$A@{(B . "0x5229") ;; <CJK>
       (?$A@|(B . "0x5088") ;; <CJK>
       (?$A@}(B . "0x4F8B") ;; <CJK>
       (?$A@~(B . "0x4FD0") ;; <CJK>
       (?$AA!(B . "0x75E2") ;; <CJK>
       (?$AA"(B . "0x7ACB") ;; <CJK>
       (?$AA#(B . "0x7C92") ;; <CJK>
       (?$AA$(B . "0x6CA5") ;; <CJK>
       (?$AA%(B . "0x96B6") ;; <CJK>
       (?$AA&(B . "0x529B") ;; <CJK>
       (?$AA'(B . "0x7483") ;; <CJK>
       (?$AA((B . "0x54E9") ;; <CJK>
       (?$AA)(B . "0x4FE9") ;; <CJK>
       (?$AA*(B . "0x8054") ;; <CJK>
       (?$AA+(B . "0x83B2") ;; <CJK>
       (?$AA,(B . "0x8FDE") ;; <CJK>
       (?$AA-(B . "0x9570") ;; <CJK>
       (?$AA.(B . "0x5EC9") ;; <CJK>
       (?$AA/(B . "0x601C") ;; <CJK>
       (?$AA0(B . "0x6D9F") ;; <CJK>
       (?$AA1(B . "0x5E18") ;; <CJK>
       (?$AA2(B . "0x655B") ;; <CJK>
       (?$AA3(B . "0x8138") ;; <CJK>
       (?$AA4(B . "0x94FE") ;; <CJK>
       (?$AA5(B . "0x604B") ;; <CJK>
       (?$AA6(B . "0x70BC") ;; <CJK>
       (?$AA7(B . "0x7EC3") ;; <CJK>
       (?$AA8(B . "0x7CAE") ;; <CJK>
       (?$AA9(B . "0x51C9") ;; <CJK>
       (?$AA:(B . "0x6881") ;; <CJK>
       (?$AA;(B . "0x7CB1") ;; <CJK>
       (?$AA<(B . "0x826F") ;; <CJK>
       (?$AA=(B . "0x4E24") ;; <CJK>
       (?$AA>(B . "0x8F86") ;; <CJK>
       (?$AA?(B . "0x91CF") ;; <CJK>
       (?$AA@(B . "0x667E") ;; <CJK>
       (?$AAA(B . "0x4EAE") ;; <CJK>
       (?$AAB(B . "0x8C05") ;; <CJK>
       (?$AAC(B . "0x64A9") ;; <CJK>
       (?$AAD(B . "0x804A") ;; <CJK>
       (?$AAE(B . "0x50DA") ;; <CJK>
       (?$AAF(B . "0x7597") ;; <CJK>
       (?$AAG(B . "0x71CE") ;; <CJK>
       (?$AAH(B . "0x5BE5") ;; <CJK>
       (?$AAI(B . "0x8FBD") ;; <CJK>
       (?$AAJ(B . "0x6F66") ;; <CJK>
       (?$AAK(B . "0x4E86") ;; <CJK>
       (?$AAL(B . "0x6482") ;; <CJK>
       (?$AAM(B . "0x9563") ;; <CJK>
       (?$AAN(B . "0x5ED6") ;; <CJK>
       (?$AAO(B . "0x6599") ;; <CJK>
       (?$AAP(B . "0x5217") ;; <CJK>
       (?$AAQ(B . "0x88C2") ;; <CJK>
       (?$AAR(B . "0x70C8") ;; <CJK>
       (?$AAS(B . "0x52A3") ;; <CJK>
       (?$AAT(B . "0x730E") ;; <CJK>
       (?$AAU(B . "0x7433") ;; <CJK>
       (?$AAV(B . "0x6797") ;; <CJK>
       (?$AAW(B . "0x78F7") ;; <CJK>
       (?$AAX(B . "0x9716") ;; <CJK>
       (?$AAY(B . "0x4E34") ;; <CJK>
       (?$AAZ(B . "0x90BB") ;; <CJK>
       (?$AA[(B . "0x9CDE") ;; <CJK>
       (?$AA\(B . "0x6DCB") ;; <CJK>
       (?$AA](B . "0x51DB") ;; <CJK>
       (?$AA^(B . "0x8D41") ;; <CJK>
       (?$AA_(B . "0x541D") ;; <CJK>
       (?$AA`(B . "0x62CE") ;; <CJK>
       (?$AAa(B . "0x73B2") ;; <CJK>
       (?$AAb(B . "0x83F1") ;; <CJK>
       (?$AAc(B . "0x96F6") ;; <CJK>
       (?$AAd(B . "0x9F84") ;; <CJK>
       (?$AAe(B . "0x94C3") ;; <CJK>
       (?$AAf(B . "0x4F36") ;; <CJK>
       (?$AAg(B . "0x7F9A") ;; <CJK>
       (?$AAh(B . "0x51CC") ;; <CJK>
       (?$AAi(B . "0x7075") ;; <CJK>
       (?$AAj(B . "0x9675") ;; <CJK>
       (?$AAk(B . "0x5CAD") ;; <CJK>
       (?$AAl(B . "0x9886") ;; <CJK>
       (?$AAm(B . "0x53E6") ;; <CJK>
       (?$AAn(B . "0x4EE4") ;; <CJK>
       (?$AAo(B . "0x6E9C") ;; <CJK>
       (?$AAp(B . "0x7409") ;; <CJK>
       (?$AAq(B . "0x69B4") ;; <CJK>
       (?$AAr(B . "0x786B") ;; <CJK>
       (?$AAs(B . "0x998F") ;; <CJK>
       (?$AAt(B . "0x7559") ;; <CJK>
       (?$AAu(B . "0x5218") ;; <CJK>
       (?$AAv(B . "0x7624") ;; <CJK>
       (?$AAw(B . "0x6D41") ;; <CJK>
       (?$AAx(B . "0x67F3") ;; <CJK>
       (?$AAy(B . "0x516D") ;; <CJK>
       (?$AAz(B . "0x9F99") ;; <CJK>
       (?$AA{(B . "0x804B") ;; <CJK>
       (?$AA|(B . "0x5499") ;; <CJK>
       (?$AA}(B . "0x7B3C") ;; <CJK>
       (?$AA~(B . "0x7ABF") ;; <CJK>
       (?$AB!(B . "0x9686") ;; <CJK>
       (?$AB"(B . "0x5784") ;; <CJK>
       (?$AB#(B . "0x62E2") ;; <CJK>
       (?$AB$(B . "0x9647") ;; <CJK>
       (?$AB%(B . "0x697C") ;; <CJK>
       (?$AB&(B . "0x5A04") ;; <CJK>
       (?$AB'(B . "0x6402") ;; <CJK>
       (?$AB((B . "0x7BD3") ;; <CJK>
       (?$AB)(B . "0x6F0F") ;; <CJK>
       (?$AB*(B . "0x964B") ;; <CJK>
       (?$AB+(B . "0x82A6") ;; <CJK>
       (?$AB,(B . "0x5362") ;; <CJK>
       (?$AB-(B . "0x9885") ;; <CJK>
       (?$AB.(B . "0x5E90") ;; <CJK>
       (?$AB/(B . "0x7089") ;; <CJK>
       (?$AB0(B . "0x63B3") ;; <CJK>
       (?$AB1(B . "0x5364") ;; <CJK>
       (?$AB2(B . "0x864F") ;; <CJK>
       (?$AB3(B . "0x9C81") ;; <CJK>
       (?$AB4(B . "0x9E93") ;; <CJK>
       (?$AB5(B . "0x788C") ;; <CJK>
       (?$AB6(B . "0x9732") ;; <CJK>
       (?$AB7(B . "0x8DEF") ;; <CJK>
       (?$AB8(B . "0x8D42") ;; <CJK>
       (?$AB9(B . "0x9E7F") ;; <CJK>
       (?$AB:(B . "0x6F5E") ;; <CJK>
       (?$AB;(B . "0x7984") ;; <CJK>
       (?$AB<(B . "0x5F55") ;; <CJK>
       (?$AB=(B . "0x9646") ;; <CJK>
       (?$AB>(B . "0x622E") ;; <CJK>
       (?$AB?(B . "0x9A74") ;; <CJK>
       (?$AB@(B . "0x5415") ;; <CJK>
       (?$ABA(B . "0x94DD") ;; <CJK>
       (?$ABB(B . "0x4FA3") ;; <CJK>
       (?$ABC(B . "0x65C5") ;; <CJK>
       (?$ABD(B . "0x5C65") ;; <CJK>
       (?$ABE(B . "0x5C61") ;; <CJK>
       (?$ABF(B . "0x7F15") ;; <CJK>
       (?$ABG(B . "0x8651") ;; <CJK>
       (?$ABH(B . "0x6C2F") ;; <CJK>
       (?$ABI(B . "0x5F8B") ;; <CJK>
       (?$ABJ(B . "0x7387") ;; <CJK>
       (?$ABK(B . "0x6EE4") ;; <CJK>
       (?$ABL(B . "0x7EFF") ;; <CJK>
       (?$ABM(B . "0x5CE6") ;; <CJK>
       (?$ABN(B . "0x631B") ;; <CJK>
       (?$ABO(B . "0x5B6A") ;; <CJK>
       (?$ABP(B . "0x6EE6") ;; <CJK>
       (?$ABQ(B . "0x5375") ;; <CJK>
       (?$ABR(B . "0x4E71") ;; <CJK>
       (?$ABS(B . "0x63A0") ;; <CJK>
       (?$ABT(B . "0x7565") ;; <CJK>
       (?$ABU(B . "0x62A1") ;; <CJK>
       (?$ABV(B . "0x8F6E") ;; <CJK>
       (?$ABW(B . "0x4F26") ;; <CJK>
       (?$ABX(B . "0x4ED1") ;; <CJK>
       (?$ABY(B . "0x6CA6") ;; <CJK>
       (?$ABZ(B . "0x7EB6") ;; <CJK>
       (?$AB[(B . "0x8BBA") ;; <CJK>
       (?$AB\(B . "0x841D") ;; <CJK>
       (?$AB](B . "0x87BA") ;; <CJK>
       (?$AB^(B . "0x7F57") ;; <CJK>
       (?$AB_(B . "0x903B") ;; <CJK>
       (?$AB`(B . "0x9523") ;; <CJK>
       (?$ABa(B . "0x7BA9") ;; <CJK>
       (?$ABb(B . "0x9AA1") ;; <CJK>
       (?$ABc(B . "0x88F8") ;; <CJK>
       (?$ABd(B . "0x843D") ;; <CJK>
       (?$ABe(B . "0x6D1B") ;; <CJK>
       (?$ABf(B . "0x9A86") ;; <CJK>
       (?$ABg(B . "0x7EDC") ;; <CJK>
       (?$ABh(B . "0x5988") ;; <CJK>
       (?$ABi(B . "0x9EBB") ;; <CJK>
       (?$ABj(B . "0x739B") ;; <CJK>
       (?$ABk(B . "0x7801") ;; <CJK>
       (?$ABl(B . "0x8682") ;; <CJK>
       (?$ABm(B . "0x9A6C") ;; <CJK>
       (?$ABn(B . "0x9A82") ;; <CJK>
       (?$ABo(B . "0x561B") ;; <CJK>
       (?$ABp(B . "0x5417") ;; <CJK>
       (?$ABq(B . "0x57CB") ;; <CJK>
       (?$ABr(B . "0x4E70") ;; <CJK>
       (?$ABs(B . "0x9EA6") ;; <CJK>
       (?$ABt(B . "0x5356") ;; <CJK>
       (?$ABu(B . "0x8FC8") ;; <CJK>
       (?$ABv(B . "0x8109") ;; <CJK>
       (?$ABw(B . "0x7792") ;; <CJK>
       (?$ABx(B . "0x9992") ;; <CJK>
       (?$ABy(B . "0x86EE") ;; <CJK>
       (?$ABz(B . "0x6EE1") ;; <CJK>
       (?$AB{(B . "0x8513") ;; <CJK>
       (?$AB|(B . "0x66FC") ;; <CJK>
       (?$AB}(B . "0x6162") ;; <CJK>
       (?$AB~(B . "0x6F2B") ;; <CJK>
       (?$AC!(B . "0x8C29") ;; <CJK>
       (?$AC"(B . "0x8292") ;; <CJK>
       (?$AC#(B . "0x832B") ;; <CJK>
       (?$AC$(B . "0x76F2") ;; <CJK>
       (?$AC%(B . "0x6C13") ;; <CJK>
       (?$AC&(B . "0x5FD9") ;; <CJK>
       (?$AC'(B . "0x83BD") ;; <CJK>
       (?$AC((B . "0x732B") ;; <CJK>
       (?$AC)(B . "0x8305") ;; <CJK>
       (?$AC*(B . "0x951A") ;; <CJK>
       (?$AC+(B . "0x6BDB") ;; <CJK>
       (?$AC,(B . "0x77DB") ;; <CJK>
       (?$AC-(B . "0x94C6") ;; <CJK>
       (?$AC.(B . "0x536F") ;; <CJK>
       (?$AC/(B . "0x8302") ;; <CJK>
       (?$AC0(B . "0x5192") ;; <CJK>
       (?$AC1(B . "0x5E3D") ;; <CJK>
       (?$AC2(B . "0x8C8C") ;; <CJK>
       (?$AC3(B . "0x8D38") ;; <CJK>
       (?$AC4(B . "0x4E48") ;; <CJK>
       (?$AC5(B . "0x73AB") ;; <CJK>
       (?$AC6(B . "0x679A") ;; <CJK>
       (?$AC7(B . "0x6885") ;; <CJK>
       (?$AC8(B . "0x9176") ;; <CJK>
       (?$AC9(B . "0x9709") ;; <CJK>
       (?$AC:(B . "0x7164") ;; <CJK>
       (?$AC;(B . "0x6CA1") ;; <CJK>
       (?$AC<(B . "0x7709") ;; <CJK>
       (?$AC=(B . "0x5A92") ;; <CJK>
       (?$AC>(B . "0x9541") ;; <CJK>
       (?$AC?(B . "0x6BCF") ;; <CJK>
       (?$AC@(B . "0x7F8E") ;; <CJK>
       (?$ACA(B . "0x6627") ;; <CJK>
       (?$ACB(B . "0x5BD0") ;; <CJK>
       (?$ACC(B . "0x59B9") ;; <CJK>
       (?$ACD(B . "0x5A9A") ;; <CJK>
       (?$ACE(B . "0x95E8") ;; <CJK>
       (?$ACF(B . "0x95F7") ;; <CJK>
       (?$ACG(B . "0x4EEC") ;; <CJK>
       (?$ACH(B . "0x840C") ;; <CJK>
       (?$ACI(B . "0x8499") ;; <CJK>
       (?$ACJ(B . "0x6AAC") ;; <CJK>
       (?$ACK(B . "0x76DF") ;; <CJK>
       (?$ACL(B . "0x9530") ;; <CJK>
       (?$ACM(B . "0x731B") ;; <CJK>
       (?$ACN(B . "0x68A6") ;; <CJK>
       (?$ACO(B . "0x5B5F") ;; <CJK>
       (?$ACP(B . "0x772F") ;; <CJK>
       (?$ACQ(B . "0x919A") ;; <CJK>
       (?$ACR(B . "0x9761") ;; <CJK>
       (?$ACS(B . "0x7CDC") ;; <CJK>
       (?$ACT(B . "0x8FF7") ;; <CJK>
       (?$ACU(B . "0x8C1C") ;; <CJK>
       (?$ACV(B . "0x5F25") ;; <CJK>
       (?$ACW(B . "0x7C73") ;; <CJK>
       (?$ACX(B . "0x79D8") ;; <CJK>
       (?$ACY(B . "0x89C5") ;; <CJK>
       (?$ACZ(B . "0x6CCC") ;; <CJK>
       (?$AC[(B . "0x871C") ;; <CJK>
       (?$AC\(B . "0x5BC6") ;; <CJK>
       (?$AC](B . "0x5E42") ;; <CJK>
       (?$AC^(B . "0x68C9") ;; <CJK>
       (?$AC_(B . "0x7720") ;; <CJK>
       (?$AC`(B . "0x7EF5") ;; <CJK>
       (?$ACa(B . "0x5195") ;; <CJK>
       (?$ACb(B . "0x514D") ;; <CJK>
       (?$ACc(B . "0x52C9") ;; <CJK>
       (?$ACd(B . "0x5A29") ;; <CJK>
       (?$ACe(B . "0x7F05") ;; <CJK>
       (?$ACf(B . "0x9762") ;; <CJK>
       (?$ACg(B . "0x82D7") ;; <CJK>
       (?$ACh(B . "0x63CF") ;; <CJK>
       (?$ACi(B . "0x7784") ;; <CJK>
       (?$ACj(B . "0x85D0") ;; <CJK>
       (?$ACk(B . "0x79D2") ;; <CJK>
       (?$ACl(B . "0x6E3A") ;; <CJK>
       (?$ACm(B . "0x5E99") ;; <CJK>
       (?$ACn(B . "0x5999") ;; <CJK>
       (?$ACo(B . "0x8511") ;; <CJK>
       (?$ACp(B . "0x706D") ;; <CJK>
       (?$ACq(B . "0x6C11") ;; <CJK>
       (?$ACr(B . "0x62BF") ;; <CJK>
       (?$ACs(B . "0x76BF") ;; <CJK>
       (?$ACt(B . "0x654F") ;; <CJK>
       (?$ACu(B . "0x60AF") ;; <CJK>
       (?$ACv(B . "0x95FD") ;; <CJK>
       (?$ACw(B . "0x660E") ;; <CJK>
       (?$ACx(B . "0x879F") ;; <CJK>
       (?$ACy(B . "0x9E23") ;; <CJK>
       (?$ACz(B . "0x94ED") ;; <CJK>
       (?$AC{(B . "0x540D") ;; <CJK>
       (?$AC|(B . "0x547D") ;; <CJK>
       (?$AC}(B . "0x8C2C") ;; <CJK>
       (?$AC~(B . "0x6478") ;; <CJK>
       (?$AD!(B . "0x6479") ;; <CJK>
       (?$AD"(B . "0x8611") ;; <CJK>
       (?$AD#(B . "0x6A21") ;; <CJK>
       (?$AD$(B . "0x819C") ;; <CJK>
       (?$AD%(B . "0x78E8") ;; <CJK>
       (?$AD&(B . "0x6469") ;; <CJK>
       (?$AD'(B . "0x9B54") ;; <CJK>
       (?$AD((B . "0x62B9") ;; <CJK>
       (?$AD)(B . "0x672B") ;; <CJK>
       (?$AD*(B . "0x83AB") ;; <CJK>
       (?$AD+(B . "0x58A8") ;; <CJK>
       (?$AD,(B . "0x9ED8") ;; <CJK>
       (?$AD-(B . "0x6CAB") ;; <CJK>
       (?$AD.(B . "0x6F20") ;; <CJK>
       (?$AD/(B . "0x5BDE") ;; <CJK>
       (?$AD0(B . "0x964C") ;; <CJK>
       (?$AD1(B . "0x8C0B") ;; <CJK>
       (?$AD2(B . "0x725F") ;; <CJK>
       (?$AD3(B . "0x67D0") ;; <CJK>
       (?$AD4(B . "0x62C7") ;; <CJK>
       (?$AD5(B . "0x7261") ;; <CJK>
       (?$AD6(B . "0x4EA9") ;; <CJK>
       (?$AD7(B . "0x59C6") ;; <CJK>
       (?$AD8(B . "0x6BCD") ;; <CJK>
       (?$AD9(B . "0x5893") ;; <CJK>
       (?$AD:(B . "0x66AE") ;; <CJK>
       (?$AD;(B . "0x5E55") ;; <CJK>
       (?$AD<(B . "0x52DF") ;; <CJK>
       (?$AD=(B . "0x6155") ;; <CJK>
       (?$AD>(B . "0x6728") ;; <CJK>
       (?$AD?(B . "0x76EE") ;; <CJK>
       (?$AD@(B . "0x7766") ;; <CJK>
       (?$ADA(B . "0x7267") ;; <CJK>
       (?$ADB(B . "0x7A46") ;; <CJK>
       (?$ADC(B . "0x62FF") ;; <CJK>
       (?$ADD(B . "0x54EA") ;; <CJK>
       (?$ADE(B . "0x5450") ;; <CJK>
       (?$ADF(B . "0x94A0") ;; <CJK>
       (?$ADG(B . "0x90A3") ;; <CJK>
       (?$ADH(B . "0x5A1C") ;; <CJK>
       (?$ADI(B . "0x7EB3") ;; <CJK>
       (?$ADJ(B . "0x6C16") ;; <CJK>
       (?$ADK(B . "0x4E43") ;; <CJK>
       (?$ADL(B . "0x5976") ;; <CJK>
       (?$ADM(B . "0x8010") ;; <CJK>
       (?$ADN(B . "0x5948") ;; <CJK>
       (?$ADO(B . "0x5357") ;; <CJK>
       (?$ADP(B . "0x7537") ;; <CJK>
       (?$ADQ(B . "0x96BE") ;; <CJK>
       (?$ADR(B . "0x56CA") ;; <CJK>
       (?$ADS(B . "0x6320") ;; <CJK>
       (?$ADT(B . "0x8111") ;; <CJK>
       (?$ADU(B . "0x607C") ;; <CJK>
       (?$ADV(B . "0x95F9") ;; <CJK>
       (?$ADW(B . "0x6DD6") ;; <CJK>
       (?$ADX(B . "0x5462") ;; <CJK>
       (?$ADY(B . "0x9981") ;; <CJK>
       (?$ADZ(B . "0x5185") ;; <CJK>
       (?$AD[(B . "0x5AE9") ;; <CJK>
       (?$AD\(B . "0x80FD") ;; <CJK>
       (?$AD](B . "0x59AE") ;; <CJK>
       (?$AD^(B . "0x9713") ;; <CJK>
       (?$AD_(B . "0x502A") ;; <CJK>
       (?$AD`(B . "0x6CE5") ;; <CJK>
       (?$ADa(B . "0x5C3C") ;; <CJK>
       (?$ADb(B . "0x62DF") ;; <CJK>
       (?$ADc(B . "0x4F60") ;; <CJK>
       (?$ADd(B . "0x533F") ;; <CJK>
       (?$ADe(B . "0x817B") ;; <CJK>
       (?$ADf(B . "0x9006") ;; <CJK>
       (?$ADg(B . "0x6EBA") ;; <CJK>
       (?$ADh(B . "0x852B") ;; <CJK>
       (?$ADi(B . "0x62C8") ;; <CJK>
       (?$ADj(B . "0x5E74") ;; <CJK>
       (?$ADk(B . "0x78BE") ;; <CJK>
       (?$ADl(B . "0x64B5") ;; <CJK>
       (?$ADm(B . "0x637B") ;; <CJK>
       (?$ADn(B . "0x5FF5") ;; <CJK>
       (?$ADo(B . "0x5A18") ;; <CJK>
       (?$ADp(B . "0x917F") ;; <CJK>
       (?$ADq(B . "0x9E1F") ;; <CJK>
       (?$ADr(B . "0x5C3F") ;; <CJK>
       (?$ADs(B . "0x634F") ;; <CJK>
       (?$ADt(B . "0x8042") ;; <CJK>
       (?$ADu(B . "0x5B7D") ;; <CJK>
       (?$ADv(B . "0x556E") ;; <CJK>
       (?$ADw(B . "0x954A") ;; <CJK>
       (?$ADx(B . "0x954D") ;; <CJK>
       (?$ADy(B . "0x6D85") ;; <CJK>
       (?$ADz(B . "0x60A8") ;; <CJK>
       (?$AD{(B . "0x67E0") ;; <CJK>
       (?$AD|(B . "0x72DE") ;; <CJK>
       (?$AD}(B . "0x51DD") ;; <CJK>
       (?$AD~(B . "0x5B81") ;; <CJK>
       (?$AE!(B . "0x62E7") ;; <CJK>
       (?$AE"(B . "0x6CDE") ;; <CJK>
       (?$AE#(B . "0x725B") ;; <CJK>
       (?$AE$(B . "0x626D") ;; <CJK>
       (?$AE%(B . "0x94AE") ;; <CJK>
       (?$AE&(B . "0x7EBD") ;; <CJK>
       (?$AE'(B . "0x8113") ;; <CJK>
       (?$AE((B . "0x6D53") ;; <CJK>
       (?$AE)(B . "0x519C") ;; <CJK>
       (?$AE*(B . "0x5F04") ;; <CJK>
       (?$AE+(B . "0x5974") ;; <CJK>
       (?$AE,(B . "0x52AA") ;; <CJK>
       (?$AE-(B . "0x6012") ;; <CJK>
       (?$AE.(B . "0x5973") ;; <CJK>
       (?$AE/(B . "0x6696") ;; <CJK>
       (?$AE0(B . "0x8650") ;; <CJK>
       (?$AE1(B . "0x759F") ;; <CJK>
       (?$AE2(B . "0x632A") ;; <CJK>
       (?$AE3(B . "0x61E6") ;; <CJK>
       (?$AE4(B . "0x7CEF") ;; <CJK>
       (?$AE5(B . "0x8BFA") ;; <CJK>
       (?$AE6(B . "0x54E6") ;; <CJK>
       (?$AE7(B . "0x6B27") ;; <CJK>
       (?$AE8(B . "0x9E25") ;; <CJK>
       (?$AE9(B . "0x6BB4") ;; <CJK>
       (?$AE:(B . "0x85D5") ;; <CJK>
       (?$AE;(B . "0x5455") ;; <CJK>
       (?$AE<(B . "0x5076") ;; <CJK>
       (?$AE=(B . "0x6CA4") ;; <CJK>
       (?$AE>(B . "0x556A") ;; <CJK>
       (?$AE?(B . "0x8DB4") ;; <CJK>
       (?$AE@(B . "0x722C") ;; <CJK>
       (?$AEA(B . "0x5E15") ;; <CJK>
       (?$AEB(B . "0x6015") ;; <CJK>
       (?$AEC(B . "0x7436") ;; <CJK>
       (?$AED(B . "0x62CD") ;; <CJK>
       (?$AEE(B . "0x6392") ;; <CJK>
       (?$AEF(B . "0x724C") ;; <CJK>
       (?$AEG(B . "0x5F98") ;; <CJK>
       (?$AEH(B . "0x6E43") ;; <CJK>
       (?$AEI(B . "0x6D3E") ;; <CJK>
       (?$AEJ(B . "0x6500") ;; <CJK>
       (?$AEK(B . "0x6F58") ;; <CJK>
       (?$AEL(B . "0x76D8") ;; <CJK>
       (?$AEM(B . "0x78D0") ;; <CJK>
       (?$AEN(B . "0x76FC") ;; <CJK>
       (?$AEO(B . "0x7554") ;; <CJK>
       (?$AEP(B . "0x5224") ;; <CJK>
       (?$AEQ(B . "0x53DB") ;; <CJK>
       (?$AER(B . "0x4E53") ;; <CJK>
       (?$AES(B . "0x5E9E") ;; <CJK>
       (?$AET(B . "0x65C1") ;; <CJK>
       (?$AEU(B . "0x802A") ;; <CJK>
       (?$AEV(B . "0x80D6") ;; <CJK>
       (?$AEW(B . "0x629B") ;; <CJK>
       (?$AEX(B . "0x5486") ;; <CJK>
       (?$AEY(B . "0x5228") ;; <CJK>
       (?$AEZ(B . "0x70AE") ;; <CJK>
       (?$AE[(B . "0x888D") ;; <CJK>
       (?$AE\(B . "0x8DD1") ;; <CJK>
       (?$AE](B . "0x6CE1") ;; <CJK>
       (?$AE^(B . "0x5478") ;; <CJK>
       (?$AE_(B . "0x80DA") ;; <CJK>
       (?$AE`(B . "0x57F9") ;; <CJK>
       (?$AEa(B . "0x88F4") ;; <CJK>
       (?$AEb(B . "0x8D54") ;; <CJK>
       (?$AEc(B . "0x966A") ;; <CJK>
       (?$AEd(B . "0x914D") ;; <CJK>
       (?$AEe(B . "0x4F69") ;; <CJK>
       (?$AEf(B . "0x6C9B") ;; <CJK>
       (?$AEg(B . "0x55B7") ;; <CJK>
       (?$AEh(B . "0x76C6") ;; <CJK>
       (?$AEi(B . "0x7830") ;; <CJK>
       (?$AEj(B . "0x62A8") ;; <CJK>
       (?$AEk(B . "0x70F9") ;; <CJK>
       (?$AEl(B . "0x6F8E") ;; <CJK>
       (?$AEm(B . "0x5F6D") ;; <CJK>
       (?$AEn(B . "0x84EC") ;; <CJK>
       (?$AEo(B . "0x68DA") ;; <CJK>
       (?$AEp(B . "0x787C") ;; <CJK>
       (?$AEq(B . "0x7BF7") ;; <CJK>
       (?$AEr(B . "0x81A8") ;; <CJK>
       (?$AEs(B . "0x670B") ;; <CJK>
       (?$AEt(B . "0x9E4F") ;; <CJK>
       (?$AEu(B . "0x6367") ;; <CJK>
       (?$AEv(B . "0x78B0") ;; <CJK>
       (?$AEw(B . "0x576F") ;; <CJK>
       (?$AEx(B . "0x7812") ;; <CJK>
       (?$AEy(B . "0x9739") ;; <CJK>
       (?$AEz(B . "0x6279") ;; <CJK>
       (?$AE{(B . "0x62AB") ;; <CJK>
       (?$AE|(B . "0x5288") ;; <CJK>
       (?$AE}(B . "0x7435") ;; <CJK>
       (?$AE~(B . "0x6BD7") ;; <CJK>
       (?$AF!(B . "0x5564") ;; <CJK>
       (?$AF"(B . "0x813E") ;; <CJK>
       (?$AF#(B . "0x75B2") ;; <CJK>
       (?$AF$(B . "0x76AE") ;; <CJK>
       (?$AF%(B . "0x5339") ;; <CJK>
       (?$AF&(B . "0x75DE") ;; <CJK>
       (?$AF'(B . "0x50FB") ;; <CJK>
       (?$AF((B . "0x5C41") ;; <CJK>
       (?$AF)(B . "0x8B6C") ;; <CJK>
       (?$AF*(B . "0x7BC7") ;; <CJK>
       (?$AF+(B . "0x504F") ;; <CJK>
       (?$AF,(B . "0x7247") ;; <CJK>
       (?$AF-(B . "0x9A97") ;; <CJK>
       (?$AF.(B . "0x98D8") ;; <CJK>
       (?$AF/(B . "0x6F02") ;; <CJK>
       (?$AF0(B . "0x74E2") ;; <CJK>
       (?$AF1(B . "0x7968") ;; <CJK>
       (?$AF2(B . "0x6487") ;; <CJK>
       (?$AF3(B . "0x77A5") ;; <CJK>
       (?$AF4(B . "0x62FC") ;; <CJK>
       (?$AF5(B . "0x9891") ;; <CJK>
       (?$AF6(B . "0x8D2B") ;; <CJK>
       (?$AF7(B . "0x54C1") ;; <CJK>
       (?$AF8(B . "0x8058") ;; <CJK>
       (?$AF9(B . "0x4E52") ;; <CJK>
       (?$AF:(B . "0x576A") ;; <CJK>
       (?$AF;(B . "0x82F9") ;; <CJK>
       (?$AF<(B . "0x840D") ;; <CJK>
       (?$AF=(B . "0x5E73") ;; <CJK>
       (?$AF>(B . "0x51ED") ;; <CJK>
       (?$AF?(B . "0x74F6") ;; <CJK>
       (?$AF@(B . "0x8BC4") ;; <CJK>
       (?$AFA(B . "0x5C4F") ;; <CJK>
       (?$AFB(B . "0x5761") ;; <CJK>
       (?$AFC(B . "0x6CFC") ;; <CJK>
       (?$AFD(B . "0x9887") ;; <CJK>
       (?$AFE(B . "0x5A46") ;; <CJK>
       (?$AFF(B . "0x7834") ;; <CJK>
       (?$AFG(B . "0x9B44") ;; <CJK>
       (?$AFH(B . "0x8FEB") ;; <CJK>
       (?$AFI(B . "0x7C95") ;; <CJK>
       (?$AFJ(B . "0x5256") ;; <CJK>
       (?$AFK(B . "0x6251") ;; <CJK>
       (?$AFL(B . "0x94FA") ;; <CJK>
       (?$AFM(B . "0x4EC6") ;; <CJK>
       (?$AFN(B . "0x8386") ;; <CJK>
       (?$AFO(B . "0x8461") ;; <CJK>
       (?$AFP(B . "0x83E9") ;; <CJK>
       (?$AFQ(B . "0x84B2") ;; <CJK>
       (?$AFR(B . "0x57D4") ;; <CJK>
       (?$AFS(B . "0x6734") ;; <CJK>
       (?$AFT(B . "0x5703") ;; <CJK>
       (?$AFU(B . "0x666E") ;; <CJK>
       (?$AFV(B . "0x6D66") ;; <CJK>
       (?$AFW(B . "0x8C31") ;; <CJK>
       (?$AFX(B . "0x66DD") ;; <CJK>
       (?$AFY(B . "0x7011") ;; <CJK>
       (?$AFZ(B . "0x671F") ;; <CJK>
       (?$AF[(B . "0x6B3A") ;; <CJK>
       (?$AF\(B . "0x6816") ;; <CJK>
       (?$AF](B . "0x621A") ;; <CJK>
       (?$AF^(B . "0x59BB") ;; <CJK>
       (?$AF_(B . "0x4E03") ;; <CJK>
       (?$AF`(B . "0x51C4") ;; <CJK>
       (?$AFa(B . "0x6F06") ;; <CJK>
       (?$AFb(B . "0x67D2") ;; <CJK>
       (?$AFc(B . "0x6C8F") ;; <CJK>
       (?$AFd(B . "0x5176") ;; <CJK>
       (?$AFe(B . "0x68CB") ;; <CJK>
       (?$AFf(B . "0x5947") ;; <CJK>
       (?$AFg(B . "0x6B67") ;; <CJK>
       (?$AFh(B . "0x7566") ;; <CJK>
       (?$AFi(B . "0x5D0E") ;; <CJK>
       (?$AFj(B . "0x8110") ;; <CJK>
       (?$AFk(B . "0x9F50") ;; <CJK>
       (?$AFl(B . "0x65D7") ;; <CJK>
       (?$AFm(B . "0x7948") ;; <CJK>
       (?$AFn(B . "0x7941") ;; <CJK>
       (?$AFo(B . "0x9A91") ;; <CJK>
       (?$AFp(B . "0x8D77") ;; <CJK>
       (?$AFq(B . "0x5C82") ;; <CJK>
       (?$AFr(B . "0x4E5E") ;; <CJK>
       (?$AFs(B . "0x4F01") ;; <CJK>
       (?$AFt(B . "0x542F") ;; <CJK>
       (?$AFu(B . "0x5951") ;; <CJK>
       (?$AFv(B . "0x780C") ;; <CJK>
       (?$AFw(B . "0x5668") ;; <CJK>
       (?$AFx(B . "0x6C14") ;; <CJK>
       (?$AFy(B . "0x8FC4") ;; <CJK>
       (?$AFz(B . "0x5F03") ;; <CJK>
       (?$AF{(B . "0x6C7D") ;; <CJK>
       (?$AF|(B . "0x6CE3") ;; <CJK>
       (?$AF}(B . "0x8BAB") ;; <CJK>
       (?$AF~(B . "0x6390") ;; <CJK>
       (?$AG!(B . "0x6070") ;; <CJK>
       (?$AG"(B . "0x6D3D") ;; <CJK>
       (?$AG#(B . "0x7275") ;; <CJK>
       (?$AG$(B . "0x6266") ;; <CJK>
       (?$AG%(B . "0x948E") ;; <CJK>
       (?$AG&(B . "0x94C5") ;; <CJK>
       (?$AG'(B . "0x5343") ;; <CJK>
       (?$AG((B . "0x8FC1") ;; <CJK>
       (?$AG)(B . "0x7B7E") ;; <CJK>
       (?$AG*(B . "0x4EDF") ;; <CJK>
       (?$AG+(B . "0x8C26") ;; <CJK>
       (?$AG,(B . "0x4E7E") ;; <CJK>
       (?$AG-(B . "0x9ED4") ;; <CJK>
       (?$AG.(B . "0x94B1") ;; <CJK>
       (?$AG/(B . "0x94B3") ;; <CJK>
       (?$AG0(B . "0x524D") ;; <CJK>
       (?$AG1(B . "0x6F5C") ;; <CJK>
       (?$AG2(B . "0x9063") ;; <CJK>
       (?$AG3(B . "0x6D45") ;; <CJK>
       (?$AG4(B . "0x8C34") ;; <CJK>
       (?$AG5(B . "0x5811") ;; <CJK>
       (?$AG6(B . "0x5D4C") ;; <CJK>
       (?$AG7(B . "0x6B20") ;; <CJK>
       (?$AG8(B . "0x6B49") ;; <CJK>
       (?$AG9(B . "0x67AA") ;; <CJK>
       (?$AG:(B . "0x545B") ;; <CJK>
       (?$AG;(B . "0x8154") ;; <CJK>
       (?$AG<(B . "0x7F8C") ;; <CJK>
       (?$AG=(B . "0x5899") ;; <CJK>
       (?$AG>(B . "0x8537") ;; <CJK>
       (?$AG?(B . "0x5F3A") ;; <CJK>
       (?$AG@(B . "0x62A2") ;; <CJK>
       (?$AGA(B . "0x6A47") ;; <CJK>
       (?$AGB(B . "0x9539") ;; <CJK>
       (?$AGC(B . "0x6572") ;; <CJK>
       (?$AGD(B . "0x6084") ;; <CJK>
       (?$AGE(B . "0x6865") ;; <CJK>
       (?$AGF(B . "0x77A7") ;; <CJK>
       (?$AGG(B . "0x4E54") ;; <CJK>
       (?$AGH(B . "0x4FA8") ;; <CJK>
       (?$AGI(B . "0x5DE7") ;; <CJK>
       (?$AGJ(B . "0x9798") ;; <CJK>
       (?$AGK(B . "0x64AC") ;; <CJK>
       (?$AGL(B . "0x7FD8") ;; <CJK>
       (?$AGM(B . "0x5CED") ;; <CJK>
       (?$AGN(B . "0x4FCF") ;; <CJK>
       (?$AGO(B . "0x7A8D") ;; <CJK>
       (?$AGP(B . "0x5207") ;; <CJK>
       (?$AGQ(B . "0x8304") ;; <CJK>
       (?$AGR(B . "0x4E14") ;; <CJK>
       (?$AGS(B . "0x602F") ;; <CJK>
       (?$AGT(B . "0x7A83") ;; <CJK>
       (?$AGU(B . "0x94A6") ;; <CJK>
       (?$AGV(B . "0x4FB5") ;; <CJK>
       (?$AGW(B . "0x4EB2") ;; <CJK>
       (?$AGX(B . "0x79E6") ;; <CJK>
       (?$AGY(B . "0x7434") ;; <CJK>
       (?$AGZ(B . "0x52E4") ;; <CJK>
       (?$AG[(B . "0x82B9") ;; <CJK>
       (?$AG\(B . "0x64D2") ;; <CJK>
       (?$AG](B . "0x79BD") ;; <CJK>
       (?$AG^(B . "0x5BDD") ;; <CJK>
       (?$AG_(B . "0x6C81") ;; <CJK>
       (?$AG`(B . "0x9752") ;; <CJK>
       (?$AGa(B . "0x8F7B") ;; <CJK>
       (?$AGb(B . "0x6C22") ;; <CJK>
       (?$AGc(B . "0x503E") ;; <CJK>
       (?$AGd(B . "0x537F") ;; <CJK>
       (?$AGe(B . "0x6E05") ;; <CJK>
       (?$AGf(B . "0x64CE") ;; <CJK>
       (?$AGg(B . "0x6674") ;; <CJK>
       (?$AGh(B . "0x6C30") ;; <CJK>
       (?$AGi(B . "0x60C5") ;; <CJK>
       (?$AGj(B . "0x9877") ;; <CJK>
       (?$AGk(B . "0x8BF7") ;; <CJK>
       (?$AGl(B . "0x5E86") ;; <CJK>
       (?$AGm(B . "0x743C") ;; <CJK>
       (?$AGn(B . "0x7A77") ;; <CJK>
       (?$AGo(B . "0x79CB") ;; <CJK>
       (?$AGp(B . "0x4E18") ;; <CJK>
       (?$AGq(B . "0x90B1") ;; <CJK>
       (?$AGr(B . "0x7403") ;; <CJK>
       (?$AGs(B . "0x6C42") ;; <CJK>
       (?$AGt(B . "0x56DA") ;; <CJK>
       (?$AGu(B . "0x914B") ;; <CJK>
       (?$AGv(B . "0x6CC5") ;; <CJK>
       (?$AGw(B . "0x8D8B") ;; <CJK>
       (?$AGx(B . "0x533A") ;; <CJK>
       (?$AGy(B . "0x86C6") ;; <CJK>
       (?$AGz(B . "0x66F2") ;; <CJK>
       (?$AG{(B . "0x8EAF") ;; <CJK>
       (?$AG|(B . "0x5C48") ;; <CJK>
       (?$AG}(B . "0x9A71") ;; <CJK>
       (?$AG~(B . "0x6E20") ;; <CJK>
       (?$AH!(B . "0x53D6") ;; <CJK>
       (?$AH"(B . "0x5A36") ;; <CJK>
       (?$AH#(B . "0x9F8B") ;; <CJK>
       (?$AH$(B . "0x8DA3") ;; <CJK>
       (?$AH%(B . "0x53BB") ;; <CJK>
       (?$AH&(B . "0x5708") ;; <CJK>
       (?$AH'(B . "0x98A7") ;; <CJK>
       (?$AH((B . "0x6743") ;; <CJK>
       (?$AH)(B . "0x919B") ;; <CJK>
       (?$AH*(B . "0x6CC9") ;; <CJK>
       (?$AH+(B . "0x5168") ;; <CJK>
       (?$AH,(B . "0x75CA") ;; <CJK>
       (?$AH-(B . "0x62F3") ;; <CJK>
       (?$AH.(B . "0x72AC") ;; <CJK>
       (?$AH/(B . "0x5238") ;; <CJK>
       (?$AH0(B . "0x529D") ;; <CJK>
       (?$AH1(B . "0x7F3A") ;; <CJK>
       (?$AH2(B . "0x7094") ;; <CJK>
       (?$AH3(B . "0x7638") ;; <CJK>
       (?$AH4(B . "0x5374") ;; <CJK>
       (?$AH5(B . "0x9E4A") ;; <CJK>
       (?$AH6(B . "0x69B7") ;; <CJK>
       (?$AH7(B . "0x786E") ;; <CJK>
       (?$AH8(B . "0x96C0") ;; <CJK>
       (?$AH9(B . "0x88D9") ;; <CJK>
       (?$AH:(B . "0x7FA4") ;; <CJK>
       (?$AH;(B . "0x7136") ;; <CJK>
       (?$AH<(B . "0x71C3") ;; <CJK>
       (?$AH=(B . "0x5189") ;; <CJK>
       (?$AH>(B . "0x67D3") ;; <CJK>
       (?$AH?(B . "0x74E4") ;; <CJK>
       (?$AH@(B . "0x58E4") ;; <CJK>
       (?$AHA(B . "0x6518") ;; <CJK>
       (?$AHB(B . "0x56B7") ;; <CJK>
       (?$AHC(B . "0x8BA9") ;; <CJK>
       (?$AHD(B . "0x9976") ;; <CJK>
       (?$AHE(B . "0x6270") ;; <CJK>
       (?$AHF(B . "0x7ED5") ;; <CJK>
       (?$AHG(B . "0x60F9") ;; <CJK>
       (?$AHH(B . "0x70ED") ;; <CJK>
       (?$AHI(B . "0x58EC") ;; <CJK>
       (?$AHJ(B . "0x4EC1") ;; <CJK>
       (?$AHK(B . "0x4EBA") ;; <CJK>
       (?$AHL(B . "0x5FCD") ;; <CJK>
       (?$AHM(B . "0x97E7") ;; <CJK>
       (?$AHN(B . "0x4EFB") ;; <CJK>
       (?$AHO(B . "0x8BA4") ;; <CJK>
       (?$AHP(B . "0x5203") ;; <CJK>
       (?$AHQ(B . "0x598A") ;; <CJK>
       (?$AHR(B . "0x7EAB") ;; <CJK>
       (?$AHS(B . "0x6254") ;; <CJK>
       (?$AHT(B . "0x4ECD") ;; <CJK>
       (?$AHU(B . "0x65E5") ;; <CJK>
       (?$AHV(B . "0x620E") ;; <CJK>
       (?$AHW(B . "0x8338") ;; <CJK>
       (?$AHX(B . "0x84C9") ;; <CJK>
       (?$AHY(B . "0x8363") ;; <CJK>
       (?$AHZ(B . "0x878D") ;; <CJK>
       (?$AH[(B . "0x7194") ;; <CJK>
       (?$AH\(B . "0x6EB6") ;; <CJK>
       (?$AH](B . "0x5BB9") ;; <CJK>
       (?$AH^(B . "0x7ED2") ;; <CJK>
       (?$AH_(B . "0x5197") ;; <CJK>
       (?$AH`(B . "0x63C9") ;; <CJK>
       (?$AHa(B . "0x67D4") ;; <CJK>
       (?$AHb(B . "0x8089") ;; <CJK>
       (?$AHc(B . "0x8339") ;; <CJK>
       (?$AHd(B . "0x8815") ;; <CJK>
       (?$AHe(B . "0x5112") ;; <CJK>
       (?$AHf(B . "0x5B7A") ;; <CJK>
       (?$AHg(B . "0x5982") ;; <CJK>
       (?$AHh(B . "0x8FB1") ;; <CJK>
       (?$AHi(B . "0x4E73") ;; <CJK>
       (?$AHj(B . "0x6C5D") ;; <CJK>
       (?$AHk(B . "0x5165") ;; <CJK>
       (?$AHl(B . "0x8925") ;; <CJK>
       (?$AHm(B . "0x8F6F") ;; <CJK>
       (?$AHn(B . "0x962E") ;; <CJK>
       (?$AHo(B . "0x854A") ;; <CJK>
       (?$AHp(B . "0x745E") ;; <CJK>
       (?$AHq(B . "0x9510") ;; <CJK>
       (?$AHr(B . "0x95F0") ;; <CJK>
       (?$AHs(B . "0x6DA6") ;; <CJK>
       (?$AHt(B . "0x82E5") ;; <CJK>
       (?$AHu(B . "0x5F31") ;; <CJK>
       (?$AHv(B . "0x6492") ;; <CJK>
       (?$AHw(B . "0x6D12") ;; <CJK>
       (?$AHx(B . "0x8428") ;; <CJK>
       (?$AHy(B . "0x816E") ;; <CJK>
       (?$AHz(B . "0x9CC3") ;; <CJK>
       (?$AH{(B . "0x585E") ;; <CJK>
       (?$AH|(B . "0x8D5B") ;; <CJK>
       (?$AH}(B . "0x4E09") ;; <CJK>
       (?$AH~(B . "0x53C1") ;; <CJK>
       (?$AI!(B . "0x4F1E") ;; <CJK>
       (?$AI"(B . "0x6563") ;; <CJK>
       (?$AI#(B . "0x6851") ;; <CJK>
       (?$AI$(B . "0x55D3") ;; <CJK>
       (?$AI%(B . "0x4E27") ;; <CJK>
       (?$AI&(B . "0x6414") ;; <CJK>
       (?$AI'(B . "0x9A9A") ;; <CJK>
       (?$AI((B . "0x626B") ;; <CJK>
       (?$AI)(B . "0x5AC2") ;; <CJK>
       (?$AI*(B . "0x745F") ;; <CJK>
       (?$AI+(B . "0x8272") ;; <CJK>
       (?$AI,(B . "0x6DA9") ;; <CJK>
       (?$AI-(B . "0x68EE") ;; <CJK>
       (?$AI.(B . "0x50E7") ;; <CJK>
       (?$AI/(B . "0x838E") ;; <CJK>
       (?$AI0(B . "0x7802") ;; <CJK>
       (?$AI1(B . "0x6740") ;; <CJK>
       (?$AI2(B . "0x5239") ;; <CJK>
       (?$AI3(B . "0x6C99") ;; <CJK>
       (?$AI4(B . "0x7EB1") ;; <CJK>
       (?$AI5(B . "0x50BB") ;; <CJK>
       (?$AI6(B . "0x5565") ;; <CJK>
       (?$AI7(B . "0x715E") ;; <CJK>
       (?$AI8(B . "0x7B5B") ;; <CJK>
       (?$AI9(B . "0x6652") ;; <CJK>
       (?$AI:(B . "0x73CA") ;; <CJK>
       (?$AI;(B . "0x82EB") ;; <CJK>
       (?$AI<(B . "0x6749") ;; <CJK>
       (?$AI=(B . "0x5C71") ;; <CJK>
       (?$AI>(B . "0x5220") ;; <CJK>
       (?$AI?(B . "0x717D") ;; <CJK>
       (?$AI@(B . "0x886B") ;; <CJK>
       (?$AIA(B . "0x95EA") ;; <CJK>
       (?$AIB(B . "0x9655") ;; <CJK>
       (?$AIC(B . "0x64C5") ;; <CJK>
       (?$AID(B . "0x8D61") ;; <CJK>
       (?$AIE(B . "0x81B3") ;; <CJK>
       (?$AIF(B . "0x5584") ;; <CJK>
       (?$AIG(B . "0x6C55") ;; <CJK>
       (?$AIH(B . "0x6247") ;; <CJK>
       (?$AII(B . "0x7F2E") ;; <CJK>
       (?$AIJ(B . "0x5892") ;; <CJK>
       (?$AIK(B . "0x4F24") ;; <CJK>
       (?$AIL(B . "0x5546") ;; <CJK>
       (?$AIM(B . "0x8D4F") ;; <CJK>
       (?$AIN(B . "0x664C") ;; <CJK>
       (?$AIO(B . "0x4E0A") ;; <CJK>
       (?$AIP(B . "0x5C1A") ;; <CJK>
       (?$AIQ(B . "0x88F3") ;; <CJK>
       (?$AIR(B . "0x68A2") ;; <CJK>
       (?$AIS(B . "0x634E") ;; <CJK>
       (?$AIT(B . "0x7A0D") ;; <CJK>
       (?$AIU(B . "0x70E7") ;; <CJK>
       (?$AIV(B . "0x828D") ;; <CJK>
       (?$AIW(B . "0x52FA") ;; <CJK>
       (?$AIX(B . "0x97F6") ;; <CJK>
       (?$AIY(B . "0x5C11") ;; <CJK>
       (?$AIZ(B . "0x54E8") ;; <CJK>
       (?$AI[(B . "0x90B5") ;; <CJK>
       (?$AI\(B . "0x7ECD") ;; <CJK>
       (?$AI](B . "0x5962") ;; <CJK>
       (?$AI^(B . "0x8D4A") ;; <CJK>
       (?$AI_(B . "0x86C7") ;; <CJK>
       (?$AI`(B . "0x820C") ;; <CJK>
       (?$AIa(B . "0x820D") ;; <CJK>
       (?$AIb(B . "0x8D66") ;; <CJK>
       (?$AIc(B . "0x6444") ;; <CJK>
       (?$AId(B . "0x5C04") ;; <CJK>
       (?$AIe(B . "0x6151") ;; <CJK>
       (?$AIf(B . "0x6D89") ;; <CJK>
       (?$AIg(B . "0x793E") ;; <CJK>
       (?$AIh(B . "0x8BBE") ;; <CJK>
       (?$AIi(B . "0x7837") ;; <CJK>
       (?$AIj(B . "0x7533") ;; <CJK>
       (?$AIk(B . "0x547B") ;; <CJK>
       (?$AIl(B . "0x4F38") ;; <CJK>
       (?$AIm(B . "0x8EAB") ;; <CJK>
       (?$AIn(B . "0x6DF1") ;; <CJK>
       (?$AIo(B . "0x5A20") ;; <CJK>
       (?$AIp(B . "0x7EC5") ;; <CJK>
       (?$AIq(B . "0x795E") ;; <CJK>
       (?$AIr(B . "0x6C88") ;; <CJK>
       (?$AIs(B . "0x5BA1") ;; <CJK>
       (?$AIt(B . "0x5A76") ;; <CJK>
       (?$AIu(B . "0x751A") ;; <CJK>
       (?$AIv(B . "0x80BE") ;; <CJK>
       (?$AIw(B . "0x614E") ;; <CJK>
       (?$AIx(B . "0x6E17") ;; <CJK>
       (?$AIy(B . "0x58F0") ;; <CJK>
       (?$AIz(B . "0x751F") ;; <CJK>
       (?$AI{(B . "0x7525") ;; <CJK>
       (?$AI|(B . "0x7272") ;; <CJK>
       (?$AI}(B . "0x5347") ;; <CJK>
       (?$AI~(B . "0x7EF3") ;; <CJK>
       (?$AJ!(B . "0x7701") ;; <CJK>
       (?$AJ"(B . "0x76DB") ;; <CJK>
       (?$AJ#(B . "0x5269") ;; <CJK>
       (?$AJ$(B . "0x80DC") ;; <CJK>
       (?$AJ%(B . "0x5723") ;; <CJK>
       (?$AJ&(B . "0x5E08") ;; <CJK>
       (?$AJ'(B . "0x5931") ;; <CJK>
       (?$AJ((B . "0x72EE") ;; <CJK>
       (?$AJ)(B . "0x65BD") ;; <CJK>
       (?$AJ*(B . "0x6E7F") ;; <CJK>
       (?$AJ+(B . "0x8BD7") ;; <CJK>
       (?$AJ,(B . "0x5C38") ;; <CJK>
       (?$AJ-(B . "0x8671") ;; <CJK>
       (?$AJ.(B . "0x5341") ;; <CJK>
       (?$AJ/(B . "0x77F3") ;; <CJK>
       (?$AJ0(B . "0x62FE") ;; <CJK>
       (?$AJ1(B . "0x65F6") ;; <CJK>
       (?$AJ2(B . "0x4EC0") ;; <CJK>
       (?$AJ3(B . "0x98DF") ;; <CJK>
       (?$AJ4(B . "0x8680") ;; <CJK>
       (?$AJ5(B . "0x5B9E") ;; <CJK>
       (?$AJ6(B . "0x8BC6") ;; <CJK>
       (?$AJ7(B . "0x53F2") ;; <CJK>
       (?$AJ8(B . "0x77E2") ;; <CJK>
       (?$AJ9(B . "0x4F7F") ;; <CJK>
       (?$AJ:(B . "0x5C4E") ;; <CJK>
       (?$AJ;(B . "0x9A76") ;; <CJK>
       (?$AJ<(B . "0x59CB") ;; <CJK>
       (?$AJ=(B . "0x5F0F") ;; <CJK>
       (?$AJ>(B . "0x793A") ;; <CJK>
       (?$AJ?(B . "0x58EB") ;; <CJK>
       (?$AJ@(B . "0x4E16") ;; <CJK>
       (?$AJA(B . "0x67FF") ;; <CJK>
       (?$AJB(B . "0x4E8B") ;; <CJK>
       (?$AJC(B . "0x62ED") ;; <CJK>
       (?$AJD(B . "0x8A93") ;; <CJK>
       (?$AJE(B . "0x901D") ;; <CJK>
       (?$AJF(B . "0x52BF") ;; <CJK>
       (?$AJG(B . "0x662F") ;; <CJK>
       (?$AJH(B . "0x55DC") ;; <CJK>
       (?$AJI(B . "0x566C") ;; <CJK>
       (?$AJJ(B . "0x9002") ;; <CJK>
       (?$AJK(B . "0x4ED5") ;; <CJK>
       (?$AJL(B . "0x4F8D") ;; <CJK>
       (?$AJM(B . "0x91CA") ;; <CJK>
       (?$AJN(B . "0x9970") ;; <CJK>
       (?$AJO(B . "0x6C0F") ;; <CJK>
       (?$AJP(B . "0x5E02") ;; <CJK>
       (?$AJQ(B . "0x6043") ;; <CJK>
       (?$AJR(B . "0x5BA4") ;; <CJK>
       (?$AJS(B . "0x89C6") ;; <CJK>
       (?$AJT(B . "0x8BD5") ;; <CJK>
       (?$AJU(B . "0x6536") ;; <CJK>
       (?$AJV(B . "0x624B") ;; <CJK>
       (?$AJW(B . "0x9996") ;; <CJK>
       (?$AJX(B . "0x5B88") ;; <CJK>
       (?$AJY(B . "0x5BFF") ;; <CJK>
       (?$AJZ(B . "0x6388") ;; <CJK>
       (?$AJ[(B . "0x552E") ;; <CJK>
       (?$AJ\(B . "0x53D7") ;; <CJK>
       (?$AJ](B . "0x7626") ;; <CJK>
       (?$AJ^(B . "0x517D") ;; <CJK>
       (?$AJ_(B . "0x852C") ;; <CJK>
       (?$AJ`(B . "0x67A2") ;; <CJK>
       (?$AJa(B . "0x68B3") ;; <CJK>
       (?$AJb(B . "0x6B8A") ;; <CJK>
       (?$AJc(B . "0x6292") ;; <CJK>
       (?$AJd(B . "0x8F93") ;; <CJK>
       (?$AJe(B . "0x53D4") ;; <CJK>
       (?$AJf(B . "0x8212") ;; <CJK>
       (?$AJg(B . "0x6DD1") ;; <CJK>
       (?$AJh(B . "0x758F") ;; <CJK>
       (?$AJi(B . "0x4E66") ;; <CJK>
       (?$AJj(B . "0x8D4E") ;; <CJK>
       (?$AJk(B . "0x5B70") ;; <CJK>
       (?$AJl(B . "0x719F") ;; <CJK>
       (?$AJm(B . "0x85AF") ;; <CJK>
       (?$AJn(B . "0x6691") ;; <CJK>
       (?$AJo(B . "0x66D9") ;; <CJK>
       (?$AJp(B . "0x7F72") ;; <CJK>
       (?$AJq(B . "0x8700") ;; <CJK>
       (?$AJr(B . "0x9ECD") ;; <CJK>
       (?$AJs(B . "0x9F20") ;; <CJK>
       (?$AJt(B . "0x5C5E") ;; <CJK>
       (?$AJu(B . "0x672F") ;; <CJK>
       (?$AJv(B . "0x8FF0") ;; <CJK>
       (?$AJw(B . "0x6811") ;; <CJK>
       (?$AJx(B . "0x675F") ;; <CJK>
       (?$AJy(B . "0x620D") ;; <CJK>
       (?$AJz(B . "0x7AD6") ;; <CJK>
       (?$AJ{(B . "0x5885") ;; <CJK>
       (?$AJ|(B . "0x5EB6") ;; <CJK>
       (?$AJ}(B . "0x6570") ;; <CJK>
       (?$AJ~(B . "0x6F31") ;; <CJK>
       (?$AK!(B . "0x6055") ;; <CJK>
       (?$AK"(B . "0x5237") ;; <CJK>
       (?$AK#(B . "0x800D") ;; <CJK>
       (?$AK$(B . "0x6454") ;; <CJK>
       (?$AK%(B . "0x8870") ;; <CJK>
       (?$AK&(B . "0x7529") ;; <CJK>
       (?$AK'(B . "0x5E05") ;; <CJK>
       (?$AK((B . "0x6813") ;; <CJK>
       (?$AK)(B . "0x62F4") ;; <CJK>
       (?$AK*(B . "0x971C") ;; <CJK>
       (?$AK+(B . "0x53CC") ;; <CJK>
       (?$AK,(B . "0x723D") ;; <CJK>
       (?$AK-(B . "0x8C01") ;; <CJK>
       (?$AK.(B . "0x6C34") ;; <CJK>
       (?$AK/(B . "0x7761") ;; <CJK>
       (?$AK0(B . "0x7A0E") ;; <CJK>
       (?$AK1(B . "0x542E") ;; <CJK>
       (?$AK2(B . "0x77AC") ;; <CJK>
       (?$AK3(B . "0x987A") ;; <CJK>
       (?$AK4(B . "0x821C") ;; <CJK>
       (?$AK5(B . "0x8BF4") ;; <CJK>
       (?$AK6(B . "0x7855") ;; <CJK>
       (?$AK7(B . "0x6714") ;; <CJK>
       (?$AK8(B . "0x70C1") ;; <CJK>
       (?$AK9(B . "0x65AF") ;; <CJK>
       (?$AK:(B . "0x6495") ;; <CJK>
       (?$AK;(B . "0x5636") ;; <CJK>
       (?$AK<(B . "0x601D") ;; <CJK>
       (?$AK=(B . "0x79C1") ;; <CJK>
       (?$AK>(B . "0x53F8") ;; <CJK>
       (?$AK?(B . "0x4E1D") ;; <CJK>
       (?$AK@(B . "0x6B7B") ;; <CJK>
       (?$AKA(B . "0x8086") ;; <CJK>
       (?$AKB(B . "0x5BFA") ;; <CJK>
       (?$AKC(B . "0x55E3") ;; <CJK>
       (?$AKD(B . "0x56DB") ;; <CJK>
       (?$AKE(B . "0x4F3A") ;; <CJK>
       (?$AKF(B . "0x4F3C") ;; <CJK>
       (?$AKG(B . "0x9972") ;; <CJK>
       (?$AKH(B . "0x5DF3") ;; <CJK>
       (?$AKI(B . "0x677E") ;; <CJK>
       (?$AKJ(B . "0x8038") ;; <CJK>
       (?$AKK(B . "0x6002") ;; <CJK>
       (?$AKL(B . "0x9882") ;; <CJK>
       (?$AKM(B . "0x9001") ;; <CJK>
       (?$AKN(B . "0x5B8B") ;; <CJK>
       (?$AKO(B . "0x8BBC") ;; <CJK>
       (?$AKP(B . "0x8BF5") ;; <CJK>
       (?$AKQ(B . "0x641C") ;; <CJK>
       (?$AKR(B . "0x8258") ;; <CJK>
       (?$AKS(B . "0x64DE") ;; <CJK>
       (?$AKT(B . "0x55FD") ;; <CJK>
       (?$AKU(B . "0x82CF") ;; <CJK>
       (?$AKV(B . "0x9165") ;; <CJK>
       (?$AKW(B . "0x4FD7") ;; <CJK>
       (?$AKX(B . "0x7D20") ;; <CJK>
       (?$AKY(B . "0x901F") ;; <CJK>
       (?$AKZ(B . "0x7C9F") ;; <CJK>
       (?$AK[(B . "0x50F3") ;; <CJK>
       (?$AK\(B . "0x5851") ;; <CJK>
       (?$AK](B . "0x6EAF") ;; <CJK>
       (?$AK^(B . "0x5BBF") ;; <CJK>
       (?$AK_(B . "0x8BC9") ;; <CJK>
       (?$AK`(B . "0x8083") ;; <CJK>
       (?$AKa(B . "0x9178") ;; <CJK>
       (?$AKb(B . "0x849C") ;; <CJK>
       (?$AKc(B . "0x7B97") ;; <CJK>
       (?$AKd(B . "0x867D") ;; <CJK>
       (?$AKe(B . "0x968B") ;; <CJK>
       (?$AKf(B . "0x968F") ;; <CJK>
       (?$AKg(B . "0x7EE5") ;; <CJK>
       (?$AKh(B . "0x9AD3") ;; <CJK>
       (?$AKi(B . "0x788E") ;; <CJK>
       (?$AKj(B . "0x5C81") ;; <CJK>
       (?$AKk(B . "0x7A57") ;; <CJK>
       (?$AKl(B . "0x9042") ;; <CJK>
       (?$AKm(B . "0x96A7") ;; <CJK>
       (?$AKn(B . "0x795F") ;; <CJK>
       (?$AKo(B . "0x5B59") ;; <CJK>
       (?$AKp(B . "0x635F") ;; <CJK>
       (?$AKq(B . "0x7B0B") ;; <CJK>
       (?$AKr(B . "0x84D1") ;; <CJK>
       (?$AKs(B . "0x68AD") ;; <CJK>
       (?$AKt(B . "0x5506") ;; <CJK>
       (?$AKu(B . "0x7F29") ;; <CJK>
       (?$AKv(B . "0x7410") ;; <CJK>
       (?$AKw(B . "0x7D22") ;; <CJK>
       (?$AKx(B . "0x9501") ;; <CJK>
       (?$AKy(B . "0x6240") ;; <CJK>
       (?$AKz(B . "0x584C") ;; <CJK>
       (?$AK{(B . "0x4ED6") ;; <CJK>
       (?$AK|(B . "0x5B83") ;; <CJK>
       (?$AK}(B . "0x5979") ;; <CJK>
       (?$AK~(B . "0x5854") ;; <CJK>
       (?$AL!(B . "0x736D") ;; <CJK>
       (?$AL"(B . "0x631E") ;; <CJK>
       (?$AL#(B . "0x8E4B") ;; <CJK>
       (?$AL$(B . "0x8E0F") ;; <CJK>
       (?$AL%(B . "0x80CE") ;; <CJK>
       (?$AL&(B . "0x82D4") ;; <CJK>
       (?$AL'(B . "0x62AC") ;; <CJK>
       (?$AL((B . "0x53F0") ;; <CJK>
       (?$AL)(B . "0x6CF0") ;; <CJK>
       (?$AL*(B . "0x915E") ;; <CJK>
       (?$AL+(B . "0x592A") ;; <CJK>
       (?$AL,(B . "0x6001") ;; <CJK>
       (?$AL-(B . "0x6C70") ;; <CJK>
       (?$AL.(B . "0x574D") ;; <CJK>
       (?$AL/(B . "0x644A") ;; <CJK>
       (?$AL0(B . "0x8D2A") ;; <CJK>
       (?$AL1(B . "0x762B") ;; <CJK>
       (?$AL2(B . "0x6EE9") ;; <CJK>
       (?$AL3(B . "0x575B") ;; <CJK>
       (?$AL4(B . "0x6A80") ;; <CJK>
       (?$AL5(B . "0x75F0") ;; <CJK>
       (?$AL6(B . "0x6F6D") ;; <CJK>
       (?$AL7(B . "0x8C2D") ;; <CJK>
       (?$AL8(B . "0x8C08") ;; <CJK>
       (?$AL9(B . "0x5766") ;; <CJK>
       (?$AL:(B . "0x6BEF") ;; <CJK>
       (?$AL;(B . "0x8892") ;; <CJK>
       (?$AL<(B . "0x78B3") ;; <CJK>
       (?$AL=(B . "0x63A2") ;; <CJK>
       (?$AL>(B . "0x53F9") ;; <CJK>
       (?$AL?(B . "0x70AD") ;; <CJK>
       (?$AL@(B . "0x6C64") ;; <CJK>
       (?$ALA(B . "0x5858") ;; <CJK>
       (?$ALB(B . "0x642A") ;; <CJK>
       (?$ALC(B . "0x5802") ;; <CJK>
       (?$ALD(B . "0x68E0") ;; <CJK>
       (?$ALE(B . "0x819B") ;; <CJK>
       (?$ALF(B . "0x5510") ;; <CJK>
       (?$ALG(B . "0x7CD6") ;; <CJK>
       (?$ALH(B . "0x5018") ;; <CJK>
       (?$ALI(B . "0x8EBA") ;; <CJK>
       (?$ALJ(B . "0x6DCC") ;; <CJK>
       (?$ALK(B . "0x8D9F") ;; <CJK>
       (?$ALL(B . "0x70EB") ;; <CJK>
       (?$ALM(B . "0x638F") ;; <CJK>
       (?$ALN(B . "0x6D9B") ;; <CJK>
       (?$ALO(B . "0x6ED4") ;; <CJK>
       (?$ALP(B . "0x7EE6") ;; <CJK>
       (?$ALQ(B . "0x8404") ;; <CJK>
       (?$ALR(B . "0x6843") ;; <CJK>
       (?$ALS(B . "0x9003") ;; <CJK>
       (?$ALT(B . "0x6DD8") ;; <CJK>
       (?$ALU(B . "0x9676") ;; <CJK>
       (?$ALV(B . "0x8BA8") ;; <CJK>
       (?$ALW(B . "0x5957") ;; <CJK>
       (?$ALX(B . "0x7279") ;; <CJK>
       (?$ALY(B . "0x85E4") ;; <CJK>
       (?$ALZ(B . "0x817E") ;; <CJK>
       (?$AL[(B . "0x75BC") ;; <CJK>
       (?$AL\(B . "0x8A8A") ;; <CJK>
       (?$AL](B . "0x68AF") ;; <CJK>
       (?$AL^(B . "0x5254") ;; <CJK>
       (?$AL_(B . "0x8E22") ;; <CJK>
       (?$AL`(B . "0x9511") ;; <CJK>
       (?$ALa(B . "0x63D0") ;; <CJK>
       (?$ALb(B . "0x9898") ;; <CJK>
       (?$ALc(B . "0x8E44") ;; <CJK>
       (?$ALd(B . "0x557C") ;; <CJK>
       (?$ALe(B . "0x4F53") ;; <CJK>
       (?$ALf(B . "0x66FF") ;; <CJK>
       (?$ALg(B . "0x568F") ;; <CJK>
       (?$ALh(B . "0x60D5") ;; <CJK>
       (?$ALi(B . "0x6D95") ;; <CJK>
       (?$ALj(B . "0x5243") ;; <CJK>
       (?$ALk(B . "0x5C49") ;; <CJK>
       (?$ALl(B . "0x5929") ;; <CJK>
       (?$ALm(B . "0x6DFB") ;; <CJK>
       (?$ALn(B . "0x586B") ;; <CJK>
       (?$ALo(B . "0x7530") ;; <CJK>
       (?$ALp(B . "0x751C") ;; <CJK>
       (?$ALq(B . "0x606C") ;; <CJK>
       (?$ALr(B . "0x8214") ;; <CJK>
       (?$ALs(B . "0x8146") ;; <CJK>
       (?$ALt(B . "0x6311") ;; <CJK>
       (?$ALu(B . "0x6761") ;; <CJK>
       (?$ALv(B . "0x8FE2") ;; <CJK>
       (?$ALw(B . "0x773A") ;; <CJK>
       (?$ALx(B . "0x8DF3") ;; <CJK>
       (?$ALy(B . "0x8D34") ;; <CJK>
       (?$ALz(B . "0x94C1") ;; <CJK>
       (?$AL{(B . "0x5E16") ;; <CJK>
       (?$AL|(B . "0x5385") ;; <CJK>
       (?$AL}(B . "0x542C") ;; <CJK>
       (?$AL~(B . "0x70C3") ;; <CJK>
       (?$AM!(B . "0x6C40") ;; <CJK>
       (?$AM"(B . "0x5EF7") ;; <CJK>
       (?$AM#(B . "0x505C") ;; <CJK>
       (?$AM$(B . "0x4EAD") ;; <CJK>
       (?$AM%(B . "0x5EAD") ;; <CJK>
       (?$AM&(B . "0x633A") ;; <CJK>
       (?$AM'(B . "0x8247") ;; <CJK>
       (?$AM((B . "0x901A") ;; <CJK>
       (?$AM)(B . "0x6850") ;; <CJK>
       (?$AM*(B . "0x916E") ;; <CJK>
       (?$AM+(B . "0x77B3") ;; <CJK>
       (?$AM,(B . "0x540C") ;; <CJK>
       (?$AM-(B . "0x94DC") ;; <CJK>
       (?$AM.(B . "0x5F64") ;; <CJK>
       (?$AM/(B . "0x7AE5") ;; <CJK>
       (?$AM0(B . "0x6876") ;; <CJK>
       (?$AM1(B . "0x6345") ;; <CJK>
       (?$AM2(B . "0x7B52") ;; <CJK>
       (?$AM3(B . "0x7EDF") ;; <CJK>
       (?$AM4(B . "0x75DB") ;; <CJK>
       (?$AM5(B . "0x5077") ;; <CJK>
       (?$AM6(B . "0x6295") ;; <CJK>
       (?$AM7(B . "0x5934") ;; <CJK>
       (?$AM8(B . "0x900F") ;; <CJK>
       (?$AM9(B . "0x51F8") ;; <CJK>
       (?$AM:(B . "0x79C3") ;; <CJK>
       (?$AM;(B . "0x7A81") ;; <CJK>
       (?$AM<(B . "0x56FE") ;; <CJK>
       (?$AM=(B . "0x5F92") ;; <CJK>
       (?$AM>(B . "0x9014") ;; <CJK>
       (?$AM?(B . "0x6D82") ;; <CJK>
       (?$AM@(B . "0x5C60") ;; <CJK>
       (?$AMA(B . "0x571F") ;; <CJK>
       (?$AMB(B . "0x5410") ;; <CJK>
       (?$AMC(B . "0x5154") ;; <CJK>
       (?$AMD(B . "0x6E4D") ;; <CJK>
       (?$AME(B . "0x56E2") ;; <CJK>
       (?$AMF(B . "0x63A8") ;; <CJK>
       (?$AMG(B . "0x9893") ;; <CJK>
       (?$AMH(B . "0x817F") ;; <CJK>
       (?$AMI(B . "0x8715") ;; <CJK>
       (?$AMJ(B . "0x892A") ;; <CJK>
       (?$AMK(B . "0x9000") ;; <CJK>
       (?$AML(B . "0x541E") ;; <CJK>
       (?$AMM(B . "0x5C6F") ;; <CJK>
       (?$AMN(B . "0x81C0") ;; <CJK>
       (?$AMO(B . "0x62D6") ;; <CJK>
       (?$AMP(B . "0x6258") ;; <CJK>
       (?$AMQ(B . "0x8131") ;; <CJK>
       (?$AMR(B . "0x9E35") ;; <CJK>
       (?$AMS(B . "0x9640") ;; <CJK>
       (?$AMT(B . "0x9A6E") ;; <CJK>
       (?$AMU(B . "0x9A7C") ;; <CJK>
       (?$AMV(B . "0x692D") ;; <CJK>
       (?$AMW(B . "0x59A5") ;; <CJK>
       (?$AMX(B . "0x62D3") ;; <CJK>
       (?$AMY(B . "0x553E") ;; <CJK>
       (?$AMZ(B . "0x6316") ;; <CJK>
       (?$AM[(B . "0x54C7") ;; <CJK>
       (?$AM\(B . "0x86D9") ;; <CJK>
       (?$AM](B . "0x6D3C") ;; <CJK>
       (?$AM^(B . "0x5A03") ;; <CJK>
       (?$AM_(B . "0x74E6") ;; <CJK>
       (?$AM`(B . "0x889C") ;; <CJK>
       (?$AMa(B . "0x6B6A") ;; <CJK>
       (?$AMb(B . "0x5916") ;; <CJK>
       (?$AMc(B . "0x8C4C") ;; <CJK>
       (?$AMd(B . "0x5F2F") ;; <CJK>
       (?$AMe(B . "0x6E7E") ;; <CJK>
       (?$AMf(B . "0x73A9") ;; <CJK>
       (?$AMg(B . "0x987D") ;; <CJK>
       (?$AMh(B . "0x4E38") ;; <CJK>
       (?$AMi(B . "0x70F7") ;; <CJK>
       (?$AMj(B . "0x5B8C") ;; <CJK>
       (?$AMk(B . "0x7897") ;; <CJK>
       (?$AMl(B . "0x633D") ;; <CJK>
       (?$AMm(B . "0x665A") ;; <CJK>
       (?$AMn(B . "0x7696") ;; <CJK>
       (?$AMo(B . "0x60CB") ;; <CJK>
       (?$AMp(B . "0x5B9B") ;; <CJK>
       (?$AMq(B . "0x5A49") ;; <CJK>
       (?$AMr(B . "0x4E07") ;; <CJK>
       (?$AMs(B . "0x8155") ;; <CJK>
       (?$AMt(B . "0x6C6A") ;; <CJK>
       (?$AMu(B . "0x738B") ;; <CJK>
       (?$AMv(B . "0x4EA1") ;; <CJK>
       (?$AMw(B . "0x6789") ;; <CJK>
       (?$AMx(B . "0x7F51") ;; <CJK>
       (?$AMy(B . "0x5F80") ;; <CJK>
       (?$AMz(B . "0x65FA") ;; <CJK>
       (?$AM{(B . "0x671B") ;; <CJK>
       (?$AM|(B . "0x5FD8") ;; <CJK>
       (?$AM}(B . "0x5984") ;; <CJK>
       (?$AM~(B . "0x5A01") ;; <CJK>
       (?$AN!(B . "0x5DCD") ;; <CJK>
       (?$AN"(B . "0x5FAE") ;; <CJK>
       (?$AN#(B . "0x5371") ;; <CJK>
       (?$AN$(B . "0x97E6") ;; <CJK>
       (?$AN%(B . "0x8FDD") ;; <CJK>
       (?$AN&(B . "0x6845") ;; <CJK>
       (?$AN'(B . "0x56F4") ;; <CJK>
       (?$AN((B . "0x552F") ;; <CJK>
       (?$AN)(B . "0x60DF") ;; <CJK>
       (?$AN*(B . "0x4E3A") ;; <CJK>
       (?$AN+(B . "0x6F4D") ;; <CJK>
       (?$AN,(B . "0x7EF4") ;; <CJK>
       (?$AN-(B . "0x82C7") ;; <CJK>
       (?$AN.(B . "0x840E") ;; <CJK>
       (?$AN/(B . "0x59D4") ;; <CJK>
       (?$AN0(B . "0x4F1F") ;; <CJK>
       (?$AN1(B . "0x4F2A") ;; <CJK>
       (?$AN2(B . "0x5C3E") ;; <CJK>
       (?$AN3(B . "0x7EAC") ;; <CJK>
       (?$AN4(B . "0x672A") ;; <CJK>
       (?$AN5(B . "0x851A") ;; <CJK>
       (?$AN6(B . "0x5473") ;; <CJK>
       (?$AN7(B . "0x754F") ;; <CJK>
       (?$AN8(B . "0x80C3") ;; <CJK>
       (?$AN9(B . "0x5582") ;; <CJK>
       (?$AN:(B . "0x9B4F") ;; <CJK>
       (?$AN;(B . "0x4F4D") ;; <CJK>
       (?$AN<(B . "0x6E2D") ;; <CJK>
       (?$AN=(B . "0x8C13") ;; <CJK>
       (?$AN>(B . "0x5C09") ;; <CJK>
       (?$AN?(B . "0x6170") ;; <CJK>
       (?$AN@(B . "0x536B") ;; <CJK>
       (?$ANA(B . "0x761F") ;; <CJK>
       (?$ANB(B . "0x6E29") ;; <CJK>
       (?$ANC(B . "0x868A") ;; <CJK>
       (?$AND(B . "0x6587") ;; <CJK>
       (?$ANE(B . "0x95FB") ;; <CJK>
       (?$ANF(B . "0x7EB9") ;; <CJK>
       (?$ANG(B . "0x543B") ;; <CJK>
       (?$ANH(B . "0x7A33") ;; <CJK>
       (?$ANI(B . "0x7D0A") ;; <CJK>
       (?$ANJ(B . "0x95EE") ;; <CJK>
       (?$ANK(B . "0x55E1") ;; <CJK>
       (?$ANL(B . "0x7FC1") ;; <CJK>
       (?$ANM(B . "0x74EE") ;; <CJK>
       (?$ANN(B . "0x631D") ;; <CJK>
       (?$ANO(B . "0x8717") ;; <CJK>
       (?$ANP(B . "0x6DA1") ;; <CJK>
       (?$ANQ(B . "0x7A9D") ;; <CJK>
       (?$ANR(B . "0x6211") ;; <CJK>
       (?$ANS(B . "0x65A1") ;; <CJK>
       (?$ANT(B . "0x5367") ;; <CJK>
       (?$ANU(B . "0x63E1") ;; <CJK>
       (?$ANV(B . "0x6C83") ;; <CJK>
       (?$ANW(B . "0x5DEB") ;; <CJK>
       (?$ANX(B . "0x545C") ;; <CJK>
       (?$ANY(B . "0x94A8") ;; <CJK>
       (?$ANZ(B . "0x4E4C") ;; <CJK>
       (?$AN[(B . "0x6C61") ;; <CJK>
       (?$AN\(B . "0x8BEC") ;; <CJK>
       (?$AN](B . "0x5C4B") ;; <CJK>
       (?$AN^(B . "0x65E0") ;; <CJK>
       (?$AN_(B . "0x829C") ;; <CJK>
       (?$AN`(B . "0x68A7") ;; <CJK>
       (?$ANa(B . "0x543E") ;; <CJK>
       (?$ANb(B . "0x5434") ;; <CJK>
       (?$ANc(B . "0x6BCB") ;; <CJK>
       (?$ANd(B . "0x6B66") ;; <CJK>
       (?$ANe(B . "0x4E94") ;; <CJK>
       (?$ANf(B . "0x6342") ;; <CJK>
       (?$ANg(B . "0x5348") ;; <CJK>
       (?$ANh(B . "0x821E") ;; <CJK>
       (?$ANi(B . "0x4F0D") ;; <CJK>
       (?$ANj(B . "0x4FAE") ;; <CJK>
       (?$ANk(B . "0x575E") ;; <CJK>
       (?$ANl(B . "0x620A") ;; <CJK>
       (?$ANm(B . "0x96FE") ;; <CJK>
       (?$ANn(B . "0x6664") ;; <CJK>
       (?$ANo(B . "0x7269") ;; <CJK>
       (?$ANp(B . "0x52FF") ;; <CJK>
       (?$ANq(B . "0x52A1") ;; <CJK>
       (?$ANr(B . "0x609F") ;; <CJK>
       (?$ANs(B . "0x8BEF") ;; <CJK>
       (?$ANt(B . "0x6614") ;; <CJK>
       (?$ANu(B . "0x7199") ;; <CJK>
       (?$ANv(B . "0x6790") ;; <CJK>
       (?$ANw(B . "0x897F") ;; <CJK>
       (?$ANx(B . "0x7852") ;; <CJK>
       (?$ANy(B . "0x77FD") ;; <CJK>
       (?$ANz(B . "0x6670") ;; <CJK>
       (?$AN{(B . "0x563B") ;; <CJK>
       (?$AN|(B . "0x5438") ;; <CJK>
       (?$AN}(B . "0x9521") ;; <CJK>
       (?$AN~(B . "0x727A") ;; <CJK>
       (?$AO!(B . "0x7A00") ;; <CJK>
       (?$AO"(B . "0x606F") ;; <CJK>
       (?$AO#(B . "0x5E0C") ;; <CJK>
       (?$AO$(B . "0x6089") ;; <CJK>
       (?$AO%(B . "0x819D") ;; <CJK>
       (?$AO&(B . "0x5915") ;; <CJK>
       (?$AO'(B . "0x60DC") ;; <CJK>
       (?$AO((B . "0x7184") ;; <CJK>
       (?$AO)(B . "0x70EF") ;; <CJK>
       (?$AO*(B . "0x6EAA") ;; <CJK>
       (?$AO+(B . "0x6C50") ;; <CJK>
       (?$AO,(B . "0x7280") ;; <CJK>
       (?$AO-(B . "0x6A84") ;; <CJK>
       (?$AO.(B . "0x88AD") ;; <CJK>
       (?$AO/(B . "0x5E2D") ;; <CJK>
       (?$AO0(B . "0x4E60") ;; <CJK>
       (?$AO1(B . "0x5AB3") ;; <CJK>
       (?$AO2(B . "0x559C") ;; <CJK>
       (?$AO3(B . "0x94E3") ;; <CJK>
       (?$AO4(B . "0x6D17") ;; <CJK>
       (?$AO5(B . "0x7CFB") ;; <CJK>
       (?$AO6(B . "0x9699") ;; <CJK>
       (?$AO7(B . "0x620F") ;; <CJK>
       (?$AO8(B . "0x7EC6") ;; <CJK>
       (?$AO9(B . "0x778E") ;; <CJK>
       (?$AO:(B . "0x867E") ;; <CJK>
       (?$AO;(B . "0x5323") ;; <CJK>
       (?$AO<(B . "0x971E") ;; <CJK>
       (?$AO=(B . "0x8F96") ;; <CJK>
       (?$AO>(B . "0x6687") ;; <CJK>
       (?$AO?(B . "0x5CE1") ;; <CJK>
       (?$AO@(B . "0x4FA0") ;; <CJK>
       (?$AOA(B . "0x72ED") ;; <CJK>
       (?$AOB(B . "0x4E0B") ;; <CJK>
       (?$AOC(B . "0x53A6") ;; <CJK>
       (?$AOD(B . "0x590F") ;; <CJK>
       (?$AOE(B . "0x5413") ;; <CJK>
       (?$AOF(B . "0x6380") ;; <CJK>
       (?$AOG(B . "0x9528") ;; <CJK>
       (?$AOH(B . "0x5148") ;; <CJK>
       (?$AOI(B . "0x4ED9") ;; <CJK>
       (?$AOJ(B . "0x9C9C") ;; <CJK>
       (?$AOK(B . "0x7EA4") ;; <CJK>
       (?$AOL(B . "0x54B8") ;; <CJK>
       (?$AOM(B . "0x8D24") ;; <CJK>
       (?$AON(B . "0x8854") ;; <CJK>
       (?$AOO(B . "0x8237") ;; <CJK>
       (?$AOP(B . "0x95F2") ;; <CJK>
       (?$AOQ(B . "0x6D8E") ;; <CJK>
       (?$AOR(B . "0x5F26") ;; <CJK>
       (?$AOS(B . "0x5ACC") ;; <CJK>
       (?$AOT(B . "0x663E") ;; <CJK>
       (?$AOU(B . "0x9669") ;; <CJK>
       (?$AOV(B . "0x73B0") ;; <CJK>
       (?$AOW(B . "0x732E") ;; <CJK>
       (?$AOX(B . "0x53BF") ;; <CJK>
       (?$AOY(B . "0x817A") ;; <CJK>
       (?$AOZ(B . "0x9985") ;; <CJK>
       (?$AO[(B . "0x7FA1") ;; <CJK>
       (?$AO\(B . "0x5BAA") ;; <CJK>
       (?$AO](B . "0x9677") ;; <CJK>
       (?$AO^(B . "0x9650") ;; <CJK>
       (?$AO_(B . "0x7EBF") ;; <CJK>
       (?$AO`(B . "0x76F8") ;; <CJK>
       (?$AOa(B . "0x53A2") ;; <CJK>
       (?$AOb(B . "0x9576") ;; <CJK>
       (?$AOc(B . "0x9999") ;; <CJK>
       (?$AOd(B . "0x7BB1") ;; <CJK>
       (?$AOe(B . "0x8944") ;; <CJK>
       (?$AOf(B . "0x6E58") ;; <CJK>
       (?$AOg(B . "0x4E61") ;; <CJK>
       (?$AOh(B . "0x7FD4") ;; <CJK>
       (?$AOi(B . "0x7965") ;; <CJK>
       (?$AOj(B . "0x8BE6") ;; <CJK>
       (?$AOk(B . "0x60F3") ;; <CJK>
       (?$AOl(B . "0x54CD") ;; <CJK>
       (?$AOm(B . "0x4EAB") ;; <CJK>
       (?$AOn(B . "0x9879") ;; <CJK>
       (?$AOo(B . "0x5DF7") ;; <CJK>
       (?$AOp(B . "0x6A61") ;; <CJK>
       (?$AOq(B . "0x50CF") ;; <CJK>
       (?$AOr(B . "0x5411") ;; <CJK>
       (?$AOs(B . "0x8C61") ;; <CJK>
       (?$AOt(B . "0x8427") ;; <CJK>
       (?$AOu(B . "0x785D") ;; <CJK>
       (?$AOv(B . "0x9704") ;; <CJK>
       (?$AOw(B . "0x524A") ;; <CJK>
       (?$AOx(B . "0x54EE") ;; <CJK>
       (?$AOy(B . "0x56A3") ;; <CJK>
       (?$AOz(B . "0x9500") ;; <CJK>
       (?$AO{(B . "0x6D88") ;; <CJK>
       (?$AO|(B . "0x5BB5") ;; <CJK>
       (?$AO}(B . "0x6DC6") ;; <CJK>
       (?$AO~(B . "0x6653") ;; <CJK>
       (?$AP!(B . "0x5C0F") ;; <CJK>
       (?$AP"(B . "0x5B5D") ;; <CJK>
       (?$AP#(B . "0x6821") ;; <CJK>
       (?$AP$(B . "0x8096") ;; <CJK>
       (?$AP%(B . "0x5578") ;; <CJK>
       (?$AP&(B . "0x7B11") ;; <CJK>
       (?$AP'(B . "0x6548") ;; <CJK>
       (?$AP((B . "0x6954") ;; <CJK>
       (?$AP)(B . "0x4E9B") ;; <CJK>
       (?$AP*(B . "0x6B47") ;; <CJK>
       (?$AP+(B . "0x874E") ;; <CJK>
       (?$AP,(B . "0x978B") ;; <CJK>
       (?$AP-(B . "0x534F") ;; <CJK>
       (?$AP.(B . "0x631F") ;; <CJK>
       (?$AP/(B . "0x643A") ;; <CJK>
       (?$AP0(B . "0x90AA") ;; <CJK>
       (?$AP1(B . "0x659C") ;; <CJK>
       (?$AP2(B . "0x80C1") ;; <CJK>
       (?$AP3(B . "0x8C10") ;; <CJK>
       (?$AP4(B . "0x5199") ;; <CJK>
       (?$AP5(B . "0x68B0") ;; <CJK>
       (?$AP6(B . "0x5378") ;; <CJK>
       (?$AP7(B . "0x87F9") ;; <CJK>
       (?$AP8(B . "0x61C8") ;; <CJK>
       (?$AP9(B . "0x6CC4") ;; <CJK>
       (?$AP:(B . "0x6CFB") ;; <CJK>
       (?$AP;(B . "0x8C22") ;; <CJK>
       (?$AP<(B . "0x5C51") ;; <CJK>
       (?$AP=(B . "0x85AA") ;; <CJK>
       (?$AP>(B . "0x82AF") ;; <CJK>
       (?$AP?(B . "0x950C") ;; <CJK>
       (?$AP@(B . "0x6B23") ;; <CJK>
       (?$APA(B . "0x8F9B") ;; <CJK>
       (?$APB(B . "0x65B0") ;; <CJK>
       (?$APC(B . "0x5FFB") ;; <CJK>
       (?$APD(B . "0x5FC3") ;; <CJK>
       (?$APE(B . "0x4FE1") ;; <CJK>
       (?$APF(B . "0x8845") ;; <CJK>
       (?$APG(B . "0x661F") ;; <CJK>
       (?$APH(B . "0x8165") ;; <CJK>
       (?$API(B . "0x7329") ;; <CJK>
       (?$APJ(B . "0x60FA") ;; <CJK>
       (?$APK(B . "0x5174") ;; <CJK>
       (?$APL(B . "0x5211") ;; <CJK>
       (?$APM(B . "0x578B") ;; <CJK>
       (?$APN(B . "0x5F62") ;; <CJK>
       (?$APO(B . "0x90A2") ;; <CJK>
       (?$APP(B . "0x884C") ;; <CJK>
       (?$APQ(B . "0x9192") ;; <CJK>
       (?$APR(B . "0x5E78") ;; <CJK>
       (?$APS(B . "0x674F") ;; <CJK>
       (?$APT(B . "0x6027") ;; <CJK>
       (?$APU(B . "0x59D3") ;; <CJK>
       (?$APV(B . "0x5144") ;; <CJK>
       (?$APW(B . "0x51F6") ;; <CJK>
       (?$APX(B . "0x80F8") ;; <CJK>
       (?$APY(B . "0x5308") ;; <CJK>
       (?$APZ(B . "0x6C79") ;; <CJK>
       (?$AP[(B . "0x96C4") ;; <CJK>
       (?$AP\(B . "0x718A") ;; <CJK>
       (?$AP](B . "0x4F11") ;; <CJK>
       (?$AP^(B . "0x4FEE") ;; <CJK>
       (?$AP_(B . "0x7F9E") ;; <CJK>
       (?$AP`(B . "0x673D") ;; <CJK>
       (?$APa(B . "0x55C5") ;; <CJK>
       (?$APb(B . "0x9508") ;; <CJK>
       (?$APc(B . "0x79C0") ;; <CJK>
       (?$APd(B . "0x8896") ;; <CJK>
       (?$APe(B . "0x7EE3") ;; <CJK>
       (?$APf(B . "0x589F") ;; <CJK>
       (?$APg(B . "0x620C") ;; <CJK>
       (?$APh(B . "0x9700") ;; <CJK>
       (?$APi(B . "0x865A") ;; <CJK>
       (?$APj(B . "0x5618") ;; <CJK>
       (?$APk(B . "0x987B") ;; <CJK>
       (?$APl(B . "0x5F90") ;; <CJK>
       (?$APm(B . "0x8BB8") ;; <CJK>
       (?$APn(B . "0x84C4") ;; <CJK>
       (?$APo(B . "0x9157") ;; <CJK>
       (?$APp(B . "0x53D9") ;; <CJK>
       (?$APq(B . "0x65ED") ;; <CJK>
       (?$APr(B . "0x5E8F") ;; <CJK>
       (?$APs(B . "0x755C") ;; <CJK>
       (?$APt(B . "0x6064") ;; <CJK>
       (?$APu(B . "0x7D6E") ;; <CJK>
       (?$APv(B . "0x5A7F") ;; <CJK>
       (?$APw(B . "0x7EEA") ;; <CJK>
       (?$APx(B . "0x7EED") ;; <CJK>
       (?$APy(B . "0x8F69") ;; <CJK>
       (?$APz(B . "0x55A7") ;; <CJK>
       (?$AP{(B . "0x5BA3") ;; <CJK>
       (?$AP|(B . "0x60AC") ;; <CJK>
       (?$AP}(B . "0x65CB") ;; <CJK>
       (?$AP~(B . "0x7384") ;; <CJK>
       (?$AQ!(B . "0x9009") ;; <CJK>
       (?$AQ"(B . "0x7663") ;; <CJK>
       (?$AQ#(B . "0x7729") ;; <CJK>
       (?$AQ$(B . "0x7EDA") ;; <CJK>
       (?$AQ%(B . "0x9774") ;; <CJK>
       (?$AQ&(B . "0x859B") ;; <CJK>
       (?$AQ'(B . "0x5B66") ;; <CJK>
       (?$AQ((B . "0x7A74") ;; <CJK>
       (?$AQ)(B . "0x96EA") ;; <CJK>
       (?$AQ*(B . "0x8840") ;; <CJK>
       (?$AQ+(B . "0x52CB") ;; <CJK>
       (?$AQ,(B . "0x718F") ;; <CJK>
       (?$AQ-(B . "0x5FAA") ;; <CJK>
       (?$AQ.(B . "0x65EC") ;; <CJK>
       (?$AQ/(B . "0x8BE2") ;; <CJK>
       (?$AQ0(B . "0x5BFB") ;; <CJK>
       (?$AQ1(B . "0x9A6F") ;; <CJK>
       (?$AQ2(B . "0x5DE1") ;; <CJK>
       (?$AQ3(B . "0x6B89") ;; <CJK>
       (?$AQ4(B . "0x6C5B") ;; <CJK>
       (?$AQ5(B . "0x8BAD") ;; <CJK>
       (?$AQ6(B . "0x8BAF") ;; <CJK>
       (?$AQ7(B . "0x900A") ;; <CJK>
       (?$AQ8(B . "0x8FC5") ;; <CJK>
       (?$AQ9(B . "0x538B") ;; <CJK>
       (?$AQ:(B . "0x62BC") ;; <CJK>
       (?$AQ;(B . "0x9E26") ;; <CJK>
       (?$AQ<(B . "0x9E2D") ;; <CJK>
       (?$AQ=(B . "0x5440") ;; <CJK>
       (?$AQ>(B . "0x4E2B") ;; <CJK>
       (?$AQ?(B . "0x82BD") ;; <CJK>
       (?$AQ@(B . "0x7259") ;; <CJK>
       (?$AQA(B . "0x869C") ;; <CJK>
       (?$AQB(B . "0x5D16") ;; <CJK>
       (?$AQC(B . "0x8859") ;; <CJK>
       (?$AQD(B . "0x6DAF") ;; <CJK>
       (?$AQE(B . "0x96C5") ;; <CJK>
       (?$AQF(B . "0x54D1") ;; <CJK>
       (?$AQG(B . "0x4E9A") ;; <CJK>
       (?$AQH(B . "0x8BB6") ;; <CJK>
       (?$AQI(B . "0x7109") ;; <CJK>
       (?$AQJ(B . "0x54BD") ;; <CJK>
       (?$AQK(B . "0x9609") ;; <CJK>
       (?$AQL(B . "0x70DF") ;; <CJK>
       (?$AQM(B . "0x6DF9") ;; <CJK>
       (?$AQN(B . "0x76D0") ;; <CJK>
       (?$AQO(B . "0x4E25") ;; <CJK>
       (?$AQP(B . "0x7814") ;; <CJK>
       (?$AQQ(B . "0x8712") ;; <CJK>
       (?$AQR(B . "0x5CA9") ;; <CJK>
       (?$AQS(B . "0x5EF6") ;; <CJK>
       (?$AQT(B . "0x8A00") ;; <CJK>
       (?$AQU(B . "0x989C") ;; <CJK>
       (?$AQV(B . "0x960E") ;; <CJK>
       (?$AQW(B . "0x708E") ;; <CJK>
       (?$AQX(B . "0x6CBF") ;; <CJK>
       (?$AQY(B . "0x5944") ;; <CJK>
       (?$AQZ(B . "0x63A9") ;; <CJK>
       (?$AQ[(B . "0x773C") ;; <CJK>
       (?$AQ\(B . "0x884D") ;; <CJK>
       (?$AQ](B . "0x6F14") ;; <CJK>
       (?$AQ^(B . "0x8273") ;; <CJK>
       (?$AQ_(B . "0x5830") ;; <CJK>
       (?$AQ`(B . "0x71D5") ;; <CJK>
       (?$AQa(B . "0x538C") ;; <CJK>
       (?$AQb(B . "0x781A") ;; <CJK>
       (?$AQc(B . "0x96C1") ;; <CJK>
       (?$AQd(B . "0x5501") ;; <CJK>
       (?$AQe(B . "0x5F66") ;; <CJK>
       (?$AQf(B . "0x7130") ;; <CJK>
       (?$AQg(B . "0x5BB4") ;; <CJK>
       (?$AQh(B . "0x8C1A") ;; <CJK>
       (?$AQi(B . "0x9A8C") ;; <CJK>
       (?$AQj(B . "0x6B83") ;; <CJK>
       (?$AQk(B . "0x592E") ;; <CJK>
       (?$AQl(B . "0x9E2F") ;; <CJK>
       (?$AQm(B . "0x79E7") ;; <CJK>
       (?$AQn(B . "0x6768") ;; <CJK>
       (?$AQo(B . "0x626C") ;; <CJK>
       (?$AQp(B . "0x4F6F") ;; <CJK>
       (?$AQq(B . "0x75A1") ;; <CJK>
       (?$AQr(B . "0x7F8A") ;; <CJK>
       (?$AQs(B . "0x6D0B") ;; <CJK>
       (?$AQt(B . "0x9633") ;; <CJK>
       (?$AQu(B . "0x6C27") ;; <CJK>
       (?$AQv(B . "0x4EF0") ;; <CJK>
       (?$AQw(B . "0x75D2") ;; <CJK>
       (?$AQx(B . "0x517B") ;; <CJK>
       (?$AQy(B . "0x6837") ;; <CJK>
       (?$AQz(B . "0x6F3E") ;; <CJK>
       (?$AQ{(B . "0x9080") ;; <CJK>
       (?$AQ|(B . "0x8170") ;; <CJK>
       (?$AQ}(B . "0x5996") ;; <CJK>
       (?$AQ~(B . "0x7476") ;; <CJK>
       (?$AR!(B . "0x6447") ;; <CJK>
       (?$AR"(B . "0x5C27") ;; <CJK>
       (?$AR#(B . "0x9065") ;; <CJK>
       (?$AR$(B . "0x7A91") ;; <CJK>
       (?$AR%(B . "0x8C23") ;; <CJK>
       (?$AR&(B . "0x59DA") ;; <CJK>
       (?$AR'(B . "0x54AC") ;; <CJK>
       (?$AR((B . "0x8200") ;; <CJK>
       (?$AR)(B . "0x836F") ;; <CJK>
       (?$AR*(B . "0x8981") ;; <CJK>
       (?$AR+(B . "0x8000") ;; <CJK>
       (?$AR,(B . "0x6930") ;; <CJK>
       (?$AR-(B . "0x564E") ;; <CJK>
       (?$AR.(B . "0x8036") ;; <CJK>
       (?$AR/(B . "0x7237") ;; <CJK>
       (?$AR0(B . "0x91CE") ;; <CJK>
       (?$AR1(B . "0x51B6") ;; <CJK>
       (?$AR2(B . "0x4E5F") ;; <CJK>
       (?$AR3(B . "0x9875") ;; <CJK>
       (?$AR4(B . "0x6396") ;; <CJK>
       (?$AR5(B . "0x4E1A") ;; <CJK>
       (?$AR6(B . "0x53F6") ;; <CJK>
       (?$AR7(B . "0x66F3") ;; <CJK>
       (?$AR8(B . "0x814B") ;; <CJK>
       (?$AR9(B . "0x591C") ;; <CJK>
       (?$AR:(B . "0x6DB2") ;; <CJK>
       (?$AR;(B . "0x4E00") ;; <CJK>
       (?$AR<(B . "0x58F9") ;; <CJK>
       (?$AR=(B . "0x533B") ;; <CJK>
       (?$AR>(B . "0x63D6") ;; <CJK>
       (?$AR?(B . "0x94F1") ;; <CJK>
       (?$AR@(B . "0x4F9D") ;; <CJK>
       (?$ARA(B . "0x4F0A") ;; <CJK>
       (?$ARB(B . "0x8863") ;; <CJK>
       (?$ARC(B . "0x9890") ;; <CJK>
       (?$ARD(B . "0x5937") ;; <CJK>
       (?$ARE(B . "0x9057") ;; <CJK>
       (?$ARF(B . "0x79FB") ;; <CJK>
       (?$ARG(B . "0x4EEA") ;; <CJK>
       (?$ARH(B . "0x80F0") ;; <CJK>
       (?$ARI(B . "0x7591") ;; <CJK>
       (?$ARJ(B . "0x6C82") ;; <CJK>
       (?$ARK(B . "0x5B9C") ;; <CJK>
       (?$ARL(B . "0x59E8") ;; <CJK>
       (?$ARM(B . "0x5F5D") ;; <CJK>
       (?$ARN(B . "0x6905") ;; <CJK>
       (?$ARO(B . "0x8681") ;; <CJK>
       (?$ARP(B . "0x501A") ;; <CJK>
       (?$ARQ(B . "0x5DF2") ;; <CJK>
       (?$ARR(B . "0x4E59") ;; <CJK>
       (?$ARS(B . "0x77E3") ;; <CJK>
       (?$ART(B . "0x4EE5") ;; <CJK>
       (?$ARU(B . "0x827A") ;; <CJK>
       (?$ARV(B . "0x6291") ;; <CJK>
       (?$ARW(B . "0x6613") ;; <CJK>
       (?$ARX(B . "0x9091") ;; <CJK>
       (?$ARY(B . "0x5C79") ;; <CJK>
       (?$ARZ(B . "0x4EBF") ;; <CJK>
       (?$AR[(B . "0x5F79") ;; <CJK>
       (?$AR\(B . "0x81C6") ;; <CJK>
       (?$AR](B . "0x9038") ;; <CJK>
       (?$AR^(B . "0x8084") ;; <CJK>
       (?$AR_(B . "0x75AB") ;; <CJK>
       (?$AR`(B . "0x4EA6") ;; <CJK>
       (?$ARa(B . "0x88D4") ;; <CJK>
       (?$ARb(B . "0x610F") ;; <CJK>
       (?$ARc(B . "0x6BC5") ;; <CJK>
       (?$ARd(B . "0x5FC6") ;; <CJK>
       (?$ARe(B . "0x4E49") ;; <CJK>
       (?$ARf(B . "0x76CA") ;; <CJK>
       (?$ARg(B . "0x6EA2") ;; <CJK>
       (?$ARh(B . "0x8BE3") ;; <CJK>
       (?$ARi(B . "0x8BAE") ;; <CJK>
       (?$ARj(B . "0x8C0A") ;; <CJK>
       (?$ARk(B . "0x8BD1") ;; <CJK>
       (?$ARl(B . "0x5F02") ;; <CJK>
       (?$ARm(B . "0x7FFC") ;; <CJK>
       (?$ARn(B . "0x7FCC") ;; <CJK>
       (?$ARo(B . "0x7ECE") ;; <CJK>
       (?$ARp(B . "0x8335") ;; <CJK>
       (?$ARq(B . "0x836B") ;; <CJK>
       (?$ARr(B . "0x56E0") ;; <CJK>
       (?$ARs(B . "0x6BB7") ;; <CJK>
       (?$ARt(B . "0x97F3") ;; <CJK>
       (?$ARu(B . "0x9634") ;; <CJK>
       (?$ARv(B . "0x59FB") ;; <CJK>
       (?$ARw(B . "0x541F") ;; <CJK>
       (?$ARx(B . "0x94F6") ;; <CJK>
       (?$ARy(B . "0x6DEB") ;; <CJK>
       (?$ARz(B . "0x5BC5") ;; <CJK>
       (?$AR{(B . "0x996E") ;; <CJK>
       (?$AR|(B . "0x5C39") ;; <CJK>
       (?$AR}(B . "0x5F15") ;; <CJK>
       (?$AR~(B . "0x9690") ;; <CJK>
       (?$AS!(B . "0x5370") ;; <CJK>
       (?$AS"(B . "0x82F1") ;; <CJK>
       (?$AS#(B . "0x6A31") ;; <CJK>
       (?$AS$(B . "0x5A74") ;; <CJK>
       (?$AS%(B . "0x9E70") ;; <CJK>
       (?$AS&(B . "0x5E94") ;; <CJK>
       (?$AS'(B . "0x7F28") ;; <CJK>
       (?$AS((B . "0x83B9") ;; <CJK>
       (?$AS)(B . "0x8424") ;; <CJK>
       (?$AS*(B . "0x8425") ;; <CJK>
       (?$AS+(B . "0x8367") ;; <CJK>
       (?$AS,(B . "0x8747") ;; <CJK>
       (?$AS-(B . "0x8FCE") ;; <CJK>
       (?$AS.(B . "0x8D62") ;; <CJK>
       (?$AS/(B . "0x76C8") ;; <CJK>
       (?$AS0(B . "0x5F71") ;; <CJK>
       (?$AS1(B . "0x9896") ;; <CJK>
       (?$AS2(B . "0x786C") ;; <CJK>
       (?$AS3(B . "0x6620") ;; <CJK>
       (?$AS4(B . "0x54DF") ;; <CJK>
       (?$AS5(B . "0x62E5") ;; <CJK>
       (?$AS6(B . "0x4F63") ;; <CJK>
       (?$AS7(B . "0x81C3") ;; <CJK>
       (?$AS8(B . "0x75C8") ;; <CJK>
       (?$AS9(B . "0x5EB8") ;; <CJK>
       (?$AS:(B . "0x96CD") ;; <CJK>
       (?$AS;(B . "0x8E0A") ;; <CJK>
       (?$AS<(B . "0x86F9") ;; <CJK>
       (?$AS=(B . "0x548F") ;; <CJK>
       (?$AS>(B . "0x6CF3") ;; <CJK>
       (?$AS?(B . "0x6D8C") ;; <CJK>
       (?$AS@(B . "0x6C38") ;; <CJK>
       (?$ASA(B . "0x607F") ;; <CJK>
       (?$ASB(B . "0x52C7") ;; <CJK>
       (?$ASC(B . "0x7528") ;; <CJK>
       (?$ASD(B . "0x5E7D") ;; <CJK>
       (?$ASE(B . "0x4F18") ;; <CJK>
       (?$ASF(B . "0x60A0") ;; <CJK>
       (?$ASG(B . "0x5FE7") ;; <CJK>
       (?$ASH(B . "0x5C24") ;; <CJK>
       (?$ASI(B . "0x7531") ;; <CJK>
       (?$ASJ(B . "0x90AE") ;; <CJK>
       (?$ASK(B . "0x94C0") ;; <CJK>
       (?$ASL(B . "0x72B9") ;; <CJK>
       (?$ASM(B . "0x6CB9") ;; <CJK>
       (?$ASN(B . "0x6E38") ;; <CJK>
       (?$ASO(B . "0x9149") ;; <CJK>
       (?$ASP(B . "0x6709") ;; <CJK>
       (?$ASQ(B . "0x53CB") ;; <CJK>
       (?$ASR(B . "0x53F3") ;; <CJK>
       (?$ASS(B . "0x4F51") ;; <CJK>
       (?$AST(B . "0x91C9") ;; <CJK>
       (?$ASU(B . "0x8BF1") ;; <CJK>
       (?$ASV(B . "0x53C8") ;; <CJK>
       (?$ASW(B . "0x5E7C") ;; <CJK>
       (?$ASX(B . "0x8FC2") ;; <CJK>
       (?$ASY(B . "0x6DE4") ;; <CJK>
       (?$ASZ(B . "0x4E8E") ;; <CJK>
       (?$AS[(B . "0x76C2") ;; <CJK>
       (?$AS\(B . "0x6986") ;; <CJK>
       (?$AS](B . "0x865E") ;; <CJK>
       (?$AS^(B . "0x611A") ;; <CJK>
       (?$AS_(B . "0x8206") ;; <CJK>
       (?$AS`(B . "0x4F59") ;; <CJK>
       (?$ASa(B . "0x4FDE") ;; <CJK>
       (?$ASb(B . "0x903E") ;; <CJK>
       (?$ASc(B . "0x9C7C") ;; <CJK>
       (?$ASd(B . "0x6109") ;; <CJK>
       (?$ASe(B . "0x6E1D") ;; <CJK>
       (?$ASf(B . "0x6E14") ;; <CJK>
       (?$ASg(B . "0x9685") ;; <CJK>
       (?$ASh(B . "0x4E88") ;; <CJK>
       (?$ASi(B . "0x5A31") ;; <CJK>
       (?$ASj(B . "0x96E8") ;; <CJK>
       (?$ASk(B . "0x4E0E") ;; <CJK>
       (?$ASl(B . "0x5C7F") ;; <CJK>
       (?$ASm(B . "0x79B9") ;; <CJK>
       (?$ASn(B . "0x5B87") ;; <CJK>
       (?$ASo(B . "0x8BED") ;; <CJK>
       (?$ASp(B . "0x7FBD") ;; <CJK>
       (?$ASq(B . "0x7389") ;; <CJK>
       (?$ASr(B . "0x57DF") ;; <CJK>
       (?$ASs(B . "0x828B") ;; <CJK>
       (?$ASt(B . "0x90C1") ;; <CJK>
       (?$ASu(B . "0x5401") ;; <CJK>
       (?$ASv(B . "0x9047") ;; <CJK>
       (?$ASw(B . "0x55BB") ;; <CJK>
       (?$ASx(B . "0x5CEA") ;; <CJK>
       (?$ASy(B . "0x5FA1") ;; <CJK>
       (?$ASz(B . "0x6108") ;; <CJK>
       (?$AS{(B . "0x6B32") ;; <CJK>
       (?$AS|(B . "0x72F1") ;; <CJK>
       (?$AS}(B . "0x80B2") ;; <CJK>
       (?$AS~(B . "0x8A89") ;; <CJK>
       (?$AT!(B . "0x6D74") ;; <CJK>
       (?$AT"(B . "0x5BD3") ;; <CJK>
       (?$AT#(B . "0x88D5") ;; <CJK>
       (?$AT$(B . "0x9884") ;; <CJK>
       (?$AT%(B . "0x8C6B") ;; <CJK>
       (?$AT&(B . "0x9A6D") ;; <CJK>
       (?$AT'(B . "0x9E33") ;; <CJK>
       (?$AT((B . "0x6E0A") ;; <CJK>
       (?$AT)(B . "0x51A4") ;; <CJK>
       (?$AT*(B . "0x5143") ;; <CJK>
       (?$AT+(B . "0x57A3") ;; <CJK>
       (?$AT,(B . "0x8881") ;; <CJK>
       (?$AT-(B . "0x539F") ;; <CJK>
       (?$AT.(B . "0x63F4") ;; <CJK>
       (?$AT/(B . "0x8F95") ;; <CJK>
       (?$AT0(B . "0x56ED") ;; <CJK>
       (?$AT1(B . "0x5458") ;; <CJK>
       (?$AT2(B . "0x5706") ;; <CJK>
       (?$AT3(B . "0x733F") ;; <CJK>
       (?$AT4(B . "0x6E90") ;; <CJK>
       (?$AT5(B . "0x7F18") ;; <CJK>
       (?$AT6(B . "0x8FDC") ;; <CJK>
       (?$AT7(B . "0x82D1") ;; <CJK>
       (?$AT8(B . "0x613F") ;; <CJK>
       (?$AT9(B . "0x6028") ;; <CJK>
       (?$AT:(B . "0x9662") ;; <CJK>
       (?$AT;(B . "0x66F0") ;; <CJK>
       (?$AT<(B . "0x7EA6") ;; <CJK>
       (?$AT=(B . "0x8D8A") ;; <CJK>
       (?$AT>(B . "0x8DC3") ;; <CJK>
       (?$AT?(B . "0x94A5") ;; <CJK>
       (?$AT@(B . "0x5CB3") ;; <CJK>
       (?$ATA(B . "0x7CA4") ;; <CJK>
       (?$ATB(B . "0x6708") ;; <CJK>
       (?$ATC(B . "0x60A6") ;; <CJK>
       (?$ATD(B . "0x9605") ;; <CJK>
       (?$ATE(B . "0x8018") ;; <CJK>
       (?$ATF(B . "0x4E91") ;; <CJK>
       (?$ATG(B . "0x90E7") ;; <CJK>
       (?$ATH(B . "0x5300") ;; <CJK>
       (?$ATI(B . "0x9668") ;; <CJK>
       (?$ATJ(B . "0x5141") ;; <CJK>
       (?$ATK(B . "0x8FD0") ;; <CJK>
       (?$ATL(B . "0x8574") ;; <CJK>
       (?$ATM(B . "0x915D") ;; <CJK>
       (?$ATN(B . "0x6655") ;; <CJK>
       (?$ATO(B . "0x97F5") ;; <CJK>
       (?$ATP(B . "0x5B55") ;; <CJK>
       (?$ATQ(B . "0x531D") ;; <CJK>
       (?$ATR(B . "0x7838") ;; <CJK>
       (?$ATS(B . "0x6742") ;; <CJK>
       (?$ATT(B . "0x683D") ;; <CJK>
       (?$ATU(B . "0x54C9") ;; <CJK>
       (?$ATV(B . "0x707E") ;; <CJK>
       (?$ATW(B . "0x5BB0") ;; <CJK>
       (?$ATX(B . "0x8F7D") ;; <CJK>
       (?$ATY(B . "0x518D") ;; <CJK>
       (?$ATZ(B . "0x5728") ;; <CJK>
       (?$AT[(B . "0x54B1") ;; <CJK>
       (?$AT\(B . "0x6512") ;; <CJK>
       (?$AT](B . "0x6682") ;; <CJK>
       (?$AT^(B . "0x8D5E") ;; <CJK>
       (?$AT_(B . "0x8D43") ;; <CJK>
       (?$AT`(B . "0x810F") ;; <CJK>
       (?$ATa(B . "0x846C") ;; <CJK>
       (?$ATb(B . "0x906D") ;; <CJK>
       (?$ATc(B . "0x7CDF") ;; <CJK>
       (?$ATd(B . "0x51FF") ;; <CJK>
       (?$ATe(B . "0x85FB") ;; <CJK>
       (?$ATf(B . "0x67A3") ;; <CJK>
       (?$ATg(B . "0x65E9") ;; <CJK>
       (?$ATh(B . "0x6FA1") ;; <CJK>
       (?$ATi(B . "0x86A4") ;; <CJK>
       (?$ATj(B . "0x8E81") ;; <CJK>
       (?$ATk(B . "0x566A") ;; <CJK>
       (?$ATl(B . "0x9020") ;; <CJK>
       (?$ATm(B . "0x7682") ;; <CJK>
       (?$ATn(B . "0x7076") ;; <CJK>
       (?$ATo(B . "0x71E5") ;; <CJK>
       (?$ATp(B . "0x8D23") ;; <CJK>
       (?$ATq(B . "0x62E9") ;; <CJK>
       (?$ATr(B . "0x5219") ;; <CJK>
       (?$ATs(B . "0x6CFD") ;; <CJK>
       (?$ATt(B . "0x8D3C") ;; <CJK>
       (?$ATu(B . "0x600E") ;; <CJK>
       (?$ATv(B . "0x589E") ;; <CJK>
       (?$ATw(B . "0x618E") ;; <CJK>
       (?$ATx(B . "0x66FE") ;; <CJK>
       (?$ATy(B . "0x8D60") ;; <CJK>
       (?$ATz(B . "0x624E") ;; <CJK>
       (?$AT{(B . "0x55B3") ;; <CJK>
       (?$AT|(B . "0x6E23") ;; <CJK>
       (?$AT}(B . "0x672D") ;; <CJK>
       (?$AT~(B . "0x8F67") ;; <CJK>
       (?$AU!(B . "0x94E1") ;; <CJK>
       (?$AU"(B . "0x95F8") ;; <CJK>
       (?$AU#(B . "0x7728") ;; <CJK>
       (?$AU$(B . "0x6805") ;; <CJK>
       (?$AU%(B . "0x69A8") ;; <CJK>
       (?$AU&(B . "0x548B") ;; <CJK>
       (?$AU'(B . "0x4E4D") ;; <CJK>
       (?$AU((B . "0x70B8") ;; <CJK>
       (?$AU)(B . "0x8BC8") ;; <CJK>
       (?$AU*(B . "0x6458") ;; <CJK>
       (?$AU+(B . "0x658B") ;; <CJK>
       (?$AU,(B . "0x5B85") ;; <CJK>
       (?$AU-(B . "0x7A84") ;; <CJK>
       (?$AU.(B . "0x503A") ;; <CJK>
       (?$AU/(B . "0x5BE8") ;; <CJK>
       (?$AU0(B . "0x77BB") ;; <CJK>
       (?$AU1(B . "0x6BE1") ;; <CJK>
       (?$AU2(B . "0x8A79") ;; <CJK>
       (?$AU3(B . "0x7C98") ;; <CJK>
       (?$AU4(B . "0x6CBE") ;; <CJK>
       (?$AU5(B . "0x76CF") ;; <CJK>
       (?$AU6(B . "0x65A9") ;; <CJK>
       (?$AU7(B . "0x8F97") ;; <CJK>
       (?$AU8(B . "0x5D2D") ;; <CJK>
       (?$AU9(B . "0x5C55") ;; <CJK>
       (?$AU:(B . "0x8638") ;; <CJK>
       (?$AU;(B . "0x6808") ;; <CJK>
       (?$AU<(B . "0x5360") ;; <CJK>
       (?$AU=(B . "0x6218") ;; <CJK>
       (?$AU>(B . "0x7AD9") ;; <CJK>
       (?$AU?(B . "0x6E5B") ;; <CJK>
       (?$AU@(B . "0x7EFD") ;; <CJK>
       (?$AUA(B . "0x6A1F") ;; <CJK>
       (?$AUB(B . "0x7AE0") ;; <CJK>
       (?$AUC(B . "0x5F70") ;; <CJK>
       (?$AUD(B . "0x6F33") ;; <CJK>
       (?$AUE(B . "0x5F20") ;; <CJK>
       (?$AUF(B . "0x638C") ;; <CJK>
       (?$AUG(B . "0x6DA8") ;; <CJK>
       (?$AUH(B . "0x6756") ;; <CJK>
       (?$AUI(B . "0x4E08") ;; <CJK>
       (?$AUJ(B . "0x5E10") ;; <CJK>
       (?$AUK(B . "0x8D26") ;; <CJK>
       (?$AUL(B . "0x4ED7") ;; <CJK>
       (?$AUM(B . "0x80C0") ;; <CJK>
       (?$AUN(B . "0x7634") ;; <CJK>
       (?$AUO(B . "0x969C") ;; <CJK>
       (?$AUP(B . "0x62DB") ;; <CJK>
       (?$AUQ(B . "0x662D") ;; <CJK>
       (?$AUR(B . "0x627E") ;; <CJK>
       (?$AUS(B . "0x6CBC") ;; <CJK>
       (?$AUT(B . "0x8D75") ;; <CJK>
       (?$AUU(B . "0x7167") ;; <CJK>
       (?$AUV(B . "0x7F69") ;; <CJK>
       (?$AUW(B . "0x5146") ;; <CJK>
       (?$AUX(B . "0x8087") ;; <CJK>
       (?$AUY(B . "0x53EC") ;; <CJK>
       (?$AUZ(B . "0x906E") ;; <CJK>
       (?$AU[(B . "0x6298") ;; <CJK>
       (?$AU\(B . "0x54F2") ;; <CJK>
       (?$AU](B . "0x86F0") ;; <CJK>
       (?$AU^(B . "0x8F99") ;; <CJK>
       (?$AU_(B . "0x8005") ;; <CJK>
       (?$AU`(B . "0x9517") ;; <CJK>
       (?$AUa(B . "0x8517") ;; <CJK>
       (?$AUb(B . "0x8FD9") ;; <CJK>
       (?$AUc(B . "0x6D59") ;; <CJK>
       (?$AUd(B . "0x73CD") ;; <CJK>
       (?$AUe(B . "0x659F") ;; <CJK>
       (?$AUf(B . "0x771F") ;; <CJK>
       (?$AUg(B . "0x7504") ;; <CJK>
       (?$AUh(B . "0x7827") ;; <CJK>
       (?$AUi(B . "0x81FB") ;; <CJK>
       (?$AUj(B . "0x8D1E") ;; <CJK>
       (?$AUk(B . "0x9488") ;; <CJK>
       (?$AUl(B . "0x4FA6") ;; <CJK>
       (?$AUm(B . "0x6795") ;; <CJK>
       (?$AUn(B . "0x75B9") ;; <CJK>
       (?$AUo(B . "0x8BCA") ;; <CJK>
       (?$AUp(B . "0x9707") ;; <CJK>
       (?$AUq(B . "0x632F") ;; <CJK>
       (?$AUr(B . "0x9547") ;; <CJK>
       (?$AUs(B . "0x9635") ;; <CJK>
       (?$AUt(B . "0x84B8") ;; <CJK>
       (?$AUu(B . "0x6323") ;; <CJK>
       (?$AUv(B . "0x7741") ;; <CJK>
       (?$AUw(B . "0x5F81") ;; <CJK>
       (?$AUx(B . "0x72F0") ;; <CJK>
       (?$AUy(B . "0x4E89") ;; <CJK>
       (?$AUz(B . "0x6014") ;; <CJK>
       (?$AU{(B . "0x6574") ;; <CJK>
       (?$AU|(B . "0x62EF") ;; <CJK>
       (?$AU}(B . "0x6B63") ;; <CJK>
       (?$AU~(B . "0x653F") ;; <CJK>
       (?$AV!(B . "0x5E27") ;; <CJK>
       (?$AV"(B . "0x75C7") ;; <CJK>
       (?$AV#(B . "0x90D1") ;; <CJK>
       (?$AV$(B . "0x8BC1") ;; <CJK>
       (?$AV%(B . "0x829D") ;; <CJK>
       (?$AV&(B . "0x679D") ;; <CJK>
       (?$AV'(B . "0x652F") ;; <CJK>
       (?$AV((B . "0x5431") ;; <CJK>
       (?$AV)(B . "0x8718") ;; <CJK>
       (?$AV*(B . "0x77E5") ;; <CJK>
       (?$AV+(B . "0x80A2") ;; <CJK>
       (?$AV,(B . "0x8102") ;; <CJK>
       (?$AV-(B . "0x6C41") ;; <CJK>
       (?$AV.(B . "0x4E4B") ;; <CJK>
       (?$AV/(B . "0x7EC7") ;; <CJK>
       (?$AV0(B . "0x804C") ;; <CJK>
       (?$AV1(B . "0x76F4") ;; <CJK>
       (?$AV2(B . "0x690D") ;; <CJK>
       (?$AV3(B . "0x6B96") ;; <CJK>
       (?$AV4(B . "0x6267") ;; <CJK>
       (?$AV5(B . "0x503C") ;; <CJK>
       (?$AV6(B . "0x4F84") ;; <CJK>
       (?$AV7(B . "0x5740") ;; <CJK>
       (?$AV8(B . "0x6307") ;; <CJK>
       (?$AV9(B . "0x6B62") ;; <CJK>
       (?$AV:(B . "0x8DBE") ;; <CJK>
       (?$AV;(B . "0x53EA") ;; <CJK>
       (?$AV<(B . "0x65E8") ;; <CJK>
       (?$AV=(B . "0x7EB8") ;; <CJK>
       (?$AV>(B . "0x5FD7") ;; <CJK>
       (?$AV?(B . "0x631A") ;; <CJK>
       (?$AV@(B . "0x63B7") ;; <CJK>
       (?$AVA(B . "0x81F3") ;; <CJK>
       (?$AVB(B . "0x81F4") ;; <CJK>
       (?$AVC(B . "0x7F6E") ;; <CJK>
       (?$AVD(B . "0x5E1C") ;; <CJK>
       (?$AVE(B . "0x5CD9") ;; <CJK>
       (?$AVF(B . "0x5236") ;; <CJK>
       (?$AVG(B . "0x667A") ;; <CJK>
       (?$AVH(B . "0x79E9") ;; <CJK>
       (?$AVI(B . "0x7A1A") ;; <CJK>
       (?$AVJ(B . "0x8D28") ;; <CJK>
       (?$AVK(B . "0x7099") ;; <CJK>
       (?$AVL(B . "0x75D4") ;; <CJK>
       (?$AVM(B . "0x6EDE") ;; <CJK>
       (?$AVN(B . "0x6CBB") ;; <CJK>
       (?$AVO(B . "0x7A92") ;; <CJK>
       (?$AVP(B . "0x4E2D") ;; <CJK>
       (?$AVQ(B . "0x76C5") ;; <CJK>
       (?$AVR(B . "0x5FE0") ;; <CJK>
       (?$AVS(B . "0x949F") ;; <CJK>
       (?$AVT(B . "0x8877") ;; <CJK>
       (?$AVU(B . "0x7EC8") ;; <CJK>
       (?$AVV(B . "0x79CD") ;; <CJK>
       (?$AVW(B . "0x80BF") ;; <CJK>
       (?$AVX(B . "0x91CD") ;; <CJK>
       (?$AVY(B . "0x4EF2") ;; <CJK>
       (?$AVZ(B . "0x4F17") ;; <CJK>
       (?$AV[(B . "0x821F") ;; <CJK>
       (?$AV\(B . "0x5468") ;; <CJK>
       (?$AV](B . "0x5DDE") ;; <CJK>
       (?$AV^(B . "0x6D32") ;; <CJK>
       (?$AV_(B . "0x8BCC") ;; <CJK>
       (?$AV`(B . "0x7CA5") ;; <CJK>
       (?$AVa(B . "0x8F74") ;; <CJK>
       (?$AVb(B . "0x8098") ;; <CJK>
       (?$AVc(B . "0x5E1A") ;; <CJK>
       (?$AVd(B . "0x5492") ;; <CJK>
       (?$AVe(B . "0x76B1") ;; <CJK>
       (?$AVf(B . "0x5B99") ;; <CJK>
       (?$AVg(B . "0x663C") ;; <CJK>
       (?$AVh(B . "0x9AA4") ;; <CJK>
       (?$AVi(B . "0x73E0") ;; <CJK>
       (?$AVj(B . "0x682A") ;; <CJK>
       (?$AVk(B . "0x86DB") ;; <CJK>
       (?$AVl(B . "0x6731") ;; <CJK>
       (?$AVm(B . "0x732A") ;; <CJK>
       (?$AVn(B . "0x8BF8") ;; <CJK>
       (?$AVo(B . "0x8BDB") ;; <CJK>
       (?$AVp(B . "0x9010") ;; <CJK>
       (?$AVq(B . "0x7AF9") ;; <CJK>
       (?$AVr(B . "0x70DB") ;; <CJK>
       (?$AVs(B . "0x716E") ;; <CJK>
       (?$AVt(B . "0x62C4") ;; <CJK>
       (?$AVu(B . "0x77A9") ;; <CJK>
       (?$AVv(B . "0x5631") ;; <CJK>
       (?$AVw(B . "0x4E3B") ;; <CJK>
       (?$AVx(B . "0x8457") ;; <CJK>
       (?$AVy(B . "0x67F1") ;; <CJK>
       (?$AVz(B . "0x52A9") ;; <CJK>
       (?$AV{(B . "0x86C0") ;; <CJK>
       (?$AV|(B . "0x8D2E") ;; <CJK>
       (?$AV}(B . "0x94F8") ;; <CJK>
       (?$AV~(B . "0x7B51") ;; <CJK>
       (?$AW!(B . "0x4F4F") ;; <CJK>
       (?$AW"(B . "0x6CE8") ;; <CJK>
       (?$AW#(B . "0x795D") ;; <CJK>
       (?$AW$(B . "0x9A7B") ;; <CJK>
       (?$AW%(B . "0x6293") ;; <CJK>
       (?$AW&(B . "0x722A") ;; <CJK>
       (?$AW'(B . "0x62FD") ;; <CJK>
       (?$AW((B . "0x4E13") ;; <CJK>
       (?$AW)(B . "0x7816") ;; <CJK>
       (?$AW*(B . "0x8F6C") ;; <CJK>
       (?$AW+(B . "0x64B0") ;; <CJK>
       (?$AW,(B . "0x8D5A") ;; <CJK>
       (?$AW-(B . "0x7BC6") ;; <CJK>
       (?$AW.(B . "0x6869") ;; <CJK>
       (?$AW/(B . "0x5E84") ;; <CJK>
       (?$AW0(B . "0x88C5") ;; <CJK>
       (?$AW1(B . "0x5986") ;; <CJK>
       (?$AW2(B . "0x649E") ;; <CJK>
       (?$AW3(B . "0x58EE") ;; <CJK>
       (?$AW4(B . "0x72B6") ;; <CJK>
       (?$AW5(B . "0x690E") ;; <CJK>
       (?$AW6(B . "0x9525") ;; <CJK>
       (?$AW7(B . "0x8FFD") ;; <CJK>
       (?$AW8(B . "0x8D58") ;; <CJK>
       (?$AW9(B . "0x5760") ;; <CJK>
       (?$AW:(B . "0x7F00") ;; <CJK>
       (?$AW;(B . "0x8C06") ;; <CJK>
       (?$AW<(B . "0x51C6") ;; <CJK>
       (?$AW=(B . "0x6349") ;; <CJK>
       (?$AW>(B . "0x62D9") ;; <CJK>
       (?$AW?(B . "0x5353") ;; <CJK>
       (?$AW@(B . "0x684C") ;; <CJK>
       (?$AWA(B . "0x7422") ;; <CJK>
       (?$AWB(B . "0x8301") ;; <CJK>
       (?$AWC(B . "0x914C") ;; <CJK>
       (?$AWD(B . "0x5544") ;; <CJK>
       (?$AWE(B . "0x7740") ;; <CJK>
       (?$AWF(B . "0x707C") ;; <CJK>
       (?$AWG(B . "0x6D4A") ;; <CJK>
       (?$AWH(B . "0x5179") ;; <CJK>
       (?$AWI(B . "0x54A8") ;; <CJK>
       (?$AWJ(B . "0x8D44") ;; <CJK>
       (?$AWK(B . "0x59FF") ;; <CJK>
       (?$AWL(B . "0x6ECB") ;; <CJK>
       (?$AWM(B . "0x6DC4") ;; <CJK>
       (?$AWN(B . "0x5B5C") ;; <CJK>
       (?$AWO(B . "0x7D2B") ;; <CJK>
       (?$AWP(B . "0x4ED4") ;; <CJK>
       (?$AWQ(B . "0x7C7D") ;; <CJK>
       (?$AWR(B . "0x6ED3") ;; <CJK>
       (?$AWS(B . "0x5B50") ;; <CJK>
       (?$AWT(B . "0x81EA") ;; <CJK>
       (?$AWU(B . "0x6E0D") ;; <CJK>
       (?$AWV(B . "0x5B57") ;; <CJK>
       (?$AWW(B . "0x9B03") ;; <CJK>
       (?$AWX(B . "0x68D5") ;; <CJK>
       (?$AWY(B . "0x8E2A") ;; <CJK>
       (?$AWZ(B . "0x5B97") ;; <CJK>
       (?$AW[(B . "0x7EFC") ;; <CJK>
       (?$AW\(B . "0x603B") ;; <CJK>
       (?$AW](B . "0x7EB5") ;; <CJK>
       (?$AW^(B . "0x90B9") ;; <CJK>
       (?$AW_(B . "0x8D70") ;; <CJK>
       (?$AW`(B . "0x594F") ;; <CJK>
       (?$AWa(B . "0x63CD") ;; <CJK>
       (?$AWb(B . "0x79DF") ;; <CJK>
       (?$AWc(B . "0x8DB3") ;; <CJK>
       (?$AWd(B . "0x5352") ;; <CJK>
       (?$AWe(B . "0x65CF") ;; <CJK>
       (?$AWf(B . "0x7956") ;; <CJK>
       (?$AWg(B . "0x8BC5") ;; <CJK>
       (?$AWh(B . "0x963B") ;; <CJK>
       (?$AWi(B . "0x7EC4") ;; <CJK>
       (?$AWj(B . "0x94BB") ;; <CJK>
       (?$AWk(B . "0x7E82") ;; <CJK>
       (?$AWl(B . "0x5634") ;; <CJK>
       (?$AWm(B . "0x9189") ;; <CJK>
       (?$AWn(B . "0x6700") ;; <CJK>
       (?$AWo(B . "0x7F6A") ;; <CJK>
       (?$AWp(B . "0x5C0A") ;; <CJK>
       (?$AWq(B . "0x9075") ;; <CJK>
       (?$AWr(B . "0x6628") ;; <CJK>
       (?$AWs(B . "0x5DE6") ;; <CJK>
       (?$AWt(B . "0x4F50") ;; <CJK>
       (?$AWu(B . "0x67DE") ;; <CJK>
       (?$AWv(B . "0x505A") ;; <CJK>
       (?$AWw(B . "0x4F5C") ;; <CJK>
       (?$AWx(B . "0x5750") ;; <CJK>
       (?$AWy(B . "0x5EA7") ;; <CJK>
       (?$AX!(B . "0x4E8D") ;; <CJK>
       (?$AX"(B . "0x4E0C") ;; <CJK>
       (?$AX#(B . "0x5140") ;; <CJK>
       (?$AX$(B . "0x4E10") ;; <CJK>
       (?$AX%(B . "0x5EFF") ;; <CJK>
       (?$AX&(B . "0x5345") ;; <CJK>
       (?$AX'(B . "0x4E15") ;; <CJK>
       (?$AX((B . "0x4E98") ;; <CJK>
       (?$AX)(B . "0x4E1E") ;; <CJK>
       (?$AX*(B . "0x9B32") ;; <CJK>
       (?$AX+(B . "0x5B6C") ;; <CJK>
       (?$AX,(B . "0x5669") ;; <CJK>
       (?$AX-(B . "0x4E28") ;; <CJK>
       (?$AX.(B . "0x79BA") ;; <CJK>
       (?$AX/(B . "0x4E3F") ;; <CJK>
       (?$AX0(B . "0x5315") ;; <CJK>
       (?$AX1(B . "0x4E47") ;; <CJK>
       (?$AX2(B . "0x592D") ;; <CJK>
       (?$AX3(B . "0x723B") ;; <CJK>
       (?$AX4(B . "0x536E") ;; <CJK>
       (?$AX5(B . "0x6C10") ;; <CJK>
       (?$AX6(B . "0x56DF") ;; <CJK>
       (?$AX7(B . "0x80E4") ;; <CJK>
       (?$AX8(B . "0x9997") ;; <CJK>
       (?$AX9(B . "0x6BD3") ;; <CJK>
       (?$AX:(B . "0x777E") ;; <CJK>
       (?$AX;(B . "0x9F17") ;; <CJK>
       (?$AX<(B . "0x4E36") ;; <CJK>
       (?$AX=(B . "0x4E9F") ;; <CJK>
       (?$AX>(B . "0x9F10") ;; <CJK>
       (?$AX?(B . "0x4E5C") ;; <CJK>
       (?$AX@(B . "0x4E69") ;; <CJK>
       (?$AXA(B . "0x4E93") ;; <CJK>
       (?$AXB(B . "0x8288") ;; <CJK>
       (?$AXC(B . "0x5B5B") ;; <CJK>
       (?$AXD(B . "0x556C") ;; <CJK>
       (?$AXE(B . "0x560F") ;; <CJK>
       (?$AXF(B . "0x4EC4") ;; <CJK>
       (?$AXG(B . "0x538D") ;; <CJK>
       (?$AXH(B . "0x539D") ;; <CJK>
       (?$AXI(B . "0x53A3") ;; <CJK>
       (?$AXJ(B . "0x53A5") ;; <CJK>
       (?$AXK(B . "0x53AE") ;; <CJK>
       (?$AXL(B . "0x9765") ;; <CJK>
       (?$AXM(B . "0x8D5D") ;; <CJK>
       (?$AXN(B . "0x531A") ;; <CJK>
       (?$AXO(B . "0x53F5") ;; <CJK>
       (?$AXP(B . "0x5326") ;; <CJK>
       (?$AXQ(B . "0x532E") ;; <CJK>
       (?$AXR(B . "0x533E") ;; <CJK>
       (?$AXS(B . "0x8D5C") ;; <CJK>
       (?$AXT(B . "0x5366") ;; <CJK>
       (?$AXU(B . "0x5363") ;; <CJK>
       (?$AXV(B . "0x5202") ;; <CJK>
       (?$AXW(B . "0x5208") ;; <CJK>
       (?$AXX(B . "0x520E") ;; <CJK>
       (?$AXY(B . "0x522D") ;; <CJK>
       (?$AXZ(B . "0x5233") ;; <CJK>
       (?$AX[(B . "0x523F") ;; <CJK>
       (?$AX\(B . "0x5240") ;; <CJK>
       (?$AX](B . "0x524C") ;; <CJK>
       (?$AX^(B . "0x525E") ;; <CJK>
       (?$AX_(B . "0x5261") ;; <CJK>
       (?$AX`(B . "0x525C") ;; <CJK>
       (?$AXa(B . "0x84AF") ;; <CJK>
       (?$AXb(B . "0x527D") ;; <CJK>
       (?$AXc(B . "0x5282") ;; <CJK>
       (?$AXd(B . "0x5281") ;; <CJK>
       (?$AXe(B . "0x5290") ;; <CJK>
       (?$AXf(B . "0x5293") ;; <CJK>
       (?$AXg(B . "0x5182") ;; <CJK>
       (?$AXh(B . "0x7F54") ;; <CJK>
       (?$AXi(B . "0x4EBB") ;; <CJK>
       (?$AXj(B . "0x4EC3") ;; <CJK>
       (?$AXk(B . "0x4EC9") ;; <CJK>
       (?$AXl(B . "0x4EC2") ;; <CJK>
       (?$AXm(B . "0x4EE8") ;; <CJK>
       (?$AXn(B . "0x4EE1") ;; <CJK>
       (?$AXo(B . "0x4EEB") ;; <CJK>
       (?$AXp(B . "0x4EDE") ;; <CJK>
       (?$AXq(B . "0x4F1B") ;; <CJK>
       (?$AXr(B . "0x4EF3") ;; <CJK>
       (?$AXs(B . "0x4F22") ;; <CJK>
       (?$AXt(B . "0x4F64") ;; <CJK>
       (?$AXu(B . "0x4EF5") ;; <CJK>
       (?$AXv(B . "0x4F25") ;; <CJK>
       (?$AXw(B . "0x4F27") ;; <CJK>
       (?$AXx(B . "0x4F09") ;; <CJK>
       (?$AXy(B . "0x4F2B") ;; <CJK>
       (?$AXz(B . "0x4F5E") ;; <CJK>
       (?$AX{(B . "0x4F67") ;; <CJK>
       (?$AX|(B . "0x6538") ;; <CJK>
       (?$AX}(B . "0x4F5A") ;; <CJK>
       (?$AX~(B . "0x4F5D") ;; <CJK>
       (?$AY!(B . "0x4F5F") ;; <CJK>
       (?$AY"(B . "0x4F57") ;; <CJK>
       (?$AY#(B . "0x4F32") ;; <CJK>
       (?$AY$(B . "0x4F3D") ;; <CJK>
       (?$AY%(B . "0x4F76") ;; <CJK>
       (?$AY&(B . "0x4F74") ;; <CJK>
       (?$AY'(B . "0x4F91") ;; <CJK>
       (?$AY((B . "0x4F89") ;; <CJK>
       (?$AY)(B . "0x4F83") ;; <CJK>
       (?$AY*(B . "0x4F8F") ;; <CJK>
       (?$AY+(B . "0x4F7E") ;; <CJK>
       (?$AY,(B . "0x4F7B") ;; <CJK>
       (?$AY-(B . "0x4FAA") ;; <CJK>
       (?$AY.(B . "0x4F7C") ;; <CJK>
       (?$AY/(B . "0x4FAC") ;; <CJK>
       (?$AY0(B . "0x4F94") ;; <CJK>
       (?$AY1(B . "0x4FE6") ;; <CJK>
       (?$AY2(B . "0x4FE8") ;; <CJK>
       (?$AY3(B . "0x4FEA") ;; <CJK>
       (?$AY4(B . "0x4FC5") ;; <CJK>
       (?$AY5(B . "0x4FDA") ;; <CJK>
       (?$AY6(B . "0x4FE3") ;; <CJK>
       (?$AY7(B . "0x4FDC") ;; <CJK>
       (?$AY8(B . "0x4FD1") ;; <CJK>
       (?$AY9(B . "0x4FDF") ;; <CJK>
       (?$AY:(B . "0x4FF8") ;; <CJK>
       (?$AY;(B . "0x5029") ;; <CJK>
       (?$AY<(B . "0x504C") ;; <CJK>
       (?$AY=(B . "0x4FF3") ;; <CJK>
       (?$AY>(B . "0x502C") ;; <CJK>
       (?$AY?(B . "0x500F") ;; <CJK>
       (?$AY@(B . "0x502E") ;; <CJK>
       (?$AYA(B . "0x502D") ;; <CJK>
       (?$AYB(B . "0x4FFE") ;; <CJK>
       (?$AYC(B . "0x501C") ;; <CJK>
       (?$AYD(B . "0x500C") ;; <CJK>
       (?$AYE(B . "0x5025") ;; <CJK>
       (?$AYF(B . "0x5028") ;; <CJK>
       (?$AYG(B . "0x507E") ;; <CJK>
       (?$AYH(B . "0x5043") ;; <CJK>
       (?$AYI(B . "0x5055") ;; <CJK>
       (?$AYJ(B . "0x5048") ;; <CJK>
       (?$AYK(B . "0x504E") ;; <CJK>
       (?$AYL(B . "0x506C") ;; <CJK>
       (?$AYM(B . "0x507B") ;; <CJK>
       (?$AYN(B . "0x50A5") ;; <CJK>
       (?$AYO(B . "0x50A7") ;; <CJK>
       (?$AYP(B . "0x50A9") ;; <CJK>
       (?$AYQ(B . "0x50BA") ;; <CJK>
       (?$AYR(B . "0x50D6") ;; <CJK>
       (?$AYS(B . "0x5106") ;; <CJK>
       (?$AYT(B . "0x50ED") ;; <CJK>
       (?$AYU(B . "0x50EC") ;; <CJK>
       (?$AYV(B . "0x50E6") ;; <CJK>
       (?$AYW(B . "0x50EE") ;; <CJK>
       (?$AYX(B . "0x5107") ;; <CJK>
       (?$AYY(B . "0x510B") ;; <CJK>
       (?$AYZ(B . "0x4EDD") ;; <CJK>
       (?$AY[(B . "0x6C3D") ;; <CJK>
       (?$AY\(B . "0x4F58") ;; <CJK>
       (?$AY](B . "0x4F65") ;; <CJK>
       (?$AY^(B . "0x4FCE") ;; <CJK>
       (?$AY_(B . "0x9FA0") ;; <CJK>
       (?$AY`(B . "0x6C46") ;; <CJK>
       (?$AYa(B . "0x7C74") ;; <CJK>
       (?$AYb(B . "0x516E") ;; <CJK>
       (?$AYc(B . "0x5DFD") ;; <CJK>
       (?$AYd(B . "0x9EC9") ;; <CJK>
       (?$AYe(B . "0x9998") ;; <CJK>
       (?$AYf(B . "0x5181") ;; <CJK>
       (?$AYg(B . "0x5914") ;; <CJK>
       (?$AYh(B . "0x52F9") ;; <CJK>
       (?$AYi(B . "0x530D") ;; <CJK>
       (?$AYj(B . "0x8A07") ;; <CJK>
       (?$AYk(B . "0x5310") ;; <CJK>
       (?$AYl(B . "0x51EB") ;; <CJK>
       (?$AYm(B . "0x5919") ;; <CJK>
       (?$AYn(B . "0x5155") ;; <CJK>
       (?$AYo(B . "0x4EA0") ;; <CJK>
       (?$AYp(B . "0x5156") ;; <CJK>
       (?$AYq(B . "0x4EB3") ;; <CJK>
       (?$AYr(B . "0x886E") ;; <CJK>
       (?$AYs(B . "0x88A4") ;; <CJK>
       (?$AYt(B . "0x4EB5") ;; <CJK>
       (?$AYu(B . "0x8114") ;; <CJK>
       (?$AYv(B . "0x88D2") ;; <CJK>
       (?$AYw(B . "0x7980") ;; <CJK>
       (?$AYx(B . "0x5B34") ;; <CJK>
       (?$AYy(B . "0x8803") ;; <CJK>
       (?$AYz(B . "0x7FB8") ;; <CJK>
       (?$AY{(B . "0x51AB") ;; <CJK>
       (?$AY|(B . "0x51B1") ;; <CJK>
       (?$AY}(B . "0x51BD") ;; <CJK>
       (?$AY~(B . "0x51BC") ;; <CJK>
       (?$AZ!(B . "0x51C7") ;; <CJK>
       (?$AZ"(B . "0x5196") ;; <CJK>
       (?$AZ#(B . "0x51A2") ;; <CJK>
       (?$AZ$(B . "0x51A5") ;; <CJK>
       (?$AZ%(B . "0x8BA0") ;; <CJK>
       (?$AZ&(B . "0x8BA6") ;; <CJK>
       (?$AZ'(B . "0x8BA7") ;; <CJK>
       (?$AZ((B . "0x8BAA") ;; <CJK>
       (?$AZ)(B . "0x8BB4") ;; <CJK>
       (?$AZ*(B . "0x8BB5") ;; <CJK>
       (?$AZ+(B . "0x8BB7") ;; <CJK>
       (?$AZ,(B . "0x8BC2") ;; <CJK>
       (?$AZ-(B . "0x8BC3") ;; <CJK>
       (?$AZ.(B . "0x8BCB") ;; <CJK>
       (?$AZ/(B . "0x8BCF") ;; <CJK>
       (?$AZ0(B . "0x8BCE") ;; <CJK>
       (?$AZ1(B . "0x8BD2") ;; <CJK>
       (?$AZ2(B . "0x8BD3") ;; <CJK>
       (?$AZ3(B . "0x8BD4") ;; <CJK>
       (?$AZ4(B . "0x8BD6") ;; <CJK>
       (?$AZ5(B . "0x8BD8") ;; <CJK>
       (?$AZ6(B . "0x8BD9") ;; <CJK>
       (?$AZ7(B . "0x8BDC") ;; <CJK>
       (?$AZ8(B . "0x8BDF") ;; <CJK>
       (?$AZ9(B . "0x8BE0") ;; <CJK>
       (?$AZ:(B . "0x8BE4") ;; <CJK>
       (?$AZ;(B . "0x8BE8") ;; <CJK>
       (?$AZ<(B . "0x8BE9") ;; <CJK>
       (?$AZ=(B . "0x8BEE") ;; <CJK>
       (?$AZ>(B . "0x8BF0") ;; <CJK>
       (?$AZ?(B . "0x8BF3") ;; <CJK>
       (?$AZ@(B . "0x8BF6") ;; <CJK>
       (?$AZA(B . "0x8BF9") ;; <CJK>
       (?$AZB(B . "0x8BFC") ;; <CJK>
       (?$AZC(B . "0x8BFF") ;; <CJK>
       (?$AZD(B . "0x8C00") ;; <CJK>
       (?$AZE(B . "0x8C02") ;; <CJK>
       (?$AZF(B . "0x8C04") ;; <CJK>
       (?$AZG(B . "0x8C07") ;; <CJK>
       (?$AZH(B . "0x8C0C") ;; <CJK>
       (?$AZI(B . "0x8C0F") ;; <CJK>
       (?$AZJ(B . "0x8C11") ;; <CJK>
       (?$AZK(B . "0x8C12") ;; <CJK>
       (?$AZL(B . "0x8C14") ;; <CJK>
       (?$AZM(B . "0x8C15") ;; <CJK>
       (?$AZN(B . "0x8C16") ;; <CJK>
       (?$AZO(B . "0x8C19") ;; <CJK>
       (?$AZP(B . "0x8C1B") ;; <CJK>
       (?$AZQ(B . "0x8C18") ;; <CJK>
       (?$AZR(B . "0x8C1D") ;; <CJK>
       (?$AZS(B . "0x8C1F") ;; <CJK>
       (?$AZT(B . "0x8C20") ;; <CJK>
       (?$AZU(B . "0x8C21") ;; <CJK>
       (?$AZV(B . "0x8C25") ;; <CJK>
       (?$AZW(B . "0x8C27") ;; <CJK>
       (?$AZX(B . "0x8C2A") ;; <CJK>
       (?$AZY(B . "0x8C2B") ;; <CJK>
       (?$AZZ(B . "0x8C2E") ;; <CJK>
       (?$AZ[(B . "0x8C2F") ;; <CJK>
       (?$AZ\(B . "0x8C32") ;; <CJK>
       (?$AZ](B . "0x8C33") ;; <CJK>
       (?$AZ^(B . "0x8C35") ;; <CJK>
       (?$AZ_(B . "0x8C36") ;; <CJK>
       (?$AZ`(B . "0x5369") ;; <CJK>
       (?$AZa(B . "0x537A") ;; <CJK>
       (?$AZb(B . "0x961D") ;; <CJK>
       (?$AZc(B . "0x9622") ;; <CJK>
       (?$AZd(B . "0x9621") ;; <CJK>
       (?$AZe(B . "0x9631") ;; <CJK>
       (?$AZf(B . "0x962A") ;; <CJK>
       (?$AZg(B . "0x963D") ;; <CJK>
       (?$AZh(B . "0x963C") ;; <CJK>
       (?$AZi(B . "0x9642") ;; <CJK>
       (?$AZj(B . "0x9649") ;; <CJK>
       (?$AZk(B . "0x9654") ;; <CJK>
       (?$AZl(B . "0x965F") ;; <CJK>
       (?$AZm(B . "0x9667") ;; <CJK>
       (?$AZn(B . "0x966C") ;; <CJK>
       (?$AZo(B . "0x9672") ;; <CJK>
       (?$AZp(B . "0x9674") ;; <CJK>
       (?$AZq(B . "0x9688") ;; <CJK>
       (?$AZr(B . "0x968D") ;; <CJK>
       (?$AZs(B . "0x9697") ;; <CJK>
       (?$AZt(B . "0x96B0") ;; <CJK>
       (?$AZu(B . "0x9097") ;; <CJK>
       (?$AZv(B . "0x909B") ;; <CJK>
       (?$AZw(B . "0x909D") ;; <CJK>
       (?$AZx(B . "0x9099") ;; <CJK>
       (?$AZy(B . "0x90AC") ;; <CJK>
       (?$AZz(B . "0x90A1") ;; <CJK>
       (?$AZ{(B . "0x90B4") ;; <CJK>
       (?$AZ|(B . "0x90B3") ;; <CJK>
       (?$AZ}(B . "0x90B6") ;; <CJK>
       (?$AZ~(B . "0x90BA") ;; <CJK>
       (?$A[!(B . "0x90B8") ;; <CJK>
       (?$A["(B . "0x90B0") ;; <CJK>
       (?$A[#(B . "0x90CF") ;; <CJK>
       (?$A[$(B . "0x90C5") ;; <CJK>
       (?$A[%(B . "0x90BE") ;; <CJK>
       (?$A[&(B . "0x90D0") ;; <CJK>
       (?$A['(B . "0x90C4") ;; <CJK>
       (?$A[((B . "0x90C7") ;; <CJK>
       (?$A[)(B . "0x90D3") ;; <CJK>
       (?$A[*(B . "0x90E6") ;; <CJK>
       (?$A[+(B . "0x90E2") ;; <CJK>
       (?$A[,(B . "0x90DC") ;; <CJK>
       (?$A[-(B . "0x90D7") ;; <CJK>
       (?$A[.(B . "0x90DB") ;; <CJK>
       (?$A[/(B . "0x90EB") ;; <CJK>
       (?$A[0(B . "0x90EF") ;; <CJK>
       (?$A[1(B . "0x90FE") ;; <CJK>
       (?$A[2(B . "0x9104") ;; <CJK>
       (?$A[3(B . "0x9122") ;; <CJK>
       (?$A[4(B . "0x911E") ;; <CJK>
       (?$A[5(B . "0x9123") ;; <CJK>
       (?$A[6(B . "0x9131") ;; <CJK>
       (?$A[7(B . "0x912F") ;; <CJK>
       (?$A[8(B . "0x9139") ;; <CJK>
       (?$A[9(B . "0x9143") ;; <CJK>
       (?$A[:(B . "0x9146") ;; <CJK>
       (?$A[;(B . "0x520D") ;; <CJK>
       (?$A[<(B . "0x5942") ;; <CJK>
       (?$A[=(B . "0x52A2") ;; <CJK>
       (?$A[>(B . "0x52AC") ;; <CJK>
       (?$A[?(B . "0x52AD") ;; <CJK>
       (?$A[@(B . "0x52BE") ;; <CJK>
       (?$A[A(B . "0x54FF") ;; <CJK>
       (?$A[B(B . "0x52D0") ;; <CJK>
       (?$A[C(B . "0x52D6") ;; <CJK>
       (?$A[D(B . "0x52F0") ;; <CJK>
       (?$A[E(B . "0x53DF") ;; <CJK>
       (?$A[F(B . "0x71EE") ;; <CJK>
       (?$A[G(B . "0x77CD") ;; <CJK>
       (?$A[H(B . "0x5EF4") ;; <CJK>
       (?$A[I(B . "0x51F5") ;; <CJK>
       (?$A[J(B . "0x51FC") ;; <CJK>
       (?$A[K(B . "0x9B2F") ;; <CJK>
       (?$A[L(B . "0x53B6") ;; <CJK>
       (?$A[M(B . "0x5F01") ;; <CJK>
       (?$A[N(B . "0x755A") ;; <CJK>
       (?$A[O(B . "0x5DEF") ;; <CJK>
       (?$A[P(B . "0x574C") ;; <CJK>
       (?$A[Q(B . "0x57A9") ;; <CJK>
       (?$A[R(B . "0x57A1") ;; <CJK>
       (?$A[S(B . "0x587E") ;; <CJK>
       (?$A[T(B . "0x58BC") ;; <CJK>
       (?$A[U(B . "0x58C5") ;; <CJK>
       (?$A[V(B . "0x58D1") ;; <CJK>
       (?$A[W(B . "0x5729") ;; <CJK>
       (?$A[X(B . "0x572C") ;; <CJK>
       (?$A[Y(B . "0x572A") ;; <CJK>
       (?$A[Z(B . "0x5733") ;; <CJK>
       (?$A[[(B . "0x5739") ;; <CJK>
       (?$A[\(B . "0x572E") ;; <CJK>
       (?$A[](B . "0x572F") ;; <CJK>
       (?$A[^(B . "0x575C") ;; <CJK>
       (?$A[_(B . "0x573B") ;; <CJK>
       (?$A[`(B . "0x5742") ;; <CJK>
       (?$A[a(B . "0x5769") ;; <CJK>
       (?$A[b(B . "0x5785") ;; <CJK>
       (?$A[c(B . "0x576B") ;; <CJK>
       (?$A[d(B . "0x5786") ;; <CJK>
       (?$A[e(B . "0x577C") ;; <CJK>
       (?$A[f(B . "0x577B") ;; <CJK>
       (?$A[g(B . "0x5768") ;; <CJK>
       (?$A[h(B . "0x576D") ;; <CJK>
       (?$A[i(B . "0x5776") ;; <CJK>
       (?$A[j(B . "0x5773") ;; <CJK>
       (?$A[k(B . "0x57AD") ;; <CJK>
       (?$A[l(B . "0x57A4") ;; <CJK>
       (?$A[m(B . "0x578C") ;; <CJK>
       (?$A[n(B . "0x57B2") ;; <CJK>
       (?$A[o(B . "0x57CF") ;; <CJK>
       (?$A[p(B . "0x57A7") ;; <CJK>
       (?$A[q(B . "0x57B4") ;; <CJK>
       (?$A[r(B . "0x5793") ;; <CJK>
       (?$A[s(B . "0x57A0") ;; <CJK>
       (?$A[t(B . "0x57D5") ;; <CJK>
       (?$A[u(B . "0x57D8") ;; <CJK>
       (?$A[v(B . "0x57DA") ;; <CJK>
       (?$A[w(B . "0x57D9") ;; <CJK>
       (?$A[x(B . "0x57D2") ;; <CJK>
       (?$A[y(B . "0x57B8") ;; <CJK>
       (?$A[z(B . "0x57F4") ;; <CJK>
       (?$A[{(B . "0x57EF") ;; <CJK>
       (?$A[|(B . "0x57F8") ;; <CJK>
       (?$A[}(B . "0x57E4") ;; <CJK>
       (?$A[~(B . "0x57DD") ;; <CJK>
       (?$A\!(B . "0x580B") ;; <CJK>
       (?$A\"(B . "0x580D") ;; <CJK>
       (?$A\#(B . "0x57FD") ;; <CJK>
       (?$A\$(B . "0x57ED") ;; <CJK>
       (?$A\%(B . "0x5800") ;; <CJK>
       (?$A\&(B . "0x581E") ;; <CJK>
       (?$A\'(B . "0x5819") ;; <CJK>
       (?$A\((B . "0x5844") ;; <CJK>
       (?$A\)(B . "0x5820") ;; <CJK>
       (?$A\*(B . "0x5865") ;; <CJK>
       (?$A\+(B . "0x586C") ;; <CJK>
       (?$A\,(B . "0x5881") ;; <CJK>
       (?$A\-(B . "0x5889") ;; <CJK>
       (?$A\.(B . "0x589A") ;; <CJK>
       (?$A\/(B . "0x5880") ;; <CJK>
       (?$A\0(B . "0x99A8") ;; <CJK>
       (?$A\1(B . "0x9F19") ;; <CJK>
       (?$A\2(B . "0x61FF") ;; <CJK>
       (?$A\3(B . "0x8279") ;; <CJK>
       (?$A\4(B . "0x827D") ;; <CJK>
       (?$A\5(B . "0x827F") ;; <CJK>
       (?$A\6(B . "0x828F") ;; <CJK>
       (?$A\7(B . "0x828A") ;; <CJK>
       (?$A\8(B . "0x82A8") ;; <CJK>
       (?$A\9(B . "0x8284") ;; <CJK>
       (?$A\:(B . "0x828E") ;; <CJK>
       (?$A\;(B . "0x8291") ;; <CJK>
       (?$A\<(B . "0x8297") ;; <CJK>
       (?$A\=(B . "0x8299") ;; <CJK>
       (?$A\>(B . "0x82AB") ;; <CJK>
       (?$A\?(B . "0x82B8") ;; <CJK>
       (?$A\@(B . "0x82BE") ;; <CJK>
       (?$A\A(B . "0x82B0") ;; <CJK>
       (?$A\B(B . "0x82C8") ;; <CJK>
       (?$A\C(B . "0x82CA") ;; <CJK>
       (?$A\D(B . "0x82E3") ;; <CJK>
       (?$A\E(B . "0x8298") ;; <CJK>
       (?$A\F(B . "0x82B7") ;; <CJK>
       (?$A\G(B . "0x82AE") ;; <CJK>
       (?$A\H(B . "0x82CB") ;; <CJK>
       (?$A\I(B . "0x82CC") ;; <CJK>
       (?$A\J(B . "0x82C1") ;; <CJK>
       (?$A\K(B . "0x82A9") ;; <CJK>
       (?$A\L(B . "0x82B4") ;; <CJK>
       (?$A\M(B . "0x82A1") ;; <CJK>
       (?$A\N(B . "0x82AA") ;; <CJK>
       (?$A\O(B . "0x829F") ;; <CJK>
       (?$A\P(B . "0x82C4") ;; <CJK>
       (?$A\Q(B . "0x82CE") ;; <CJK>
       (?$A\R(B . "0x82A4") ;; <CJK>
       (?$A\S(B . "0x82E1") ;; <CJK>
       (?$A\T(B . "0x8309") ;; <CJK>
       (?$A\U(B . "0x82F7") ;; <CJK>
       (?$A\V(B . "0x82E4") ;; <CJK>
       (?$A\W(B . "0x830F") ;; <CJK>
       (?$A\X(B . "0x8307") ;; <CJK>
       (?$A\Y(B . "0x82DC") ;; <CJK>
       (?$A\Z(B . "0x82F4") ;; <CJK>
       (?$A\[(B . "0x82D2") ;; <CJK>
       (?$A\\(B . "0x82D8") ;; <CJK>
       (?$A\](B . "0x830C") ;; <CJK>
       (?$A\^(B . "0x82FB") ;; <CJK>
       (?$A\_(B . "0x82D3") ;; <CJK>
       (?$A\`(B . "0x8311") ;; <CJK>
       (?$A\a(B . "0x831A") ;; <CJK>
       (?$A\b(B . "0x8306") ;; <CJK>
       (?$A\c(B . "0x8314") ;; <CJK>
       (?$A\d(B . "0x8315") ;; <CJK>
       (?$A\e(B . "0x82E0") ;; <CJK>
       (?$A\f(B . "0x82D5") ;; <CJK>
       (?$A\g(B . "0x831C") ;; <CJK>
       (?$A\h(B . "0x8351") ;; <CJK>
       (?$A\i(B . "0x835B") ;; <CJK>
       (?$A\j(B . "0x835C") ;; <CJK>
       (?$A\k(B . "0x8308") ;; <CJK>
       (?$A\l(B . "0x8392") ;; <CJK>
       (?$A\m(B . "0x833C") ;; <CJK>
       (?$A\n(B . "0x8334") ;; <CJK>
       (?$A\o(B . "0x8331") ;; <CJK>
       (?$A\p(B . "0x839B") ;; <CJK>
       (?$A\q(B . "0x835E") ;; <CJK>
       (?$A\r(B . "0x832F") ;; <CJK>
       (?$A\s(B . "0x834F") ;; <CJK>
       (?$A\t(B . "0x8347") ;; <CJK>
       (?$A\u(B . "0x8343") ;; <CJK>
       (?$A\v(B . "0x835F") ;; <CJK>
       (?$A\w(B . "0x8340") ;; <CJK>
       (?$A\x(B . "0x8317") ;; <CJK>
       (?$A\y(B . "0x8360") ;; <CJK>
       (?$A\z(B . "0x832D") ;; <CJK>
       (?$A\{(B . "0x833A") ;; <CJK>
       (?$A\|(B . "0x8333") ;; <CJK>
       (?$A\}(B . "0x8366") ;; <CJK>
       (?$A\~(B . "0x8365") ;; <CJK>
       (?$A]!(B . "0x8368") ;; <CJK>
       (?$A]"(B . "0x831B") ;; <CJK>
       (?$A]#(B . "0x8369") ;; <CJK>
       (?$A]$(B . "0x836C") ;; <CJK>
       (?$A]%(B . "0x836A") ;; <CJK>
       (?$A]&(B . "0x836D") ;; <CJK>
       (?$A]'(B . "0x836E") ;; <CJK>
       (?$A]((B . "0x83B0") ;; <CJK>
       (?$A])(B . "0x8378") ;; <CJK>
       (?$A]*(B . "0x83B3") ;; <CJK>
       (?$A]+(B . "0x83B4") ;; <CJK>
       (?$A],(B . "0x83A0") ;; <CJK>
       (?$A]-(B . "0x83AA") ;; <CJK>
       (?$A].(B . "0x8393") ;; <CJK>
       (?$A]/(B . "0x839C") ;; <CJK>
       (?$A]0(B . "0x8385") ;; <CJK>
       (?$A]1(B . "0x837C") ;; <CJK>
       (?$A]2(B . "0x83B6") ;; <CJK>
       (?$A]3(B . "0x83A9") ;; <CJK>
       (?$A]4(B . "0x837D") ;; <CJK>
       (?$A]5(B . "0x83B8") ;; <CJK>
       (?$A]6(B . "0x837B") ;; <CJK>
       (?$A]7(B . "0x8398") ;; <CJK>
       (?$A]8(B . "0x839E") ;; <CJK>
       (?$A]9(B . "0x83A8") ;; <CJK>
       (?$A]:(B . "0x83BA") ;; <CJK>
       (?$A];(B . "0x83BC") ;; <CJK>
       (?$A]<(B . "0x83C1") ;; <CJK>
       (?$A]=(B . "0x8401") ;; <CJK>
       (?$A]>(B . "0x83E5") ;; <CJK>
       (?$A]?(B . "0x83D8") ;; <CJK>
       (?$A]@(B . "0x5807") ;; <CJK>
       (?$A]A(B . "0x8418") ;; <CJK>
       (?$A]B(B . "0x840B") ;; <CJK>
       (?$A]C(B . "0x83DD") ;; <CJK>
       (?$A]D(B . "0x83FD") ;; <CJK>
       (?$A]E(B . "0x83D6") ;; <CJK>
       (?$A]F(B . "0x841C") ;; <CJK>
       (?$A]G(B . "0x8438") ;; <CJK>
       (?$A]H(B . "0x8411") ;; <CJK>
       (?$A]I(B . "0x8406") ;; <CJK>
       (?$A]J(B . "0x83D4") ;; <CJK>
       (?$A]K(B . "0x83DF") ;; <CJK>
       (?$A]L(B . "0x840F") ;; <CJK>
       (?$A]M(B . "0x8403") ;; <CJK>
       (?$A]N(B . "0x83F8") ;; <CJK>
       (?$A]O(B . "0x83F9") ;; <CJK>
       (?$A]P(B . "0x83EA") ;; <CJK>
       (?$A]Q(B . "0x83C5") ;; <CJK>
       (?$A]R(B . "0x83C0") ;; <CJK>
       (?$A]S(B . "0x8426") ;; <CJK>
       (?$A]T(B . "0x83F0") ;; <CJK>
       (?$A]U(B . "0x83E1") ;; <CJK>
       (?$A]V(B . "0x845C") ;; <CJK>
       (?$A]W(B . "0x8451") ;; <CJK>
       (?$A]X(B . "0x845A") ;; <CJK>
       (?$A]Y(B . "0x8459") ;; <CJK>
       (?$A]Z(B . "0x8473") ;; <CJK>
       (?$A][(B . "0x8487") ;; <CJK>
       (?$A]\(B . "0x8488") ;; <CJK>
       (?$A]](B . "0x847A") ;; <CJK>
       (?$A]^(B . "0x8489") ;; <CJK>
       (?$A]_(B . "0x8478") ;; <CJK>
       (?$A]`(B . "0x843C") ;; <CJK>
       (?$A]a(B . "0x8446") ;; <CJK>
       (?$A]b(B . "0x8469") ;; <CJK>
       (?$A]c(B . "0x8476") ;; <CJK>
       (?$A]d(B . "0x848C") ;; <CJK>
       (?$A]e(B . "0x848E") ;; <CJK>
       (?$A]f(B . "0x8431") ;; <CJK>
       (?$A]g(B . "0x846D") ;; <CJK>
       (?$A]h(B . "0x84C1") ;; <CJK>
       (?$A]i(B . "0x84CD") ;; <CJK>
       (?$A]j(B . "0x84D0") ;; <CJK>
       (?$A]k(B . "0x84E6") ;; <CJK>
       (?$A]l(B . "0x84BD") ;; <CJK>
       (?$A]m(B . "0x84D3") ;; <CJK>
       (?$A]n(B . "0x84CA") ;; <CJK>
       (?$A]o(B . "0x84BF") ;; <CJK>
       (?$A]p(B . "0x84BA") ;; <CJK>
       (?$A]q(B . "0x84E0") ;; <CJK>
       (?$A]r(B . "0x84A1") ;; <CJK>
       (?$A]s(B . "0x84B9") ;; <CJK>
       (?$A]t(B . "0x84B4") ;; <CJK>
       (?$A]u(B . "0x8497") ;; <CJK>
       (?$A]v(B . "0x84E5") ;; <CJK>
       (?$A]w(B . "0x84E3") ;; <CJK>
       (?$A]x(B . "0x850C") ;; <CJK>
       (?$A]y(B . "0x750D") ;; <CJK>
       (?$A]z(B . "0x8538") ;; <CJK>
       (?$A]{(B . "0x84F0") ;; <CJK>
       (?$A]|(B . "0x8539") ;; <CJK>
       (?$A]}(B . "0x851F") ;; <CJK>
       (?$A]~(B . "0x853A") ;; <CJK>
       (?$A^!(B . "0x8556") ;; <CJK>
       (?$A^"(B . "0x853B") ;; <CJK>
       (?$A^#(B . "0x84FF") ;; <CJK>
       (?$A^$(B . "0x84FC") ;; <CJK>
       (?$A^%(B . "0x8559") ;; <CJK>
       (?$A^&(B . "0x8548") ;; <CJK>
       (?$A^'(B . "0x8568") ;; <CJK>
       (?$A^((B . "0x8564") ;; <CJK>
       (?$A^)(B . "0x855E") ;; <CJK>
       (?$A^*(B . "0x857A") ;; <CJK>
       (?$A^+(B . "0x77A2") ;; <CJK>
       (?$A^,(B . "0x8543") ;; <CJK>
       (?$A^-(B . "0x8572") ;; <CJK>
       (?$A^.(B . "0x857B") ;; <CJK>
       (?$A^/(B . "0x85A4") ;; <CJK>
       (?$A^0(B . "0x85A8") ;; <CJK>
       (?$A^1(B . "0x8587") ;; <CJK>
       (?$A^2(B . "0x858F") ;; <CJK>
       (?$A^3(B . "0x8579") ;; <CJK>
       (?$A^4(B . "0x85AE") ;; <CJK>
       (?$A^5(B . "0x859C") ;; <CJK>
       (?$A^6(B . "0x8585") ;; <CJK>
       (?$A^7(B . "0x85B9") ;; <CJK>
       (?$A^8(B . "0x85B7") ;; <CJK>
       (?$A^9(B . "0x85B0") ;; <CJK>
       (?$A^:(B . "0x85D3") ;; <CJK>
       (?$A^;(B . "0x85C1") ;; <CJK>
       (?$A^<(B . "0x85DC") ;; <CJK>
       (?$A^=(B . "0x85FF") ;; <CJK>
       (?$A^>(B . "0x8627") ;; <CJK>
       (?$A^?(B . "0x8605") ;; <CJK>
       (?$A^@(B . "0x8629") ;; <CJK>
       (?$A^A(B . "0x8616") ;; <CJK>
       (?$A^B(B . "0x863C") ;; <CJK>
       (?$A^C(B . "0x5EFE") ;; <CJK>
       (?$A^D(B . "0x5F08") ;; <CJK>
       (?$A^E(B . "0x593C") ;; <CJK>
       (?$A^F(B . "0x5941") ;; <CJK>
       (?$A^G(B . "0x8037") ;; <CJK>
       (?$A^H(B . "0x5955") ;; <CJK>
       (?$A^I(B . "0x595A") ;; <CJK>
       (?$A^J(B . "0x5958") ;; <CJK>
       (?$A^K(B . "0x530F") ;; <CJK>
       (?$A^L(B . "0x5C22") ;; <CJK>
       (?$A^M(B . "0x5C25") ;; <CJK>
       (?$A^N(B . "0x5C2C") ;; <CJK>
       (?$A^O(B . "0x5C34") ;; <CJK>
       (?$A^P(B . "0x624C") ;; <CJK>
       (?$A^Q(B . "0x626A") ;; <CJK>
       (?$A^R(B . "0x629F") ;; <CJK>
       (?$A^S(B . "0x62BB") ;; <CJK>
       (?$A^T(B . "0x62CA") ;; <CJK>
       (?$A^U(B . "0x62DA") ;; <CJK>
       (?$A^V(B . "0x62D7") ;; <CJK>
       (?$A^W(B . "0x62EE") ;; <CJK>
       (?$A^X(B . "0x6322") ;; <CJK>
       (?$A^Y(B . "0x62F6") ;; <CJK>
       (?$A^Z(B . "0x6339") ;; <CJK>
       (?$A^[(B . "0x634B") ;; <CJK>
       (?$A^\(B . "0x6343") ;; <CJK>
       (?$A^](B . "0x63AD") ;; <CJK>
       (?$A^^(B . "0x63F6") ;; <CJK>
       (?$A^_(B . "0x6371") ;; <CJK>
       (?$A^`(B . "0x637A") ;; <CJK>
       (?$A^a(B . "0x638E") ;; <CJK>
       (?$A^b(B . "0x63B4") ;; <CJK>
       (?$A^c(B . "0x636D") ;; <CJK>
       (?$A^d(B . "0x63AC") ;; <CJK>
       (?$A^e(B . "0x638A") ;; <CJK>
       (?$A^f(B . "0x6369") ;; <CJK>
       (?$A^g(B . "0x63AE") ;; <CJK>
       (?$A^h(B . "0x63BC") ;; <CJK>
       (?$A^i(B . "0x63F2") ;; <CJK>
       (?$A^j(B . "0x63F8") ;; <CJK>
       (?$A^k(B . "0x63E0") ;; <CJK>
       (?$A^l(B . "0x63FF") ;; <CJK>
       (?$A^m(B . "0x63C4") ;; <CJK>
       (?$A^n(B . "0x63DE") ;; <CJK>
       (?$A^o(B . "0x63CE") ;; <CJK>
       (?$A^p(B . "0x6452") ;; <CJK>
       (?$A^q(B . "0x63C6") ;; <CJK>
       (?$A^r(B . "0x63BE") ;; <CJK>
       (?$A^s(B . "0x6445") ;; <CJK>
       (?$A^t(B . "0x6441") ;; <CJK>
       (?$A^u(B . "0x640B") ;; <CJK>
       (?$A^v(B . "0x641B") ;; <CJK>
       (?$A^w(B . "0x6420") ;; <CJK>
       (?$A^x(B . "0x640C") ;; <CJK>
       (?$A^y(B . "0x6426") ;; <CJK>
       (?$A^z(B . "0x6421") ;; <CJK>
       (?$A^{(B . "0x645E") ;; <CJK>
       (?$A^|(B . "0x6484") ;; <CJK>
       (?$A^}(B . "0x646D") ;; <CJK>
       (?$A^~(B . "0x6496") ;; <CJK>
       (?$A_!(B . "0x647A") ;; <CJK>
       (?$A_"(B . "0x64B7") ;; <CJK>
       (?$A_#(B . "0x64B8") ;; <CJK>
       (?$A_$(B . "0x6499") ;; <CJK>
       (?$A_%(B . "0x64BA") ;; <CJK>
       (?$A_&(B . "0x64C0") ;; <CJK>
       (?$A_'(B . "0x64D0") ;; <CJK>
       (?$A_((B . "0x64D7") ;; <CJK>
       (?$A_)(B . "0x64E4") ;; <CJK>
       (?$A_*(B . "0x64E2") ;; <CJK>
       (?$A_+(B . "0x6509") ;; <CJK>
       (?$A_,(B . "0x6525") ;; <CJK>
       (?$A_-(B . "0x652E") ;; <CJK>
       (?$A_.(B . "0x5F0B") ;; <CJK>
       (?$A_/(B . "0x5FD2") ;; <CJK>
       (?$A_0(B . "0x7519") ;; <CJK>
       (?$A_1(B . "0x5F11") ;; <CJK>
       (?$A_2(B . "0x535F") ;; <CJK>
       (?$A_3(B . "0x53F1") ;; <CJK>
       (?$A_4(B . "0x53FD") ;; <CJK>
       (?$A_5(B . "0x53E9") ;; <CJK>
       (?$A_6(B . "0x53E8") ;; <CJK>
       (?$A_7(B . "0x53FB") ;; <CJK>
       (?$A_8(B . "0x5412") ;; <CJK>
       (?$A_9(B . "0x5416") ;; <CJK>
       (?$A_:(B . "0x5406") ;; <CJK>
       (?$A_;(B . "0x544B") ;; <CJK>
       (?$A_<(B . "0x5452") ;; <CJK>
       (?$A_=(B . "0x5453") ;; <CJK>
       (?$A_>(B . "0x5454") ;; <CJK>
       (?$A_?(B . "0x5456") ;; <CJK>
       (?$A_@(B . "0x5443") ;; <CJK>
       (?$A_A(B . "0x5421") ;; <CJK>
       (?$A_B(B . "0x5457") ;; <CJK>
       (?$A_C(B . "0x5459") ;; <CJK>
       (?$A_D(B . "0x5423") ;; <CJK>
       (?$A_E(B . "0x5432") ;; <CJK>
       (?$A_F(B . "0x5482") ;; <CJK>
       (?$A_G(B . "0x5494") ;; <CJK>
       (?$A_H(B . "0x5477") ;; <CJK>
       (?$A_I(B . "0x5471") ;; <CJK>
       (?$A_J(B . "0x5464") ;; <CJK>
       (?$A_K(B . "0x549A") ;; <CJK>
       (?$A_L(B . "0x549B") ;; <CJK>
       (?$A_M(B . "0x5484") ;; <CJK>
       (?$A_N(B . "0x5476") ;; <CJK>
       (?$A_O(B . "0x5466") ;; <CJK>
       (?$A_P(B . "0x549D") ;; <CJK>
       (?$A_Q(B . "0x54D0") ;; <CJK>
       (?$A_R(B . "0x54AD") ;; <CJK>
       (?$A_S(B . "0x54C2") ;; <CJK>
       (?$A_T(B . "0x54B4") ;; <CJK>
       (?$A_U(B . "0x54D2") ;; <CJK>
       (?$A_V(B . "0x54A7") ;; <CJK>
       (?$A_W(B . "0x54A6") ;; <CJK>
       (?$A_X(B . "0x54D3") ;; <CJK>
       (?$A_Y(B . "0x54D4") ;; <CJK>
       (?$A_Z(B . "0x5472") ;; <CJK>
       (?$A_[(B . "0x54A3") ;; <CJK>
       (?$A_\(B . "0x54D5") ;; <CJK>
       (?$A_](B . "0x54BB") ;; <CJK>
       (?$A_^(B . "0x54BF") ;; <CJK>
       (?$A__(B . "0x54CC") ;; <CJK>
       (?$A_`(B . "0x54D9") ;; <CJK>
       (?$A_a(B . "0x54DA") ;; <CJK>
       (?$A_b(B . "0x54DC") ;; <CJK>
       (?$A_c(B . "0x54A9") ;; <CJK>
       (?$A_d(B . "0x54AA") ;; <CJK>
       (?$A_e(B . "0x54A4") ;; <CJK>
       (?$A_f(B . "0x54DD") ;; <CJK>
       (?$A_g(B . "0x54CF") ;; <CJK>
       (?$A_h(B . "0x54DE") ;; <CJK>
       (?$A_i(B . "0x551B") ;; <CJK>
       (?$A_j(B . "0x54E7") ;; <CJK>
       (?$A_k(B . "0x5520") ;; <CJK>
       (?$A_l(B . "0x54FD") ;; <CJK>
       (?$A_m(B . "0x5514") ;; <CJK>
       (?$A_n(B . "0x54F3") ;; <CJK>
       (?$A_o(B . "0x5522") ;; <CJK>
       (?$A_p(B . "0x5523") ;; <CJK>
       (?$A_q(B . "0x550F") ;; <CJK>
       (?$A_r(B . "0x5511") ;; <CJK>
       (?$A_s(B . "0x5527") ;; <CJK>
       (?$A_t(B . "0x552A") ;; <CJK>
       (?$A_u(B . "0x5567") ;; <CJK>
       (?$A_v(B . "0x558F") ;; <CJK>
       (?$A_w(B . "0x55B5") ;; <CJK>
       (?$A_x(B . "0x5549") ;; <CJK>
       (?$A_y(B . "0x556D") ;; <CJK>
       (?$A_z(B . "0x5541") ;; <CJK>
       (?$A_{(B . "0x5555") ;; <CJK>
       (?$A_|(B . "0x553F") ;; <CJK>
       (?$A_}(B . "0x5550") ;; <CJK>
       (?$A_~(B . "0x553C") ;; <CJK>
       (?$A`!(B . "0x5537") ;; <CJK>
       (?$A`"(B . "0x5556") ;; <CJK>
       (?$A`#(B . "0x5575") ;; <CJK>
       (?$A`$(B . "0x5576") ;; <CJK>
       (?$A`%(B . "0x5577") ;; <CJK>
       (?$A`&(B . "0x5533") ;; <CJK>
       (?$A`'(B . "0x5530") ;; <CJK>
       (?$A`((B . "0x555C") ;; <CJK>
       (?$A`)(B . "0x558B") ;; <CJK>
       (?$A`*(B . "0x55D2") ;; <CJK>
       (?$A`+(B . "0x5583") ;; <CJK>
       (?$A`,(B . "0x55B1") ;; <CJK>
       (?$A`-(B . "0x55B9") ;; <CJK>
       (?$A`.(B . "0x5588") ;; <CJK>
       (?$A`/(B . "0x5581") ;; <CJK>
       (?$A`0(B . "0x559F") ;; <CJK>
       (?$A`1(B . "0x557E") ;; <CJK>
       (?$A`2(B . "0x55D6") ;; <CJK>
       (?$A`3(B . "0x5591") ;; <CJK>
       (?$A`4(B . "0x557B") ;; <CJK>
       (?$A`5(B . "0x55DF") ;; <CJK>
       (?$A`6(B . "0x55BD") ;; <CJK>
       (?$A`7(B . "0x55BE") ;; <CJK>
       (?$A`8(B . "0x5594") ;; <CJK>
       (?$A`9(B . "0x5599") ;; <CJK>
       (?$A`:(B . "0x55EA") ;; <CJK>
       (?$A`;(B . "0x55F7") ;; <CJK>
       (?$A`<(B . "0x55C9") ;; <CJK>
       (?$A`=(B . "0x561F") ;; <CJK>
       (?$A`>(B . "0x55D1") ;; <CJK>
       (?$A`?(B . "0x55EB") ;; <CJK>
       (?$A`@(B . "0x55EC") ;; <CJK>
       (?$A`A(B . "0x55D4") ;; <CJK>
       (?$A`B(B . "0x55E6") ;; <CJK>
       (?$A`C(B . "0x55DD") ;; <CJK>
       (?$A`D(B . "0x55C4") ;; <CJK>
       (?$A`E(B . "0x55EF") ;; <CJK>
       (?$A`F(B . "0x55E5") ;; <CJK>
       (?$A`G(B . "0x55F2") ;; <CJK>
       (?$A`H(B . "0x55F3") ;; <CJK>
       (?$A`I(B . "0x55CC") ;; <CJK>
       (?$A`J(B . "0x55CD") ;; <CJK>
       (?$A`K(B . "0x55E8") ;; <CJK>
       (?$A`L(B . "0x55F5") ;; <CJK>
       (?$A`M(B . "0x55E4") ;; <CJK>
       (?$A`N(B . "0x8F94") ;; <CJK>
       (?$A`O(B . "0x561E") ;; <CJK>
       (?$A`P(B . "0x5608") ;; <CJK>
       (?$A`Q(B . "0x560C") ;; <CJK>
       (?$A`R(B . "0x5601") ;; <CJK>
       (?$A`S(B . "0x5624") ;; <CJK>
       (?$A`T(B . "0x5623") ;; <CJK>
       (?$A`U(B . "0x55FE") ;; <CJK>
       (?$A`V(B . "0x5600") ;; <CJK>
       (?$A`W(B . "0x5627") ;; <CJK>
       (?$A`X(B . "0x562D") ;; <CJK>
       (?$A`Y(B . "0x5658") ;; <CJK>
       (?$A`Z(B . "0x5639") ;; <CJK>
       (?$A`[(B . "0x5657") ;; <CJK>
       (?$A`\(B . "0x562C") ;; <CJK>
       (?$A`](B . "0x564D") ;; <CJK>
       (?$A`^(B . "0x5662") ;; <CJK>
       (?$A`_(B . "0x5659") ;; <CJK>
       (?$A``(B . "0x565C") ;; <CJK>
       (?$A`a(B . "0x564C") ;; <CJK>
       (?$A`b(B . "0x5654") ;; <CJK>
       (?$A`c(B . "0x5686") ;; <CJK>
       (?$A`d(B . "0x5664") ;; <CJK>
       (?$A`e(B . "0x5671") ;; <CJK>
       (?$A`f(B . "0x566B") ;; <CJK>
       (?$A`g(B . "0x567B") ;; <CJK>
       (?$A`h(B . "0x567C") ;; <CJK>
       (?$A`i(B . "0x5685") ;; <CJK>
       (?$A`j(B . "0x5693") ;; <CJK>
       (?$A`k(B . "0x56AF") ;; <CJK>
       (?$A`l(B . "0x56D4") ;; <CJK>
       (?$A`m(B . "0x56D7") ;; <CJK>
       (?$A`n(B . "0x56DD") ;; <CJK>
       (?$A`o(B . "0x56E1") ;; <CJK>
       (?$A`p(B . "0x56F5") ;; <CJK>
       (?$A`q(B . "0x56EB") ;; <CJK>
       (?$A`r(B . "0x56F9") ;; <CJK>
       (?$A`s(B . "0x56FF") ;; <CJK>
       (?$A`t(B . "0x5704") ;; <CJK>
       (?$A`u(B . "0x570A") ;; <CJK>
       (?$A`v(B . "0x5709") ;; <CJK>
       (?$A`w(B . "0x571C") ;; <CJK>
       (?$A`x(B . "0x5E0F") ;; <CJK>
       (?$A`y(B . "0x5E19") ;; <CJK>
       (?$A`z(B . "0x5E14") ;; <CJK>
       (?$A`{(B . "0x5E11") ;; <CJK>
       (?$A`|(B . "0x5E31") ;; <CJK>
       (?$A`}(B . "0x5E3B") ;; <CJK>
       (?$A`~(B . "0x5E3C") ;; <CJK>
       (?$Aa!(B . "0x5E37") ;; <CJK>
       (?$Aa"(B . "0x5E44") ;; <CJK>
       (?$Aa#(B . "0x5E54") ;; <CJK>
       (?$Aa$(B . "0x5E5B") ;; <CJK>
       (?$Aa%(B . "0x5E5E") ;; <CJK>
       (?$Aa&(B . "0x5E61") ;; <CJK>
       (?$Aa'(B . "0x5C8C") ;; <CJK>
       (?$Aa((B . "0x5C7A") ;; <CJK>
       (?$Aa)(B . "0x5C8D") ;; <CJK>
       (?$Aa*(B . "0x5C90") ;; <CJK>
       (?$Aa+(B . "0x5C96") ;; <CJK>
       (?$Aa,(B . "0x5C88") ;; <CJK>
       (?$Aa-(B . "0x5C98") ;; <CJK>
       (?$Aa.(B . "0x5C99") ;; <CJK>
       (?$Aa/(B . "0x5C91") ;; <CJK>
       (?$Aa0(B . "0x5C9A") ;; <CJK>
       (?$Aa1(B . "0x5C9C") ;; <CJK>
       (?$Aa2(B . "0x5CB5") ;; <CJK>
       (?$Aa3(B . "0x5CA2") ;; <CJK>
       (?$Aa4(B . "0x5CBD") ;; <CJK>
       (?$Aa5(B . "0x5CAC") ;; <CJK>
       (?$Aa6(B . "0x5CAB") ;; <CJK>
       (?$Aa7(B . "0x5CB1") ;; <CJK>
       (?$Aa8(B . "0x5CA3") ;; <CJK>
       (?$Aa9(B . "0x5CC1") ;; <CJK>
       (?$Aa:(B . "0x5CB7") ;; <CJK>
       (?$Aa;(B . "0x5CC4") ;; <CJK>
       (?$Aa<(B . "0x5CD2") ;; <CJK>
       (?$Aa=(B . "0x5CE4") ;; <CJK>
       (?$Aa>(B . "0x5CCB") ;; <CJK>
       (?$Aa?(B . "0x5CE5") ;; <CJK>
       (?$Aa@(B . "0x5D02") ;; <CJK>
       (?$AaA(B . "0x5D03") ;; <CJK>
       (?$AaB(B . "0x5D27") ;; <CJK>
       (?$AaC(B . "0x5D26") ;; <CJK>
       (?$AaD(B . "0x5D2E") ;; <CJK>
       (?$AaE(B . "0x5D24") ;; <CJK>
       (?$AaF(B . "0x5D1E") ;; <CJK>
       (?$AaG(B . "0x5D06") ;; <CJK>
       (?$AaH(B . "0x5D1B") ;; <CJK>
       (?$AaI(B . "0x5D58") ;; <CJK>
       (?$AaJ(B . "0x5D3E") ;; <CJK>
       (?$AaK(B . "0x5D34") ;; <CJK>
       (?$AaL(B . "0x5D3D") ;; <CJK>
       (?$AaM(B . "0x5D6C") ;; <CJK>
       (?$AaN(B . "0x5D5B") ;; <CJK>
       (?$AaO(B . "0x5D6F") ;; <CJK>
       (?$AaP(B . "0x5D5D") ;; <CJK>
       (?$AaQ(B . "0x5D6B") ;; <CJK>
       (?$AaR(B . "0x5D4B") ;; <CJK>
       (?$AaS(B . "0x5D4A") ;; <CJK>
       (?$AaT(B . "0x5D69") ;; <CJK>
       (?$AaU(B . "0x5D74") ;; <CJK>
       (?$AaV(B . "0x5D82") ;; <CJK>
       (?$AaW(B . "0x5D99") ;; <CJK>
       (?$AaX(B . "0x5D9D") ;; <CJK>
       (?$AaY(B . "0x8C73") ;; <CJK>
       (?$AaZ(B . "0x5DB7") ;; <CJK>
       (?$Aa[(B . "0x5DC5") ;; <CJK>
       (?$Aa\(B . "0x5F73") ;; <CJK>
       (?$Aa](B . "0x5F77") ;; <CJK>
       (?$Aa^(B . "0x5F82") ;; <CJK>
       (?$Aa_(B . "0x5F87") ;; <CJK>
       (?$Aa`(B . "0x5F89") ;; <CJK>
       (?$Aaa(B . "0x5F8C") ;; <CJK>
       (?$Aab(B . "0x5F95") ;; <CJK>
       (?$Aac(B . "0x5F99") ;; <CJK>
       (?$Aad(B . "0x5F9C") ;; <CJK>
       (?$Aae(B . "0x5FA8") ;; <CJK>
       (?$Aaf(B . "0x5FAD") ;; <CJK>
       (?$Aag(B . "0x5FB5") ;; <CJK>
       (?$Aah(B . "0x5FBC") ;; <CJK>
       (?$Aai(B . "0x8862") ;; <CJK>
       (?$Aaj(B . "0x5F61") ;; <CJK>
       (?$Aak(B . "0x72AD") ;; <CJK>
       (?$Aal(B . "0x72B0") ;; <CJK>
       (?$Aam(B . "0x72B4") ;; <CJK>
       (?$Aan(B . "0x72B7") ;; <CJK>
       (?$Aao(B . "0x72B8") ;; <CJK>
       (?$Aap(B . "0x72C3") ;; <CJK>
       (?$Aaq(B . "0x72C1") ;; <CJK>
       (?$Aar(B . "0x72CE") ;; <CJK>
       (?$Aas(B . "0x72CD") ;; <CJK>
       (?$Aat(B . "0x72D2") ;; <CJK>
       (?$Aau(B . "0x72E8") ;; <CJK>
       (?$Aav(B . "0x72EF") ;; <CJK>
       (?$Aaw(B . "0x72E9") ;; <CJK>
       (?$Aax(B . "0x72F2") ;; <CJK>
       (?$Aay(B . "0x72F4") ;; <CJK>
       (?$Aaz(B . "0x72F7") ;; <CJK>
       (?$Aa{(B . "0x7301") ;; <CJK>
       (?$Aa|(B . "0x72F3") ;; <CJK>
       (?$Aa}(B . "0x7303") ;; <CJK>
       (?$Aa~(B . "0x72FA") ;; <CJK>
       (?$Ab!(B . "0x72FB") ;; <CJK>
       (?$Ab"(B . "0x7317") ;; <CJK>
       (?$Ab#(B . "0x7313") ;; <CJK>
       (?$Ab$(B . "0x7321") ;; <CJK>
       (?$Ab%(B . "0x730A") ;; <CJK>
       (?$Ab&(B . "0x731E") ;; <CJK>
       (?$Ab'(B . "0x731D") ;; <CJK>
       (?$Ab((B . "0x7315") ;; <CJK>
       (?$Ab)(B . "0x7322") ;; <CJK>
       (?$Ab*(B . "0x7339") ;; <CJK>
       (?$Ab+(B . "0x7325") ;; <CJK>
       (?$Ab,(B . "0x732C") ;; <CJK>
       (?$Ab-(B . "0x7338") ;; <CJK>
       (?$Ab.(B . "0x7331") ;; <CJK>
       (?$Ab/(B . "0x7350") ;; <CJK>
       (?$Ab0(B . "0x734D") ;; <CJK>
       (?$Ab1(B . "0x7357") ;; <CJK>
       (?$Ab2(B . "0x7360") ;; <CJK>
       (?$Ab3(B . "0x736C") ;; <CJK>
       (?$Ab4(B . "0x736F") ;; <CJK>
       (?$Ab5(B . "0x737E") ;; <CJK>
       (?$Ab6(B . "0x821B") ;; <CJK>
       (?$Ab7(B . "0x5925") ;; <CJK>
       (?$Ab8(B . "0x98E7") ;; <CJK>
       (?$Ab9(B . "0x5924") ;; <CJK>
       (?$Ab:(B . "0x5902") ;; <CJK>
       (?$Ab;(B . "0x9963") ;; <CJK>
       (?$Ab<(B . "0x9967") ;; <CJK>
       (?$Ab=(B . "0x9968") ;; <CJK>
       (?$Ab>(B . "0x9969") ;; <CJK>
       (?$Ab?(B . "0x996A") ;; <CJK>
       (?$Ab@(B . "0x996B") ;; <CJK>
       (?$AbA(B . "0x996C") ;; <CJK>
       (?$AbB(B . "0x9974") ;; <CJK>
       (?$AbC(B . "0x9977") ;; <CJK>
       (?$AbD(B . "0x997D") ;; <CJK>
       (?$AbE(B . "0x9980") ;; <CJK>
       (?$AbF(B . "0x9984") ;; <CJK>
       (?$AbG(B . "0x9987") ;; <CJK>
       (?$AbH(B . "0x998A") ;; <CJK>
       (?$AbI(B . "0x998D") ;; <CJK>
       (?$AbJ(B . "0x9990") ;; <CJK>
       (?$AbK(B . "0x9991") ;; <CJK>
       (?$AbL(B . "0x9993") ;; <CJK>
       (?$AbM(B . "0x9994") ;; <CJK>
       (?$AbN(B . "0x9995") ;; <CJK>
       (?$AbO(B . "0x5E80") ;; <CJK>
       (?$AbP(B . "0x5E91") ;; <CJK>
       (?$AbQ(B . "0x5E8B") ;; <CJK>
       (?$AbR(B . "0x5E96") ;; <CJK>
       (?$AbS(B . "0x5EA5") ;; <CJK>
       (?$AbT(B . "0x5EA0") ;; <CJK>
       (?$AbU(B . "0x5EB9") ;; <CJK>
       (?$AbV(B . "0x5EB5") ;; <CJK>
       (?$AbW(B . "0x5EBE") ;; <CJK>
       (?$AbX(B . "0x5EB3") ;; <CJK>
       (?$AbY(B . "0x8D53") ;; <CJK>
       (?$AbZ(B . "0x5ED2") ;; <CJK>
       (?$Ab[(B . "0x5ED1") ;; <CJK>
       (?$Ab\(B . "0x5EDB") ;; <CJK>
       (?$Ab](B . "0x5EE8") ;; <CJK>
       (?$Ab^(B . "0x5EEA") ;; <CJK>
       (?$Ab_(B . "0x81BA") ;; <CJK>
       (?$Ab`(B . "0x5FC4") ;; <CJK>
       (?$Aba(B . "0x5FC9") ;; <CJK>
       (?$Abb(B . "0x5FD6") ;; <CJK>
       (?$Abc(B . "0x5FCF") ;; <CJK>
       (?$Abd(B . "0x6003") ;; <CJK>
       (?$Abe(B . "0x5FEE") ;; <CJK>
       (?$Abf(B . "0x6004") ;; <CJK>
       (?$Abg(B . "0x5FE1") ;; <CJK>
       (?$Abh(B . "0x5FE4") ;; <CJK>
       (?$Abi(B . "0x5FFE") ;; <CJK>
       (?$Abj(B . "0x6005") ;; <CJK>
       (?$Abk(B . "0x6006") ;; <CJK>
       (?$Abl(B . "0x5FEA") ;; <CJK>
       (?$Abm(B . "0x5FED") ;; <CJK>
       (?$Abn(B . "0x5FF8") ;; <CJK>
       (?$Abo(B . "0x6019") ;; <CJK>
       (?$Abp(B . "0x6035") ;; <CJK>
       (?$Abq(B . "0x6026") ;; <CJK>
       (?$Abr(B . "0x601B") ;; <CJK>
       (?$Abs(B . "0x600F") ;; <CJK>
       (?$Abt(B . "0x600D") ;; <CJK>
       (?$Abu(B . "0x6029") ;; <CJK>
       (?$Abv(B . "0x602B") ;; <CJK>
       (?$Abw(B . "0x600A") ;; <CJK>
       (?$Abx(B . "0x603F") ;; <CJK>
       (?$Aby(B . "0x6021") ;; <CJK>
       (?$Abz(B . "0x6078") ;; <CJK>
       (?$Ab{(B . "0x6079") ;; <CJK>
       (?$Ab|(B . "0x607B") ;; <CJK>
       (?$Ab}(B . "0x607A") ;; <CJK>
       (?$Ab~(B . "0x6042") ;; <CJK>
       (?$Ac!(B . "0x606A") ;; <CJK>
       (?$Ac"(B . "0x607D") ;; <CJK>
       (?$Ac#(B . "0x6096") ;; <CJK>
       (?$Ac$(B . "0x609A") ;; <CJK>
       (?$Ac%(B . "0x60AD") ;; <CJK>
       (?$Ac&(B . "0x609D") ;; <CJK>
       (?$Ac'(B . "0x6083") ;; <CJK>
       (?$Ac((B . "0x6092") ;; <CJK>
       (?$Ac)(B . "0x608C") ;; <CJK>
       (?$Ac*(B . "0x609B") ;; <CJK>
       (?$Ac+(B . "0x60EC") ;; <CJK>
       (?$Ac,(B . "0x60BB") ;; <CJK>
       (?$Ac-(B . "0x60B1") ;; <CJK>
       (?$Ac.(B . "0x60DD") ;; <CJK>
       (?$Ac/(B . "0x60D8") ;; <CJK>
       (?$Ac0(B . "0x60C6") ;; <CJK>
       (?$Ac1(B . "0x60DA") ;; <CJK>
       (?$Ac2(B . "0x60B4") ;; <CJK>
       (?$Ac3(B . "0x6120") ;; <CJK>
       (?$Ac4(B . "0x6126") ;; <CJK>
       (?$Ac5(B . "0x6115") ;; <CJK>
       (?$Ac6(B . "0x6123") ;; <CJK>
       (?$Ac7(B . "0x60F4") ;; <CJK>
       (?$Ac8(B . "0x6100") ;; <CJK>
       (?$Ac9(B . "0x610E") ;; <CJK>
       (?$Ac:(B . "0x612B") ;; <CJK>
       (?$Ac;(B . "0x614A") ;; <CJK>
       (?$Ac<(B . "0x6175") ;; <CJK>
       (?$Ac=(B . "0x61AC") ;; <CJK>
       (?$Ac>(B . "0x6194") ;; <CJK>
       (?$Ac?(B . "0x61A7") ;; <CJK>
       (?$Ac@(B . "0x61B7") ;; <CJK>
       (?$AcA(B . "0x61D4") ;; <CJK>
       (?$AcB(B . "0x61F5") ;; <CJK>
       (?$AcC(B . "0x5FDD") ;; <CJK>
       (?$AcD(B . "0x96B3") ;; <CJK>
       (?$AcE(B . "0x95E9") ;; <CJK>
       (?$AcF(B . "0x95EB") ;; <CJK>
       (?$AcG(B . "0x95F1") ;; <CJK>
       (?$AcH(B . "0x95F3") ;; <CJK>
       (?$AcI(B . "0x95F5") ;; <CJK>
       (?$AcJ(B . "0x95F6") ;; <CJK>
       (?$AcK(B . "0x95FC") ;; <CJK>
       (?$AcL(B . "0x95FE") ;; <CJK>
       (?$AcM(B . "0x9603") ;; <CJK>
       (?$AcN(B . "0x9604") ;; <CJK>
       (?$AcO(B . "0x9606") ;; <CJK>
       (?$AcP(B . "0x9608") ;; <CJK>
       (?$AcQ(B . "0x960A") ;; <CJK>
       (?$AcR(B . "0x960B") ;; <CJK>
       (?$AcS(B . "0x960C") ;; <CJK>
       (?$AcT(B . "0x960D") ;; <CJK>
       (?$AcU(B . "0x960F") ;; <CJK>
       (?$AcV(B . "0x9612") ;; <CJK>
       (?$AcW(B . "0x9615") ;; <CJK>
       (?$AcX(B . "0x9616") ;; <CJK>
       (?$AcY(B . "0x9617") ;; <CJK>
       (?$AcZ(B . "0x9619") ;; <CJK>
       (?$Ac[(B . "0x961A") ;; <CJK>
       (?$Ac\(B . "0x4E2C") ;; <CJK>
       (?$Ac](B . "0x723F") ;; <CJK>
       (?$Ac^(B . "0x6215") ;; <CJK>
       (?$Ac_(B . "0x6C35") ;; <CJK>
       (?$Ac`(B . "0x6C54") ;; <CJK>
       (?$Aca(B . "0x6C5C") ;; <CJK>
       (?$Acb(B . "0x6C4A") ;; <CJK>
       (?$Acc(B . "0x6CA3") ;; <CJK>
       (?$Acd(B . "0x6C85") ;; <CJK>
       (?$Ace(B . "0x6C90") ;; <CJK>
       (?$Acf(B . "0x6C94") ;; <CJK>
       (?$Acg(B . "0x6C8C") ;; <CJK>
       (?$Ach(B . "0x6C68") ;; <CJK>
       (?$Aci(B . "0x6C69") ;; <CJK>
       (?$Acj(B . "0x6C74") ;; <CJK>
       (?$Ack(B . "0x6C76") ;; <CJK>
       (?$Acl(B . "0x6C86") ;; <CJK>
       (?$Acm(B . "0x6CA9") ;; <CJK>
       (?$Acn(B . "0x6CD0") ;; <CJK>
       (?$Aco(B . "0x6CD4") ;; <CJK>
       (?$Acp(B . "0x6CAD") ;; <CJK>
       (?$Acq(B . "0x6CF7") ;; <CJK>
       (?$Acr(B . "0x6CF8") ;; <CJK>
       (?$Acs(B . "0x6CF1") ;; <CJK>
       (?$Act(B . "0x6CD7") ;; <CJK>
       (?$Acu(B . "0x6CB2") ;; <CJK>
       (?$Acv(B . "0x6CE0") ;; <CJK>
       (?$Acw(B . "0x6CD6") ;; <CJK>
       (?$Acx(B . "0x6CFA") ;; <CJK>
       (?$Acy(B . "0x6CEB") ;; <CJK>
       (?$Acz(B . "0x6CEE") ;; <CJK>
       (?$Ac{(B . "0x6CB1") ;; <CJK>
       (?$Ac|(B . "0x6CD3") ;; <CJK>
       (?$Ac}(B . "0x6CEF") ;; <CJK>
       (?$Ac~(B . "0x6CFE") ;; <CJK>
       (?$Ad!(B . "0x6D39") ;; <CJK>
       (?$Ad"(B . "0x6D27") ;; <CJK>
       (?$Ad#(B . "0x6D0C") ;; <CJK>
       (?$Ad$(B . "0x6D43") ;; <CJK>
       (?$Ad%(B . "0x6D48") ;; <CJK>
       (?$Ad&(B . "0x6D07") ;; <CJK>
       (?$Ad'(B . "0x6D04") ;; <CJK>
       (?$Ad((B . "0x6D19") ;; <CJK>
       (?$Ad)(B . "0x6D0E") ;; <CJK>
       (?$Ad*(B . "0x6D2B") ;; <CJK>
       (?$Ad+(B . "0x6D4D") ;; <CJK>
       (?$Ad,(B . "0x6D2E") ;; <CJK>
       (?$Ad-(B . "0x6D35") ;; <CJK>
       (?$Ad.(B . "0x6D1A") ;; <CJK>
       (?$Ad/(B . "0x6D4F") ;; <CJK>
       (?$Ad0(B . "0x6D52") ;; <CJK>
       (?$Ad1(B . "0x6D54") ;; <CJK>
       (?$Ad2(B . "0x6D33") ;; <CJK>
       (?$Ad3(B . "0x6D91") ;; <CJK>
       (?$Ad4(B . "0x6D6F") ;; <CJK>
       (?$Ad5(B . "0x6D9E") ;; <CJK>
       (?$Ad6(B . "0x6DA0") ;; <CJK>
       (?$Ad7(B . "0x6D5E") ;; <CJK>
       (?$Ad8(B . "0x6D93") ;; <CJK>
       (?$Ad9(B . "0x6D94") ;; <CJK>
       (?$Ad:(B . "0x6D5C") ;; <CJK>
       (?$Ad;(B . "0x6D60") ;; <CJK>
       (?$Ad<(B . "0x6D7C") ;; <CJK>
       (?$Ad=(B . "0x6D63") ;; <CJK>
       (?$Ad>(B . "0x6E1A") ;; <CJK>
       (?$Ad?(B . "0x6DC7") ;; <CJK>
       (?$Ad@(B . "0x6DC5") ;; <CJK>
       (?$AdA(B . "0x6DDE") ;; <CJK>
       (?$AdB(B . "0x6E0E") ;; <CJK>
       (?$AdC(B . "0x6DBF") ;; <CJK>
       (?$AdD(B . "0x6DE0") ;; <CJK>
       (?$AdE(B . "0x6E11") ;; <CJK>
       (?$AdF(B . "0x6DE6") ;; <CJK>
       (?$AdG(B . "0x6DDD") ;; <CJK>
       (?$AdH(B . "0x6DD9") ;; <CJK>
       (?$AdI(B . "0x6E16") ;; <CJK>
       (?$AdJ(B . "0x6DAB") ;; <CJK>
       (?$AdK(B . "0x6E0C") ;; <CJK>
       (?$AdL(B . "0x6DAE") ;; <CJK>
       (?$AdM(B . "0x6E2B") ;; <CJK>
       (?$AdN(B . "0x6E6E") ;; <CJK>
       (?$AdO(B . "0x6E4E") ;; <CJK>
       (?$AdP(B . "0x6E6B") ;; <CJK>
       (?$AdQ(B . "0x6EB2") ;; <CJK>
       (?$AdR(B . "0x6E5F") ;; <CJK>
       (?$AdS(B . "0x6E86") ;; <CJK>
       (?$AdT(B . "0x6E53") ;; <CJK>
       (?$AdU(B . "0x6E54") ;; <CJK>
       (?$AdV(B . "0x6E32") ;; <CJK>
       (?$AdW(B . "0x6E25") ;; <CJK>
       (?$AdX(B . "0x6E44") ;; <CJK>
       (?$AdY(B . "0x6EDF") ;; <CJK>
       (?$AdZ(B . "0x6EB1") ;; <CJK>
       (?$Ad[(B . "0x6E98") ;; <CJK>
       (?$Ad\(B . "0x6EE0") ;; <CJK>
       (?$Ad](B . "0x6F2D") ;; <CJK>
       (?$Ad^(B . "0x6EE2") ;; <CJK>
       (?$Ad_(B . "0x6EA5") ;; <CJK>
       (?$Ad`(B . "0x6EA7") ;; <CJK>
       (?$Ada(B . "0x6EBD") ;; <CJK>
       (?$Adb(B . "0x6EBB") ;; <CJK>
       (?$Adc(B . "0x6EB7") ;; <CJK>
       (?$Add(B . "0x6ED7") ;; <CJK>
       (?$Ade(B . "0x6EB4") ;; <CJK>
       (?$Adf(B . "0x6ECF") ;; <CJK>
       (?$Adg(B . "0x6E8F") ;; <CJK>
       (?$Adh(B . "0x6EC2") ;; <CJK>
       (?$Adi(B . "0x6E9F") ;; <CJK>
       (?$Adj(B . "0x6F62") ;; <CJK>
       (?$Adk(B . "0x6F46") ;; <CJK>
       (?$Adl(B . "0x6F47") ;; <CJK>
       (?$Adm(B . "0x6F24") ;; <CJK>
       (?$Adn(B . "0x6F15") ;; <CJK>
       (?$Ado(B . "0x6EF9") ;; <CJK>
       (?$Adp(B . "0x6F2F") ;; <CJK>
       (?$Adq(B . "0x6F36") ;; <CJK>
       (?$Adr(B . "0x6F4B") ;; <CJK>
       (?$Ads(B . "0x6F74") ;; <CJK>
       (?$Adt(B . "0x6F2A") ;; <CJK>
       (?$Adu(B . "0x6F09") ;; <CJK>
       (?$Adv(B . "0x6F29") ;; <CJK>
       (?$Adw(B . "0x6F89") ;; <CJK>
       (?$Adx(B . "0x6F8D") ;; <CJK>
       (?$Ady(B . "0x6F8C") ;; <CJK>
       (?$Adz(B . "0x6F78") ;; <CJK>
       (?$Ad{(B . "0x6F72") ;; <CJK>
       (?$Ad|(B . "0x6F7C") ;; <CJK>
       (?$Ad}(B . "0x6F7A") ;; <CJK>
       (?$Ad~(B . "0x6FD1") ;; <CJK>
       (?$Ae!(B . "0x6FC9") ;; <CJK>
       (?$Ae"(B . "0x6FA7") ;; <CJK>
       (?$Ae#(B . "0x6FB9") ;; <CJK>
       (?$Ae$(B . "0x6FB6") ;; <CJK>
       (?$Ae%(B . "0x6FC2") ;; <CJK>
       (?$Ae&(B . "0x6FE1") ;; <CJK>
       (?$Ae'(B . "0x6FEE") ;; <CJK>
       (?$Ae((B . "0x6FDE") ;; <CJK>
       (?$Ae)(B . "0x6FE0") ;; <CJK>
       (?$Ae*(B . "0x6FEF") ;; <CJK>
       (?$Ae+(B . "0x701A") ;; <CJK>
       (?$Ae,(B . "0x7023") ;; <CJK>
       (?$Ae-(B . "0x701B") ;; <CJK>
       (?$Ae.(B . "0x7039") ;; <CJK>
       (?$Ae/(B . "0x7035") ;; <CJK>
       (?$Ae0(B . "0x704F") ;; <CJK>
       (?$Ae1(B . "0x705E") ;; <CJK>
       (?$Ae2(B . "0x5B80") ;; <CJK>
       (?$Ae3(B . "0x5B84") ;; <CJK>
       (?$Ae4(B . "0x5B95") ;; <CJK>
       (?$Ae5(B . "0x5B93") ;; <CJK>
       (?$Ae6(B . "0x5BA5") ;; <CJK>
       (?$Ae7(B . "0x5BB8") ;; <CJK>
       (?$Ae8(B . "0x752F") ;; <CJK>
       (?$Ae9(B . "0x9A9E") ;; <CJK>
       (?$Ae:(B . "0x6434") ;; <CJK>
       (?$Ae;(B . "0x5BE4") ;; <CJK>
       (?$Ae<(B . "0x5BEE") ;; <CJK>
       (?$Ae=(B . "0x8930") ;; <CJK>
       (?$Ae>(B . "0x5BF0") ;; <CJK>
       (?$Ae?(B . "0x8E47") ;; <CJK>
       (?$Ae@(B . "0x8B07") ;; <CJK>
       (?$AeA(B . "0x8FB6") ;; <CJK>
       (?$AeB(B . "0x8FD3") ;; <CJK>
       (?$AeC(B . "0x8FD5") ;; <CJK>
       (?$AeD(B . "0x8FE5") ;; <CJK>
       (?$AeE(B . "0x8FEE") ;; <CJK>
       (?$AeF(B . "0x8FE4") ;; <CJK>
       (?$AeG(B . "0x8FE9") ;; <CJK>
       (?$AeH(B . "0x8FE6") ;; <CJK>
       (?$AeI(B . "0x8FF3") ;; <CJK>
       (?$AeJ(B . "0x8FE8") ;; <CJK>
       (?$AeK(B . "0x9005") ;; <CJK>
       (?$AeL(B . "0x9004") ;; <CJK>
       (?$AeM(B . "0x900B") ;; <CJK>
       (?$AeN(B . "0x9026") ;; <CJK>
       (?$AeO(B . "0x9011") ;; <CJK>
       (?$AeP(B . "0x900D") ;; <CJK>
       (?$AeQ(B . "0x9016") ;; <CJK>
       (?$AeR(B . "0x9021") ;; <CJK>
       (?$AeS(B . "0x9035") ;; <CJK>
       (?$AeT(B . "0x9036") ;; <CJK>
       (?$AeU(B . "0x902D") ;; <CJK>
       (?$AeV(B . "0x902F") ;; <CJK>
       (?$AeW(B . "0x9044") ;; <CJK>
       (?$AeX(B . "0x9051") ;; <CJK>
       (?$AeY(B . "0x9052") ;; <CJK>
       (?$AeZ(B . "0x9050") ;; <CJK>
       (?$Ae[(B . "0x9068") ;; <CJK>
       (?$Ae\(B . "0x9058") ;; <CJK>
       (?$Ae](B . "0x9062") ;; <CJK>
       (?$Ae^(B . "0x905B") ;; <CJK>
       (?$Ae_(B . "0x66B9") ;; <CJK>
       (?$Ae`(B . "0x9074") ;; <CJK>
       (?$Aea(B . "0x907D") ;; <CJK>
       (?$Aeb(B . "0x9082") ;; <CJK>
       (?$Aec(B . "0x9088") ;; <CJK>
       (?$Aed(B . "0x9083") ;; <CJK>
       (?$Aee(B . "0x908B") ;; <CJK>
       (?$Aef(B . "0x5F50") ;; <CJK>
       (?$Aeg(B . "0x5F57") ;; <CJK>
       (?$Aeh(B . "0x5F56") ;; <CJK>
       (?$Aei(B . "0x5F58") ;; <CJK>
       (?$Aej(B . "0x5C3B") ;; <CJK>
       (?$Aek(B . "0x54AB") ;; <CJK>
       (?$Ael(B . "0x5C50") ;; <CJK>
       (?$Aem(B . "0x5C59") ;; <CJK>
       (?$Aen(B . "0x5B71") ;; <CJK>
       (?$Aeo(B . "0x5C63") ;; <CJK>
       (?$Aep(B . "0x5C66") ;; <CJK>
       (?$Aeq(B . "0x7FBC") ;; <CJK>
       (?$Aer(B . "0x5F2A") ;; <CJK>
       (?$Aes(B . "0x5F29") ;; <CJK>
       (?$Aet(B . "0x5F2D") ;; <CJK>
       (?$Aeu(B . "0x8274") ;; <CJK>
       (?$Aev(B . "0x5F3C") ;; <CJK>
       (?$Aew(B . "0x9B3B") ;; <CJK>
       (?$Aex(B . "0x5C6E") ;; <CJK>
       (?$Aey(B . "0x5981") ;; <CJK>
       (?$Aez(B . "0x5983") ;; <CJK>
       (?$Ae{(B . "0x598D") ;; <CJK>
       (?$Ae|(B . "0x59A9") ;; <CJK>
       (?$Ae}(B . "0x59AA") ;; <CJK>
       (?$Ae~(B . "0x59A3") ;; <CJK>
       (?$Af!(B . "0x5997") ;; <CJK>
       (?$Af"(B . "0x59CA") ;; <CJK>
       (?$Af#(B . "0x59AB") ;; <CJK>
       (?$Af$(B . "0x599E") ;; <CJK>
       (?$Af%(B . "0x59A4") ;; <CJK>
       (?$Af&(B . "0x59D2") ;; <CJK>
       (?$Af'(B . "0x59B2") ;; <CJK>
       (?$Af((B . "0x59AF") ;; <CJK>
       (?$Af)(B . "0x59D7") ;; <CJK>
       (?$Af*(B . "0x59BE") ;; <CJK>
       (?$Af+(B . "0x5A05") ;; <CJK>
       (?$Af,(B . "0x5A06") ;; <CJK>
       (?$Af-(B . "0x59DD") ;; <CJK>
       (?$Af.(B . "0x5A08") ;; <CJK>
       (?$Af/(B . "0x59E3") ;; <CJK>
       (?$Af0(B . "0x59D8") ;; <CJK>
       (?$Af1(B . "0x59F9") ;; <CJK>
       (?$Af2(B . "0x5A0C") ;; <CJK>
       (?$Af3(B . "0x5A09") ;; <CJK>
       (?$Af4(B . "0x5A32") ;; <CJK>
       (?$Af5(B . "0x5A34") ;; <CJK>
       (?$Af6(B . "0x5A11") ;; <CJK>
       (?$Af7(B . "0x5A23") ;; <CJK>
       (?$Af8(B . "0x5A13") ;; <CJK>
       (?$Af9(B . "0x5A40") ;; <CJK>
       (?$Af:(B . "0x5A67") ;; <CJK>
       (?$Af;(B . "0x5A4A") ;; <CJK>
       (?$Af<(B . "0x5A55") ;; <CJK>
       (?$Af=(B . "0x5A3C") ;; <CJK>
       (?$Af>(B . "0x5A62") ;; <CJK>
       (?$Af?(B . "0x5A75") ;; <CJK>
       (?$Af@(B . "0x80EC") ;; <CJK>
       (?$AfA(B . "0x5AAA") ;; <CJK>
       (?$AfB(B . "0x5A9B") ;; <CJK>
       (?$AfC(B . "0x5A77") ;; <CJK>
       (?$AfD(B . "0x5A7A") ;; <CJK>
       (?$AfE(B . "0x5ABE") ;; <CJK>
       (?$AfF(B . "0x5AEB") ;; <CJK>
       (?$AfG(B . "0x5AB2") ;; <CJK>
       (?$AfH(B . "0x5AD2") ;; <CJK>
       (?$AfI(B . "0x5AD4") ;; <CJK>
       (?$AfJ(B . "0x5AB8") ;; <CJK>
       (?$AfK(B . "0x5AE0") ;; <CJK>
       (?$AfL(B . "0x5AE3") ;; <CJK>
       (?$AfM(B . "0x5AF1") ;; <CJK>
       (?$AfN(B . "0x5AD6") ;; <CJK>
       (?$AfO(B . "0x5AE6") ;; <CJK>
       (?$AfP(B . "0x5AD8") ;; <CJK>
       (?$AfQ(B . "0x5ADC") ;; <CJK>
       (?$AfR(B . "0x5B09") ;; <CJK>
       (?$AfS(B . "0x5B17") ;; <CJK>
       (?$AfT(B . "0x5B16") ;; <CJK>
       (?$AfU(B . "0x5B32") ;; <CJK>
       (?$AfV(B . "0x5B37") ;; <CJK>
       (?$AfW(B . "0x5B40") ;; <CJK>
       (?$AfX(B . "0x5C15") ;; <CJK>
       (?$AfY(B . "0x5C1C") ;; <CJK>
       (?$AfZ(B . "0x5B5A") ;; <CJK>
       (?$Af[(B . "0x5B65") ;; <CJK>
       (?$Af\(B . "0x5B73") ;; <CJK>
       (?$Af](B . "0x5B51") ;; <CJK>
       (?$Af^(B . "0x5B53") ;; <CJK>
       (?$Af_(B . "0x5B62") ;; <CJK>
       (?$Af`(B . "0x9A75") ;; <CJK>
       (?$Afa(B . "0x9A77") ;; <CJK>
       (?$Afb(B . "0x9A78") ;; <CJK>
       (?$Afc(B . "0x9A7A") ;; <CJK>
       (?$Afd(B . "0x9A7F") ;; <CJK>
       (?$Afe(B . "0x9A7D") ;; <CJK>
       (?$Aff(B . "0x9A80") ;; <CJK>
       (?$Afg(B . "0x9A81") ;; <CJK>
       (?$Afh(B . "0x9A85") ;; <CJK>
       (?$Afi(B . "0x9A88") ;; <CJK>
       (?$Afj(B . "0x9A8A") ;; <CJK>
       (?$Afk(B . "0x9A90") ;; <CJK>
       (?$Afl(B . "0x9A92") ;; <CJK>
       (?$Afm(B . "0x9A93") ;; <CJK>
       (?$Afn(B . "0x9A96") ;; <CJK>
       (?$Afo(B . "0x9A98") ;; <CJK>
       (?$Afp(B . "0x9A9B") ;; <CJK>
       (?$Afq(B . "0x9A9C") ;; <CJK>
       (?$Afr(B . "0x9A9D") ;; <CJK>
       (?$Afs(B . "0x9A9F") ;; <CJK>
       (?$Aft(B . "0x9AA0") ;; <CJK>
       (?$Afu(B . "0x9AA2") ;; <CJK>
       (?$Afv(B . "0x9AA3") ;; <CJK>
       (?$Afw(B . "0x9AA5") ;; <CJK>
       (?$Afx(B . "0x9AA7") ;; <CJK>
       (?$Afy(B . "0x7E9F") ;; <CJK>
       (?$Afz(B . "0x7EA1") ;; <CJK>
       (?$Af{(B . "0x7EA3") ;; <CJK>
       (?$Af|(B . "0x7EA5") ;; <CJK>
       (?$Af}(B . "0x7EA8") ;; <CJK>
       (?$Af~(B . "0x7EA9") ;; <CJK>
       (?$Ag!(B . "0x7EAD") ;; <CJK>
       (?$Ag"(B . "0x7EB0") ;; <CJK>
       (?$Ag#(B . "0x7EBE") ;; <CJK>
       (?$Ag$(B . "0x7EC0") ;; <CJK>
       (?$Ag%(B . "0x7EC1") ;; <CJK>
       (?$Ag&(B . "0x7EC2") ;; <CJK>
       (?$Ag'(B . "0x7EC9") ;; <CJK>
       (?$Ag((B . "0x7ECB") ;; <CJK>
       (?$Ag)(B . "0x7ECC") ;; <CJK>
       (?$Ag*(B . "0x7ED0") ;; <CJK>
       (?$Ag+(B . "0x7ED4") ;; <CJK>
       (?$Ag,(B . "0x7ED7") ;; <CJK>
       (?$Ag-(B . "0x7EDB") ;; <CJK>
       (?$Ag.(B . "0x7EE0") ;; <CJK>
       (?$Ag/(B . "0x7EE1") ;; <CJK>
       (?$Ag0(B . "0x7EE8") ;; <CJK>
       (?$Ag1(B . "0x7EEB") ;; <CJK>
       (?$Ag2(B . "0x7EEE") ;; <CJK>
       (?$Ag3(B . "0x7EEF") ;; <CJK>
       (?$Ag4(B . "0x7EF1") ;; <CJK>
       (?$Ag5(B . "0x7EF2") ;; <CJK>
       (?$Ag6(B . "0x7F0D") ;; <CJK>
       (?$Ag7(B . "0x7EF6") ;; <CJK>
       (?$Ag8(B . "0x7EFA") ;; <CJK>
       (?$Ag9(B . "0x7EFB") ;; <CJK>
       (?$Ag:(B . "0x7EFE") ;; <CJK>
       (?$Ag;(B . "0x7F01") ;; <CJK>
       (?$Ag<(B . "0x7F02") ;; <CJK>
       (?$Ag=(B . "0x7F03") ;; <CJK>
       (?$Ag>(B . "0x7F07") ;; <CJK>
       (?$Ag?(B . "0x7F08") ;; <CJK>
       (?$Ag@(B . "0x7F0B") ;; <CJK>
       (?$AgA(B . "0x7F0C") ;; <CJK>
       (?$AgB(B . "0x7F0F") ;; <CJK>
       (?$AgC(B . "0x7F11") ;; <CJK>
       (?$AgD(B . "0x7F12") ;; <CJK>
       (?$AgE(B . "0x7F17") ;; <CJK>
       (?$AgF(B . "0x7F19") ;; <CJK>
       (?$AgG(B . "0x7F1C") ;; <CJK>
       (?$AgH(B . "0x7F1B") ;; <CJK>
       (?$AgI(B . "0x7F1F") ;; <CJK>
       (?$AgJ(B . "0x7F21") ;; <CJK>
       (?$AgK(B . "0x7F22") ;; <CJK>
       (?$AgL(B . "0x7F23") ;; <CJK>
       (?$AgM(B . "0x7F24") ;; <CJK>
       (?$AgN(B . "0x7F25") ;; <CJK>
       (?$AgO(B . "0x7F26") ;; <CJK>
       (?$AgP(B . "0x7F27") ;; <CJK>
       (?$AgQ(B . "0x7F2A") ;; <CJK>
       (?$AgR(B . "0x7F2B") ;; <CJK>
       (?$AgS(B . "0x7F2C") ;; <CJK>
       (?$AgT(B . "0x7F2D") ;; <CJK>
       (?$AgU(B . "0x7F2F") ;; <CJK>
       (?$AgV(B . "0x7F30") ;; <CJK>
       (?$AgW(B . "0x7F31") ;; <CJK>
       (?$AgX(B . "0x7F32") ;; <CJK>
       (?$AgY(B . "0x7F33") ;; <CJK>
       (?$AgZ(B . "0x7F35") ;; <CJK>
       (?$Ag[(B . "0x5E7A") ;; <CJK>
       (?$Ag\(B . "0x757F") ;; <CJK>
       (?$Ag](B . "0x5DDB") ;; <CJK>
       (?$Ag^(B . "0x753E") ;; <CJK>
       (?$Ag_(B . "0x9095") ;; <CJK>
       (?$Ag`(B . "0x738E") ;; <CJK>
       (?$Aga(B . "0x7391") ;; <CJK>
       (?$Agb(B . "0x73AE") ;; <CJK>
       (?$Agc(B . "0x73A2") ;; <CJK>
       (?$Agd(B . "0x739F") ;; <CJK>
       (?$Age(B . "0x73CF") ;; <CJK>
       (?$Agf(B . "0x73C2") ;; <CJK>
       (?$Agg(B . "0x73D1") ;; <CJK>
       (?$Agh(B . "0x73B7") ;; <CJK>
       (?$Agi(B . "0x73B3") ;; <CJK>
       (?$Agj(B . "0x73C0") ;; <CJK>
       (?$Agk(B . "0x73C9") ;; <CJK>
       (?$Agl(B . "0x73C8") ;; <CJK>
       (?$Agm(B . "0x73E5") ;; <CJK>
       (?$Agn(B . "0x73D9") ;; <CJK>
       (?$Ago(B . "0x987C") ;; <CJK>
       (?$Agp(B . "0x740A") ;; <CJK>
       (?$Agq(B . "0x73E9") ;; <CJK>
       (?$Agr(B . "0x73E7") ;; <CJK>
       (?$Ags(B . "0x73DE") ;; <CJK>
       (?$Agt(B . "0x73BA") ;; <CJK>
       (?$Agu(B . "0x73F2") ;; <CJK>
       (?$Agv(B . "0x740F") ;; <CJK>
       (?$Agw(B . "0x742A") ;; <CJK>
       (?$Agx(B . "0x745B") ;; <CJK>
       (?$Agy(B . "0x7426") ;; <CJK>
       (?$Agz(B . "0x7425") ;; <CJK>
       (?$Ag{(B . "0x7428") ;; <CJK>
       (?$Ag|(B . "0x7430") ;; <CJK>
       (?$Ag}(B . "0x742E") ;; <CJK>
       (?$Ag~(B . "0x742C") ;; <CJK>
       (?$Ah!(B . "0x741B") ;; <CJK>
       (?$Ah"(B . "0x741A") ;; <CJK>
       (?$Ah#(B . "0x7441") ;; <CJK>
       (?$Ah$(B . "0x745C") ;; <CJK>
       (?$Ah%(B . "0x7457") ;; <CJK>
       (?$Ah&(B . "0x7455") ;; <CJK>
       (?$Ah'(B . "0x7459") ;; <CJK>
       (?$Ah((B . "0x7477") ;; <CJK>
       (?$Ah)(B . "0x746D") ;; <CJK>
       (?$Ah*(B . "0x747E") ;; <CJK>
       (?$Ah+(B . "0x749C") ;; <CJK>
       (?$Ah,(B . "0x748E") ;; <CJK>
       (?$Ah-(B . "0x7480") ;; <CJK>
       (?$Ah.(B . "0x7481") ;; <CJK>
       (?$Ah/(B . "0x7487") ;; <CJK>
       (?$Ah0(B . "0x748B") ;; <CJK>
       (?$Ah1(B . "0x749E") ;; <CJK>
       (?$Ah2(B . "0x74A8") ;; <CJK>
       (?$Ah3(B . "0x74A9") ;; <CJK>
       (?$Ah4(B . "0x7490") ;; <CJK>
       (?$Ah5(B . "0x74A7") ;; <CJK>
       (?$Ah6(B . "0x74D2") ;; <CJK>
       (?$Ah7(B . "0x74BA") ;; <CJK>
       (?$Ah8(B . "0x97EA") ;; <CJK>
       (?$Ah9(B . "0x97EB") ;; <CJK>
       (?$Ah:(B . "0x97EC") ;; <CJK>
       (?$Ah;(B . "0x674C") ;; <CJK>
       (?$Ah<(B . "0x6753") ;; <CJK>
       (?$Ah=(B . "0x675E") ;; <CJK>
       (?$Ah>(B . "0x6748") ;; <CJK>
       (?$Ah?(B . "0x6769") ;; <CJK>
       (?$Ah@(B . "0x67A5") ;; <CJK>
       (?$AhA(B . "0x6787") ;; <CJK>
       (?$AhB(B . "0x676A") ;; <CJK>
       (?$AhC(B . "0x6773") ;; <CJK>
       (?$AhD(B . "0x6798") ;; <CJK>
       (?$AhE(B . "0x67A7") ;; <CJK>
       (?$AhF(B . "0x6775") ;; <CJK>
       (?$AhG(B . "0x67A8") ;; <CJK>
       (?$AhH(B . "0x679E") ;; <CJK>
       (?$AhI(B . "0x67AD") ;; <CJK>
       (?$AhJ(B . "0x678B") ;; <CJK>
       (?$AhK(B . "0x6777") ;; <CJK>
       (?$AhL(B . "0x677C") ;; <CJK>
       (?$AhM(B . "0x67F0") ;; <CJK>
       (?$AhN(B . "0x6809") ;; <CJK>
       (?$AhO(B . "0x67D8") ;; <CJK>
       (?$AhP(B . "0x680A") ;; <CJK>
       (?$AhQ(B . "0x67E9") ;; <CJK>
       (?$AhR(B . "0x67B0") ;; <CJK>
       (?$AhS(B . "0x680C") ;; <CJK>
       (?$AhT(B . "0x67D9") ;; <CJK>
       (?$AhU(B . "0x67B5") ;; <CJK>
       (?$AhV(B . "0x67DA") ;; <CJK>
       (?$AhW(B . "0x67B3") ;; <CJK>
       (?$AhX(B . "0x67DD") ;; <CJK>
       (?$AhY(B . "0x6800") ;; <CJK>
       (?$AhZ(B . "0x67C3") ;; <CJK>
       (?$Ah[(B . "0x67B8") ;; <CJK>
       (?$Ah\(B . "0x67E2") ;; <CJK>
       (?$Ah](B . "0x680E") ;; <CJK>
       (?$Ah^(B . "0x67C1") ;; <CJK>
       (?$Ah_(B . "0x67FD") ;; <CJK>
       (?$Ah`(B . "0x6832") ;; <CJK>
       (?$Aha(B . "0x6833") ;; <CJK>
       (?$Ahb(B . "0x6860") ;; <CJK>
       (?$Ahc(B . "0x6861") ;; <CJK>
       (?$Ahd(B . "0x684E") ;; <CJK>
       (?$Ahe(B . "0x6862") ;; <CJK>
       (?$Ahf(B . "0x6844") ;; <CJK>
       (?$Ahg(B . "0x6864") ;; <CJK>
       (?$Ahh(B . "0x6883") ;; <CJK>
       (?$Ahi(B . "0x681D") ;; <CJK>
       (?$Ahj(B . "0x6855") ;; <CJK>
       (?$Ahk(B . "0x6866") ;; <CJK>
       (?$Ahl(B . "0x6841") ;; <CJK>
       (?$Ahm(B . "0x6867") ;; <CJK>
       (?$Ahn(B . "0x6840") ;; <CJK>
       (?$Aho(B . "0x683E") ;; <CJK>
       (?$Ahp(B . "0x684A") ;; <CJK>
       (?$Ahq(B . "0x6849") ;; <CJK>
       (?$Ahr(B . "0x6829") ;; <CJK>
       (?$Ahs(B . "0x68B5") ;; <CJK>
       (?$Aht(B . "0x688F") ;; <CJK>
       (?$Ahu(B . "0x6874") ;; <CJK>
       (?$Ahv(B . "0x6877") ;; <CJK>
       (?$Ahw(B . "0x6893") ;; <CJK>
       (?$Ahx(B . "0x686B") ;; <CJK>
       (?$Ahy(B . "0x68C2") ;; <CJK>
       (?$Ahz(B . "0x696E") ;; <CJK>
       (?$Ah{(B . "0x68FC") ;; <CJK>
       (?$Ah|(B . "0x691F") ;; <CJK>
       (?$Ah}(B . "0x6920") ;; <CJK>
       (?$Ah~(B . "0x68F9") ;; <CJK>
       (?$Ai!(B . "0x6924") ;; <CJK>
       (?$Ai"(B . "0x68F0") ;; <CJK>
       (?$Ai#(B . "0x690B") ;; <CJK>
       (?$Ai$(B . "0x6901") ;; <CJK>
       (?$Ai%(B . "0x6957") ;; <CJK>
       (?$Ai&(B . "0x68E3") ;; <CJK>
       (?$Ai'(B . "0x6910") ;; <CJK>
       (?$Ai((B . "0x6971") ;; <CJK>
       (?$Ai)(B . "0x6939") ;; <CJK>
       (?$Ai*(B . "0x6960") ;; <CJK>
       (?$Ai+(B . "0x6942") ;; <CJK>
       (?$Ai,(B . "0x695D") ;; <CJK>
       (?$Ai-(B . "0x6984") ;; <CJK>
       (?$Ai.(B . "0x696B") ;; <CJK>
       (?$Ai/(B . "0x6980") ;; <CJK>
       (?$Ai0(B . "0x6998") ;; <CJK>
       (?$Ai1(B . "0x6978") ;; <CJK>
       (?$Ai2(B . "0x6934") ;; <CJK>
       (?$Ai3(B . "0x69CC") ;; <CJK>
       (?$Ai4(B . "0x6987") ;; <CJK>
       (?$Ai5(B . "0x6988") ;; <CJK>
       (?$Ai6(B . "0x69CE") ;; <CJK>
       (?$Ai7(B . "0x6989") ;; <CJK>
       (?$Ai8(B . "0x6966") ;; <CJK>
       (?$Ai9(B . "0x6963") ;; <CJK>
       (?$Ai:(B . "0x6979") ;; <CJK>
       (?$Ai;(B . "0x699B") ;; <CJK>
       (?$Ai<(B . "0x69A7") ;; <CJK>
       (?$Ai=(B . "0x69BB") ;; <CJK>
       (?$Ai>(B . "0x69AB") ;; <CJK>
       (?$Ai?(B . "0x69AD") ;; <CJK>
       (?$Ai@(B . "0x69D4") ;; <CJK>
       (?$AiA(B . "0x69B1") ;; <CJK>
       (?$AiB(B . "0x69C1") ;; <CJK>
       (?$AiC(B . "0x69CA") ;; <CJK>
       (?$AiD(B . "0x69DF") ;; <CJK>
       (?$AiE(B . "0x6995") ;; <CJK>
       (?$AiF(B . "0x69E0") ;; <CJK>
       (?$AiG(B . "0x698D") ;; <CJK>
       (?$AiH(B . "0x69FF") ;; <CJK>
       (?$AiI(B . "0x6A2F") ;; <CJK>
       (?$AiJ(B . "0x69ED") ;; <CJK>
       (?$AiK(B . "0x6A17") ;; <CJK>
       (?$AiL(B . "0x6A18") ;; <CJK>
       (?$AiM(B . "0x6A65") ;; <CJK>
       (?$AiN(B . "0x69F2") ;; <CJK>
       (?$AiO(B . "0x6A44") ;; <CJK>
       (?$AiP(B . "0x6A3E") ;; <CJK>
       (?$AiQ(B . "0x6AA0") ;; <CJK>
       (?$AiR(B . "0x6A50") ;; <CJK>
       (?$AiS(B . "0x6A5B") ;; <CJK>
       (?$AiT(B . "0x6A35") ;; <CJK>
       (?$AiU(B . "0x6A8E") ;; <CJK>
       (?$AiV(B . "0x6A79") ;; <CJK>
       (?$AiW(B . "0x6A3D") ;; <CJK>
       (?$AiX(B . "0x6A28") ;; <CJK>
       (?$AiY(B . "0x6A58") ;; <CJK>
       (?$AiZ(B . "0x6A7C") ;; <CJK>
       (?$Ai[(B . "0x6A91") ;; <CJK>
       (?$Ai\(B . "0x6A90") ;; <CJK>
       (?$Ai](B . "0x6AA9") ;; <CJK>
       (?$Ai^(B . "0x6A97") ;; <CJK>
       (?$Ai_(B . "0x6AAB") ;; <CJK>
       (?$Ai`(B . "0x7337") ;; <CJK>
       (?$Aia(B . "0x7352") ;; <CJK>
       (?$Aib(B . "0x6B81") ;; <CJK>
       (?$Aic(B . "0x6B82") ;; <CJK>
       (?$Aid(B . "0x6B87") ;; <CJK>
       (?$Aie(B . "0x6B84") ;; <CJK>
       (?$Aif(B . "0x6B92") ;; <CJK>
       (?$Aig(B . "0x6B93") ;; <CJK>
       (?$Aih(B . "0x6B8D") ;; <CJK>
       (?$Aii(B . "0x6B9A") ;; <CJK>
       (?$Aij(B . "0x6B9B") ;; <CJK>
       (?$Aik(B . "0x6BA1") ;; <CJK>
       (?$Ail(B . "0x6BAA") ;; <CJK>
       (?$Aim(B . "0x8F6B") ;; <CJK>
       (?$Ain(B . "0x8F6D") ;; <CJK>
       (?$Aio(B . "0x8F71") ;; <CJK>
       (?$Aip(B . "0x8F72") ;; <CJK>
       (?$Aiq(B . "0x8F73") ;; <CJK>
       (?$Air(B . "0x8F75") ;; <CJK>
       (?$Ais(B . "0x8F76") ;; <CJK>
       (?$Ait(B . "0x8F78") ;; <CJK>
       (?$Aiu(B . "0x8F77") ;; <CJK>
       (?$Aiv(B . "0x8F79") ;; <CJK>
       (?$Aiw(B . "0x8F7A") ;; <CJK>
       (?$Aix(B . "0x8F7C") ;; <CJK>
       (?$Aiy(B . "0x8F7E") ;; <CJK>
       (?$Aiz(B . "0x8F81") ;; <CJK>
       (?$Ai{(B . "0x8F82") ;; <CJK>
       (?$Ai|(B . "0x8F84") ;; <CJK>
       (?$Ai}(B . "0x8F87") ;; <CJK>
       (?$Ai~(B . "0x8F8B") ;; <CJK>
       (?$Aj!(B . "0x8F8D") ;; <CJK>
       (?$Aj"(B . "0x8F8E") ;; <CJK>
       (?$Aj#(B . "0x8F8F") ;; <CJK>
       (?$Aj$(B . "0x8F98") ;; <CJK>
       (?$Aj%(B . "0x8F9A") ;; <CJK>
       (?$Aj&(B . "0x8ECE") ;; <CJK>
       (?$Aj'(B . "0x620B") ;; <CJK>
       (?$Aj((B . "0x6217") ;; <CJK>
       (?$Aj)(B . "0x621B") ;; <CJK>
       (?$Aj*(B . "0x621F") ;; <CJK>
       (?$Aj+(B . "0x6222") ;; <CJK>
       (?$Aj,(B . "0x6221") ;; <CJK>
       (?$Aj-(B . "0x6225") ;; <CJK>
       (?$Aj.(B . "0x6224") ;; <CJK>
       (?$Aj/(B . "0x622C") ;; <CJK>
       (?$Aj0(B . "0x81E7") ;; <CJK>
       (?$Aj1(B . "0x74EF") ;; <CJK>
       (?$Aj2(B . "0x74F4") ;; <CJK>
       (?$Aj3(B . "0x74FF") ;; <CJK>
       (?$Aj4(B . "0x750F") ;; <CJK>
       (?$Aj5(B . "0x7511") ;; <CJK>
       (?$Aj6(B . "0x7513") ;; <CJK>
       (?$Aj7(B . "0x6534") ;; <CJK>
       (?$Aj8(B . "0x65EE") ;; <CJK>
       (?$Aj9(B . "0x65EF") ;; <CJK>
       (?$Aj:(B . "0x65F0") ;; <CJK>
       (?$Aj;(B . "0x660A") ;; <CJK>
       (?$Aj<(B . "0x6619") ;; <CJK>
       (?$Aj=(B . "0x6772") ;; <CJK>
       (?$Aj>(B . "0x6603") ;; <CJK>
       (?$Aj?(B . "0x6615") ;; <CJK>
       (?$Aj@(B . "0x6600") ;; <CJK>
       (?$AjA(B . "0x7085") ;; <CJK>
       (?$AjB(B . "0x66F7") ;; <CJK>
       (?$AjC(B . "0x661D") ;; <CJK>
       (?$AjD(B . "0x6634") ;; <CJK>
       (?$AjE(B . "0x6631") ;; <CJK>
       (?$AjF(B . "0x6636") ;; <CJK>
       (?$AjG(B . "0x6635") ;; <CJK>
       (?$AjH(B . "0x8006") ;; <CJK>
       (?$AjI(B . "0x665F") ;; <CJK>
       (?$AjJ(B . "0x6654") ;; <CJK>
       (?$AjK(B . "0x6641") ;; <CJK>
       (?$AjL(B . "0x664F") ;; <CJK>
       (?$AjM(B . "0x6656") ;; <CJK>
       (?$AjN(B . "0x6661") ;; <CJK>
       (?$AjO(B . "0x6657") ;; <CJK>
       (?$AjP(B . "0x6677") ;; <CJK>
       (?$AjQ(B . "0x6684") ;; <CJK>
       (?$AjR(B . "0x668C") ;; <CJK>
       (?$AjS(B . "0x66A7") ;; <CJK>
       (?$AjT(B . "0x669D") ;; <CJK>
       (?$AjU(B . "0x66BE") ;; <CJK>
       (?$AjV(B . "0x66DB") ;; <CJK>
       (?$AjW(B . "0x66DC") ;; <CJK>
       (?$AjX(B . "0x66E6") ;; <CJK>
       (?$AjY(B . "0x66E9") ;; <CJK>
       (?$AjZ(B . "0x8D32") ;; <CJK>
       (?$Aj[(B . "0x8D33") ;; <CJK>
       (?$Aj\(B . "0x8D36") ;; <CJK>
       (?$Aj](B . "0x8D3B") ;; <CJK>
       (?$Aj^(B . "0x8D3D") ;; <CJK>
       (?$Aj_(B . "0x8D40") ;; <CJK>
       (?$Aj`(B . "0x8D45") ;; <CJK>
       (?$Aja(B . "0x8D46") ;; <CJK>
       (?$Ajb(B . "0x8D48") ;; <CJK>
       (?$Ajc(B . "0x8D49") ;; <CJK>
       (?$Ajd(B . "0x8D47") ;; <CJK>
       (?$Aje(B . "0x8D4D") ;; <CJK>
       (?$Ajf(B . "0x8D55") ;; <CJK>
       (?$Ajg(B . "0x8D59") ;; <CJK>
       (?$Ajh(B . "0x89C7") ;; <CJK>
       (?$Aji(B . "0x89CA") ;; <CJK>
       (?$Ajj(B . "0x89CB") ;; <CJK>
       (?$Ajk(B . "0x89CC") ;; <CJK>
       (?$Ajl(B . "0x89CE") ;; <CJK>
       (?$Ajm(B . "0x89CF") ;; <CJK>
       (?$Ajn(B . "0x89D0") ;; <CJK>
       (?$Ajo(B . "0x89D1") ;; <CJK>
       (?$Ajp(B . "0x726E") ;; <CJK>
       (?$Ajq(B . "0x729F") ;; <CJK>
       (?$Ajr(B . "0x725D") ;; <CJK>
       (?$Ajs(B . "0x7266") ;; <CJK>
       (?$Ajt(B . "0x726F") ;; <CJK>
       (?$Aju(B . "0x727E") ;; <CJK>
       (?$Ajv(B . "0x727F") ;; <CJK>
       (?$Ajw(B . "0x7284") ;; <CJK>
       (?$Ajx(B . "0x728B") ;; <CJK>
       (?$Ajy(B . "0x728D") ;; <CJK>
       (?$Ajz(B . "0x728F") ;; <CJK>
       (?$Aj{(B . "0x7292") ;; <CJK>
       (?$Aj|(B . "0x6308") ;; <CJK>
       (?$Aj}(B . "0x6332") ;; <CJK>
       (?$Aj~(B . "0x63B0") ;; <CJK>
       (?$Ak!(B . "0x643F") ;; <CJK>
       (?$Ak"(B . "0x64D8") ;; <CJK>
       (?$Ak#(B . "0x8004") ;; <CJK>
       (?$Ak$(B . "0x6BEA") ;; <CJK>
       (?$Ak%(B . "0x6BF3") ;; <CJK>
       (?$Ak&(B . "0x6BFD") ;; <CJK>
       (?$Ak'(B . "0x6BF5") ;; <CJK>
       (?$Ak((B . "0x6BF9") ;; <CJK>
       (?$Ak)(B . "0x6C05") ;; <CJK>
       (?$Ak*(B . "0x6C07") ;; <CJK>
       (?$Ak+(B . "0x6C06") ;; <CJK>
       (?$Ak,(B . "0x6C0D") ;; <CJK>
       (?$Ak-(B . "0x6C15") ;; <CJK>
       (?$Ak.(B . "0x6C18") ;; <CJK>
       (?$Ak/(B . "0x6C19") ;; <CJK>
       (?$Ak0(B . "0x6C1A") ;; <CJK>
       (?$Ak1(B . "0x6C21") ;; <CJK>
       (?$Ak2(B . "0x6C29") ;; <CJK>
       (?$Ak3(B . "0x6C24") ;; <CJK>
       (?$Ak4(B . "0x6C2A") ;; <CJK>
       (?$Ak5(B . "0x6C32") ;; <CJK>
       (?$Ak6(B . "0x6535") ;; <CJK>
       (?$Ak7(B . "0x6555") ;; <CJK>
       (?$Ak8(B . "0x656B") ;; <CJK>
       (?$Ak9(B . "0x724D") ;; <CJK>
       (?$Ak:(B . "0x7252") ;; <CJK>
       (?$Ak;(B . "0x7256") ;; <CJK>
       (?$Ak<(B . "0x7230") ;; <CJK>
       (?$Ak=(B . "0x8662") ;; <CJK>
       (?$Ak>(B . "0x5216") ;; <CJK>
       (?$Ak?(B . "0x809F") ;; <CJK>
       (?$Ak@(B . "0x809C") ;; <CJK>
       (?$AkA(B . "0x8093") ;; <CJK>
       (?$AkB(B . "0x80BC") ;; <CJK>
       (?$AkC(B . "0x670A") ;; <CJK>
       (?$AkD(B . "0x80BD") ;; <CJK>
       (?$AkE(B . "0x80B1") ;; <CJK>
       (?$AkF(B . "0x80AB") ;; <CJK>
       (?$AkG(B . "0x80AD") ;; <CJK>
       (?$AkH(B . "0x80B4") ;; <CJK>
       (?$AkI(B . "0x80B7") ;; <CJK>
       (?$AkJ(B . "0x80E7") ;; <CJK>
       (?$AkK(B . "0x80E8") ;; <CJK>
       (?$AkL(B . "0x80E9") ;; <CJK>
       (?$AkM(B . "0x80EA") ;; <CJK>
       (?$AkN(B . "0x80DB") ;; <CJK>
       (?$AkO(B . "0x80C2") ;; <CJK>
       (?$AkP(B . "0x80C4") ;; <CJK>
       (?$AkQ(B . "0x80D9") ;; <CJK>
       (?$AkR(B . "0x80CD") ;; <CJK>
       (?$AkS(B . "0x80D7") ;; <CJK>
       (?$AkT(B . "0x6710") ;; <CJK>
       (?$AkU(B . "0x80DD") ;; <CJK>
       (?$AkV(B . "0x80EB") ;; <CJK>
       (?$AkW(B . "0x80F1") ;; <CJK>
       (?$AkX(B . "0x80F4") ;; <CJK>
       (?$AkY(B . "0x80ED") ;; <CJK>
       (?$AkZ(B . "0x810D") ;; <CJK>
       (?$Ak[(B . "0x810E") ;; <CJK>
       (?$Ak\(B . "0x80F2") ;; <CJK>
       (?$Ak](B . "0x80FC") ;; <CJK>
       (?$Ak^(B . "0x6715") ;; <CJK>
       (?$Ak_(B . "0x8112") ;; <CJK>
       (?$Ak`(B . "0x8C5A") ;; <CJK>
       (?$Aka(B . "0x8136") ;; <CJK>
       (?$Akb(B . "0x811E") ;; <CJK>
       (?$Akc(B . "0x812C") ;; <CJK>
       (?$Akd(B . "0x8118") ;; <CJK>
       (?$Ake(B . "0x8132") ;; <CJK>
       (?$Akf(B . "0x8148") ;; <CJK>
       (?$Akg(B . "0x814C") ;; <CJK>
       (?$Akh(B . "0x8153") ;; <CJK>
       (?$Aki(B . "0x8174") ;; <CJK>
       (?$Akj(B . "0x8159") ;; <CJK>
       (?$Akk(B . "0x815A") ;; <CJK>
       (?$Akl(B . "0x8171") ;; <CJK>
       (?$Akm(B . "0x8160") ;; <CJK>
       (?$Akn(B . "0x8169") ;; <CJK>
       (?$Ako(B . "0x817C") ;; <CJK>
       (?$Akp(B . "0x817D") ;; <CJK>
       (?$Akq(B . "0x816D") ;; <CJK>
       (?$Akr(B . "0x8167") ;; <CJK>
       (?$Aks(B . "0x584D") ;; <CJK>
       (?$Akt(B . "0x5AB5") ;; <CJK>
       (?$Aku(B . "0x8188") ;; <CJK>
       (?$Akv(B . "0x8182") ;; <CJK>
       (?$Akw(B . "0x8191") ;; <CJK>
       (?$Akx(B . "0x6ED5") ;; <CJK>
       (?$Aky(B . "0x81A3") ;; <CJK>
       (?$Akz(B . "0x81AA") ;; <CJK>
       (?$Ak{(B . "0x81CC") ;; <CJK>
       (?$Ak|(B . "0x6726") ;; <CJK>
       (?$Ak}(B . "0x81CA") ;; <CJK>
       (?$Ak~(B . "0x81BB") ;; <CJK>
       (?$Al!(B . "0x81C1") ;; <CJK>
       (?$Al"(B . "0x81A6") ;; <CJK>
       (?$Al#(B . "0x6B24") ;; <CJK>
       (?$Al$(B . "0x6B37") ;; <CJK>
       (?$Al%(B . "0x6B39") ;; <CJK>
       (?$Al&(B . "0x6B43") ;; <CJK>
       (?$Al'(B . "0x6B46") ;; <CJK>
       (?$Al((B . "0x6B59") ;; <CJK>
       (?$Al)(B . "0x98D1") ;; <CJK>
       (?$Al*(B . "0x98D2") ;; <CJK>
       (?$Al+(B . "0x98D3") ;; <CJK>
       (?$Al,(B . "0x98D5") ;; <CJK>
       (?$Al-(B . "0x98D9") ;; <CJK>
       (?$Al.(B . "0x98DA") ;; <CJK>
       (?$Al/(B . "0x6BB3") ;; <CJK>
       (?$Al0(B . "0x5F40") ;; <CJK>
       (?$Al1(B . "0x6BC2") ;; <CJK>
       (?$Al2(B . "0x89F3") ;; <CJK>
       (?$Al3(B . "0x6590") ;; <CJK>
       (?$Al4(B . "0x9F51") ;; <CJK>
       (?$Al5(B . "0x6593") ;; <CJK>
       (?$Al6(B . "0x65BC") ;; <CJK>
       (?$Al7(B . "0x65C6") ;; <CJK>
       (?$Al8(B . "0x65C4") ;; <CJK>
       (?$Al9(B . "0x65C3") ;; <CJK>
       (?$Al:(B . "0x65CC") ;; <CJK>
       (?$Al;(B . "0x65CE") ;; <CJK>
       (?$Al<(B . "0x65D2") ;; <CJK>
       (?$Al=(B . "0x65D6") ;; <CJK>
       (?$Al>(B . "0x7080") ;; <CJK>
       (?$Al?(B . "0x709C") ;; <CJK>
       (?$Al@(B . "0x7096") ;; <CJK>
       (?$AlA(B . "0x709D") ;; <CJK>
       (?$AlB(B . "0x70BB") ;; <CJK>
       (?$AlC(B . "0x70C0") ;; <CJK>
       (?$AlD(B . "0x70B7") ;; <CJK>
       (?$AlE(B . "0x70AB") ;; <CJK>
       (?$AlF(B . "0x70B1") ;; <CJK>
       (?$AlG(B . "0x70E8") ;; <CJK>
       (?$AlH(B . "0x70CA") ;; <CJK>
       (?$AlI(B . "0x7110") ;; <CJK>
       (?$AlJ(B . "0x7113") ;; <CJK>
       (?$AlK(B . "0x7116") ;; <CJK>
       (?$AlL(B . "0x712F") ;; <CJK>
       (?$AlM(B . "0x7131") ;; <CJK>
       (?$AlN(B . "0x7173") ;; <CJK>
       (?$AlO(B . "0x715C") ;; <CJK>
       (?$AlP(B . "0x7168") ;; <CJK>
       (?$AlQ(B . "0x7145") ;; <CJK>
       (?$AlR(B . "0x7172") ;; <CJK>
       (?$AlS(B . "0x714A") ;; <CJK>
       (?$AlT(B . "0x7178") ;; <CJK>
       (?$AlU(B . "0x717A") ;; <CJK>
       (?$AlV(B . "0x7198") ;; <CJK>
       (?$AlW(B . "0x71B3") ;; <CJK>
       (?$AlX(B . "0x71B5") ;; <CJK>
       (?$AlY(B . "0x71A8") ;; <CJK>
       (?$AlZ(B . "0x71A0") ;; <CJK>
       (?$Al[(B . "0x71E0") ;; <CJK>
       (?$Al\(B . "0x71D4") ;; <CJK>
       (?$Al](B . "0x71E7") ;; <CJK>
       (?$Al^(B . "0x71F9") ;; <CJK>
       (?$Al_(B . "0x721D") ;; <CJK>
       (?$Al`(B . "0x7228") ;; <CJK>
       (?$Ala(B . "0x706C") ;; <CJK>
       (?$Alb(B . "0x7118") ;; <CJK>
       (?$Alc(B . "0x7166") ;; <CJK>
       (?$Ald(B . "0x71B9") ;; <CJK>
       (?$Ale(B . "0x623E") ;; <CJK>
       (?$Alf(B . "0x623D") ;; <CJK>
       (?$Alg(B . "0x6243") ;; <CJK>
       (?$Alh(B . "0x6248") ;; <CJK>
       (?$Ali(B . "0x6249") ;; <CJK>
       (?$Alj(B . "0x793B") ;; <CJK>
       (?$Alk(B . "0x7940") ;; <CJK>
       (?$All(B . "0x7946") ;; <CJK>
       (?$Alm(B . "0x7949") ;; <CJK>
       (?$Aln(B . "0x795B") ;; <CJK>
       (?$Alo(B . "0x795C") ;; <CJK>
       (?$Alp(B . "0x7953") ;; <CJK>
       (?$Alq(B . "0x795A") ;; <CJK>
       (?$Alr(B . "0x7962") ;; <CJK>
       (?$Als(B . "0x7957") ;; <CJK>
       (?$Alt(B . "0x7960") ;; <CJK>
       (?$Alu(B . "0x796F") ;; <CJK>
       (?$Alv(B . "0x7967") ;; <CJK>
       (?$Alw(B . "0x797A") ;; <CJK>
       (?$Alx(B . "0x7985") ;; <CJK>
       (?$Aly(B . "0x798A") ;; <CJK>
       (?$Alz(B . "0x799A") ;; <CJK>
       (?$Al{(B . "0x79A7") ;; <CJK>
       (?$Al|(B . "0x79B3") ;; <CJK>
       (?$Al}(B . "0x5FD1") ;; <CJK>
       (?$Al~(B . "0x5FD0") ;; <CJK>
       (?$Am!(B . "0x603C") ;; <CJK>
       (?$Am"(B . "0x605D") ;; <CJK>
       (?$Am#(B . "0x605A") ;; <CJK>
       (?$Am$(B . "0x6067") ;; <CJK>
       (?$Am%(B . "0x6041") ;; <CJK>
       (?$Am&(B . "0x6059") ;; <CJK>
       (?$Am'(B . "0x6063") ;; <CJK>
       (?$Am((B . "0x60AB") ;; <CJK>
       (?$Am)(B . "0x6106") ;; <CJK>
       (?$Am*(B . "0x610D") ;; <CJK>
       (?$Am+(B . "0x615D") ;; <CJK>
       (?$Am,(B . "0x61A9") ;; <CJK>
       (?$Am-(B . "0x619D") ;; <CJK>
       (?$Am.(B . "0x61CB") ;; <CJK>
       (?$Am/(B . "0x61D1") ;; <CJK>
       (?$Am0(B . "0x6206") ;; <CJK>
       (?$Am1(B . "0x8080") ;; <CJK>
       (?$Am2(B . "0x807F") ;; <CJK>
       (?$Am3(B . "0x6C93") ;; <CJK>
       (?$Am4(B . "0x6CF6") ;; <CJK>
       (?$Am5(B . "0x6DFC") ;; <CJK>
       (?$Am6(B . "0x77F6") ;; <CJK>
       (?$Am7(B . "0x77F8") ;; <CJK>
       (?$Am8(B . "0x7800") ;; <CJK>
       (?$Am9(B . "0x7809") ;; <CJK>
       (?$Am:(B . "0x7817") ;; <CJK>
       (?$Am;(B . "0x7818") ;; <CJK>
       (?$Am<(B . "0x7811") ;; <CJK>
       (?$Am=(B . "0x65AB") ;; <CJK>
       (?$Am>(B . "0x782D") ;; <CJK>
       (?$Am?(B . "0x781C") ;; <CJK>
       (?$Am@(B . "0x781D") ;; <CJK>
       (?$AmA(B . "0x7839") ;; <CJK>
       (?$AmB(B . "0x783A") ;; <CJK>
       (?$AmC(B . "0x783B") ;; <CJK>
       (?$AmD(B . "0x781F") ;; <CJK>
       (?$AmE(B . "0x783C") ;; <CJK>
       (?$AmF(B . "0x7825") ;; <CJK>
       (?$AmG(B . "0x782C") ;; <CJK>
       (?$AmH(B . "0x7823") ;; <CJK>
       (?$AmI(B . "0x7829") ;; <CJK>
       (?$AmJ(B . "0x784E") ;; <CJK>
       (?$AmK(B . "0x786D") ;; <CJK>
       (?$AmL(B . "0x7856") ;; <CJK>
       (?$AmM(B . "0x7857") ;; <CJK>
       (?$AmN(B . "0x7826") ;; <CJK>
       (?$AmO(B . "0x7850") ;; <CJK>
       (?$AmP(B . "0x7847") ;; <CJK>
       (?$AmQ(B . "0x784C") ;; <CJK>
       (?$AmR(B . "0x786A") ;; <CJK>
       (?$AmS(B . "0x789B") ;; <CJK>
       (?$AmT(B . "0x7893") ;; <CJK>
       (?$AmU(B . "0x789A") ;; <CJK>
       (?$AmV(B . "0x7887") ;; <CJK>
       (?$AmW(B . "0x789C") ;; <CJK>
       (?$AmX(B . "0x78A1") ;; <CJK>
       (?$AmY(B . "0x78A3") ;; <CJK>
       (?$AmZ(B . "0x78B2") ;; <CJK>
       (?$Am[(B . "0x78B9") ;; <CJK>
       (?$Am\(B . "0x78A5") ;; <CJK>
       (?$Am](B . "0x78D4") ;; <CJK>
       (?$Am^(B . "0x78D9") ;; <CJK>
       (?$Am_(B . "0x78C9") ;; <CJK>
       (?$Am`(B . "0x78EC") ;; <CJK>
       (?$Ama(B . "0x78F2") ;; <CJK>
       (?$Amb(B . "0x7905") ;; <CJK>
       (?$Amc(B . "0x78F4") ;; <CJK>
       (?$Amd(B . "0x7913") ;; <CJK>
       (?$Ame(B . "0x7924") ;; <CJK>
       (?$Amf(B . "0x791E") ;; <CJK>
       (?$Amg(B . "0x7934") ;; <CJK>
       (?$Amh(B . "0x9F9B") ;; <CJK>
       (?$Ami(B . "0x9EF9") ;; <CJK>
       (?$Amj(B . "0x9EFB") ;; <CJK>
       (?$Amk(B . "0x9EFC") ;; <CJK>
       (?$Aml(B . "0x76F1") ;; <CJK>
       (?$Amm(B . "0x7704") ;; <CJK>
       (?$Amn(B . "0x770D") ;; <CJK>
       (?$Amo(B . "0x76F9") ;; <CJK>
       (?$Amp(B . "0x7707") ;; <CJK>
       (?$Amq(B . "0x7708") ;; <CJK>
       (?$Amr(B . "0x771A") ;; <CJK>
       (?$Ams(B . "0x7722") ;; <CJK>
       (?$Amt(B . "0x7719") ;; <CJK>
       (?$Amu(B . "0x772D") ;; <CJK>
       (?$Amv(B . "0x7726") ;; <CJK>
       (?$Amw(B . "0x7735") ;; <CJK>
       (?$Amx(B . "0x7738") ;; <CJK>
       (?$Amy(B . "0x7750") ;; <CJK>
       (?$Amz(B . "0x7751") ;; <CJK>
       (?$Am{(B . "0x7747") ;; <CJK>
       (?$Am|(B . "0x7743") ;; <CJK>
       (?$Am}(B . "0x775A") ;; <CJK>
       (?$Am~(B . "0x7768") ;; <CJK>
       (?$An!(B . "0x7762") ;; <CJK>
       (?$An"(B . "0x7765") ;; <CJK>
       (?$An#(B . "0x777F") ;; <CJK>
       (?$An$(B . "0x778D") ;; <CJK>
       (?$An%(B . "0x777D") ;; <CJK>
       (?$An&(B . "0x7780") ;; <CJK>
       (?$An'(B . "0x778C") ;; <CJK>
       (?$An((B . "0x7791") ;; <CJK>
       (?$An)(B . "0x779F") ;; <CJK>
       (?$An*(B . "0x77A0") ;; <CJK>
       (?$An+(B . "0x77B0") ;; <CJK>
       (?$An,(B . "0x77B5") ;; <CJK>
       (?$An-(B . "0x77BD") ;; <CJK>
       (?$An.(B . "0x753A") ;; <CJK>
       (?$An/(B . "0x7540") ;; <CJK>
       (?$An0(B . "0x754E") ;; <CJK>
       (?$An1(B . "0x754B") ;; <CJK>
       (?$An2(B . "0x7548") ;; <CJK>
       (?$An3(B . "0x755B") ;; <CJK>
       (?$An4(B . "0x7572") ;; <CJK>
       (?$An5(B . "0x7579") ;; <CJK>
       (?$An6(B . "0x7583") ;; <CJK>
       (?$An7(B . "0x7F58") ;; <CJK>
       (?$An8(B . "0x7F61") ;; <CJK>
       (?$An9(B . "0x7F5F") ;; <CJK>
       (?$An:(B . "0x8A48") ;; <CJK>
       (?$An;(B . "0x7F68") ;; <CJK>
       (?$An<(B . "0x7F74") ;; <CJK>
       (?$An=(B . "0x7F71") ;; <CJK>
       (?$An>(B . "0x7F79") ;; <CJK>
       (?$An?(B . "0x7F81") ;; <CJK>
       (?$An@(B . "0x7F7E") ;; <CJK>
       (?$AnA(B . "0x76CD") ;; <CJK>
       (?$AnB(B . "0x76E5") ;; <CJK>
       (?$AnC(B . "0x8832") ;; <CJK>
       (?$AnD(B . "0x9485") ;; <CJK>
       (?$AnE(B . "0x9486") ;; <CJK>
       (?$AnF(B . "0x9487") ;; <CJK>
       (?$AnG(B . "0x948B") ;; <CJK>
       (?$AnH(B . "0x948A") ;; <CJK>
       (?$AnI(B . "0x948C") ;; <CJK>
       (?$AnJ(B . "0x948D") ;; <CJK>
       (?$AnK(B . "0x948F") ;; <CJK>
       (?$AnL(B . "0x9490") ;; <CJK>
       (?$AnM(B . "0x9494") ;; <CJK>
       (?$AnN(B . "0x9497") ;; <CJK>
       (?$AnO(B . "0x9495") ;; <CJK>
       (?$AnP(B . "0x949A") ;; <CJK>
       (?$AnQ(B . "0x949B") ;; <CJK>
       (?$AnR(B . "0x949C") ;; <CJK>
       (?$AnS(B . "0x94A3") ;; <CJK>
       (?$AnT(B . "0x94A4") ;; <CJK>
       (?$AnU(B . "0x94AB") ;; <CJK>
       (?$AnV(B . "0x94AA") ;; <CJK>
       (?$AnW(B . "0x94AD") ;; <CJK>
       (?$AnX(B . "0x94AC") ;; <CJK>
       (?$AnY(B . "0x94AF") ;; <CJK>
       (?$AnZ(B . "0x94B0") ;; <CJK>
       (?$An[(B . "0x94B2") ;; <CJK>
       (?$An\(B . "0x94B4") ;; <CJK>
       (?$An](B . "0x94B6") ;; <CJK>
       (?$An^(B . "0x94B7") ;; <CJK>
       (?$An_(B . "0x94B8") ;; <CJK>
       (?$An`(B . "0x94B9") ;; <CJK>
       (?$Ana(B . "0x94BA") ;; <CJK>
       (?$Anb(B . "0x94BC") ;; <CJK>
       (?$Anc(B . "0x94BD") ;; <CJK>
       (?$And(B . "0x94BF") ;; <CJK>
       (?$Ane(B . "0x94C4") ;; <CJK>
       (?$Anf(B . "0x94C8") ;; <CJK>
       (?$Ang(B . "0x94C9") ;; <CJK>
       (?$Anh(B . "0x94CA") ;; <CJK>
       (?$Ani(B . "0x94CB") ;; <CJK>
       (?$Anj(B . "0x94CC") ;; <CJK>
       (?$Ank(B . "0x94CD") ;; <CJK>
       (?$Anl(B . "0x94CE") ;; <CJK>
       (?$Anm(B . "0x94D0") ;; <CJK>
       (?$Ann(B . "0x94D1") ;; <CJK>
       (?$Ano(B . "0x94D2") ;; <CJK>
       (?$Anp(B . "0x94D5") ;; <CJK>
       (?$Anq(B . "0x94D6") ;; <CJK>
       (?$Anr(B . "0x94D7") ;; <CJK>
       (?$Ans(B . "0x94D9") ;; <CJK>
       (?$Ant(B . "0x94D8") ;; <CJK>
       (?$Anu(B . "0x94DB") ;; <CJK>
       (?$Anv(B . "0x94DE") ;; <CJK>
       (?$Anw(B . "0x94DF") ;; <CJK>
       (?$Anx(B . "0x94E0") ;; <CJK>
       (?$Any(B . "0x94E2") ;; <CJK>
       (?$Anz(B . "0x94E4") ;; <CJK>
       (?$An{(B . "0x94E5") ;; <CJK>
       (?$An|(B . "0x94E7") ;; <CJK>
       (?$An}(B . "0x94E8") ;; <CJK>
       (?$An~(B . "0x94EA") ;; <CJK>
       (?$Ao!(B . "0x94E9") ;; <CJK>
       (?$Ao"(B . "0x94EB") ;; <CJK>
       (?$Ao#(B . "0x94EE") ;; <CJK>
       (?$Ao$(B . "0x94EF") ;; <CJK>
       (?$Ao%(B . "0x94F3") ;; <CJK>
       (?$Ao&(B . "0x94F4") ;; <CJK>
       (?$Ao'(B . "0x94F5") ;; <CJK>
       (?$Ao((B . "0x94F7") ;; <CJK>
       (?$Ao)(B . "0x94F9") ;; <CJK>
       (?$Ao*(B . "0x94FC") ;; <CJK>
       (?$Ao+(B . "0x94FD") ;; <CJK>
       (?$Ao,(B . "0x94FF") ;; <CJK>
       (?$Ao-(B . "0x9503") ;; <CJK>
       (?$Ao.(B . "0x9502") ;; <CJK>
       (?$Ao/(B . "0x9506") ;; <CJK>
       (?$Ao0(B . "0x9507") ;; <CJK>
       (?$Ao1(B . "0x9509") ;; <CJK>
       (?$Ao2(B . "0x950A") ;; <CJK>
       (?$Ao3(B . "0x950D") ;; <CJK>
       (?$Ao4(B . "0x950E") ;; <CJK>
       (?$Ao5(B . "0x950F") ;; <CJK>
       (?$Ao6(B . "0x9512") ;; <CJK>
       (?$Ao7(B . "0x9513") ;; <CJK>
       (?$Ao8(B . "0x9514") ;; <CJK>
       (?$Ao9(B . "0x9515") ;; <CJK>
       (?$Ao:(B . "0x9516") ;; <CJK>
       (?$Ao;(B . "0x9518") ;; <CJK>
       (?$Ao<(B . "0x951B") ;; <CJK>
       (?$Ao=(B . "0x951D") ;; <CJK>
       (?$Ao>(B . "0x951E") ;; <CJK>
       (?$Ao?(B . "0x951F") ;; <CJK>
       (?$Ao@(B . "0x9522") ;; <CJK>
       (?$AoA(B . "0x952A") ;; <CJK>
       (?$AoB(B . "0x952B") ;; <CJK>
       (?$AoC(B . "0x9529") ;; <CJK>
       (?$AoD(B . "0x952C") ;; <CJK>
       (?$AoE(B . "0x9531") ;; <CJK>
       (?$AoF(B . "0x9532") ;; <CJK>
       (?$AoG(B . "0x9534") ;; <CJK>
       (?$AoH(B . "0x9536") ;; <CJK>
       (?$AoI(B . "0x9537") ;; <CJK>
       (?$AoJ(B . "0x9538") ;; <CJK>
       (?$AoK(B . "0x953C") ;; <CJK>
       (?$AoL(B . "0x953E") ;; <CJK>
       (?$AoM(B . "0x953F") ;; <CJK>
       (?$AoN(B . "0x9542") ;; <CJK>
       (?$AoO(B . "0x9535") ;; <CJK>
       (?$AoP(B . "0x9544") ;; <CJK>
       (?$AoQ(B . "0x9545") ;; <CJK>
       (?$AoR(B . "0x9546") ;; <CJK>
       (?$AoS(B . "0x9549") ;; <CJK>
       (?$AoT(B . "0x954C") ;; <CJK>
       (?$AoU(B . "0x954E") ;; <CJK>
       (?$AoV(B . "0x954F") ;; <CJK>
       (?$AoW(B . "0x9552") ;; <CJK>
       (?$AoX(B . "0x9553") ;; <CJK>
       (?$AoY(B . "0x9554") ;; <CJK>
       (?$AoZ(B . "0x9556") ;; <CJK>
       (?$Ao[(B . "0x9557") ;; <CJK>
       (?$Ao\(B . "0x9558") ;; <CJK>
       (?$Ao](B . "0x9559") ;; <CJK>
       (?$Ao^(B . "0x955B") ;; <CJK>
       (?$Ao_(B . "0x955E") ;; <CJK>
       (?$Ao`(B . "0x955F") ;; <CJK>
       (?$Aoa(B . "0x955D") ;; <CJK>
       (?$Aob(B . "0x9561") ;; <CJK>
       (?$Aoc(B . "0x9562") ;; <CJK>
       (?$Aod(B . "0x9564") ;; <CJK>
       (?$Aoe(B . "0x9565") ;; <CJK>
       (?$Aof(B . "0x9566") ;; <CJK>
       (?$Aog(B . "0x9567") ;; <CJK>
       (?$Aoh(B . "0x9568") ;; <CJK>
       (?$Aoi(B . "0x9569") ;; <CJK>
       (?$Aoj(B . "0x956A") ;; <CJK>
       (?$Aok(B . "0x956B") ;; <CJK>
       (?$Aol(B . "0x956C") ;; <CJK>
       (?$Aom(B . "0x956F") ;; <CJK>
       (?$Aon(B . "0x9571") ;; <CJK>
       (?$Aoo(B . "0x9572") ;; <CJK>
       (?$Aop(B . "0x9573") ;; <CJK>
       (?$Aoq(B . "0x953A") ;; <CJK>
       (?$Aor(B . "0x77E7") ;; <CJK>
       (?$Aos(B . "0x77EC") ;; <CJK>
       (?$Aot(B . "0x96C9") ;; <CJK>
       (?$Aou(B . "0x79D5") ;; <CJK>
       (?$Aov(B . "0x79ED") ;; <CJK>
       (?$Aow(B . "0x79E3") ;; <CJK>
       (?$Aox(B . "0x79EB") ;; <CJK>
       (?$Aoy(B . "0x7A06") ;; <CJK>
       (?$Aoz(B . "0x5D47") ;; <CJK>
       (?$Ao{(B . "0x7A03") ;; <CJK>
       (?$Ao|(B . "0x7A02") ;; <CJK>
       (?$Ao}(B . "0x7A1E") ;; <CJK>
       (?$Ao~(B . "0x7A14") ;; <CJK>
       (?$Ap!(B . "0x7A39") ;; <CJK>
       (?$Ap"(B . "0x7A37") ;; <CJK>
       (?$Ap#(B . "0x7A51") ;; <CJK>
       (?$Ap$(B . "0x9ECF") ;; <CJK>
       (?$Ap%(B . "0x99A5") ;; <CJK>
       (?$Ap&(B . "0x7A70") ;; <CJK>
       (?$Ap'(B . "0x7688") ;; <CJK>
       (?$Ap((B . "0x768E") ;; <CJK>
       (?$Ap)(B . "0x7693") ;; <CJK>
       (?$Ap*(B . "0x7699") ;; <CJK>
       (?$Ap+(B . "0x76A4") ;; <CJK>
       (?$Ap,(B . "0x74DE") ;; <CJK>
       (?$Ap-(B . "0x74E0") ;; <CJK>
       (?$Ap.(B . "0x752C") ;; <CJK>
       (?$Ap/(B . "0x9E20") ;; <CJK>
       (?$Ap0(B . "0x9E22") ;; <CJK>
       (?$Ap1(B . "0x9E28") ;; <CJK>
       (?$Ap2(B . "0x9E29") ;; <CJK>
       (?$Ap3(B . "0x9E2A") ;; <CJK>
       (?$Ap4(B . "0x9E2B") ;; <CJK>
       (?$Ap5(B . "0x9E2C") ;; <CJK>
       (?$Ap6(B . "0x9E32") ;; <CJK>
       (?$Ap7(B . "0x9E31") ;; <CJK>
       (?$Ap8(B . "0x9E36") ;; <CJK>
       (?$Ap9(B . "0x9E38") ;; <CJK>
       (?$Ap:(B . "0x9E37") ;; <CJK>
       (?$Ap;(B . "0x9E39") ;; <CJK>
       (?$Ap<(B . "0x9E3A") ;; <CJK>
       (?$Ap=(B . "0x9E3E") ;; <CJK>
       (?$Ap>(B . "0x9E41") ;; <CJK>
       (?$Ap?(B . "0x9E42") ;; <CJK>
       (?$Ap@(B . "0x9E44") ;; <CJK>
       (?$ApA(B . "0x9E46") ;; <CJK>
       (?$ApB(B . "0x9E47") ;; <CJK>
       (?$ApC(B . "0x9E48") ;; <CJK>
       (?$ApD(B . "0x9E49") ;; <CJK>
       (?$ApE(B . "0x9E4B") ;; <CJK>
       (?$ApF(B . "0x9E4C") ;; <CJK>
       (?$ApG(B . "0x9E4E") ;; <CJK>
       (?$ApH(B . "0x9E51") ;; <CJK>
       (?$ApI(B . "0x9E55") ;; <CJK>
       (?$ApJ(B . "0x9E57") ;; <CJK>
       (?$ApK(B . "0x9E5A") ;; <CJK>
       (?$ApL(B . "0x9E5B") ;; <CJK>
       (?$ApM(B . "0x9E5C") ;; <CJK>
       (?$ApN(B . "0x9E5E") ;; <CJK>
       (?$ApO(B . "0x9E63") ;; <CJK>
       (?$ApP(B . "0x9E66") ;; <CJK>
       (?$ApQ(B . "0x9E67") ;; <CJK>
       (?$ApR(B . "0x9E68") ;; <CJK>
       (?$ApS(B . "0x9E69") ;; <CJK>
       (?$ApT(B . "0x9E6A") ;; <CJK>
       (?$ApU(B . "0x9E6B") ;; <CJK>
       (?$ApV(B . "0x9E6C") ;; <CJK>
       (?$ApW(B . "0x9E71") ;; <CJK>
       (?$ApX(B . "0x9E6D") ;; <CJK>
       (?$ApY(B . "0x9E73") ;; <CJK>
       (?$ApZ(B . "0x7592") ;; <CJK>
       (?$Ap[(B . "0x7594") ;; <CJK>
       (?$Ap\(B . "0x7596") ;; <CJK>
       (?$Ap](B . "0x75A0") ;; <CJK>
       (?$Ap^(B . "0x759D") ;; <CJK>
       (?$Ap_(B . "0x75AC") ;; <CJK>
       (?$Ap`(B . "0x75A3") ;; <CJK>
       (?$Apa(B . "0x75B3") ;; <CJK>
       (?$Apb(B . "0x75B4") ;; <CJK>
       (?$Apc(B . "0x75B8") ;; <CJK>
       (?$Apd(B . "0x75C4") ;; <CJK>
       (?$Ape(B . "0x75B1") ;; <CJK>
       (?$Apf(B . "0x75B0") ;; <CJK>
       (?$Apg(B . "0x75C3") ;; <CJK>
       (?$Aph(B . "0x75C2") ;; <CJK>
       (?$Api(B . "0x75D6") ;; <CJK>
       (?$Apj(B . "0x75CD") ;; <CJK>
       (?$Apk(B . "0x75E3") ;; <CJK>
       (?$Apl(B . "0x75E8") ;; <CJK>
       (?$Apm(B . "0x75E6") ;; <CJK>
       (?$Apn(B . "0x75E4") ;; <CJK>
       (?$Apo(B . "0x75EB") ;; <CJK>
       (?$App(B . "0x75E7") ;; <CJK>
       (?$Apq(B . "0x7603") ;; <CJK>
       (?$Apr(B . "0x75F1") ;; <CJK>
       (?$Aps(B . "0x75FC") ;; <CJK>
       (?$Apt(B . "0x75FF") ;; <CJK>
       (?$Apu(B . "0x7610") ;; <CJK>
       (?$Apv(B . "0x7600") ;; <CJK>
       (?$Apw(B . "0x7605") ;; <CJK>
       (?$Apx(B . "0x760C") ;; <CJK>
       (?$Apy(B . "0x7617") ;; <CJK>
       (?$Apz(B . "0x760A") ;; <CJK>
       (?$Ap{(B . "0x7625") ;; <CJK>
       (?$Ap|(B . "0x7618") ;; <CJK>
       (?$Ap}(B . "0x7615") ;; <CJK>
       (?$Ap~(B . "0x7619") ;; <CJK>
       (?$Aq!(B . "0x761B") ;; <CJK>
       (?$Aq"(B . "0x763C") ;; <CJK>
       (?$Aq#(B . "0x7622") ;; <CJK>
       (?$Aq$(B . "0x7620") ;; <CJK>
       (?$Aq%(B . "0x7640") ;; <CJK>
       (?$Aq&(B . "0x762D") ;; <CJK>
       (?$Aq'(B . "0x7630") ;; <CJK>
       (?$Aq((B . "0x763F") ;; <CJK>
       (?$Aq)(B . "0x7635") ;; <CJK>
       (?$Aq*(B . "0x7643") ;; <CJK>
       (?$Aq+(B . "0x763E") ;; <CJK>
       (?$Aq,(B . "0x7633") ;; <CJK>
       (?$Aq-(B . "0x764D") ;; <CJK>
       (?$Aq.(B . "0x765E") ;; <CJK>
       (?$Aq/(B . "0x7654") ;; <CJK>
       (?$Aq0(B . "0x765C") ;; <CJK>
       (?$Aq1(B . "0x7656") ;; <CJK>
       (?$Aq2(B . "0x766B") ;; <CJK>
       (?$Aq3(B . "0x766F") ;; <CJK>
       (?$Aq4(B . "0x7FCA") ;; <CJK>
       (?$Aq5(B . "0x7AE6") ;; <CJK>
       (?$Aq6(B . "0x7A78") ;; <CJK>
       (?$Aq7(B . "0x7A79") ;; <CJK>
       (?$Aq8(B . "0x7A80") ;; <CJK>
       (?$Aq9(B . "0x7A86") ;; <CJK>
       (?$Aq:(B . "0x7A88") ;; <CJK>
       (?$Aq;(B . "0x7A95") ;; <CJK>
       (?$Aq<(B . "0x7AA6") ;; <CJK>
       (?$Aq=(B . "0x7AA0") ;; <CJK>
       (?$Aq>(B . "0x7AAC") ;; <CJK>
       (?$Aq?(B . "0x7AA8") ;; <CJK>
       (?$Aq@(B . "0x7AAD") ;; <CJK>
       (?$AqA(B . "0x7AB3") ;; <CJK>
       (?$AqB(B . "0x8864") ;; <CJK>
       (?$AqC(B . "0x8869") ;; <CJK>
       (?$AqD(B . "0x8872") ;; <CJK>
       (?$AqE(B . "0x887D") ;; <CJK>
       (?$AqF(B . "0x887F") ;; <CJK>
       (?$AqG(B . "0x8882") ;; <CJK>
       (?$AqH(B . "0x88A2") ;; <CJK>
       (?$AqI(B . "0x88C6") ;; <CJK>
       (?$AqJ(B . "0x88B7") ;; <CJK>
       (?$AqK(B . "0x88BC") ;; <CJK>
       (?$AqL(B . "0x88C9") ;; <CJK>
       (?$AqM(B . "0x88E2") ;; <CJK>
       (?$AqN(B . "0x88CE") ;; <CJK>
       (?$AqO(B . "0x88E3") ;; <CJK>
       (?$AqP(B . "0x88E5") ;; <CJK>
       (?$AqQ(B . "0x88F1") ;; <CJK>
       (?$AqR(B . "0x891A") ;; <CJK>
       (?$AqS(B . "0x88FC") ;; <CJK>
       (?$AqT(B . "0x88E8") ;; <CJK>
       (?$AqU(B . "0x88FE") ;; <CJK>
       (?$AqV(B . "0x88F0") ;; <CJK>
       (?$AqW(B . "0x8921") ;; <CJK>
       (?$AqX(B . "0x8919") ;; <CJK>
       (?$AqY(B . "0x8913") ;; <CJK>
       (?$AqZ(B . "0x891B") ;; <CJK>
       (?$Aq[(B . "0x890A") ;; <CJK>
       (?$Aq\(B . "0x8934") ;; <CJK>
       (?$Aq](B . "0x892B") ;; <CJK>
       (?$Aq^(B . "0x8936") ;; <CJK>
       (?$Aq_(B . "0x8941") ;; <CJK>
       (?$Aq`(B . "0x8966") ;; <CJK>
       (?$Aqa(B . "0x897B") ;; <CJK>
       (?$Aqb(B . "0x758B") ;; <CJK>
       (?$Aqc(B . "0x80E5") ;; <CJK>
       (?$Aqd(B . "0x76B2") ;; <CJK>
       (?$Aqe(B . "0x76B4") ;; <CJK>
       (?$Aqf(B . "0x77DC") ;; <CJK>
       (?$Aqg(B . "0x8012") ;; <CJK>
       (?$Aqh(B . "0x8014") ;; <CJK>
       (?$Aqi(B . "0x8016") ;; <CJK>
       (?$Aqj(B . "0x801C") ;; <CJK>
       (?$Aqk(B . "0x8020") ;; <CJK>
       (?$Aql(B . "0x8022") ;; <CJK>
       (?$Aqm(B . "0x8025") ;; <CJK>
       (?$Aqn(B . "0x8026") ;; <CJK>
       (?$Aqo(B . "0x8027") ;; <CJK>
       (?$Aqp(B . "0x8029") ;; <CJK>
       (?$Aqq(B . "0x8028") ;; <CJK>
       (?$Aqr(B . "0x8031") ;; <CJK>
       (?$Aqs(B . "0x800B") ;; <CJK>
       (?$Aqt(B . "0x8035") ;; <CJK>
       (?$Aqu(B . "0x8043") ;; <CJK>
       (?$Aqv(B . "0x8046") ;; <CJK>
       (?$Aqw(B . "0x804D") ;; <CJK>
       (?$Aqx(B . "0x8052") ;; <CJK>
       (?$Aqy(B . "0x8069") ;; <CJK>
       (?$Aqz(B . "0x8071") ;; <CJK>
       (?$Aq{(B . "0x8983") ;; <CJK>
       (?$Aq|(B . "0x9878") ;; <CJK>
       (?$Aq}(B . "0x9880") ;; <CJK>
       (?$Aq~(B . "0x9883") ;; <CJK>
       (?$Ar!(B . "0x9889") ;; <CJK>
       (?$Ar"(B . "0x988C") ;; <CJK>
       (?$Ar#(B . "0x988D") ;; <CJK>
       (?$Ar$(B . "0x988F") ;; <CJK>
       (?$Ar%(B . "0x9894") ;; <CJK>
       (?$Ar&(B . "0x989A") ;; <CJK>
       (?$Ar'(B . "0x989B") ;; <CJK>
       (?$Ar((B . "0x989E") ;; <CJK>
       (?$Ar)(B . "0x989F") ;; <CJK>
       (?$Ar*(B . "0x98A1") ;; <CJK>
       (?$Ar+(B . "0x98A2") ;; <CJK>
       (?$Ar,(B . "0x98A5") ;; <CJK>
       (?$Ar-(B . "0x98A6") ;; <CJK>
       (?$Ar.(B . "0x864D") ;; <CJK>
       (?$Ar/(B . "0x8654") ;; <CJK>
       (?$Ar0(B . "0x866C") ;; <CJK>
       (?$Ar1(B . "0x866E") ;; <CJK>
       (?$Ar2(B . "0x867F") ;; <CJK>
       (?$Ar3(B . "0x867A") ;; <CJK>
       (?$Ar4(B . "0x867C") ;; <CJK>
       (?$Ar5(B . "0x867B") ;; <CJK>
       (?$Ar6(B . "0x86A8") ;; <CJK>
       (?$Ar7(B . "0x868D") ;; <CJK>
       (?$Ar8(B . "0x868B") ;; <CJK>
       (?$Ar9(B . "0x86AC") ;; <CJK>
       (?$Ar:(B . "0x869D") ;; <CJK>
       (?$Ar;(B . "0x86A7") ;; <CJK>
       (?$Ar<(B . "0x86A3") ;; <CJK>
       (?$Ar=(B . "0x86AA") ;; <CJK>
       (?$Ar>(B . "0x8693") ;; <CJK>
       (?$Ar?(B . "0x86A9") ;; <CJK>
       (?$Ar@(B . "0x86B6") ;; <CJK>
       (?$ArA(B . "0x86C4") ;; <CJK>
       (?$ArB(B . "0x86B5") ;; <CJK>
       (?$ArC(B . "0x86CE") ;; <CJK>
       (?$ArD(B . "0x86B0") ;; <CJK>
       (?$ArE(B . "0x86BA") ;; <CJK>
       (?$ArF(B . "0x86B1") ;; <CJK>
       (?$ArG(B . "0x86AF") ;; <CJK>
       (?$ArH(B . "0x86C9") ;; <CJK>
       (?$ArI(B . "0x86CF") ;; <CJK>
       (?$ArJ(B . "0x86B4") ;; <CJK>
       (?$ArK(B . "0x86E9") ;; <CJK>
       (?$ArL(B . "0x86F1") ;; <CJK>
       (?$ArM(B . "0x86F2") ;; <CJK>
       (?$ArN(B . "0x86ED") ;; <CJK>
       (?$ArO(B . "0x86F3") ;; <CJK>
       (?$ArP(B . "0x86D0") ;; <CJK>
       (?$ArQ(B . "0x8713") ;; <CJK>
       (?$ArR(B . "0x86DE") ;; <CJK>
       (?$ArS(B . "0x86F4") ;; <CJK>
       (?$ArT(B . "0x86DF") ;; <CJK>
       (?$ArU(B . "0x86D8") ;; <CJK>
       (?$ArV(B . "0x86D1") ;; <CJK>
       (?$ArW(B . "0x8703") ;; <CJK>
       (?$ArX(B . "0x8707") ;; <CJK>
       (?$ArY(B . "0x86F8") ;; <CJK>
       (?$ArZ(B . "0x8708") ;; <CJK>
       (?$Ar[(B . "0x870A") ;; <CJK>
       (?$Ar\(B . "0x870D") ;; <CJK>
       (?$Ar](B . "0x8709") ;; <CJK>
       (?$Ar^(B . "0x8723") ;; <CJK>
       (?$Ar_(B . "0x873B") ;; <CJK>
       (?$Ar`(B . "0x871E") ;; <CJK>
       (?$Ara(B . "0x8725") ;; <CJK>
       (?$Arb(B . "0x872E") ;; <CJK>
       (?$Arc(B . "0x871A") ;; <CJK>
       (?$Ard(B . "0x873E") ;; <CJK>
       (?$Are(B . "0x8748") ;; <CJK>
       (?$Arf(B . "0x8734") ;; <CJK>
       (?$Arg(B . "0x8731") ;; <CJK>
       (?$Arh(B . "0x8729") ;; <CJK>
       (?$Ari(B . "0x8737") ;; <CJK>
       (?$Arj(B . "0x873F") ;; <CJK>
       (?$Ark(B . "0x8782") ;; <CJK>
       (?$Arl(B . "0x8722") ;; <CJK>
       (?$Arm(B . "0x877D") ;; <CJK>
       (?$Arn(B . "0x877E") ;; <CJK>
       (?$Aro(B . "0x877B") ;; <CJK>
       (?$Arp(B . "0x8760") ;; <CJK>
       (?$Arq(B . "0x8770") ;; <CJK>
       (?$Arr(B . "0x874C") ;; <CJK>
       (?$Ars(B . "0x876E") ;; <CJK>
       (?$Art(B . "0x878B") ;; <CJK>
       (?$Aru(B . "0x8753") ;; <CJK>
       (?$Arv(B . "0x8763") ;; <CJK>
       (?$Arw(B . "0x877C") ;; <CJK>
       (?$Arx(B . "0x8764") ;; <CJK>
       (?$Ary(B . "0x8759") ;; <CJK>
       (?$Arz(B . "0x8765") ;; <CJK>
       (?$Ar{(B . "0x8793") ;; <CJK>
       (?$Ar|(B . "0x87AF") ;; <CJK>
       (?$Ar}(B . "0x87A8") ;; <CJK>
       (?$Ar~(B . "0x87D2") ;; <CJK>
       (?$As!(B . "0x87C6") ;; <CJK>
       (?$As"(B . "0x8788") ;; <CJK>
       (?$As#(B . "0x8785") ;; <CJK>
       (?$As$(B . "0x87AD") ;; <CJK>
       (?$As%(B . "0x8797") ;; <CJK>
       (?$As&(B . "0x8783") ;; <CJK>
       (?$As'(B . "0x87AB") ;; <CJK>
       (?$As((B . "0x87E5") ;; <CJK>
       (?$As)(B . "0x87AC") ;; <CJK>
       (?$As*(B . "0x87B5") ;; <CJK>
       (?$As+(B . "0x87B3") ;; <CJK>
       (?$As,(B . "0x87CB") ;; <CJK>
       (?$As-(B . "0x87D3") ;; <CJK>
       (?$As.(B . "0x87BD") ;; <CJK>
       (?$As/(B . "0x87D1") ;; <CJK>
       (?$As0(B . "0x87C0") ;; <CJK>
       (?$As1(B . "0x87CA") ;; <CJK>
       (?$As2(B . "0x87DB") ;; <CJK>
       (?$As3(B . "0x87EA") ;; <CJK>
       (?$As4(B . "0x87E0") ;; <CJK>
       (?$As5(B . "0x87EE") ;; <CJK>
       (?$As6(B . "0x8816") ;; <CJK>
       (?$As7(B . "0x8813") ;; <CJK>
       (?$As8(B . "0x87FE") ;; <CJK>
       (?$As9(B . "0x880A") ;; <CJK>
       (?$As:(B . "0x881B") ;; <CJK>
       (?$As;(B . "0x8821") ;; <CJK>
       (?$As<(B . "0x8839") ;; <CJK>
       (?$As=(B . "0x883C") ;; <CJK>
       (?$As>(B . "0x7F36") ;; <CJK>
       (?$As?(B . "0x7F42") ;; <CJK>
       (?$As@(B . "0x7F44") ;; <CJK>
       (?$AsA(B . "0x7F45") ;; <CJK>
       (?$AsB(B . "0x8210") ;; <CJK>
       (?$AsC(B . "0x7AFA") ;; <CJK>
       (?$AsD(B . "0x7AFD") ;; <CJK>
       (?$AsE(B . "0x7B08") ;; <CJK>
       (?$AsF(B . "0x7B03") ;; <CJK>
       (?$AsG(B . "0x7B04") ;; <CJK>
       (?$AsH(B . "0x7B15") ;; <CJK>
       (?$AsI(B . "0x7B0A") ;; <CJK>
       (?$AsJ(B . "0x7B2B") ;; <CJK>
       (?$AsK(B . "0x7B0F") ;; <CJK>
       (?$AsL(B . "0x7B47") ;; <CJK>
       (?$AsM(B . "0x7B38") ;; <CJK>
       (?$AsN(B . "0x7B2A") ;; <CJK>
       (?$AsO(B . "0x7B19") ;; <CJK>
       (?$AsP(B . "0x7B2E") ;; <CJK>
       (?$AsQ(B . "0x7B31") ;; <CJK>
       (?$AsR(B . "0x7B20") ;; <CJK>
       (?$AsS(B . "0x7B25") ;; <CJK>
       (?$AsT(B . "0x7B24") ;; <CJK>
       (?$AsU(B . "0x7B33") ;; <CJK>
       (?$AsV(B . "0x7B3E") ;; <CJK>
       (?$AsW(B . "0x7B1E") ;; <CJK>
       (?$AsX(B . "0x7B58") ;; <CJK>
       (?$AsY(B . "0x7B5A") ;; <CJK>
       (?$AsZ(B . "0x7B45") ;; <CJK>
       (?$As[(B . "0x7B75") ;; <CJK>
       (?$As\(B . "0x7B4C") ;; <CJK>
       (?$As](B . "0x7B5D") ;; <CJK>
       (?$As^(B . "0x7B60") ;; <CJK>
       (?$As_(B . "0x7B6E") ;; <CJK>
       (?$As`(B . "0x7B7B") ;; <CJK>
       (?$Asa(B . "0x7B62") ;; <CJK>
       (?$Asb(B . "0x7B72") ;; <CJK>
       (?$Asc(B . "0x7B71") ;; <CJK>
       (?$Asd(B . "0x7B90") ;; <CJK>
       (?$Ase(B . "0x7BA6") ;; <CJK>
       (?$Asf(B . "0x7BA7") ;; <CJK>
       (?$Asg(B . "0x7BB8") ;; <CJK>
       (?$Ash(B . "0x7BAC") ;; <CJK>
       (?$Asi(B . "0x7B9D") ;; <CJK>
       (?$Asj(B . "0x7BA8") ;; <CJK>
       (?$Ask(B . "0x7B85") ;; <CJK>
       (?$Asl(B . "0x7BAA") ;; <CJK>
       (?$Asm(B . "0x7B9C") ;; <CJK>
       (?$Asn(B . "0x7BA2") ;; <CJK>
       (?$Aso(B . "0x7BAB") ;; <CJK>
       (?$Asp(B . "0x7BB4") ;; <CJK>
       (?$Asq(B . "0x7BD1") ;; <CJK>
       (?$Asr(B . "0x7BC1") ;; <CJK>
       (?$Ass(B . "0x7BCC") ;; <CJK>
       (?$Ast(B . "0x7BDD") ;; <CJK>
       (?$Asu(B . "0x7BDA") ;; <CJK>
       (?$Asv(B . "0x7BE5") ;; <CJK>
       (?$Asw(B . "0x7BE6") ;; <CJK>
       (?$Asx(B . "0x7BEA") ;; <CJK>
       (?$Asy(B . "0x7C0C") ;; <CJK>
       (?$Asz(B . "0x7BFE") ;; <CJK>
       (?$As{(B . "0x7BFC") ;; <CJK>
       (?$As|(B . "0x7C0F") ;; <CJK>
       (?$As}(B . "0x7C16") ;; <CJK>
       (?$As~(B . "0x7C0B") ;; <CJK>
       (?$At!(B . "0x7C1F") ;; <CJK>
       (?$At"(B . "0x7C2A") ;; <CJK>
       (?$At#(B . "0x7C26") ;; <CJK>
       (?$At$(B . "0x7C38") ;; <CJK>
       (?$At%(B . "0x7C41") ;; <CJK>
       (?$At&(B . "0x7C40") ;; <CJK>
       (?$At'(B . "0x81FE") ;; <CJK>
       (?$At((B . "0x8201") ;; <CJK>
       (?$At)(B . "0x8202") ;; <CJK>
       (?$At*(B . "0x8204") ;; <CJK>
       (?$At+(B . "0x81EC") ;; <CJK>
       (?$At,(B . "0x8844") ;; <CJK>
       (?$At-(B . "0x8221") ;; <CJK>
       (?$At.(B . "0x8222") ;; <CJK>
       (?$At/(B . "0x8223") ;; <CJK>
       (?$At0(B . "0x822D") ;; <CJK>
       (?$At1(B . "0x822F") ;; <CJK>
       (?$At2(B . "0x8228") ;; <CJK>
       (?$At3(B . "0x822B") ;; <CJK>
       (?$At4(B . "0x8238") ;; <CJK>
       (?$At5(B . "0x823B") ;; <CJK>
       (?$At6(B . "0x8233") ;; <CJK>
       (?$At7(B . "0x8234") ;; <CJK>
       (?$At8(B . "0x823E") ;; <CJK>
       (?$At9(B . "0x8244") ;; <CJK>
       (?$At:(B . "0x8249") ;; <CJK>
       (?$At;(B . "0x824B") ;; <CJK>
       (?$At<(B . "0x824F") ;; <CJK>
       (?$At=(B . "0x825A") ;; <CJK>
       (?$At>(B . "0x825F") ;; <CJK>
       (?$At?(B . "0x8268") ;; <CJK>
       (?$At@(B . "0x887E") ;; <CJK>
       (?$AtA(B . "0x8885") ;; <CJK>
       (?$AtB(B . "0x8888") ;; <CJK>
       (?$AtC(B . "0x88D8") ;; <CJK>
       (?$AtD(B . "0x88DF") ;; <CJK>
       (?$AtE(B . "0x895E") ;; <CJK>
       (?$AtF(B . "0x7F9D") ;; <CJK>
       (?$AtG(B . "0x7F9F") ;; <CJK>
       (?$AtH(B . "0x7FA7") ;; <CJK>
       (?$AtI(B . "0x7FAF") ;; <CJK>
       (?$AtJ(B . "0x7FB0") ;; <CJK>
       (?$AtK(B . "0x7FB2") ;; <CJK>
       (?$AtL(B . "0x7C7C") ;; <CJK>
       (?$AtM(B . "0x6549") ;; <CJK>
       (?$AtN(B . "0x7C91") ;; <CJK>
       (?$AtO(B . "0x7C9D") ;; <CJK>
       (?$AtP(B . "0x7C9C") ;; <CJK>
       (?$AtQ(B . "0x7C9E") ;; <CJK>
       (?$AtR(B . "0x7CA2") ;; <CJK>
       (?$AtS(B . "0x7CB2") ;; <CJK>
       (?$AtT(B . "0x7CBC") ;; <CJK>
       (?$AtU(B . "0x7CBD") ;; <CJK>
       (?$AtV(B . "0x7CC1") ;; <CJK>
       (?$AtW(B . "0x7CC7") ;; <CJK>
       (?$AtX(B . "0x7CCC") ;; <CJK>
       (?$AtY(B . "0x7CCD") ;; <CJK>
       (?$AtZ(B . "0x7CC8") ;; <CJK>
       (?$At[(B . "0x7CC5") ;; <CJK>
       (?$At\(B . "0x7CD7") ;; <CJK>
       (?$At](B . "0x7CE8") ;; <CJK>
       (?$At^(B . "0x826E") ;; <CJK>
       (?$At_(B . "0x66A8") ;; <CJK>
       (?$At`(B . "0x7FBF") ;; <CJK>
       (?$Ata(B . "0x7FCE") ;; <CJK>
       (?$Atb(B . "0x7FD5") ;; <CJK>
       (?$Atc(B . "0x7FE5") ;; <CJK>
       (?$Atd(B . "0x7FE1") ;; <CJK>
       (?$Ate(B . "0x7FE6") ;; <CJK>
       (?$Atf(B . "0x7FE9") ;; <CJK>
       (?$Atg(B . "0x7FEE") ;; <CJK>
       (?$Ath(B . "0x7FF3") ;; <CJK>
       (?$Ati(B . "0x7CF8") ;; <CJK>
       (?$Atj(B . "0x7D77") ;; <CJK>
       (?$Atk(B . "0x7DA6") ;; <CJK>
       (?$Atl(B . "0x7DAE") ;; <CJK>
       (?$Atm(B . "0x7E47") ;; <CJK>
       (?$Atn(B . "0x7E9B") ;; <CJK>
       (?$Ato(B . "0x9EB8") ;; <CJK>
       (?$Atp(B . "0x9EB4") ;; <CJK>
       (?$Atq(B . "0x8D73") ;; <CJK>
       (?$Atr(B . "0x8D84") ;; <CJK>
       (?$Ats(B . "0x8D94") ;; <CJK>
       (?$Att(B . "0x8D91") ;; <CJK>
       (?$Atu(B . "0x8DB1") ;; <CJK>
       (?$Atv(B . "0x8D67") ;; <CJK>
       (?$Atw(B . "0x8D6D") ;; <CJK>
       (?$Atx(B . "0x8C47") ;; <CJK>
       (?$Aty(B . "0x8C49") ;; <CJK>
       (?$Atz(B . "0x914A") ;; <CJK>
       (?$At{(B . "0x9150") ;; <CJK>
       (?$At|(B . "0x914E") ;; <CJK>
       (?$At}(B . "0x914F") ;; <CJK>
       (?$At~(B . "0x9164") ;; <CJK>
       (?$Au!(B . "0x9162") ;; <CJK>
       (?$Au"(B . "0x9161") ;; <CJK>
       (?$Au#(B . "0x9170") ;; <CJK>
       (?$Au$(B . "0x9169") ;; <CJK>
       (?$Au%(B . "0x916F") ;; <CJK>
       (?$Au&(B . "0x917D") ;; <CJK>
       (?$Au'(B . "0x917E") ;; <CJK>
       (?$Au((B . "0x9172") ;; <CJK>
       (?$Au)(B . "0x9174") ;; <CJK>
       (?$Au*(B . "0x9179") ;; <CJK>
       (?$Au+(B . "0x918C") ;; <CJK>
       (?$Au,(B . "0x9185") ;; <CJK>
       (?$Au-(B . "0x9190") ;; <CJK>
       (?$Au.(B . "0x918D") ;; <CJK>
       (?$Au/(B . "0x9191") ;; <CJK>
       (?$Au0(B . "0x91A2") ;; <CJK>
       (?$Au1(B . "0x91A3") ;; <CJK>
       (?$Au2(B . "0x91AA") ;; <CJK>
       (?$Au3(B . "0x91AD") ;; <CJK>
       (?$Au4(B . "0x91AE") ;; <CJK>
       (?$Au5(B . "0x91AF") ;; <CJK>
       (?$Au6(B . "0x91B5") ;; <CJK>
       (?$Au7(B . "0x91B4") ;; <CJK>
       (?$Au8(B . "0x91BA") ;; <CJK>
       (?$Au9(B . "0x8C55") ;; <CJK>
       (?$Au:(B . "0x9E7E") ;; <CJK>
       (?$Au;(B . "0x8DB8") ;; <CJK>
       (?$Au<(B . "0x8DEB") ;; <CJK>
       (?$Au=(B . "0x8E05") ;; <CJK>
       (?$Au>(B . "0x8E59") ;; <CJK>
       (?$Au?(B . "0x8E69") ;; <CJK>
       (?$Au@(B . "0x8DB5") ;; <CJK>
       (?$AuA(B . "0x8DBF") ;; <CJK>
       (?$AuB(B . "0x8DBC") ;; <CJK>
       (?$AuC(B . "0x8DBA") ;; <CJK>
       (?$AuD(B . "0x8DC4") ;; <CJK>
       (?$AuE(B . "0x8DD6") ;; <CJK>
       (?$AuF(B . "0x8DD7") ;; <CJK>
       (?$AuG(B . "0x8DDA") ;; <CJK>
       (?$AuH(B . "0x8DDE") ;; <CJK>
       (?$AuI(B . "0x8DCE") ;; <CJK>
       (?$AuJ(B . "0x8DCF") ;; <CJK>
       (?$AuK(B . "0x8DDB") ;; <CJK>
       (?$AuL(B . "0x8DC6") ;; <CJK>
       (?$AuM(B . "0x8DEC") ;; <CJK>
       (?$AuN(B . "0x8DF7") ;; <CJK>
       (?$AuO(B . "0x8DF8") ;; <CJK>
       (?$AuP(B . "0x8DE3") ;; <CJK>
       (?$AuQ(B . "0x8DF9") ;; <CJK>
       (?$AuR(B . "0x8DFB") ;; <CJK>
       (?$AuS(B . "0x8DE4") ;; <CJK>
       (?$AuT(B . "0x8E09") ;; <CJK>
       (?$AuU(B . "0x8DFD") ;; <CJK>
       (?$AuV(B . "0x8E14") ;; <CJK>
       (?$AuW(B . "0x8E1D") ;; <CJK>
       (?$AuX(B . "0x8E1F") ;; <CJK>
       (?$AuY(B . "0x8E2C") ;; <CJK>
       (?$AuZ(B . "0x8E2E") ;; <CJK>
       (?$Au[(B . "0x8E23") ;; <CJK>
       (?$Au\(B . "0x8E2F") ;; <CJK>
       (?$Au](B . "0x8E3A") ;; <CJK>
       (?$Au^(B . "0x8E40") ;; <CJK>
       (?$Au_(B . "0x8E39") ;; <CJK>
       (?$Au`(B . "0x8E35") ;; <CJK>
       (?$Aua(B . "0x8E3D") ;; <CJK>
       (?$Aub(B . "0x8E31") ;; <CJK>
       (?$Auc(B . "0x8E49") ;; <CJK>
       (?$Aud(B . "0x8E41") ;; <CJK>
       (?$Aue(B . "0x8E42") ;; <CJK>
       (?$Auf(B . "0x8E51") ;; <CJK>
       (?$Aug(B . "0x8E52") ;; <CJK>
       (?$Auh(B . "0x8E4A") ;; <CJK>
       (?$Aui(B . "0x8E70") ;; <CJK>
       (?$Auj(B . "0x8E76") ;; <CJK>
       (?$Auk(B . "0x8E7C") ;; <CJK>
       (?$Aul(B . "0x8E6F") ;; <CJK>
       (?$Aum(B . "0x8E74") ;; <CJK>
       (?$Aun(B . "0x8E85") ;; <CJK>
       (?$Auo(B . "0x8E8F") ;; <CJK>
       (?$Aup(B . "0x8E94") ;; <CJK>
       (?$Auq(B . "0x8E90") ;; <CJK>
       (?$Aur(B . "0x8E9C") ;; <CJK>
       (?$Aus(B . "0x8E9E") ;; <CJK>
       (?$Aut(B . "0x8C78") ;; <CJK>
       (?$Auu(B . "0x8C82") ;; <CJK>
       (?$Auv(B . "0x8C8A") ;; <CJK>
       (?$Auw(B . "0x8C85") ;; <CJK>
       (?$Aux(B . "0x8C98") ;; <CJK>
       (?$Auy(B . "0x8C94") ;; <CJK>
       (?$Auz(B . "0x659B") ;; <CJK>
       (?$Au{(B . "0x89D6") ;; <CJK>
       (?$Au|(B . "0x89DE") ;; <CJK>
       (?$Au}(B . "0x89DA") ;; <CJK>
       (?$Au~(B . "0x89DC") ;; <CJK>
       (?$Av!(B . "0x89E5") ;; <CJK>
       (?$Av"(B . "0x89EB") ;; <CJK>
       (?$Av#(B . "0x89EF") ;; <CJK>
       (?$Av$(B . "0x8A3E") ;; <CJK>
       (?$Av%(B . "0x8B26") ;; <CJK>
       (?$Av&(B . "0x9753") ;; <CJK>
       (?$Av'(B . "0x96E9") ;; <CJK>
       (?$Av((B . "0x96F3") ;; <CJK>
       (?$Av)(B . "0x96EF") ;; <CJK>
       (?$Av*(B . "0x9706") ;; <CJK>
       (?$Av+(B . "0x9701") ;; <CJK>
       (?$Av,(B . "0x9708") ;; <CJK>
       (?$Av-(B . "0x970F") ;; <CJK>
       (?$Av.(B . "0x970E") ;; <CJK>
       (?$Av/(B . "0x972A") ;; <CJK>
       (?$Av0(B . "0x972D") ;; <CJK>
       (?$Av1(B . "0x9730") ;; <CJK>
       (?$Av2(B . "0x973E") ;; <CJK>
       (?$Av3(B . "0x9F80") ;; <CJK>
       (?$Av4(B . "0x9F83") ;; <CJK>
       (?$Av5(B . "0x9F85") ;; <CJK>
       (?$Av6(B . "0x9F86") ;; <CJK>
       (?$Av7(B . "0x9F87") ;; <CJK>
       (?$Av8(B . "0x9F88") ;; <CJK>
       (?$Av9(B . "0x9F89") ;; <CJK>
       (?$Av:(B . "0x9F8A") ;; <CJK>
       (?$Av;(B . "0x9F8C") ;; <CJK>
       (?$Av<(B . "0x9EFE") ;; <CJK>
       (?$Av=(B . "0x9F0B") ;; <CJK>
       (?$Av>(B . "0x9F0D") ;; <CJK>
       (?$Av?(B . "0x96B9") ;; <CJK>
       (?$Av@(B . "0x96BC") ;; <CJK>
       (?$AvA(B . "0x96BD") ;; <CJK>
       (?$AvB(B . "0x96CE") ;; <CJK>
       (?$AvC(B . "0x96D2") ;; <CJK>
       (?$AvD(B . "0x77BF") ;; <CJK>
       (?$AvE(B . "0x96E0") ;; <CJK>
       (?$AvF(B . "0x928E") ;; <CJK>
       (?$AvG(B . "0x92AE") ;; <CJK>
       (?$AvH(B . "0x92C8") ;; <CJK>
       (?$AvI(B . "0x933E") ;; <CJK>
       (?$AvJ(B . "0x936A") ;; <CJK>
       (?$AvK(B . "0x93CA") ;; <CJK>
       (?$AvL(B . "0x938F") ;; <CJK>
       (?$AvM(B . "0x943E") ;; <CJK>
       (?$AvN(B . "0x946B") ;; <CJK>
       (?$AvO(B . "0x9C7F") ;; <CJK>
       (?$AvP(B . "0x9C82") ;; <CJK>
       (?$AvQ(B . "0x9C85") ;; <CJK>
       (?$AvR(B . "0x9C86") ;; <CJK>
       (?$AvS(B . "0x9C87") ;; <CJK>
       (?$AvT(B . "0x9C88") ;; <CJK>
       (?$AvU(B . "0x7A23") ;; <CJK>
       (?$AvV(B . "0x9C8B") ;; <CJK>
       (?$AvW(B . "0x9C8E") ;; <CJK>
       (?$AvX(B . "0x9C90") ;; <CJK>
       (?$AvY(B . "0x9C91") ;; <CJK>
       (?$AvZ(B . "0x9C92") ;; <CJK>
       (?$Av[(B . "0x9C94") ;; <CJK>
       (?$Av\(B . "0x9C95") ;; <CJK>
       (?$Av](B . "0x9C9A") ;; <CJK>
       (?$Av^(B . "0x9C9B") ;; <CJK>
       (?$Av_(B . "0x9C9E") ;; <CJK>
       (?$Av`(B . "0x9C9F") ;; <CJK>
       (?$Ava(B . "0x9CA0") ;; <CJK>
       (?$Avb(B . "0x9CA1") ;; <CJK>
       (?$Avc(B . "0x9CA2") ;; <CJK>
       (?$Avd(B . "0x9CA3") ;; <CJK>
       (?$Ave(B . "0x9CA5") ;; <CJK>
       (?$Avf(B . "0x9CA6") ;; <CJK>
       (?$Avg(B . "0x9CA7") ;; <CJK>
       (?$Avh(B . "0x9CA8") ;; <CJK>
       (?$Avi(B . "0x9CA9") ;; <CJK>
       (?$Avj(B . "0x9CAB") ;; <CJK>
       (?$Avk(B . "0x9CAD") ;; <CJK>
       (?$Avl(B . "0x9CAE") ;; <CJK>
       (?$Avm(B . "0x9CB0") ;; <CJK>
       (?$Avn(B . "0x9CB1") ;; <CJK>
       (?$Avo(B . "0x9CB2") ;; <CJK>
       (?$Avp(B . "0x9CB3") ;; <CJK>
       (?$Avq(B . "0x9CB4") ;; <CJK>
       (?$Avr(B . "0x9CB5") ;; <CJK>
       (?$Avs(B . "0x9CB6") ;; <CJK>
       (?$Avt(B . "0x9CB7") ;; <CJK>
       (?$Avu(B . "0x9CBA") ;; <CJK>
       (?$Avv(B . "0x9CBB") ;; <CJK>
       (?$Avw(B . "0x9CBC") ;; <CJK>
       (?$Avx(B . "0x9CBD") ;; <CJK>
       (?$Avy(B . "0x9CC4") ;; <CJK>
       (?$Avz(B . "0x9CC5") ;; <CJK>
       (?$Av{(B . "0x9CC6") ;; <CJK>
       (?$Av|(B . "0x9CC7") ;; <CJK>
       (?$Av}(B . "0x9CCA") ;; <CJK>
       (?$Av~(B . "0x9CCB") ;; <CJK>
       (?$Aw!(B . "0x9CCC") ;; <CJK>
       (?$Aw"(B . "0x9CCD") ;; <CJK>
       (?$Aw#(B . "0x9CCE") ;; <CJK>
       (?$Aw$(B . "0x9CCF") ;; <CJK>
       (?$Aw%(B . "0x9CD0") ;; <CJK>
       (?$Aw&(B . "0x9CD3") ;; <CJK>
       (?$Aw'(B . "0x9CD4") ;; <CJK>
       (?$Aw((B . "0x9CD5") ;; <CJK>
       (?$Aw)(B . "0x9CD7") ;; <CJK>
       (?$Aw*(B . "0x9CD8") ;; <CJK>
       (?$Aw+(B . "0x9CD9") ;; <CJK>
       (?$Aw,(B . "0x9CDC") ;; <CJK>
       (?$Aw-(B . "0x9CDD") ;; <CJK>
       (?$Aw.(B . "0x9CDF") ;; <CJK>
       (?$Aw/(B . "0x9CE2") ;; <CJK>
       (?$Aw0(B . "0x977C") ;; <CJK>
       (?$Aw1(B . "0x9785") ;; <CJK>
       (?$Aw2(B . "0x9791") ;; <CJK>
       (?$Aw3(B . "0x9792") ;; <CJK>
       (?$Aw4(B . "0x9794") ;; <CJK>
       (?$Aw5(B . "0x97AF") ;; <CJK>
       (?$Aw6(B . "0x97AB") ;; <CJK>
       (?$Aw7(B . "0x97A3") ;; <CJK>
       (?$Aw8(B . "0x97B2") ;; <CJK>
       (?$Aw9(B . "0x97B4") ;; <CJK>
       (?$Aw:(B . "0x9AB1") ;; <CJK>
       (?$Aw;(B . "0x9AB0") ;; <CJK>
       (?$Aw<(B . "0x9AB7") ;; <CJK>
       (?$Aw=(B . "0x9E58") ;; <CJK>
       (?$Aw>(B . "0x9AB6") ;; <CJK>
       (?$Aw?(B . "0x9ABA") ;; <CJK>
       (?$Aw@(B . "0x9ABC") ;; <CJK>
       (?$AwA(B . "0x9AC1") ;; <CJK>
       (?$AwB(B . "0x9AC0") ;; <CJK>
       (?$AwC(B . "0x9AC5") ;; <CJK>
       (?$AwD(B . "0x9AC2") ;; <CJK>
       (?$AwE(B . "0x9ACB") ;; <CJK>
       (?$AwF(B . "0x9ACC") ;; <CJK>
       (?$AwG(B . "0x9AD1") ;; <CJK>
       (?$AwH(B . "0x9B45") ;; <CJK>
       (?$AwI(B . "0x9B43") ;; <CJK>
       (?$AwJ(B . "0x9B47") ;; <CJK>
       (?$AwK(B . "0x9B49") ;; <CJK>
       (?$AwL(B . "0x9B48") ;; <CJK>
       (?$AwM(B . "0x9B4D") ;; <CJK>
       (?$AwN(B . "0x9B51") ;; <CJK>
       (?$AwO(B . "0x98E8") ;; <CJK>
       (?$AwP(B . "0x990D") ;; <CJK>
       (?$AwQ(B . "0x992E") ;; <CJK>
       (?$AwR(B . "0x9955") ;; <CJK>
       (?$AwS(B . "0x9954") ;; <CJK>
       (?$AwT(B . "0x9ADF") ;; <CJK>
       (?$AwU(B . "0x9AE1") ;; <CJK>
       (?$AwV(B . "0x9AE6") ;; <CJK>
       (?$AwW(B . "0x9AEF") ;; <CJK>
       (?$AwX(B . "0x9AEB") ;; <CJK>
       (?$AwY(B . "0x9AFB") ;; <CJK>
       (?$AwZ(B . "0x9AED") ;; <CJK>
       (?$Aw[(B . "0x9AF9") ;; <CJK>
       (?$Aw\(B . "0x9B08") ;; <CJK>
       (?$Aw](B . "0x9B0F") ;; <CJK>
       (?$Aw^(B . "0x9B13") ;; <CJK>
       (?$Aw_(B . "0x9B1F") ;; <CJK>
       (?$Aw`(B . "0x9B23") ;; <CJK>
       (?$Awa(B . "0x9EBD") ;; <CJK>
       (?$Awb(B . "0x9EBE") ;; <CJK>
       (?$Awc(B . "0x7E3B") ;; <CJK>
       (?$Awd(B . "0x9E82") ;; <CJK>
       (?$Awe(B . "0x9E87") ;; <CJK>
       (?$Awf(B . "0x9E88") ;; <CJK>
       (?$Awg(B . "0x9E8B") ;; <CJK>
       (?$Awh(B . "0x9E92") ;; <CJK>
       (?$Awi(B . "0x93D6") ;; <CJK>
       (?$Awj(B . "0x9E9D") ;; <CJK>
       (?$Awk(B . "0x9E9F") ;; <CJK>
       (?$Awl(B . "0x9EDB") ;; <CJK>
       (?$Awm(B . "0x9EDC") ;; <CJK>
       (?$Awn(B . "0x9EDD") ;; <CJK>
       (?$Awo(B . "0x9EE0") ;; <CJK>
       (?$Awp(B . "0x9EDF") ;; <CJK>
       (?$Awq(B . "0x9EE2") ;; <CJK>
       (?$Awr(B . "0x9EE9") ;; <CJK>
       (?$Aws(B . "0x9EE7") ;; <CJK>
       (?$Awt(B . "0x9EE5") ;; <CJK>
       (?$Awu(B . "0x9EEA") ;; <CJK>
       (?$Awv(B . "0x9EEF") ;; <CJK>
       (?$Aww(B . "0x9F22") ;; <CJK>
       (?$Awx(B . "0x9F2C") ;; <CJK>
       (?$Awy(B . "0x9F2F") ;; <CJK>
       (?$Awz(B . "0x9F39") ;; <CJK>
       (?$Aw{(B . "0x9F37") ;; <CJK>
       (?$Aw|(B . "0x9F3D") ;; <CJK>
       (?$Aw}(B . "0x9F3E") ;; <CJK>
       (?$Aw~(B . "0x9F44") ;; <CJK>
       ))))

(provide 'ugb2312)
     
     
