/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.apiguardian.api.API;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.MethodSelector;
import org.junit.platform.engine.discovery.ModuleSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.discovery.UriSelector;

@API(status=API.Status.STABLE, since="1.0")
public final class DiscoverySelectors {
    private DiscoverySelectors() {
    }

    public static UriSelector selectUri(String uri) {
        Preconditions.notBlank((String)uri, (String)"URI must not be null or blank");
        try {
            return new UriSelector(new URI(uri));
        }
        catch (URISyntaxException ex) {
            throw new PreconditionViolationException("Failed to create a java.net.URI from: " + uri, (Throwable)ex);
        }
    }

    public static UriSelector selectUri(URI uri) {
        Preconditions.notNull((Object)uri, (String)"URI must not be null");
        return new UriSelector(uri);
    }

    public static FileSelector selectFile(String path) {
        Preconditions.notBlank((String)path, (String)"File path must not be null or blank");
        return new FileSelector(path);
    }

    public static FileSelector selectFile(File file) {
        Preconditions.notNull((Object)file, (String)"File must not be null");
        Preconditions.condition((boolean)file.isFile(), () -> String.format("The supplied java.io.File [%s] must represent an existing file", file));
        try {
            return new FileSelector(file.getCanonicalPath());
        }
        catch (IOException ex) {
            throw new PreconditionViolationException("Failed to retrieve canonical path for file: " + file, (Throwable)ex);
        }
    }

    public static DirectorySelector selectDirectory(String path) {
        Preconditions.notBlank((String)path, (String)"Directory path must not be null or blank");
        return new DirectorySelector(path);
    }

    public static DirectorySelector selectDirectory(File directory) {
        Preconditions.notNull((Object)directory, (String)"Directory must not be null");
        Preconditions.condition((boolean)directory.isDirectory(), () -> String.format("The supplied java.io.File [%s] must represent an existing directory", directory));
        try {
            return new DirectorySelector(directory.getCanonicalPath());
        }
        catch (IOException ex) {
            throw new PreconditionViolationException("Failed to retrieve canonical path for directory: " + directory, (Throwable)ex);
        }
    }

    public static List<ClasspathRootSelector> selectClasspathRoots(Set<Path> classpathRoots) {
        Preconditions.notNull(classpathRoots, (String)"classpathRoots must not be null");
        return (List)classpathRoots.stream().filter(x$0 -> Files.exists(x$0, new LinkOption[0])).map(Path::toUri).map(ClasspathRootSelector::new).collect(CollectionUtils.toUnmodifiableList());
    }

    public static ClasspathResourceSelector selectClasspathResource(String classpathResourceName) {
        Preconditions.notBlank((String)classpathResourceName, (String)"Classpath resource name must not be null or blank");
        return new ClasspathResourceSelector(classpathResourceName);
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.1")
    public static ModuleSelector selectModule(String moduleName) {
        Preconditions.notBlank((String)moduleName, (String)"Module name must not be null or blank");
        return new ModuleSelector(moduleName.trim());
    }

    @API(status=API.Status.EXPERIMENTAL, since="1.1")
    public static List<ModuleSelector> selectModules(Set<String> moduleNames) {
        Preconditions.notNull(moduleNames, (String)"moduleNames must not be null");
        Preconditions.containsNoNullElements(moduleNames, (String)"individual module name must not be null");
        return (List)moduleNames.stream().map(DiscoverySelectors::selectModule).collect(CollectionUtils.toUnmodifiableList());
    }

    public static PackageSelector selectPackage(String packageName) {
        Preconditions.notNull((Object)packageName, (String)"Package name must not be null");
        Preconditions.condition((packageName.isEmpty() || !packageName.trim().isEmpty() ? 1 : 0) != 0, (String)"Package name must not contain only whitespace");
        return new PackageSelector(packageName.trim());
    }

    public static ClassSelector selectClass(Class<?> clazz) {
        Preconditions.notNull(clazz, (String)"Class must not be null");
        return new ClassSelector(clazz);
    }

    public static ClassSelector selectClass(String className) {
        Preconditions.notBlank((String)className, (String)"Class name must not be null or blank");
        return new ClassSelector(className);
    }

    public static MethodSelector selectMethod(String fullyQualifiedMethodName) throws PreconditionViolationException {
        String[] methodParts = ReflectionUtils.parseFullyQualifiedMethodName((String)fullyQualifiedMethodName);
        return DiscoverySelectors.selectMethod(methodParts[0], methodParts[1], methodParts[2]);
    }

    public static MethodSelector selectMethod(String className, String methodName) {
        Preconditions.notBlank((String)className, (String)"Class name must not be null or blank");
        Preconditions.notBlank((String)methodName, (String)"Method name must not be null or blank");
        return new MethodSelector(className, methodName);
    }

    public static MethodSelector selectMethod(String className, String methodName, String methodParameterTypes) {
        Preconditions.notBlank((String)className, (String)"Class name must not be null or blank");
        Preconditions.notBlank((String)methodName, (String)"Method name must not be null or blank");
        Preconditions.notNull((Object)methodParameterTypes, (String)"Parameter types must not be null");
        return new MethodSelector(className, methodName, methodParameterTypes.trim());
    }

    public static MethodSelector selectMethod(Class<?> javaClass, String methodName) {
        Preconditions.notNull(javaClass, (String)"Class must not be null");
        Preconditions.notBlank((String)methodName, (String)"Method name must not be null or blank");
        return new MethodSelector(javaClass, methodName);
    }

    public static MethodSelector selectMethod(Class<?> javaClass, String methodName, String methodParameterTypes) {
        Preconditions.notNull(javaClass, (String)"Class must not be null");
        Preconditions.notBlank((String)methodName, (String)"Method name must not be null or blank");
        Preconditions.notNull((Object)methodParameterTypes, (String)"Parameter types must not be null");
        return new MethodSelector(javaClass, methodName, methodParameterTypes.trim());
    }

    public static MethodSelector selectMethod(Class<?> javaClass, Method method) {
        Preconditions.notNull(javaClass, (String)"Class must not be null");
        Preconditions.notNull((Object)method, (String)"Method must not be null");
        return new MethodSelector(javaClass, method);
    }

    public static UniqueIdSelector selectUniqueId(UniqueId uniqueId) {
        Preconditions.notNull((Object)uniqueId, (String)"UniqueId must not be null");
        return new UniqueIdSelector(uniqueId);
    }

    public static UniqueIdSelector selectUniqueId(String uniqueId) {
        Preconditions.notBlank((String)uniqueId, (String)"Unique ID must not be null or blank");
        return new UniqueIdSelector(UniqueId.parse(uniqueId));
    }
}

